/***************************************************************************
                          dvbpanel.h  -  description
                             -------------------
    begin                : Mon Jan 19 2004
    copyright            : (C) 2004-2005 by Christophe Thommeret
    email                : hftom@free.fr
    last modified        : $Date: 2005/02/02 10:08:24 $ by $Author: juergenk $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DVBPANEL_H
#define DVBPANEL_H

#include <qwidget.h>
#include <qcombobox.h>
#include <qlistbox.h>
#include <qtoolbutton.h>
#include <qptrlist.h>
#include <qtimer.h>

#include <kapp.h>
#include <kpushbutton.h>
#include <kled.h>
#include <kconfig.h>

#include "scandialog.h"
#include "dvbconfig.h"
#include "krecord.h"



class ChannelDesc;
class DvbStream;



class DvbPanel : public QWidget
{
	Q_OBJECT

public: 

	DvbPanel( QWidget *accel, QWidget *parent=0, const char *name=0);
	~DvbPanel();
	bool getChannelList();
	bool saveChannelList();
	bool timeShiftMode();
	void setConfig();
	bool close();
	void enableLiveDvb( bool on );
	void playChannel();
	void checkFirstRun();

	QPtrList<ChannelDesc> channels;
	QPtrList<RecTimer> timers;
	//QPtrList<DvbStream> dvb;
	DvbStream *dvb;
	QString fifoName;
	QString timeShiftFileName;
	KConfig *conf;

public slots:

	void stopLive();
	void setShiftLed( bool on );
	void setRecordLed( bool on );
	void setRecord();
	void pauseLiveTV();
	void killTimer( RecTimer *t );
	void numKeyInput( int n );
	void showEvents();
	void showTimers();
	void scanner();
	void showConfigDialog();
	void next();
	void previous();
	void dvbOSD();

private:

	bool getTimerList();
	bool saveTimerList();
	void fillChannelList( ChannelDesc curchan, bool all=true );

	QPixmap tvPix, raPix, tvcPix, racPix;
	QListBox *channelsCb;
	QComboBox *audioComb;
	KPushButton *broadcastBtn, *recordBtn;
	QToolButton *dateBtn, *infoBtn, *channelsBtn, *configBtn;
	KLed *shiftLed, *recordLed;
	QTimer timersTimer, numKeyHideTimer;
	DVBconfig *dvbConfig;
	KRecord *timersDialog;
	int numKey;
	int updown;
	unsigned long autocount;
	int currentChannelNumber;

private slots:

	void checkTimers();
	void channelSelected( const QString &cname );
	void audioSelected( int n );
	void dvbZap( ChannelDesc *chan );
	void finalZap( ChannelDesc *chan, bool setAudio, int napid=0 );
	void newTimer( QString channel, QString name, QDateTime begin, QTime duration );
	void hideNumKey();
	void dumpEvents();

signals:

	void zap( ChannelDesc* );
	void playDvb();
	void timersChanged();
	void dvbOpen( QString filename, QString chanName, int haveVideo );
	void dvbStop();
	void dvbPause( bool pauseLive );
	void setTimeShiftFilename( QString );
	void showPlayer();
	void showOSD( QString text, int duration, int priority );
	void showDvbOSD( QStringList );
};

#endif
