/*
  Licence: LGPL(?)
  author: goto <harpy@lily.freemail.ne.jp>
*/

#include "utf8.h"

int UTF8Length(const char *string)
{
  int l, str_len, i;

  str_len = 0;
  l = strlen(string);
  for(i=0; i<l; ++i)
  {
    unsigned int byte0, byte1, byte2;

    byte0 = (unsigned int)string[i];
    if (byte0 & 0x80) {
      if ((byte0 & 0xe0) == 0xc0) {
	i++;
	if (i >= l) break;
	byte1 = (unsigned int)string[i];
	str_len++;
      } else if ((byte0 & 0xf0) == 0xe0) {
	i++;
	if (i >= l) break;
	byte1 = (unsigned int)string[i];
	i++;
	if (i >= l) break;
	byte2 = (unsigned int)string[i];
	str_len++;
      } else {
	break;
	/* MMM - currently up to 16-bit code are supported */
      }
    } else {
      str_len++;
    }
  }
  return str_len;
}

unsigned short UTF8GetChar(const char *string, int *index)
{
  unsigned int byte0, byte1, byte2;
  unsigned short mbcode;

  if (!string[*index]) return 0xffff;
  byte0 = (unsigned int)string[*index];
  (*index)++;

  if (byte0 & 0x80) {

    if ((byte0 & 0xe0) == 0xc0) {

      if (!string[*index]) return 0xffff;
      byte1 = (unsigned int)string[*index];
      (*index)++;

      mbcode = ((byte0 & 0x1f)<<6) | (byte1 & 0x3f);

    } else if ((byte0 & 0xf0) == 0xe0) {

      if (!string[*index]) return 0xffff;
      byte1 = (unsigned int)string[*index];
      (*index)++;

      if (!string[*index]) return 0xffff;
      byte2 = (unsigned int)string[*index];
      (*index)++;

      mbcode = ((byte0 & 0x0f)<<12) | ((byte1 & 0x3f)<<6) | (byte2 & 0x3f);

    } else {
      return 0xffff;
      /* MMM - currently up to 16-bit code are supported */
    }

  } else {
    mbcode = byte0;
  }

  return mbcode;
}
