/*
 * Three-pane widget header
 *
 * This is one of components in threepane-view widget.
 * Show three files on three text widgets coloring the different portions.
 * Some interfaces such as show line numbers, are provided by basepane-widget.
 *
 * Copyright INOUE Seiichiro <inoue@ainet.or.jp>, licensed under the GPL.
 */
#ifndef __GDIFF_THREEPANE_H__
#define __GDIFF_THREEPANE_H__

#include "basepane-widget.h"
#include <gtk/gtktext.h>

#ifdef __cplusplus 
extern "C" {
#endif /* __cplusplus */

#define GDIFF_TYPE_THREEPANE				(gdiff_threepane_get_type())
#define GDIFF_THREEPANE(obj)				GTK_CHECK_CAST(obj, gdiff_threepane_get_type(), GdiffThreePane)
#define GDIFF_THREEPANE_CLASS(klass)		GTK_CHECK_CLASS_CAST(klass, gdiff_threepane_get_type(), GdiffThreePaneClass)
#define GDIFF_IS_THREEPANE(obj)			GTK_CHECK_TYPE(obj, gdiff_threepane_get_type())
#define GDIFF_IS_THREEPANE_CLASS(klass)	(GTK_CHECK_CLASS_TYPE((klass), GDIFF_TYPE_THREEPANE))

	
typedef struct _GdiffThreePane       GdiffThreePane;
typedef struct _GdiffThreePaneClass  GdiffThreePaneClass;

struct _GdiffThreePane {
	GdiffBasePane basepane;

	GtkWidget *text[3];

	/* Three-pane specific internal data */
	/* DTextMap is internally related to GtkText widget */
	DTextMap *dtmap[3];
	
	/* Line number column */
	int n_col[3];	/* -1 implies that format hasn't been calculated */
	int ln_col_size[3];/* size including MARK */
	char format_common[32];					/* e.g. "%4d  " */
	char format_diff[3][32];/* e.g. "%4d< " and "%4d> " */

	/* These work as cache in a sense */
	/* Current line number for string search */
	int search_ln[3]; /* in buf */
	int search_tln[3];/* in text */
	/* Point in text widget */
	int search_tpoint[3];/* in text */
	/* Current index of the above line */
	int search_tindex[3];/* in text */
};

struct _GdiffThreePaneClass {
	GdiffBasePaneClass parent_class;
};


GtkType gdiff_threepane_get_type(void);
GtkWidget* gdiff_threepane_new(DiffDir *diffdir, DiffFiles *dfiles);

#ifdef __cplusplus
} 
#endif /* __cplusplus */
 
#endif /* __GDIFF_THREEPANE_H__ */
