/*
 * Multipane (file)compare view widget header
 *
 * From a GUI perspective, this widget consists of three components,
 * multipane-widget(2 or 3 panes), overview-widget, and vertical scrollbar.
 * This widget is just a GUI container of them.
 * Almost every logic is handled by GdiffTwoPane or GdiffThreePane widget.
 *
 * Copyright INOUE Seiichiro <inoue@ainet.or.jp>, licensed under the GPL.
 */
#ifndef __GDIFF_MULTIPVIEW_H__
#define __GDIFF_MULTIPVIEW_H__

#include <gtk/gtkhbox.h>
#include <gtk/gtkvscrollbar.h>
#include "basepane-widget.h"
#include "gdiffoverview.h"

#ifdef __cplusplus 
extern "C" {
#endif /* __cplusplus */

#define GDIFF_TYPE_MULTIPVIEW				(gdiff_multipview_get_type())
#define GDIFF_MULTIPVIEW(obj)				GTK_CHECK_CAST(obj, gdiff_multipview_get_type(), GdiffMultipView)
#define GDIFF_MULTIPVIEW_CLASS(klass)		GTK_CHECK_CLASS_CAST(klass, gdiff_multipview_get_type(), GdiffMultipViewClass)
#define GDIFF_IS_MULTIPVIEW(obj)			GTK_CHECK_TYPE(obj, gdiff_multipview_get_type())
#define GDIFF_IS_MULTIPVIEW_CLASS(klass)	(GTK_CHECK_CLASS_TYPE((klass), GDIFF_TYPE_MULTIPVIEW))


typedef struct _GdiffMultipView       GdiffMultipView;
typedef struct _GdiffMultipViewClass  GdiffMultipViewClass;

struct _GdiffMultipView {
	GtkHBox hbox;

	/* Child GUI components */
	GdiffBasePane *multipane;/* accessed via arg "basepane" */
	GdiffOverview *overview;
	GtkVScrollbar *vscrollboth;
	GtkWidget *rmenu;

	/* backward pointer for reference */
	GDiffWindow *gdwin;

	/* TRUE if this view is under directory view */
	gboolean is_under_dir;
};

struct _GdiffMultipViewClass {
	GtkHBoxClass parent_class;

	/* Interfaces */
	void (*scrollup)(GdiffMultipView *multipview);/* signal */
	void (*scrolldown)(GdiffMultipView *multipview);/* signal */
};


GtkType gdiff_multipview_get_type(void);
GtkWidget* gdiff_multipview_new(DiffDir *diffdir, DiffFiles *dfiles, gboolean is_under_dir);

/* Macros */
/* I could have these informations in this widget, but I don't do that.
   Instead, they are implicitly kept in multipane widget.
   I provide interfaces for them by macros. */
#define GDIFF_MULTIPVIEW_DIFFDIR(multipview)\
	(GDIFF_BASEPANE(GDIFF_MULTIPVIEW(multipview)->multipane)->diffdir)
#define GDIFF_MULTIPVIEW_DFILES(multipview)\
	(GDIFF_BASEPANE(GDIFF_MULTIPVIEW(multipview)->multipane)->dfiles)
#define GDIFF_MULTIPVIEW_FILENAME(multipview, whichfile)\
	(GDIFF_BASEPANE(GDIFF_MULTIPVIEW(multipview)->multipane)->filename[whichfile])
#define GDIFF_MULTIPVIEW_PREF(multipview)\
	(GDIFF_BASEPANE(GDIFF_MULTIPVIEW(multipview)->multipane)->pref)

#define GDIFF_MULTIPVIEW_NUM_FILES(multipview)\
	((GDIFF_MULTIPVIEW_DFILES(multipview)->is_diff3) ? 3 : 2)
	 
#ifdef __cplusplus
} 
#endif /* __cplusplus */
 
#endif /* __GDIFF_MULTIPVIEW_H__ */
