/*
 * Misc header
 *
 * Copyright INOUE Seiichiro <inoue@ainet.or.jp>, licensed under the GPL.
 */
#ifndef __GDIFF_MISC_H__
#define __GDIFF_MISC_H__

#include <stdio.h>/* for FILE */

#ifdef __cplusplus 
extern "C" {
#endif /* __cplusplus */


/* Constant numbers */
typedef enum {
	REGULARFILE,
	DIRECTORY,
	OTHERFILE
} FileType;
	

/* Global function declarations */
/* misc.c */
extern FileType check_filetype(const char *fname);
extern int get_num_chars(const char *src, int lenb, int f_sbcs);
extern int calc_number_places(int n);
extern char* get_file_name(char *fpath);
extern char* get_rel_file_name(char *fpath, int dirlen);
extern void close_allfd_except_std(void);

/* spawn.c */
extern FILE* spawn_prog(char *prog, char *args, char *path1, char *path2, char *path3);

#ifdef __cplusplus
} 
#endif /* __cplusplus */
 
#endif /* __GDIFF_MISC_H__ */
