/* $Id: FVSCombo.h,v 1.7 2004/12/11 19:26:08 ellson Exp $ $Revision: 1.7 $ */
/* vim:set shiftwidth=4 ts=8: */

/**********************************************************
*      This software is part of the graphviz package      *
*                http://www.graphviz.org/                 *
*                                                         *
*            Copyright (c) 1994-2004 AT&T Corp.           *
*                and is licensed under the                *
*            Common Public License, Version 1.0           *
*                      by AT&T Corp.                      *
*                                                         *
*        Information and Software Systems Research        *
*              AT&T Research, Florham Park NJ             *
**********************************************************/


#include "fdp.h"
#include "voronoi/voronoi.h"
#include "shortspline/shortspline.h"
struct FVSCombo:CompoundServer {
    FVSCombo(Layout * client, Layout * current):CompoundServer(client,
							       current) {
	actors.push_back(new FDP::FDPServer(client, current));
	actors.push_back(new Voronoi::VoronoiServer(client, current));
	actors.push_back(new ShortSpliner(client, current));
}};
