#ifndef GCC_DCMPLR_D_REAL_H
#define GCC_DCMPLR_D_REAL_H

struct real_value;

class real_t {
public:
    // Including gcc/real.h presents too many problems, so
    // just statically allocate enough space for
    // REAL_VALUE_TYPE.
    typedef enum {
	Float,
	Double,
	LongDouble,
	NumModes
    } MyMode;
    typedef struct {
	int c;
	int s;
	int e;
	long m[ (16 + sizeof(long))/sizeof(long) + 1 ];
    } fake_t;
    
    fake_t frv;    
    
    static void init();
    static real_t parse(const char * str, MyMode mode);
    static real_t getnan(MyMode mode);
    static real_t getinfinity();
    
    real_t() { };// %% prevents usage in a union... shouldn't rely on zero init since long double isn't
    // %% also, can't call funcs in real.h because there are static real_t's and these will be
    // constructed before the real.c module is initialized
    
    real_t(const real_t & r);
    const real_value & rv() const { return * (real_value *) & frv; }
    real_value & rv() { return * (real_value *) & frv; }
    real_t(const struct real_value & rv);
    real_t(int v);
    real_t(d_uns64 v);
    real_t(d_int64 v);
    real_t & operator=(const real_t & r);
    real_t & operator=(int v);
    real_t operator+ (const real_t & r);
    real_t operator- (const real_t & r);
    real_t operator- ();
    real_t operator* (const real_t & r);
    real_t operator/ (const real_t & r);
    real_t operator% (const real_t & r);
    bool operator< (const real_t & r);
    bool operator> (const real_t & r);
    bool operator<= (const real_t & r);
    bool operator>= (const real_t & r);
    bool operator== (const real_t & r);
    bool operator!= (const real_t & r);
    //operator d_uns64(); // avoid bugs, but maybe allow operator bool()
    d_uns64 toInt();
    bool isZero();
    bool isNegative();
    bool floatCompare(int op, const real_t & r);
    void format(char * buf, unsigned buf_size);
private:
    // prevent this from being used
    real_t & operator=(float v) { return *this; }
    real_t & operator=(double v) { return *this; }
    // real_t & operator=(long double v) { return *this; }
};

typedef struct {
    real_t maxval, minval, epsilonval/*, nanval, infval*/;
    d_int64 dig, mant_dig;
    d_int64 max_10_exp, min_10_exp;
    d_int64 max_exp, min_exp;
} real_t_Properties;

extern real_t_Properties real_t_properties[real_t::NumModes];

#endif
