/* GDC -- D front-end for GCC
   Copyright (C) 2004 David Friedman
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef GCC_DCMPLR_DC_GCC_INCLUDES_H
#define GCC_DCMPLR_DC_GCC_INCLUDES_H

extern "C" {

// hack needed to prevent inclusion of the generated insn-flags.h
// which defines some inline functions that use C prototypes....
#define GCC_INSN_FLAGS_H

// Confliction definition getween stdio.h and libiberty.h over the throw()
#define HAVE_DECL_ASPRINTF 1

#include "config.h"
#include "system.h"

// coretypes.h and tm.h is not present in gcc < 3.4 (so it seems)
#if D_GCC_VER == 33
    /* nothing */
#else
    // gcc 3.4
#include "coretypes.h"
#include "tm.h"
#endif
    
#include "tree.h"
#include "real.h"
#include "langhooks.h"
#include "langhooks-def.h"
#include "debug.h"
#include "flags.h"
#include "toplev.h"
#include "target.h"
#include "function.h"
#include "rtl.h"
#include "diagnostic.h"
#include "output.h"
#include "except.h"
#include "libfuncs.h"
#include "expr.h"
#include "convert.h"
#include "ggc.h"

#if D_GCC_VER >= 34
#include "opts.h"
#endif
    
}

// Undefine things that give us problems
#undef RET

#endif
