;;;; -*- Mode: LISP; Syntax: ANSI-Common-Lisp; Base: 10 -*-
;;;;
;;;; CMUCL 19a Patch 002: The unbound-slot condition is supposed to
;;;; take a :name arg, not a :slot arg.  Bug reported to cmucl-imp,
;;;; 2004-08-31.  This breaks backward compatibility in that cmucl no
;;;; longer recognizes the :slot arg.

(pushnew :cmucl-19a-patch-002 *features*)

(in-package "PCL")

#+(and cmu19a (not cmucl-19a-patch-002))
(define-condition unbound-slot (cell-error)
  ((instance :reader unbound-slot-instance :initarg :instance))
  (:report (lambda (condition stream)
	     (format stream "~@<The slot ~S is unbound in the object ~S.~@:>"
		     (cell-error-name condition)
		     (unbound-slot-instance condition)))))

#+(and cmu19a (not cmucl-19a-patch-002))
(defmethod slot-unbound ((class t) instance slot-name)
  (error 'unbound-slot :name slot-name :instance instance))




