/********************************************************************
 * COPYRIGHT: 
 * Copyright (c) 1997-2001, International Business Machines Corporation and
 * others. All Rights Reserved.
 ********************************************************************/

/**
 * CollationSpanishTest is a third level test class. This tests the locale
 * specific primary and tertiary rules. This Spanish sort uses the traditional
 * sorting sequence.  The Spanish modern sorting sequence does not sort
 * ch and ll as unique characters.
 */

#ifndef _ESCOLL
#define _ESCOLL

#include "tscoll.h"

class CollationSpanishTest: public IntlTestCollator {
public:
    // If this is too small for the test data, just increase it.
    // Just don't make it too large, otherwise the executable will get too big
    enum EToken_Len { MAX_TOKEN_LEN = 16 };

    CollationSpanishTest();
    virtual ~CollationSpanishTest();
    void runIndexedTest( int32_t index, UBool exec, const char* &name, char* par = NULL );

    // amin test routine, tests rules specific to the spanish locale
    void doTest( UnicodeString source, UnicodeString target, Collator::EComparisonResult result);

    // performs tests with strength PRIMARY
    void TestPrimary(/* char* par */);

    // prforms test with strength TERTIARY
    void TestTertiary(/* char* par */);

private:
    static const UChar testSourceCases[][MAX_TOKEN_LEN];
    static const UChar testTargetCases[][MAX_TOKEN_LEN];
    static const Collator::EComparisonResult results[];

    Collator *myCollation;
};
#endif
