/* 
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 * 
 * The Original Code is the Sablotron XSLT Processor.
 * 
 * The Initial Developer of the Original Code is Ginger Alliance Ltd.
 * Portions created by Ginger Alliance are Copyright (C) 2000 Ginger
 * Alliance Ltd. All Rights Reserved.
 * 
 * Contributor(s):
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL"), in which case the provisions of the GPL are applicable 
 * instead of those above.  If you wish to allow use of your 
 * version of this file only under the terms of the GPL and not to
 * allow others to use your version of this file under the MPL,
 * indicate your decision by deleting the provisions above and
 * replace them with the notice and other provisions required by
 * the GPL.  If you do not delete the provisions above, a recipient
 * may use your version of this file under either the MPL or the
 * GPL.
 */

#ifndef TreeHIncl
#define TreeHIncl

// GP: clean

#include "base.h"
#include "verts.h"
#include "datastr.h"
#include "output.h"

//
//  Document
//  holds information about a source document that yielded
//  some of the nodes in a tree
//

/*      T B D
class Document
{
public:
    Document(Processor *proc_);
};
*/

/****************************************
T r e e
****************************************/

class Tree;

class Tree /* : public SabObj */
{
public:
    Tree(const Str&, BOOL, Processor* proc);
    ~Tree();
    BOOL XSLTree;
    eFlag appendVertex(Vertex *);
    Vertex *popVertex();
    Vertex *appendText(char *, int);
    eFlag parseFinished();
    void output();
    void dump();
    void
        setName(const Str&);
    RootNode root;
    DataLine *dline;
    // Box treeBox;
    Vertex *stackTop;
    Str name;
    NSList pendingNS;
    int
        stripped;
    void dropCurrentElement(Vertex *);
    OutputDefinition
        outputDef;
    void flushPendingText();
    Processor* proc;
private:
    Text *pendingTextNode;
    DStr pendingText;
    int
        vcount;             // # of vertices in tree
};

#endif //ifndef TreeHIncl
