/* 
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 * 
 * The Original Code is the Sablotron XSLT Processor.
 * 
 * The Initial Developer of the Original Code is Ginger Alliance Ltd.
 * Portions created by Ginger Alliance are Copyright (C) 2000 Ginger
 * Alliance Ltd. All Rights Reserved.
 * 
 * Contributor(s):
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL"), in which case the provisions of the GPL are applicable 
 * instead of those above.  If you wish to allow use of your 
 * version of this file only under the terms of the GPL and not to
 * allow others to use your version of this file under the MPL,
 * indicate your decision by deleting the provisions above and
 * replace them with the notice and other provisions required by
 * the GPL.  If you do not delete the provisions above, a recipient
 * may use your version of this file under either the MPL or the
 * GPL.
 */

#ifndef ProcHIncl
#define ProcHIncl

// GP: clean

#define PROC_ARENA_SIZE         0x10000
#define PROC_DICTIONARY_LOGSIZE    10

enum StandardPhrase
{
    PHRASE_EMPTY = 0,
    PHRASE_XSL,
    PHRASE_XSL_NAMESPACE,
    PHRASE_XML_NAMESPACE,
    PHRASE_STAR,
    PHRASE_LAST
};

#include "base.h"
#include "arena.h"
#include "hash.h"
#include "datastr.h"
#include "uri.h"
#include "output.h"
#include "encoding.h"
// #include "vars.h"
//#include "expr.h"
//#include "context.h"

extern const char *theXSLTNamespace;

class Tree;
class TreeConstructer;
class LocStep;
class Vertex;
class XSLElement;
class Expression;
class Context;
typedef PList<Expression*> ExprList;

/*****************************************************************

    R u l e I t e m
    an item of RuleSList describing a rule

*****************************************************************/

class RuleItem
{
public:
    RuleItem(XSLElement *,double, QName &, QName *);
    ~RuleItem();
    XSLElement *rule;
    double priority;
    QName name,
        *mode;
};


class Processor;

/*****************************************************************

    R u l e S L i s t
    sorted list of rules

*****************************************************************/

class RuleSList : public SList<RuleItem*>
{
public:
    RuleSList(Processor* proc);
    ~RuleSList();
    int compare(int first, int second);
    XSLElement *findByName(QName &);
    Processor* proc;
};

/*****************************************************************

DataLinesList

*****************************************************************/

class DataLineItem
{
public:
    ~DataLineItem();
    DataLine *_dataline;
    Tree *_tree;
    Bool _isXSL;
};

class DataLinesList: public PList<DataLineItem*>
{
public:
    int findNum(Str &absoluteURI, Bool _isXSL,
        DLAccessMode _mode);
    Tree *getTree(Str &absoluteURI, Bool _isXSL, DLAccessMode _mode);
    eFlag addLine(DataLine *d, Tree *t, Bool isXSL);
};


/*****************************************************************

    P   r   o   c   e   s   s   o   r

*****************************************************************/

class VarsList;
class VertexList;
class Element;

class Processor /* : public SabObj */
{
public:
    SituationObj situation_;
    SituationObj* situation;
    Tree *input,
        *styleSheet;
//        *result;
    RuleSList rules;
    Processor();
    ~Processor();
    eFlag open(char *sheetURI, char *inputURI, char *resultURI);
    eFlag execute(Vertex *, Context *&);
    eFlag execute(VertexList&, Context *&);
    eFlag parse(Tree *, DataLine *d);
    double defaultPriorityLP(Expression *);
    double defaultPriority(XSLElement *);
    eFlag bestRule(XSLElement *&, Context *);
    eFlag builtinRule(Context *c);
    eFlag insertRule(XSLElement *);
    FILE *logfile;
    unsigned long allocObjects,
        allocBytes,
        maxAllocObjects,
        maxAllocBytes;
    Expression* getVarBinding(QName &);
    Bool cmpQNames(const QName&, const QName&) const;
    VarsList *vars;
    OutputterObj *outputter()
    {
//        assert(outputters_.number()); 
        if (outputters_.number())
            return outputters_.last();
        else return NULL;
    }
    QName *getCurrentMode();
    void pushMode(QName *);
    void popMode();
    eFlag readTreeFromURI(Tree*& newTree, const Str& location, const Str& base, Bool isXSL);
    eFlag pushOutputterForURI(Str& location, Str& base);
    eFlag pushTreeConstructer(TreeConstructer *&newTC, Tree *t);
    eFlag pushOutputter(OutputterObj* out_);
    eFlag popOutputter();
    eFlag popTreeConstructer(TreeConstructer *theTC);
    // eFlag makeTreeForURI(Tree*& newTree, Str& location, Str& base);
    eFlag processVertexAfterParse(Vertex *, Tree *, TreeConstructer *tc);

    eFlag setHandler(HandlerType type, void *handler, void *userData);
    SchemeHandler *getSchemeHandler(void **udata);
    MessageHandler *getMessageHandler(void **udata);
    SAXHandler *getSAXHandler(void **udata);
    MiscHandler *getMiscHandler(void **udata);
    EncHandler *getEncHandler(void **udata);

    void *getHandlerUserData(HandlerType type, void *handler);

    void setHardEncoding(const Str& hardEncoding_);
    const Str& getHardEncoding() const;

    eFlag addLineNoTree(DataLine *&d, Str &absolute, Bool isXSL);
    eFlag addLineParse(Tree *& newTree, Str &absolute, Bool isXSL);
    void copyArg(const Str& argName, int* argOrdinal, char*& newCopy);
    eFlag getArg(const char*, char*&, Bool);
    eFlag useArg(char *name, char *val);
    eFlag freeResultArgs();
    eFlag useGlobalParam(char *name, char *val);
    const Str& baseForVertex(Element *v);
    const Str& findBaseURI(const Str& unmappedBase);
    void addBaseURIMapping(const Str& scheme, const Str& mapping);
    void setHardBaseURI(const char* hardBase);

    void setInstanceData(void *idata)
    { 
        instanceData = idata; 
    };

    void *getInstanceData()
    { 
        return instanceData; 
    };
    void prepareForRun();
    void cleanupAfterRun();
    const QName theEmptyQName;
    Arena *getArena();
    HashTable& dict() { return dictionary; }
    Phrase stdPhrase(StandardPhrase s) const { assert(s <= PHRASE_LAST); return stdPhrases[s]; }
    Str getAliasedName(const QName& name, NamespaceStack& currNamespaces);
    Recoder theRecoder;

private:
    P2List aliases;
    eFlag openCommon();
    eFlag execApply(Context *c);
    PList<QName*> modes;
    StrStrList
        argList;
    DataLinesList datalines;
    PList<OutputterObj*> outputters_;
    //  handlers
    SchemeHandler *theSchemeHandler;
    MessageHandler *theMessageHandler;
    SAXHandler *theSAXHandler;
    MiscHandler *theMiscHandler;
    EncHandler *theEncHandler;
    void 
        *theSchemeUserData,
        *theMessageUserData,
        *theSAXUserData,    
        *theMiscUserData,
        *theEncUserData;    
    void *instanceData;
    void freeNonArgDatalines();
    StrStrList baseURIMappings;
    Arena theArena;
    HashTable dictionary;
    Phrase stdPhrases[PHRASE_LAST];
    Str hardEncoding;
};

#endif //ifndef ProcHIncl
