/*************************************************************************
 *
 *  $RCSfile: mainwrappedservicefactory.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: sb $ $Date: 2001/02/06 11:11:23 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef INCLUDED_UCB_MAINWRAPPEDSERVICEFACTORY_HXX
#define INCLUDED_UCB_MAINWRAPPEDSERVICEFACTORY_HXX

#ifndef _COM_SUN_STAR_CONTAINER_XCONTENTENUMERATIONACCESS_HPP_
#include <com/sun/star/container/XContentEnumerationAccess.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XSET_HPP_
#include <com/sun/star/container/XSet.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XCOMPONENT_HPP_
#include <com/sun/star/lang/XComponent.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XSERVICEINFO_HPP_
#include <com/sun/star/lang/XServiceInfo.hpp>
#endif
#ifndef _COM_SUN_STAR_UNO_REFERENCE_HXX_
#include <com/sun/star/uno/Reference.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_RUNTIMEEXCEPTION_HPP_
#include <com/sun/star/uno/RuntimeException.hpp>
#endif
#ifndef _CPPUHELPER_IMPLBASE5_HXX_
#include <cppuhelper/implbase5.hxx>
#endif
#ifndef _CPPUHELPER_INTERFACECONTAINER_HXX_
#include <cppuhelper/interfacecontainer.hxx>
#endif
#ifndef _OSL_MUTEX_HXX_
#include <osl/mutex.hxx>
#endif

namespace com { namespace sun { namespace star {
	namespace uno { class XInterface; }
} } }

//============================================================================
namespace ucb_main {

class WrappedServiceFactory:
	public cppu::WeakImplHelper5<
		com::sun::star::lang::XMultiServiceFactory,
		com::sun::star::lang::XServiceInfo,
		com::sun::star::lang::XComponent,
		com::sun::star::container::XSet,
		com::sun::star::container::XContentEnumerationAccess >
{
public:
	WrappedServiceFactory(
		com::sun::star::uno::Reference<
				com::sun::star::lang::XMultiServiceFactory > const &
			rServiceFactory,
		bool bServer)
		throw (com::sun::star::uno::RuntimeException);

	virtual ~WrappedServiceFactory() throw ();

	//========================================================================
	// com::sun::star::lang::XMultiServiceFactory:

	virtual
	com::sun::star::uno::Reference< com::sun::star::uno::XInterface > SAL_CALL
	createInstance(rtl::OUString const & rServiceSpecifier)
		throw (com::sun::star::uno::Exception,
			   com::sun::star::uno::RuntimeException);

	virtual
	com::sun::star::uno::Reference< com::sun::star::uno::XInterface > SAL_CALL
	createInstanceWithArguments(
		rtl::OUString const & rServiceSpecifier,
		com::sun::star::uno::Sequence< com::sun::star::uno::Any > const &
			rArguments)
		throw (com::sun::star::uno::Exception,
			   com::sun::star::uno::RuntimeException);

	virtual com::sun::star::uno::Sequence< rtl::OUString > SAL_CALL
	getAvailableServiceNames()
		throw (com::sun::star::uno::RuntimeException);

	//========================================================================
	// com::sun::star::lang::XServiceInfo:

	virtual rtl::OUString SAL_CALL getImplementationName()
		throw (com::sun::star::uno::RuntimeException);

	virtual sal_Bool SAL_CALL
	supportsService(rtl::OUString const & rServiceName)
		throw (com::sun::star::uno::RuntimeException);

	virtual com::sun::star::uno::Sequence< rtl::OUString > SAL_CALL
	getSupportedServiceNames()
		throw (com::sun::star::uno::RuntimeException);

	//========================================================================
	// com::sun::star::lang::XComponent:

	virtual void SAL_CALL dispose()
		throw (com::sun::star::uno::RuntimeException);

	virtual void SAL_CALL
	addEventListener(com::sun::star::uno::Reference<
					         com::sun::star::lang::XEventListener > const &
					     rListener)
		throw (com::sun::star::uno::RuntimeException);

	virtual void SAL_CALL
	removeEventListener(com::sun::star::uno::Reference<
						        com::sun::star::lang::XEventListener > const &
						    rListener)
		throw (com::sun::star::uno::RuntimeException);

	//========================================================================
	// com::sun::star::container::XSet:

	virtual com::sun::star::uno::Type SAL_CALL getElementType()
		throw (com::sun::star::uno::RuntimeException);

	virtual sal_Bool SAL_CALL hasElements()
		throw (com::sun::star::uno::RuntimeException);

	virtual
	com::sun::star::uno::Reference< com::sun::star::container::XEnumeration >
	SAL_CALL
	createEnumeration()
		throw (com::sun::star::uno::RuntimeException);

	virtual sal_Bool SAL_CALL has(com::sun::star::uno::Any const & rElement)
		throw (com::sun::star::uno::RuntimeException);

	virtual void SAL_CALL insert(com::sun::star::uno::Any const & rElement)
		throw (com::sun::star::lang::IllegalArgumentException,
			   com::sun::star::container::ElementExistException,
			   com::sun::star::uno::RuntimeException);

	virtual void SAL_CALL remove(com::sun::star::uno::Any const & rElement)
		throw (com::sun::star::lang::IllegalArgumentException,
			   com::sun::star::container::NoSuchElementException,
			   com::sun::star::uno::RuntimeException);

	//========================================================================
	// com::sun::star::container::XContentEnumerationAccess:

	virtual
	com::sun::star::uno::Reference< com::sun::star::container::XEnumeration >
	SAL_CALL
	createContentEnumeration(rtl::OUString const & rServiceName)
		throw (com::sun::star::uno::RuntimeException);

private:
	osl::Mutex m_aMutex;
	cppu::OInterfaceContainerHelper m_aListeners;
		// m_aMutex must come before m_aListeners...
	com::sun::star::uno::Reference<
			com::sun::star::lang::XMultiServiceFactory >
		m_xServiceFactory;
	com::sun::star::uno::Reference< com::sun::star::uno::XInterface >
	    m_xUniversalContentBroker;
	com::sun::star::uno::Reference< com::sun::star::uno::XInterface >
	    m_xRemoteContentBroker;
	com::sun::star::uno::Reference< com::sun::star::uno::XInterface >
	    m_xRemoteContentProviderAcceptor;
	bool m_bServer;

	com::sun::star::uno::Reference< com::sun::star::uno::XInterface >
	getUniversalContentBroker()
		throw (com::sun::star::uno::RuntimeException);

	com::sun::star::uno::Reference< com::sun::star::uno::XInterface >
	getRemoteContentBroker(rtl::OUString const & rServiceSpecifier)
		throw (com::sun::star::uno::Exception);

	com::sun::star::uno::Reference< com::sun::star::uno::XInterface >
	getRemoteContentProviderAcceptor(
		rtl::OUString const & rServiceSpecifier)
		throw (com::sun::star::uno::Exception);
};

}

#endif // INCLUDED_UCB_MAINWRAPPEDSERVICEFACTORY_HXX
