/*************************************************************************
 *
 *  $RCSfile: mac.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:03:07 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <mac_start.h>
#include <errno.h>
#include <stdlib.h>
#include <stdio.h>
#include <Errors.h>
#include <resources.h>
#include <Memory.h>
#include <PLStringFuncs.h>
#include <folders.h>
#include <Aliases.h>
#include <mac_end.h>

#include <debug.hxx>
#include <list.hxx>
#include "comdep.hxx"
#include "fsys.hxx"

DECLARE_LIST( DirEntryList, DirEntry* );
DECLARE_LIST( FSysSortList, FSysSort* );
DECLARE_LIST( FileStatList, FileStat* );

/*************************************************************************
|*
|*    MAC_StringPtr c2pStr2( const char *pChar, Str255& rString )
|*
|*    Beschreibung      wie c2pStr aber nicht in Place -> Schneller
|*    Ersterstellung    MA  18.09.91
|*    Letzte Aenderung  WKC 28.06.95 CW6
|*
*************************************************************************/

MAC_StringPtr c2pStr2( const char *pChar, Str255& rString )
{   MAC_StringPtr sp = rString;
    if (!pChar)
        rString[0] = '\0';
    else
    {
        int len = strlen(pChar);
        rString[0] = (BYTE) Min(len,255);
        strncpy( (char*) &rString[1], pChar,rString[0] );
    }
    return (MAC_StringPtr)sp;
}

/*************************************************************************
|*
|*    char* p2cStr2( const char *pChar, Str255& rString )
|*
|*    Beschreibung      wie p2cStr aber nicht in Place -> Schneller
|*    Ersterstellung    MA 18.09.91
|*    Letzte Aenderung  MA 18.09.91
|*
*************************************************************************/

char* p2cStr2(ConstStr255Param rString, char *pChar )
{
    pChar[rString[0]] = '\0';
    strncpy( pChar,(const char*) &rString[1] ,rString[0]);
    return pChar;
}

/*************************************************************************
|*
|*    char * strdup( const char *pChar )
|*
|*    Beschreibung      FSYS.SDW
|*    Ersterstellung    MA 18.09.91
|*    Letzte Aenderung  MA 18.09.91
|*
*************************************************************************/

//strdup kennt der MAC leider nicht
char * strdup( const char *pChar )
{
    char *pReturn = new char[ strlen( pChar ) + 1 ];
    strcpy( pReturn, pChar );
    return pReturn;
}

/*************************************************************************
|*
|*    DIR *opendir( const char* pPfad )
|*
|*    Beschreibung      FSYS.SDW
|*    Ersterstellung    MA 18.09.91
|*    Letzte Aenderung  MA 01.10.91
|*
*************************************************************************/

DIR *opendir( const char* pPath )
{
    DIR     *pDir = new DIR;
    Str255   pPasStr;
    WDPBRec aWDParam;

    pDir->d_name   = NULL;
    pDir->nFileNum = 0;

    //Open an Working Directory
    aWDParam.ioNamePtr  = c2pStr2(pPath,pPasStr);
    aWDParam.ioCompletion = NULL;
    aWDParam.ioVRefNum  = 0;
    aWDParam.ioWDProcID = 'ERIK';
    aWDParam.ioWDDirID  = 0;

    if ( PBOpenWDSync( &aWDParam ) )
    {
        delete pDir;
        return NULL;
    }

    //looks like an succesfull call, now remark the values
    pDir->d_name = new char[ pPasStr[0] + 1 ];
    p2cStr2(pPasStr,pDir->d_name);

    pDir->nioVRefNum = aWDParam.ioVRefNum;

    return pDir;
}

/*************************************************************************
|*
|*    struct dirent *readdir( DIR *pDir )
|*
|*    Beschreibung      FSYS.SDW
|*    Ersterstellung    MA 18.09.91
|*    Letzte Aenderung  MA 15.01.92
|*
*************************************************************************/

struct dirent *readdir( DIR *pDir )
{
#define PARAM pDir->aInfo.hFileInfo

    if ( !pDir ) return NULL;

    Str255 pPasStr;
    pPasStr[0] = '\0';

    pDir->nFileNum++;
    PARAM.ioFDirIndex = pDir->nFileNum;
    PARAM.ioVRefNum   = pDir->nioVRefNum;
    PARAM.ioNamePtr   = pPasStr;
    PARAM.ioCompletion = NULL;
    PARAM.ioDirID      = 0;
    PARAM.ioFRefNum    = 0;

    if ( PBGetCatInfoSync( &pDir->aInfo) )
        return NULL; //Hier darf kein closdir stattfinden!

    //looks like an succesfull call, now remark the values
    if ( pDir->d_name != NULL ) delete pDir->d_name;
    pDir->d_name = new char[ pPasStr[0] + 1 ];
    p2cStr2(pPasStr,pDir->d_name);

    return pDir;
#undef PARAM
}

/*************************************************************************
|*
|*    int closedir( DIR *pDir )
|*
|*    Beschreibung      FSYS.SDW
|*    Ersterstellung    MA 18.09.91
|*    Letzte Aenderung  MA 30.09.91
|*
*************************************************************************/

int closedir( DIR *pDir )
{
    if ( !pDir ) return 1;
    if ( pDir->d_name != NULL ) delete pDir->d_name;

    return 0;
}

/*************************************************************************
|*
|*    int mkdir( char* pPfad, int )
|*
|*    Beschreibung      FSYS.SDW
|*    Ersterstellung    MA 30.09.91
|*    Letzte Aenderung  MA 01.10.91
|*
*************************************************************************/

int mkdir( char* pPath )
{
    HParamBlockRec aParmBlk;
    Str255         pPasStr;

    aParmBlk.fileParam.ioCompletion = NULL;
    aParmBlk.fileParam.ioVRefNum = 0;
    aParmBlk.fileParam.ioDirID   = 0;
    aParmBlk.fileParam.ioNamePtr = c2pStr2(pPath,pPasStr);

    if ( PBDirCreateSync( &aParmBlk ) )
        return 1;
    return 0;
}

/*************************************************************************
|*
|*    int rmdir( char* pPfad )
|*
|*    Beschreibung      FSYS.SDW
|*    Ersterstellung    MI 27.05.93
|*    Letzte Aenderung  MI 27.05.93
|*
*************************************************************************/

int rmdir( char* pPath )
{
    HParamBlockRec aParmBlk;
    Str255         pPasStr;

    aParmBlk.fileParam.ioCompletion = NULL;
    aParmBlk.fileParam.ioVRefNum = 0;
    aParmBlk.fileParam.ioDirID   = 0;
    aParmBlk.fileParam.ioNamePtr = c2pStr2(pPath,pPasStr);

	OSErr nErr = PBHDeleteSync( &aParmBlk);

	if (nErr != noErr)
	{
		WDPBRec aWDParam;

		//Open an Working Directory
		aWDParam.ioNamePtr  = pPasStr;
		aWDParam.ioCompletion = NULL;
		aWDParam.ioVRefNum  = 0;
		aWDParam.ioWDProcID = 'ERIK';
		aWDParam.ioWDDirID  = 0;

		nErr = PBOpenWDSync( &aWDParam);

		if (nErr == noErr)
		{
			nErr = PBCloseWDSync( &aWDParam );
			nErr = PBHDeleteSync( &aParmBlk );
		}
	}

    switch ( nErr )
    {
        case 0:
            return 0;
        case nsvErr:
        case bdNamErr:
        case fnfErr:
        case dirNFErr:
            return ENOENT;
        case wPrErr:
        case fLckdErr:
        case vLckdErr:
        case fBsyErr:
        case afpAccessDenied:
            return EACCES;
        default:
            return EIO;
    }
}

/*************************************************************************
|*
|*    char* getcwd( char* pBuf, int nMaxLen )
|*
|*    Beschreibung      FSYS.SDW
|*    Ersterstellung    MA 01.10.91
|*    Letzte Aenderung  MA 01.10.91
|*
*************************************************************************/

char* getcwd( char* pBuf, int nMaxLen )
{
#define PARAM aPBParam.dirInfo

    if ( nMaxLen < 1 )
    {   //No Len no Buf
        pBuf = NULL;
        return pBuf;
    }

    WDPBRec     aWDParam;
    CInfoPBRec  aPBParam;
    String      aCurPath;
    Str255      pPasStr;
    OSErr       eErr;

    //Get a Working Directory to identify
    //the Currend Directory
    pPasStr[0] = '\0';
    aWDParam.ioCompletion = NULL;
    aWDParam.ioNamePtr  = pPasStr;
    aWDParam.ioVRefNum  = 0;
    aWDParam.ioWDProcID = 'ERIK';
    aWDParam.ioWDDirID  = 0;

    if ( PBOpenWDSync( &aWDParam) )
    {
        pBuf[0] = '\0';
        return pBuf;
    }

    //Use the Working Directory to find the
    //vRefNum and DirID of the real directory
    aWDParam.ioWDIndex  = 0;
    aWDParam.ioWDProcID = 0;
    aWDParam.ioNamePtr  = NULL;
    if ( PBGetWDInfoSync( &aWDParam ) )
    {
        pBuf[0] = '\0';
        return pBuf;
    }

    //Now get the Full Pathname using the
    //vRefNum and the DirID
    pPasStr[0] = '\0';
    PARAM.ioNamePtr    = pPasStr;
    PARAM.ioFDirIndex  = -1;
    PARAM.ioVRefNum    = aWDParam.ioVRefNum;
    PARAM.ioDrDirID    = aWDParam.ioWDDirID;

    for ( eErr = PBGetCatInfoSync( &aPBParam);
          eErr == noErr;
          eErr = PBGetCatInfoSync( &aPBParam) )
    {
        PARAM.ioDrDirID = PARAM.ioDrParID;
        String aCurFolder( (char*) &PARAM.ioNamePtr[1] , PARAM.ioNamePtr[0]);
        aCurFolder += ':';
        aCurPath = aCurFolder + aCurPath;
    }
    //Delete the colon at the tail.
    aCurPath.Erase( aCurPath.Len() - 1 );

    //since the Path can be a Simple Volume-Name in this case it
    //should have an colon at the tail!
    if ( aCurPath.Search( ":" ) == STRING_NOTFOUND )
        aCurPath += ':';

    return strncpy( pBuf, aCurPath.GetStr(), nMaxLen );
#undef PARAM
};

/*************************************************************************
|*
|*    OSErr CopyData( BOOL bResource, DirEntry& rSource, DirEntry& rDest,
|*                    short nSourceVol, short nDestVol, long nSpace )
|*
|*    Beschreibung      FSYS.SDW
|*    Ersterstellung    MA 10.10.91
|*    Letzte Aenderung  DV 25.01.94
|*
*************************************************************************/

/* Copies the Data from on File to another.
   If bResource is TRUE the Resource Fork would be copied, otherwise the
   Data Fork would be copied.
*/

OSErr CopyData( BOOL bResource, FileCopier *pCopier,
                const DirEntry &rSource, const DirEntry &rTarget,
                short nSourceVol, short nDestVol, long nSpace )
{
    short   nSourceRef = 0;     //Reference to Source-Path
    short   nDestRef = 0;       //Reference to Destination-Path
    OSErr   eErr;
    BOOL    bDontClose = FALSE;

    if ( !nSpace )
        return 0;

    //Try to Open the Forks
    {
        String aSourceStr( rSource.GetFull() );
        String aDestStr ( rTarget.GetFull() );
        if ( bResource )
        {
            eErr = OpenRF( aSourceStr.GetPascalStr(), nSourceVol, &nSourceRef );
            if ( eErr == opWrErr )
                bDontClose = TRUE;
            if ( ( eErr == noErr ) || ( eErr == opWrErr ) )
                eErr = OpenRF( aDestStr.GetPascalStr(),
                               nDestVol, &nDestRef );
        }
        else
        {
            eErr = FSOpen( aSourceStr.GetPascalStr(), nSourceVol, &nSourceRef );
            if ( eErr == opWrErr )
                bDontClose = TRUE;
            if ( ( eErr == noErr ) || ( eErr == opWrErr ) )
                eErr = FSOpen( aDestStr.GetPascalStr()
                                , nDestVol, &nDestRef );
        }
    }

    // Allocate Space to the Destination and set the Marks to the
    // Beginning of the Files
    if (   eErr ||
         ( eErr = Allocate( nDestRef, &nSpace ) ) ||
         ( eErr = SetFPos( nSourceRef, fsFromStart, (long)0 ) ) ||
         ( eErr = SetFPos( nDestRef,   fsFromStart, (long)0 ) ) )
    {
        if ( nDestRef )
            FSClose( nDestRef );
        if ( !bDontClose && nSourceRef )
            FSClose( nSourceRef );
        return eErr;
    }

    // allocate the buffer
    Handle  hMyData = 0;
    long    nGrow;
    OSErr   nErr;
    void    *pData;
    long    nMaxLen;
    long    nCount;

    nMaxLen = MaxBlock();
    if ( ( nMaxLen > nSpace ) || ( nMaxLen > 0x1000 ) ) {
        if ( nMaxLen > nSpace )
            nMaxLen = nSpace;
        hMyData = NewHandle( nMaxLen );
    }
    if ( ! hMyData ) {
        nMaxLen = TempMaxMem( &nGrow );
        if ( nMaxLen > nSpace )
            nMaxLen = nSpace;
        hMyData = TempNewHandle( nMaxLen, &nErr );
    }

    if ( hMyData ) {
        HLock( hMyData );
        pData = *hMyData;
        nCount = nMaxLen;
    } else {
        pData  = malloc ( 1024 );
        nCount  = 1024;
    }

    if ( pData == NULL )
        return -1;

    nErr    = 0;

    // copy the data
    if ( pCopier )
        pCopier->nBlockSize = nCount;
    while ( ( !pCopier || pCopier->Progress() ) && !eErr && !nErr )
    {
        nErr = SetVol( (MAC_StringPtr)NULL, nSourceVol );
        if ( !nErr )
            eErr = FSRead( nSourceRef, &nCount, pData );
        if ( ( eErr == noErr ) || ( eErr == eofErr ) )
            nErr = SetVol( (MAC_StringPtr)NULL, nDestVol );
        if ( !nErr )
            nErr = FSWrite( nDestRef, &nCount, pData );

        if ( pCopier )
        {
            pCopier->nBlockSize = nCount;
            pCopier->nBytesCopied += nCount;
            if ( pCopier->nBytesTotal < pCopier->nBytesCopied )
                pCopier->nBytesTotal = pCopier->nBytesCopied;
        }
    }
    if ( hMyData ) {
        HUnlock( hMyData );
        DisposeHandle( hMyData );
    } else
        free ( pData );

    if ( !bDontClose )
        FSClose( nSourceRef );

    // Die Rueckgabewerte von FSClose und FlushVol interessieren nicht
    FSClose( nDestRef );
    FlushVol( (MAC_StringPtr)NULL, nDestVol );

    // eErr enthaelt die beim Lesen aufgetretenen Fehler, eofErr ist KEIN
    // Fehler. nErr enthaelt den letzten beim Schreiben aufgetretenen Fehler.
    if ( eErr == eofErr )
        eErr = noErr;
    if ( ( eErr == noErr ) && ( nErr != noErr ) )
        eErr = nErr;

    return eErr;
}

/*************************************************************************
|*
|*    FSysError CopyFile( FileCopier *pCopier,
|*                        const DirEntry &rSource, const DirEntry &rTarget,
|*                        BOOL bRemoveSource )
|*
|*    Beschreibung      FSYS.SDW
|*    Ersterstellung    MA 10.10.91
|*    Letzte Aenderung  DV 16.12.96
|*
*************************************************************************/

/* This Routive Copies a File fron one Volume to another, then it
   deletes the Source-File
   The Direntry have to contain absolute Pathes!
   The Default-Volume is changed by this Routine!
   If required the Destination-Path would be created.
*/

FSysError CopyFile( FileCopier *pCopier,
                    const DirEntry &rSource, const DirEntry &rTarget,
                    BOOL bRemoveSource )
{
    CInfoPBRec    aPBParmSource,
                  aPBParmDest;
    ParamBlockRec aVolParam;
    short         nSourceVol,   //ID of the Source-Volume
                  nDestVol;     //ID of the Destination-Volume
    OSErr         eErr;
    Str255        aPascalStr;

    // Get the Source and Destination-Volumes
    String aSourceStr( rSource.GetDevice().GetFull() );
    aVolParam.volumeParam.ioCompletion = NULL;
    aVolParam.volumeParam.ioNamePtr    = c2pStr2( aSourceStr, aPascalStr );
    aVolParam.volumeParam.ioVRefNum    = 0;
    aVolParam.volumeParam.ioVolIndex   = -1;
    if ( PBGetVInfoSync( &aVolParam) )
        return FSYS_ERR_INVALIDDEVICE;
    nSourceVol = aVolParam.volumeParam.ioVRefNum;

    String aDestStr( rTarget.GetDevice().GetFull() );
    aVolParam.volumeParam.ioNamePtr = c2pStr2( aDestStr, aPascalStr );
    aVolParam.volumeParam.ioVRefNum = 0;
    if ( PBGetVInfoSync( &aVolParam) )
        return FSYS_ERR_INVALIDDEVICE;
    nDestVol = aVolParam.volumeParam.ioVRefNum;

    // Get Information about the Source. This Info would be needed to
    // get the Creator, Type, Creation-Date and so on.
    aSourceStr = rSource.GetFull();
    aPBParmSource.hFileInfo.ioCompletion = NULL;
    aPBParmSource.hFileInfo.ioNamePtr    = c2pStr2( aSourceStr, aPascalStr );
    aPBParmSource.hFileInfo.ioVRefNum    = 0;
    aPBParmSource.hFileInfo.ioFRefNum    = 0;
    aPBParmSource.hFileInfo.ioFDirIndex  = 0;
    aPBParmSource.hFileInfo.ioDirID      = 0;
    if ( eErr = PBGetCatInfoSync( &aPBParmSource) )
        return FSYS_ERR_UNKNOWN;    //not reachable!

    rTarget.GetPath().MakeDir();
    aDestStr = rTarget.GetFull();
    eErr = Create(aDestStr.GetPascalStr(), nDestVol,
                 aPBParmSource.hFileInfo.ioFlFndrInfo.fdType,
                 aPBParmSource.hFileInfo.ioFlFndrInfo.fdCreator );
    if ( eErr != noErr ) {
        switch ( eErr )
        {
            case dupFNErr:
			{
				FSDelete( aDestStr.GetPascalStr(), nDestVol );
				eErr = Create(aDestStr.GetPascalStr(), nDestVol,
							 aPBParmSource.hFileInfo.ioFlFndrInfo.fdType,
							 aPBParmSource.hFileInfo.ioFlFndrInfo.fdCreator );
				if ( eErr != noErr )
					return FSYS_ERR_UNKNOWN;
				break;
			}
			case dirFulErr: return FSYS_ERR_VOLUMEFULL;
            case vLckdErr:
            case wPrErr:    return FSYS_ERR_LOCKVIOLATION;
            default:        return FSYS_ERR_UNKNOWN;
        }
    }

    // Try to copy the source- and destination-Data
    if ( ( eErr = CopyData( FALSE, pCopier, rSource, rTarget,
                            nSourceVol, nDestVol,
                          aPBParmSource.hFileInfo.ioFlLgLen ) ) ||
         ( eErr = CopyData( TRUE, pCopier, rSource, rTarget,
                            nSourceVol, nDestVol,
                          aPBParmSource.hFileInfo.ioFlRLgLen ) ) )
    {
        FSDelete(aDestStr.GetPascalStr(), nDestVol );
        switch ( eErr )
        {
            case dskFulErr: return FSYS_ERR_VOLUMEFULL;
            case opWrErr:
            case fLckdErr:
            case vLckdErr:
            case wrPermErr:
            case tmfoErr:   return FSYS_ERR_LOCKVIOLATION;
            default:        return FSYS_ERR_UNKNOWN;
        }
    }
    //Update the File-Information of the Destination
    aPBParmDest.hFileInfo.ioCompletion = NULL;
    aPBParmDest.hFileInfo.ioNamePtr    = c2pStr2( aDestStr, aPascalStr );
    aPBParmDest.hFileInfo.ioVRefNum    = 0;
    aPBParmDest.hFileInfo.ioFRefNum    = 0;
    aPBParmDest.hFileInfo.ioFDirIndex  = 0;
    aPBParmDest.hFileInfo.ioDirID      = 0;
    aPBParmDest.hFileInfo.ioFlFndrInfo = aPBParmSource.hFileInfo.ioFlFndrInfo;

    // clear the hasBeenInited bit
	aPBParmDest.hFileInfo.ioFlFndrInfo.fdFlags &= 0xfeff;
//    aPBParmDest.hFileInfo.ioFlFndrInfo.fdLocation.h += 10;
//    aPBParmDest.hFileInfo.ioFlFndrInfo.fdLocation.v += 10;
    aPBParmDest.hFileInfo.ioFlCrDat    = aPBParmSource.hFileInfo.ioFlCrDat;
    aPBParmDest.hFileInfo.ioFlMdDat    = aPBParmSource.hFileInfo.ioFlMdDat;
    aPBParmDest.hFileInfo.ioFlBkDat    = aPBParmSource.hFileInfo.ioFlBkDat;
    aPBParmDest.hFileInfo.ioFlXFndrInfo= aPBParmSource.hFileInfo.ioFlXFndrInfo;
    aPBParmDest.hFileInfo.ioFlClpSiz   = 0;
    if ( PBSetCatInfoSync( &aPBParmDest) )
    {
        FSDelete( aDestStr.GetPascalStr(), nDestVol );
        return FSYS_ERR_UNKNOWN;    //shouldn't be reached!
    }

    if ( bRemoveSource )
    {
        //Now delete the Source-File
        if ( eErr = FSDelete( aSourceStr.GetPascalStr(), nSourceVol ) ) {
            FSDelete( aDestStr.GetPascalStr(), nDestVol );
            switch ( eErr )
            {
                case vLckdErr:
                case wPrErr:
                case fLckdErr: return FSYS_ERR_LOCKVIOLATION;
                default:       return FSYS_ERR_UNKNOWN;
            }
        }
    }

    return FSYS_ERR_OK;
}

/*************************************************************************
|*
|*    DirEntry::ToAbs()
|*
|*    Beschreibung      FSYS.SDW
|*    Ersterstellung    MI 26.04.91
|*    Letzte Aenderung  MA 02.12.91 13:30
|*
*************************************************************************/

BOOL DirEntry::ToAbs()
{
    DBG_CHKTHIS( DirEntry, ImpCheckDirEntry );

	if (paVirtualURL)
	{
	    return TRUE;
	}

	if ( FSYS_FLAG_VOLUME == eFlag )
	{
		eFlag = FSYS_FLAG_ABSROOT;
		return TRUE;
	}

    if ( IsAbs() )
        return TRUE;

    char sBuf[ MAXPATHLEN ];
    *this = DirEntry( String( getcwd( sBuf, MAXPATHLEN ) ) ) + *this;

    return IsAbs();
}

/*************************************************************************
|*
|*    DirEntry::GetVol()
|*
|*    Beschreibung      FSYS.SDW
|*    Ersterstellung    MA 02.12.91 14:07
|*    Letzte Aenderung
|*
*************************************************************************/

String DirEntry::GetVolume() const
{
    DBG_CHKTHIS( DirEntry, ImpCheckDirEntry );

    return GetDevice().GetName();
}

/*************************************************************************
|*
|*    DirEntry::SetCWD()
|*
|*    Beschreibung      FSYS.SDW
|*    Ersterstellung    MA 02.12.91 14:07
|*    Letzte Aenderung  DV 04.03.94
|*
*************************************************************************/

BOOL DirEntry::SetCWD( BOOL bSloppy )
{
    DBG_CHKTHIS( DirEntry, ImpCheckDirEntry );

	if (paVirtualURL)
	{
		String aTempString(GetRealPathFromVirtualURL());
		if (aTempString.Len()==0)
		{
		        return FALSE;
		}
		DirEntry aTempDirEntry(aTempString);
		return aTempDirEntry.SetCWD(bSloppy);
	}
	
    if ( eFlag == FSYS_FLAG_CURRENT && !aName.Len() )
        return TRUE;

    DirEntry         aTmpDir( *this );
    ParamBlockRec    aParam;
    BOOL             bRet = TRUE;
    DIR             *pDir;

    aTmpDir.ToAbs();
    pDir = opendir( (const char*)aTmpDir.GetFull() );

    //Nemen wir mal an, es handelt sich um ein Verzeichnis
    aParam.volumeParam.ioCompletion = NULL;
    aParam.volumeParam.ioNamePtr = NULL;
    if ( pDir )
        aParam.volumeParam.ioVRefNum = pDir->nioVRefNum;

    if ( !pDir || ( noErr != PBSetVolSync( &aParam) ) )
    {
        if ( bSloppy && pParent )
        {
            //Zweiter Versuch; bei Sloppy reicht es, wenn der
            //Parent ein Verzeichnis ist
            if ( pDir ) {
                closedir( pDir );
                delete pDir;
            }
            pDir = opendir( (const char*)aTmpDir.pParent->GetFull() );
            if ( pDir ) {
                aParam.volumeParam.ioVRefNum = pDir->nioVRefNum;
                if ( PBSetVolSync( &aParam) )
                    bRet = FALSE;
            } else {
                bRet = FALSE;
            }
        }
        else
            bRet = FALSE;
    }

    if ( pDir ) {
        closedir( pDir );
        delete pDir;
    }

    return bRet;
}

/*************************************************************************
|*
|*    DirEntry::MoveTo()
|*
|*    Beschreibung      FSYS.SDW
|*    Ersterstellung    MA 02.12.91 14:07
|*    Letzte Aenderung  DV 04.12.97
|*
*************************************************************************/

FSysError DirEntry::MoveTo( const DirEntry& rDest ) const
{
    DBG_CHKTHIS( DirEntry, ImpCheckDirEntry );

    DirEntry	aDstEntry = rDest;

	//The Destination should not Exist
    if ( aDstEntry.Exists() )
	{
	    DirEntryKind eKind = FileStat( aDstEntry ).GetKind();
    	if ( eKind & FSYS_KIND_DIR )
		{
			aDstEntry += GetName();
		    if ( aDstEntry.Exists() )
				return FSYS_ERR_ALREADYEXISTS;
		}
		else
			return FSYS_ERR_ALREADYEXISTS;
	}

    //The Source should Exist
    if ( !Exists() )
        return FSYS_ERR_NOTEXISTS ;

    OSErr   nErr;
    FSSpec  aSource;
    FSSpec  aDest;

    nErr = FSMakeFSSpec( 0, 0, GetFull().GetPascalStr(), &aSource );
    if ( nErr != noErr )
        return FSYS_ERR_UNKNOWN;

	nErr = FSMakeFSSpec( 0, 0, aDstEntry.GetFull().GetPascalStr(), &aDest );
    if ( ( nErr != noErr ) && ( nErr != fnfErr ) )
        return FSYS_ERR_UNKNOWN;

    // Wenn die Volumes unterschiedlich sind, dann Sonderbehandlung
    if ( aSource.vRefNum != aDest.vRefNum ) {
        // Different Volumes -> I have to Copy and Delete
        // This runs only if the source is a File
        // (otherwise 'subsequent' Files and Dirs must be copied!)

        if ( !FileStat( *this ).IsKind( FSYS_KIND_FILE ) )
            return FSYS_ERR_NOTSUPPORTED;

        short nDefVol = 0;

        if ( ::GetVol( (MAC_StringPtr)NULL, &nDefVol ) )
            return FSYS_ERR_UNKNOWN;

        DirEntry aSrcEntry( *this );

        if ( CopyFile( 0, aSrcEntry, aDstEntry, TRUE ) != 0 )
            return FSYS_ERR_UNKNOWN;
        SetVol( (MAC_StringPtr)NULL, nDefVol );
    } else {
        // Gleiches Volume, aber unterschiedliche Directories
        if ( aSource.parID != aDest.parID ) {
            nErr = CatMove( aSource.vRefNum, aSource.parID,
                            aSource.name, aDest.parID, (unsigned char*)"\p:" );
            if ( nErr != noErr )
                return FSYS_ERR_UNKNOWN;
        }
        // The File is moved, must it be renamed?
        if ( aName != aDstEntry.aName ) {
            nErr = HRename( aDest.vRefNum, aDest.parID,
                            aSource.name, aDest.name );
            if ( nErr != noErr )
                return FSYS_ERR_UNKNOWN;
        }
    }

    return FSYS_ERR_OK;
}

/*************************************************************************
|*
|*    FileCopier::Execute()
|*
|*    Beschreibung      FSYS.SDW
|*    Ersterstellung    MA 02.12.91 14:07 (DirEntry::CopyTo())
|*    Letzte Aenderung  DV 04.12.97
|*
*************************************************************************/

FSysError FileCopier::DoCopy_Impl( const DirEntry &rSource, const DirEntry &rTarget,
								   BOOL bTop )
{
	FSysError eRet = FSYS_ERR_OK;
	ErrCode eWarn = FSYS_ERR_OK;

	DirEntry aTarget = rTarget;

	// source is directory?
	FileStat aSourceFileStat( rSource );

	if ( aSourceFileStat.IsKind(FSYS_KIND_DIR) )
	{
		// recursive copy
		eRet = Error( aTarget.MakeDir() ? FSYS_ERR_OK : FSYS_ERR_UNKNOWN,
					  0, &aTarget );
		Dir aSourceDir( rSource, FSYS_KIND_DIR|FSYS_KIND_FILE );
		for ( USHORT n = 0;
			  ERRCODE_TOERROR(eRet) == FSYS_ERR_OK && n < aSourceDir.Count();
			  ++n )
		{
			const DirEntry &rSubSource = aSourceDir[n];
			DirEntryFlag eFlag = rSubSource.GetFlag();
			if ( eFlag != FSYS_FLAG_CURRENT && eFlag != FSYS_FLAG_PARENT )
			{
				DirEntry aSubTarget( aTarget );
				aSubTarget += rSubSource.GetName();
				eRet = DoCopy_Impl( rSubSource, aSubTarget, FALSE );
				if ( eRet && !eWarn )
					eWarn = eRet;
			}
		}
	}
	else if ( aSourceFileStat.IsKind(FSYS_KIND_FILE) )
	{
		// copy file
		short nDefVol = 0;
		nBytesTotal = FileStat( rSource ).GetSize();
		nBytesCopied = 0;

		if ( ::GetVol( (MAC_StringPtr)NULL, &nDefVol ) )
			eRet = FSYS_ERR_UNKNOWN;
		else if ( CopyFile( this, rSource, aTarget, FALSE ) != 0 )
			eRet = FSYS_ERR_UNKNOWN;
		else
			SetVol( (MAC_StringPtr)NULL, nDefVol );
    }

	// bei Move ggf. das File/Dir loeschen
	if ( ( FSYS_ERR_OK == eRet) &&
		 ( pImp->nActions & FSYS_ACTION_MOVE ) )
	{
		ErrCode eKillErr =
			Error( rSource.Kill() | ERRCODE_WARNING_MASK, &rSource, 0 );
		if ( eKillErr != ERRCODE_WARNING_MASK )
		{
			if ( rSource.Exists() )
				// loeschen ging nicht => dann die Kopie wieder loeschen
				aTarget.Kill( pImp->nActions );
			if ( !eWarn )
				eWarn = eKillErr;
		}
	}

    return !eRet ? eWarn : eRet;
}

#ifdef NOT_NEEDED_ANY_MORE
FSysError FileCopier::Execute( FSysAction nActions )
{
    // Now I have to Work with absolute Pathes. Since the
    // Destination and Source are const they must be copied.
    DirEntry aAbsSource = DirEntry( aSource);
    DirEntry aAbsDest   = DirEntry( aTarget );

    // check if both pathes are accessible and source and target are different
    if ( !aAbsDest.ToAbs() || !aAbsSource.ToAbs() ||
         aAbsDest == aAbsSource )
        return FSYS_ERR_ACCESSDENIED;

    // This runs only if the source is a File
    // (otherwise 'subsequent' Files and Dirs must be copied!)
    FileStat aSourceStat( aAbsSource );
    if ( !aSourceStat.IsKind( FSYS_KIND_FILE ) )
        return FSYS_ERR_NOTSUPPORTED;

	// Target ist Directory?
	if ( FileStat( aAbsDest ).IsKind(FSYS_KIND_DIR) )
		// dann Namen vom Source anh"angen
		aAbsDest += aSource.GetName();

    short nDefVol = 0;
    nBytesTotal = aSourceStat.GetSize();
    nBytesCopied = 0;

    if ( ::GetVol( (MAC_StringPtr)NULL, &nDefVol ) )
        return FSYS_ERR_UNKNOWN;
    if ( CopyFile( this, aAbsSource, aAbsDest, FALSE ) != 0 )
        return FSYS_ERR_UNKNOWN;
    SetVol( (MAC_StringPtr)NULL, nDefVol );

    return FSYS_ERR_OK;
}
#endif

//-------------------------------------------------------------------------

USHORT DirReader_Impl::Init()
{
    //Erstmal die Volumes versorgen
	USHORT nRead = 0;
    if ( pDir->eAttrMask &
         ( FSYS_KIND_DEV | FSYS_KIND_CHAR | FSYS_KIND_BLOCK ) )
    {
        ParamBlockRec aParam;
        Str255        sPasStr;

        sPasStr[0] = '\0';
        aParam.volumeParam.ioCompletion = NULL;
        aParam.volumeParam.ioNamePtr    = sPasStr;
        aParam.volumeParam.ioVRefNum    = 0;
        aParam.volumeParam.ioVolIndex   = 1;

        while ( noErr == PBGetVInfoSync( &aParam) )
        {
            String aVolName( (const char*) &sPasStr[1], sPasStr[0]);
            if ( pDir->aNameMask.Matches( aVolName.Lower() ) )
            {
                aVolName += ':';
                DirEntry *pNewEntry = new DirEntry( aVolName, FSYS_FLAG_VOLUME, FSYS_STYLE_HOST );
                if ( pDir->pStatLst ) //Status fuer Sort gewuenscht?
                {
                    FileStat *pNewStat = new FileStat( (void*)NULL, (void*)&aParam );
                    pDir->ImpSortedInsert( pNewEntry, pNewStat );
                }
                else
                    pDir->ImpSortedInsert( pNewEntry, NULL );
				++nRead;
            }
            aParam.volumeParam.ioVRefNum = 0;
            aParam.volumeParam.ioVolIndex++;
        }
    }
	return nRead;
}

//-------------------------------------------------------------------------

USHORT DirReader_Impl::Read()
{
    // Directories und Files auflisten?
	if ( ( pDir->eAttrMask & FSYS_KIND_DIR || pDir->eAttrMask & FSYS_KIND_FILE ) &&
		 ( ( pDosDir = readdir( pDosDir ) ) != NULL ) )
	{
	    if ( pDir->aNameMask.Matches( String( pDosDir->d_name ).Lower() ) )
	        if ( ( ( pDir->eAttrMask & FSYS_KIND_DIR ) &&
	        	   ( pDosDir->aInfo.dirInfo.ioFlAttrib & 16 ) &&
	               ( ( ! ( pDir->eAttrMask & FSYS_KIND_VISIBLE ) ) ||
	                 ( ! ( pDosDir->aInfo.dirInfo.ioDrUsrWds.frFlags & kIsInvisible ) ) ) ) ||
                 ( ( pDir->eAttrMask & FSYS_KIND_FILE ) &&
	               ( ! ( pDosDir->aInfo.dirInfo.ioFlAttrib & 16 ) ) &&
	               ( ( ! ( pDir->eAttrMask & FSYS_KIND_VISIBLE ) ) ||
	                 ( ! ( pDosDir->aInfo.hFileInfo.ioFlFndrInfo.fdFlags & kIsInvisible ) ) ) ) )
	        {
	            DirEntry *pNewEntry = new DirEntry( pDosDir->d_name );
//	            pNewEntry->ImpChangeParent( new DirEntry( aPfad ) );
				if ( pParent )
					pNewEntry->ImpChangeParent( new DirEntry( *pParent ), FALSE );
	            if ( pDir->pStatLst ) //Status fuer Sort gewuenscht?
	            {
	                FileStat *pNewStat = new FileStat( (void*)&(pDosDir->aInfo), (void*)NULL );
	                pDir->ImpSortedInsert( pNewEntry, pNewStat );
	            }
	            else
	                pDir->ImpSortedInsert( pNewEntry, NULL );
				return 1;
	        }
	}
	else
		bReady = TRUE;
	return 0;
}

/*************************************************************************
|*
|*    FileStat::FileStat()
|*
|*    Beschreibung      FSYS.SDW
|*    Ersterstellung    MA 05.11.91
|*    Letzte Aenderung  MA 07.11.91
|*
*************************************************************************/

FileStat::FileStat( const void *pInfo,      //CInfoPBRec
                    const void *pVolInfo ): //HParamBlockRec
	aDateCreated(0),
	aTimeCreated(0),
	aDateModified(0),
	aTimeModified(0),
	aDateAccessed(0),
	aTimeAccessed(0)
{
#define VOLINFO ((HParamBlockRec*)pVolInfo)->volumeParam
#define INFO    ((const CInfoPBRec*)pInfo)

	paVirtualURL    = NULL;

    nSize = 0;
    aCreator.Erase();
    aType.Erase();

    //Volume?
    if ( pVolInfo )
    {
        aDateCreated  = Mac2Date( VOLINFO.ioVCrDate );
        aTimeCreated  = Mac2Time( VOLINFO.ioVCrDate );
        aDateModified = Mac2Date( VOLINFO.ioVLsMod );
        aTimeModified = Mac2Time( VOLINFO.ioVLsMod );
        aDateAccessed = aDateModified;
        aTimeAccessed = aTimeModified;
        nSize         = ( VOLINFO.ioVNmAlBlks +
                          VOLINFO.ioVFrBlk )  *
                          VOLINFO.ioVAlBlkSiz;
        nKindFlags = FSYS_KIND_DEV;
    }
    else
    {   //Dir oder File!
        if ( INFO->dirInfo.ioFlAttrib & 16 )
                {
            nKindFlags = FSYS_KIND_DIR;

                        aDateCreated  = Mac2Date( INFO->dirInfo.ioDrCrDat );
                aTimeCreated  = Mac2Time( INFO->dirInfo.ioDrCrDat );
                aDateModified = Mac2Date( INFO->dirInfo.ioDrMdDat );
                aTimeModified = Mac2Time( INFO->dirInfo.ioDrMdDat );
        }
        else
                {
                    nKindFlags = FSYS_KIND_FILE;
            nSize  = INFO->hFileInfo.ioFlLgLen;
            //!      INFO->hFileInfo.ioFlRLgLen;

                        memcpy( aCreator.AllocStrBuf(4),
                &INFO->hFileInfo.ioFlFndrInfo.fdCreator, 4 );
                memcpy( aType.AllocStrBuf(4),
                &INFO->hFileInfo.ioFlFndrInfo.fdType, 4 );

                        aDateCreated  = Mac2Date( INFO->hFileInfo.ioFlCrDat );
                aTimeCreated  = Mac2Time( INFO->hFileInfo.ioFlCrDat );
                aDateModified = Mac2Date( INFO->hFileInfo.ioFlMdDat );
                aTimeModified = Mac2Time( INFO->hFileInfo.ioFlMdDat );
                }

        aDateAccessed = aDateModified;
        aTimeAccessed = aTimeModified;
    }
#undef VOLINFO
#undef INFO
}

/*************************************************************************
|*
|*    FileStat::Update()
|*
|*    Beschreibung      FSYS.SDW
|*    Ersterstellung    MI 11.06.91
|*    Letzte Aenderung  DV 09.12.97
|*
*************************************************************************/

// BOOL FileStat::Update( const DirEntry& rDirEntry )
// {
// 	return Update( rDirEntry, FALSE );
// }

BOOL FileStat::Update( const DirEntry& rDirEntry, BOOL bAccessRemovableDevice )
{
	paVirtualURL	= rDirEntry.paVirtualURL;

    nSize = 0;
    nKindFlags = 0;
    nError = FSYS_ERR_OK;
    aCreator.Erase();
    aType.Erase();
    aDateCreated = Date(0);
    aTimeCreated = Time(0);
    aDateModified = Date(0);
    aTimeModified = Time(0);
    aDateAccessed = Date(0);
    aTimeAccessed = Time(0);

	if (paVirtualURL)
	{
		if (rDirEntry.GetRealPathFromVirtualURL().Len()==0)
		{
			nKindFlags = FSYS_KIND_ALL;

			if (Folder(ItemIDPath(rDirEntry.GetFull())).IsValid())
			{
				nKindFlags &= ~FSYS_KIND_FILE;
			}
			else
			{
				nKindFlags &= ~FSYS_KIND_DIR;
			}

			nError = FSYS_ERR_OK;
		    return TRUE;
		}
	}

    if ( !rDirEntry.IsValid() )
    {
        nError = FSYS_ERR_NOTEXISTS;
        return FALSE;
    }

    //Sonderbehandlung falls es sich um ein Volume handelt
    Str255 pPasStr;
    if ( (rDirEntry.eFlag == FSYS_FLAG_VOLUME ) ||
         (rDirEntry.eFlag == FSYS_FLAG_ABSROOT) )
    {
        HParamBlockRec aParam;
        aParam.volumeParam.ioCompletion = NULL;
        aParam.volumeParam.ioNamePtr    = c2pStr2(rDirEntry.aName,pPasStr);
        aParam.volumeParam.ioVRefNum    = 0;
        aParam.volumeParam.ioVolIndex   = -1;
		
		aParam.volumeParam.ioNamePtr[ 0 ] += 1;
		aParam.volumeParam.ioNamePtr[aParam.volumeParam.ioNamePtr[0]] = ':';
		
        if ( PBHGetVInfoSync( &aParam) )
        {
            nError = FSYS_ERR_NOTEXISTS;
            return FALSE;
        }

        aDateCreated  = Mac2Date( aParam.volumeParam.ioVCrDate );
        aTimeCreated  = Mac2Time( aParam.volumeParam.ioVCrDate );
        aDateModified = Mac2Date( aParam.volumeParam.ioVLsMod );
        aTimeModified = Mac2Time( aParam.volumeParam.ioVLsMod );
        aDateAccessed = aDateModified;
        aTimeAccessed = aTimeModified;
        nSize         = ( aParam.volumeParam.ioVNmAlBlks +
                          aParam.volumeParam.ioVFrBlk )  *
                          aParam.volumeParam.ioVAlBlkSiz;
        nKindFlags = FSYS_KIND_DEV | FSYS_KIND_DIR;

        USHORT ioVDRefNum = aParam.volumeParam.ioVDRefNum;
		switch ( ioVDRefNum )
		{
			case 0xFFDF: nKindFlags |= FSYS_KIND_FIXED; break;
			case 0xFFD6: nKindFlags |= FSYS_KIND_REMOTE; break;
			case 0xFFDC: nKindFlags |= FSYS_KIND_CDROM; break;
			case 0xFFDA: nKindFlags |= FSYS_KIND_REMOVEABLE; break; // ZIP?
			case 0xFFFB: nKindFlags |= FSYS_KIND_REMOVEABLE; break; // Floppy?
			default: nKindFlags |= FSYS_KIND_FIXED; break;
		}

        return TRUE;
    }

    CInfoPBRec  aParam;

    //File-/Directory-Info holen
    aParam.dirInfo.ioCompletion = NULL;
    aParam.dirInfo.ioNamePtr    = c2pStr2(rDirEntry.paVirtualURL?rDirEntry.GetRealPathFromVirtualURL():rDirEntry.GetFull(),pPasStr);
    aParam.dirInfo.ioVRefNum    = 0;
    aParam.dirInfo.ioFDirIndex  = 0;
    aParam.dirInfo.ioDrDirID    = 0;
    if ( PBGetCatInfoSync( &aParam) )
    {
	    // Sonderbehandlung falls es sich um eine Wildcard handelt
	    String aTempName( rDirEntry.GetName() );
	    if ( strchr( (char*) (const char*) aTempName, '?' ) ||
	         strchr( (char*) (const char*) aTempName, '*' ) ||
	         strchr( (char*) (const char*) aTempName, ';' ) )
	    {
	        nKindFlags = FSYS_KIND_WILD;
	        return TRUE;
	    }

        nError = FSYS_ERR_NOTEXISTS;
        return FALSE;
    }

    if ( aParam.dirInfo.ioFlAttrib & 16 )
    {
        nKindFlags = FSYS_KIND_DIR;

        aDateCreated  = Mac2Date( aParam.dirInfo.ioDrCrDat );
        aTimeCreated  = Mac2Time( aParam.dirInfo.ioDrCrDat );
        aDateModified = Mac2Date( aParam.dirInfo.ioDrMdDat );
        aTimeModified = Mac2Time( aParam.dirInfo.ioDrMdDat );
        }
    else
    {
        nKindFlags = FSYS_KIND_FILE;
        nSize = aParam.hFileInfo.ioFlLgLen;
        //!     aParam.hFileInfo.ioFlRLgLen;

        aDateCreated  = Mac2Date( aParam.hFileInfo.ioFlCrDat );
        aTimeCreated  = Mac2Time( aParam.hFileInfo.ioFlCrDat );
        aDateModified = Mac2Date( aParam.hFileInfo.ioFlMdDat );
        aTimeModified = Mac2Time( aParam.hFileInfo.ioFlMdDat );

        memcpy( aCreator.AllocStrBuf(4),
            &aParam.hFileInfo.ioFlFndrInfo.fdCreator, 4 );
        memcpy( aType.AllocStrBuf(4),
            &aParam.hFileInfo.ioFlFndrInfo.fdType, 4 );
    }

    aDateAccessed = aDateModified;
    aTimeAccessed = aTimeModified;

    return TRUE;
}

//====================================================================

char *PathNameFromDirID( long DirID, short vRefNum, char *s)
{
    CInfoPBRec  block;
    Str255      directoryName;
    OSErr       err;
    char*       pBase = &s[1];  // s ist Pascal String !

    *s = 0;
    block.dirInfo.ioNamePtr = directoryName;
    block.dirInfo.ioDrParID = DirID;

    do {
        block.dirInfo.ioVRefNum = vRefNum;
        block.dirInfo.ioFDirIndex = -1;
        block.dirInfo.ioDrDirID = block.dirInfo.ioDrParID;

        err = PBGetCatInfoSync(&block);
        if ( err != noErr )
            break;

        /* Append a Macintosh style colon (':') */
        directoryName[0]++;
        directoryName[directoryName[0]] = ':';

        /* Move String to the back ... */
        memmove(pBase+directoryName[0],pBase,*s);
        memcpy(pBase,&directoryName[1],directoryName[0]);

        /* adjust len of result */
        *s += directoryName[0];
    } while (block.dirInfo.ioDrDirID != fsRtDirID);

    return(s);
}

const char *TempDirImpl( char *pBuf )
{
    OSErr   nErr;
    short   nRefNum, nNewRefNum;
    char    buffer[255];
    long    nDirID;

    nErr = GetVol( nil, &nRefNum );
    nErr = FindFolder( nRefNum, kTemporaryFolderType, kCreateFolder,
                &nNewRefNum, &nDirID );
    if ( nErr != noErr ) {
        pBuf[0] = 0;
        return pBuf;
    }
    PathNameFromDirID( nDirID, nNewRefNum, buffer );
    p2cStr2((MAC_StringPtr) buffer, pBuf);

    return pBuf;
}

/*************************************************************************
|*
|*    DirEntry::GetPathStyle() const
|*
|*    Beschreibung
|*    Ersterstellung    MI 11.05.95
|*    Letzte Aenderung  MI 11.05.95
|*
*************************************************************************/

FSysPathStyle DirEntry::GetPathStyle( const String &rDevice )
{
    return FSYS_STYLE_MAC;
}

/*************************************************************************
|*
|*    ImpConvertNameToSystem()
|*
|*    Beschreibung		Wandelt einen DirEntry, der als String vorliegen muss,
|*						in ein Alias Handle um und das Handle anschliessend
|*						in einen Hex-String.
|*    Ersterstellung    DV 29.03.96
|*    Letzte Aenderung  DV 01.04.96
|*
*************************************************************************/
String ImpConvertNameToSystem( const String &rName )
{
	AliasHandle	hAlias;
	FSSpec		aFSSpec;
	OSErr		anErr;
	String		aRetVal;

	anErr = FSMakeFSSpec( 0, 0, rName.GetPascalStr(), &aFSSpec );

	if ( anErr == noErr )
	{
		anErr = NewAlias( nil, &aFSSpec, &hAlias );
		if ( noErr == anErr )
		{
			HLock( (Handle) hAlias );
			short i, j, nLow, nHigh;
			short nSize = (**hAlias).aliasSize;
			unsigned char *pBuffer = (unsigned char*) new char[ nSize * 2 ];
			unsigned char *pSource = (unsigned char*) *hAlias;

			for ( i=0; i<4; i++ )
				pBuffer[i] = 58;		// = ':'

			j = i;

			for ( ; i<nSize; i++ )
			{
				nLow = pSource[i];
				nHigh = ( nLow >> 4) + 'A';
				nLow &= 0x0F;
				nLow += 'A';

				pBuffer[j++] = nHigh;
				pBuffer[j++] = nLow;
			}
			pBuffer[j] = 0;
			aRetVal = String( (char*) pBuffer );
			delete pBuffer;
			HUnlock( (Handle) hAlias );
		}
		if ( hAlias )
			DisposeHandle( (Handle) hAlias );
	}

	if ( noErr != anErr )
		aRetVal = rName;

	return aRetVal;
}

/*************************************************************************
|*
|*    ImpConvertSystemToName()
|*
|*    Beschreibung
|*    Ersterstellung    DV 29.03.96
|*    Letzte Aenderung  DV 11.04.96
|*
*************************************************************************/

#define PROG_PATH_VAR "$(prog)"

String ImpConvertSystemToName( const String &rName )
{
	FSSpec		aFSSpec;
	OSErr		anErr;
	String		aRetVal;
	AliasHandle	hAlias;
	MAC_Boolean		bWasChanged;
	Str255		aPath;

	const unsigned char *pSource = (unsigned char*) rName.GetStr();

	if ( * (long *)pSource == 0x3A3A3A3A )		// = "::::"
	{
		unsigned char	*pDest;
		short			i, nSize, nLow, nHigh;

		pSource += sizeof( OSType );
		i = 0;
		while ( i < 2 )
		{
			nHigh = *pSource++ - 'A';
			nHigh <<= 4;
			nLow = *pSource++ - 'A' + nHigh;

			*(((char*)&nSize) + i++ ) = nLow;
		}

		hAlias = (AliasHandle) NewHandle( nSize + 4 );
		(**hAlias).userType = 0;
		(**hAlias).aliasSize = nSize;

		HLock( (Handle) hAlias );
		pDest = (unsigned char*) *hAlias;
		pDest += 6;
		i = 5;
		while ( i < nSize )
		{
			nHigh = *pSource++ - 'A';
			nHigh <<= 4;
			nLow = *pSource++ - 'A' + nHigh;

			*pDest++ = nLow;
			i++;
		}

		HUnlock( (Handle) hAlias );
		anErr = ResolveAlias( NULL, hAlias, &aFSSpec, &bWasChanged );

		if ( noErr == anErr )
		{
			PathNameFromDirID( aFSSpec.parID, aFSSpec.vRefNum, (char*) aPath );
			aRetVal = String( (char*)(aPath+1), aPath[0] );
			aRetVal += String( (char*) &aFSSpec.name[1], aFSSpec.name[0] );
		}
		else
		{
		}
		DisposeHandle( (Handle) hAlias );
	}
	else if ( rName.ICompare( PROG_PATH_VAR, strlen( PROG_PATH_VAR ) ) == COMPARE_EQUAL )
	{
		aRetVal = rName;
		hAlias = (AliasHandle) GetResource( 'alis', 4224 );

		if ( hAlias )
		{
			DetachResource( (Handle) hAlias );
			anErr = ResolveAlias( NULL, hAlias, &aFSSpec, &bWasChanged );
			DisposeHandle( (Handle) hAlias );

			if ( noErr == anErr )
			{
				PathNameFromDirID( aFSSpec.parID, aFSSpec.vRefNum, (char*) aPath );
				aRetVal.Erase( 0, strlen( PROG_PATH_VAR ) );
				aRetVal.Insert( String( (char*)(aPath+1), aPath[0] ), 0 );
			}
		}
	}
	else
		aRetVal = rName;

	return aRetVal;
}

/*************************************************************************
|*
|*    FileStat::SetDateTime
|*
|*    Ersterstellung	PB  27.06.97
|*    Letzte Aenderung	DV  18.09.97
|*
*************************************************************************/

void FileStat::SetDateTime( const String& rFileName,
							const DateTime& rNewDateTime )
{
	Str255 aFile;

	strncpy( (char*)aFile+1, rFileName.GetStr(), 255 );
	aFile[0] = strlen( rFileName.GetStr() );

	// init parameter block
	HParamBlockRec aParaBlock;
	memset( &aParaBlock,0,sizeof(HParamBlockRec) );
	aParaBlock.fileParam.ioCompletion = 0;  // no completion function
	aParaBlock.fileParam.ioNamePtr = aFile; // file name
	aParaBlock.fileParam.ioVRefNum = 0;     // search with file name
	aParaBlock.fileParam.ioFDirIndex = -1;  // search with file name

	if ( PBHGetFInfoSync( &aParaBlock ) )
		return;

	// convert new date and time in seconds
	DateTimeRec aDTRec;
	aDTRec.year 	= rNewDateTime.GetYear();
	aDTRec.month 	= rNewDateTime.GetMonth();
	aDTRec.day   	= rNewDateTime.GetDay();
	aDTRec.hour 	= rNewDateTime.GetHour();
	aDTRec.minute 	= rNewDateTime.GetMin();
	aDTRec.second 	= rNewDateTime.GetSec();

	switch ( rNewDateTime.GetDayOfWeek() )
	{
		case MONDAY:    aDTRec.dayOfWeek = 2; break;
		case TUESDAY:   aDTRec.dayOfWeek = 3; break;
		case WEDNESDAY: aDTRec.dayOfWeek = 4; break;
		case THURSDAY:  aDTRec.dayOfWeek = 5; break;
		case FRIDAY:    aDTRec.dayOfWeek = 6; break;
		case SATURDAY:  aDTRec.dayOfWeek = 7; break;
		case SUNDAY:    aDTRec.dayOfWeek = 1; break;
	}

	ULONG nSeconds = 0;
	DateToSeconds( &aDTRec, &nSeconds );
	aParaBlock.fileParam.ioFlCrDat = nSeconds;
	aParaBlock.fileParam.ioFlMdDat = nSeconds;
	PBHSetFInfoSync( &aParaBlock );
}

//=========================================================================

ErrCode FileStat::QueryDiskSpace( const String &rPath,
								  BigInt &rFreeBytes, BigInt &rTotalBytes )
{
	return ERRCODE_IO_NOTSUPPORTED;
}

//=========================================================================

void FSysEnableSysErrorBox( BOOL bEnable )
{
}

