/*************************************************************************
 *
 *  $RCSfile: MemMgr.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:03:04 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

// -----------------------------------------------------------------------

#define MEMBLOCK_MINSIZE    sizeof(FreeBlock)
#define MEMBLOCK_ISLARGE    512
#define MEMBLOCK_LAST       0xFFFF
#define MEMBLOCK_SYSBLOCK   0xFFFF
#define MEMBLOCK_NOTFREE    0x8000

// -----------------------------------------------------------------------

#pragma pack( 1 )

// ! MemBlock muss in gleicher Form am Anfang von FreeBlock stehen !

struct MemBlock
{
    USHORT      nSize;      // Groesse des Blocks
    USHORT      nPrev;      // Offset zum vorherigen Block
};

struct FreeBlock
{
    USHORT      nSize;      // Groesse des Blocks
    USHORT      nPrev;      // Offset zum vorherigen Block
    FreeBlock*  pNext;      // Pointer auf naechsten freien Block
    FreeBlock*  pPrev;      // Pointer auf vorherigen freien Block
};

#pragma pack()

// -----------------------------------------------------------------------

void* MemAlloc( ULONG nAlloc );

// -----------------------------------------------------------------------

#ifdef DBG_UTIL

#define DBG_INIT_SIGNATURE                  0x77
#define DBG_BOUND_SIGNATURE                 0x55
#define DBG_FREE_SIGNATURE                  0x33

#define DBG_MEMERR_OVERWRITE_BEFOR          1
#define DBG_MEMERR_OVERWRITE_BEHIND         2
#define DBG_MEMERR_OVERWRITE_FREE           3
#define DBG_MEMERR_UNKNOWN_PTR              4
#ifdef MAC
	#define DBG_MEMERR_ODD_PTR 		            5
	#define DBG_MEMERR_NOTINHEAP_PTR            6
#endif

// -----------------------------------------------------------------------

#include <debug.hxx>

void* DbgMemAlloc( ULONG nAlloc );
void* DbgMemFree( void* p );


#define DBG_MEM_ALLOC( n )                                              \
    DbgMemAlloc( n )

#define DBG_MEM_FREE( p )                                               \
    p = DbgMemFree( p );                                                \
    if ( !p )                                                           \
        return;

#define DBG_MEM_FREESET( p, n )                                         \
    DbgData* pData = DbgGetData();                                      \
    if ( pData )                                                        \
    {                                                                   \
        if ( pData->nTestFlags &                                        \
             (DBG_TEST_MEM_INIT | DBG_TEST_MEM_OVERWRITEFREE) )         \
            memset( p, DBG_FREE_SIGNATURE, n );                         \
    }

// -----------------------------------------------------------------------
#else

#define DBG_MEM_ALLOC( n )          MemAlloc( n )
#define DBG_MEM_FREE( p )
#define DBG_MEM_FREESET( p, n )

#endif
