/*************************************************************************
 *
 *  $RCSfile: srcview.hxx,v $
 *
 *  $Revision: 1.3.328.1 $
 *
 *  last change: $Author: vg $ $Date: 2003/11/14 11:50:50 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SRCVIEW_HXX
#define _SRCIEW_HXX

#ifndef _VIEWFAC_HXX //autogen
#include <sfx2/viewfac.hxx>
#endif
#ifndef _SFXVIEWSH_HXX //autogen
#include <sfx2/viewsh.hxx>
#endif
#include "srcedtw.hxx"
#include "shellid.hxx"

class SwDocShell;
class SvxSearchItem;
class SfxMedium;

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/

class SwSrcView: public SfxViewShell
{
	SwSrcEditWindow 	aEditWin;

	SvxSearchItem*		pSearchItem;

	BOOL				bSourceSaved	:1;
    rtl_TextEncoding    eLoadEncoding;
    void                Init();

	// fuer Readonly-Umschaltung
	virtual void		Notify( SfxBroadcaster& rBC, const SfxHint& rHint );


protected:
	USHORT 				StartSearchAndReplace(const SvxSearchItem& rItem,
														BOOL bFromStart,
														BOOL bApi,
														BOOL bRecursive = FALSE);


public:

	SFX_DECL_VIEWFACTORY(SwSrcView);
	SFX_DECL_INTERFACE(SW_SRC_VIEWSHELL);
	TYPEINFO();


	SwSrcView(SfxViewFrame* pFrame, const SwSrcView&);
	SwSrcView(SfxViewFrame* pFrame, SfxViewShell*);

	~SwSrcView();

	SwDocShell*			GetDocShell();
	SwSrcEditWindow&    GetEditWin() {return aEditWin;}
	void				SaveContent(const String& rTmpFile);
	void				SaveContentTo(SfxMedium& rMed);

	BOOL				IsModified() {return aEditWin.IsModified();}



	void			Execute(SfxRequest&);
	void			GetState(SfxItemSet&);

	SvxSearchItem* 	GetSearchItem();
	void 			SetSearchItem( const SvxSearchItem& rItem );

	void			Load(SwDocShell* pDocShell);

	virtual USHORT	SetPrinter(	SfxPrinter* pNew,
										USHORT nDiff = SFX_PRINTER_ALL);
	virtual ErrCode			DoPrint( SfxPrinter *pPrinter, PrintDialog *pPrintDialog,
									 BOOL bSilent );
	virtual			SfxPrinter* 	GetPrinter( BOOL bCreate = FALSE );

	void			SourceSaved() {bSourceSaved = TRUE;}
	BOOL			HasSourceSaved() const {return bSourceSaved;}

	// Set encoding specified in the HTML option in the doc shell's header
	// attributes.
	static void SetEncoding( SwDocShell &DocShell );
};


#endif





















