/*************************************************************************
 *
 *  $RCSfile: sample.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:01:29 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SAMPLE_HXX
#define _SAMPLE_HXX

#include <sfx.hxx>
#include <sfxdoc.hxx>
#include <sfxitems.hxx>
#include <dialogs.hxx>
#include <sample.hrc>

//==================================================================

#define SAMPLE_INTERFACE_APP			(SFX_INTERFACE_APP+0)
#define SAMPLE_INTERFACE_VIEW 			(SFX_INTERFACE_APP+1)
#define SAMPLE_INTERFACE_DOC 			(SFX_INTERFACE_APP+2)

class Example: public SfxApplication
{
private:
	void							Initialize();

protected:
	virtual StatusBar*				CreateStatusBar();

	// do application initialization and deinit. (see Application::Main())
	virtual void					Init( int nArgs, char* pArgs[] );
	virtual void					Exit();
public:
									SFX_DECL_INTERFACE(SAMPLE_INTERFACE_APP);

									Example();
									~Example();

	void							Main( int nArgc, char* pArgv[] );
	void							Execute( SfxRequest& rReq );
	void							GetState(SfxItemSet &);
};

enum ViewType {
	VIEW_STD = 1,
	VIEW_COLUMNS = 2,
	VIEW_TABLE = 3,
	VIEW_OBJECT
};

#define TESTDOC_NAME    "TestDocument"
class TestDoc: public SfxDocumentShell, public SfxInPlaceObject
{
private:
	SfxItemPool         *pPool;
	SvxLRSpaceItem *pLRSpaceItem;
	SvxULSpaceItem *pULSpaceItem;
	SvxTabStopItem *pTabStopItem;
	SvxLRSpaceItem *pParaItem;
	SvxPagePosSizeItem *pPagePosItem;
	SvxColumnItem *pColumnItem;
	SvxColumnItem *pTableItem;
	SvxColumnItem *pVTableItem;
	SvxObjectItem *pObjectItem;

	USHORT	nZoom;
	USHORT	nUser;
	BOOL	bInsert;
	Point	aPos;
	Size	aSize;

	int eViewType;

	void Init();
	void InitTable();
	void InitColumns();
protected:
	virtual BOOL        Save() { return TRUE ;}
	virtual BOOL        SaveAs( SvStorage * pNewStor ) { return TRUE; }


public:
					SFX_DECL_INTERFACE(SAMPLE_INTERFACE_DOC);
					SFX_DECL_DOCUMENTFACTORY(TestDoc);
					TestDoc(SfxShellCreateMode = SHELL_CREATE_MODE_EMBEDDED);
					~TestDoc();
	virtual void    	Draw( OutputDevice *, const Rectangle & rBound,
							  const JobSetup & rSetup,
							  USHORT nAspect = ASPECT_CONTENT );
	void                GetAttr( SfxItemSet &rSet );

	void                Execute( SfxRequest& rReq );
	void                GetState(SfxItemSet &);

	void				SetViewType(int eType);
	int					GetViewType() const { return eViewType; }

	virtual SfxItemPool &GetPool();
};


class TestView: public SfxViewShell, public Window
{
	Size            aTotalSize;
	SvxRuler        aRuler;
	SvxRuler        aVRuler;
	PopupMenu		aMenu;
	BOOL			bMouseCaptured;

private:
	void            Construct();       // common for all constrructors

protected:
	const Size&     GetTotalSize() const { return aTotalSize; }

	virtual void    Paint( const Rectangle& rRect );

	virtual void    OuterResizePixel( const Point &rPos, const Size &rSize );
	virtual Size    GetOptimalSizePixel() const;
	virtual void    MouseButtonDown( const MouseEvent& rMEvt );
	virtual void    MouseButtonUp( const MouseEvent& rMEvt );
	virtual void    MouseMove( const MouseEvent& rMEvt );
	DECL_LINK( MenuSelect, Menu * );
	DECL_LINK( MenuActivate, Menu * );

public:
					SFX_DECL_INTERFACE(SAMPLE_INTERFACE_VIEW);
					SFX_DECL_VIEWFACTORY(TestView);
					TestView( SfxViewFrame *pFrame, const TestView& rWin );
					TestView( SfxViewFrame *pFrame, Window *pParent);
					TestView( SfxViewFrame *pFrame, SfxViewShell* );
					~TestView();
	void            Execute( SfxRequest& rReq );
	void            GetState(SfxItemSet &);

	DECL_LINK( ExtraDownHandler, Ruler * );
};

#endif
