/*************************************************************************
 *
 *  $RCSfile: pntobj3d.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: thb $ $Date: 2001/07/17 07:04:30 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SVDIO_HXX
#include "svdio.hxx"
#endif

#ifndef _E3D_GLOBL3D_HXX
#include "globl3d.hxx"
#endif

#ifndef _E3D_PNTOBJ3D_HXX
#include "pntobj3d.hxx"
#endif

TYPEINIT1(E3dPointObj, E3dObject);

/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

E3dPointObj::E3dPointObj(const Vector3D& rPos) :
	aPosition(rPos),
	bTransPosValid(FALSE)
{
	aLocalBoundVol = Volume3D(aPosition, Vector3D(), FALSE);
	bBoundVolValid = FALSE;
}

/*************************************************************************
|*
|* Leer-Konstruktor
|*
\************************************************************************/

E3dPointObj::E3dPointObj() :
	aPosition(Vector3D()),
	bTransPosValid(FALSE)
{
	aLocalBoundVol = Volume3D(aPosition, Vector3D(), FALSE);
	bBoundVolValid = FALSE;
}

/*************************************************************************
|*
|* bei Aenderung der Transformation
|*
\************************************************************************/

void E3dPointObj::SetTransformChanged()
{
	E3dObject::SetTransformChanged();
	bTransPosValid = FALSE;
}

/*************************************************************************
|*
|* Identifier zurueckgeben
|*
\************************************************************************/

UINT16 E3dPointObj::GetObjIdentifier() const
{
	return E3D_POINTOBJ_ID;
}

/*************************************************************************
|*
|* neue Position setzen und Aenderung an Parents (Szene) melden
|*
\************************************************************************/

void E3dPointObj::SetPosition(const Vector3D& rNewPos)
{
	if ( aPosition != rNewPos )
	{
		aPosition = rNewPos;
		bBoundVolValid = FALSE;
		bTransPosValid = FALSE;
		StructureChanged(this);
	}
}

/*************************************************************************
|*
|* Transformierte Position zurueckgeben
|*
\************************************************************************/

const Vector3D& E3dPointObj::GetTransPosition()
{
	if ( !bTransPosValid )
	{
		aTransPos = GetFullTransform() * aPosition;
		bTransPosValid = TRUE;
	}
	return aTransPos;
}

/*************************************************************************
|*
|* sichern
|*
\************************************************************************/

void E3dPointObj::WriteData(SvStream& rOut) const
{
#ifndef SVX_LIGHT
	E3dObject::WriteData(rOut);

#ifdef E3D_STREAMING

	SdrDownCompat aCompat(rOut, STREAM_WRITE);
#ifdef DBG_UTIL
	aCompat.SetID("E3dPointObj");
#endif

	rOut << aPosition;
#endif
#endif	// #ifndef SVX_LIGHT
}

/*************************************************************************
|*
|* laden
|*
\************************************************************************/

void E3dPointObj::ReadData(const SdrObjIOHeader& rHead, SvStream& rIn)
{
	if (ImpCheckSubRecords (rHead, rIn))
	{
		E3dObject::ReadData(rHead, rIn);

		SdrDownCompat aCompat(rIn, STREAM_READ);
#ifdef DBG_UTIL
		aCompat.SetID("E3dPointObj");
#endif

		rIn >> aPosition;

		bTransPosValid = FALSE;
	}
}

/*************************************************************************
|*
|* Zuweisungsoperator
|*
\************************************************************************/

void E3dPointObj::operator=(const SdrObject& rObj)
{
	E3dObject::operator=(rObj);

	const E3dPointObj& r3DObj = (const E3dPointObj&) rObj;
	aPosition = r3DObj.aPosition;
	// sicher ist sicher...
	bTransPosValid = FALSE;
}



