/*************************************************************************
 *
 *  $RCSfile: lingucfg.hxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/27 14:36:22 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SVTOOLS_LINGUCFG_HXX_
#define _SVTOOLS_LINGUCFG_HXX_

#include <com/sun/star/beans/PropertyValues.hpp>
#include <com/sun/star/uno/Sequence.hxx>

#ifndef _COM_SUN_STAR_UNO_ANY_H_
#include <com/sun/star/uno/Any.h>
#endif

#include <tools/solar.h>

#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif
#ifndef _UTL_CONFIGITEM_HXX_
#include <unotools/configitem.hxx>
#endif

//////////////////////////////////////////////////////////////////////


struct SvtLinguOptions
{
	::com::sun::star::uno::Sequence< rtl::OUString >	aActiveDics;
    BOOL                                                bROActiveDics;

	// Hyphenator service specific options
	INT16	nHyphMinLeading,
			nHyphMinTrailing,
			nHyphMinWordLength;

    BOOL    bROHyphMinLeading,
            bROHyphMinTrailing,
            bROHyphMinWordLength;

	// misc options (non-service specific)
	INT16	nDefaultLanguage;
	INT16	nDefaultLanguage_CJK;
	INT16	nDefaultLanguage_CTL;

    BOOL    bRODefaultLanguage;
    BOOL    bRODefaultLanguage_CJK;
    BOOL    bRODefaultLanguage_CTL;

	// spelling options (non-service specific)
	BOOL	bIsSpellSpecial;
	BOOL	bIsSpellInAllLanguages;
	BOOL	bIsSpellAuto;
	BOOL	bIsSpellHideMarkings;
	BOOL	bIsSpellReverse;

    BOOL    bROIsSpellSpecial;
    BOOL    bROIsSpellInAllLanguages;
    BOOL    bROIsSpellAuto;
    BOOL    bROIsSpellHideMarkings;
    BOOL    bROIsSpellReverse;

	// hyphenation options (non-service specific)
	BOOL	bIsHyphSpecial;
	BOOL	bIsHyphAuto;

    BOOL    bROIsHyphSpecial;
    BOOL    bROIsHyphAuto;

	// common to SpellChecker, Hyphenator and Thesaurus service
	BOOL	bIsGermanPreReform;
	BOOL	bIsUseDictionaryList;
	BOOL	bIsIgnoreControlCharacters;

    BOOL    bROIsGermanPreReform;
    BOOL    bROIsUseDictionaryList;
    BOOL    bROIsIgnoreControlCharacters;

	// SpellChecker service specific options
	BOOL	bIsSpellWithDigits,
			bIsSpellUpperCase,
			bIsSpellCapitalization;

    BOOL    bROIsSpellWithDigits,
            bROIsSpellUpperCase,
            bROIsSpellCapitalization;

	SvtLinguOptions();
};


//////////////////////////////////////////////////////////////////////


class SvtLinguConfigItem : public utl::ConfigItem
{
	// disallow copy-constructor and assignment-operator for now
	SvtLinguConfigItem( const SvtLinguConfigItem & );
	SvtLinguConfigItem & operator = ( const SvtLinguConfigItem & );

public:
	SvtLinguConfigItem( const rtl::OUString &rPath ) : ConfigItem( rPath )	{}

	com::sun::star::uno::Sequence< rtl::OUString >
		GetPropertyNames();

	com::sun::star::uno::Sequence< com::sun::star::uno::Any >
		GetProperties(
			const com::sun::star::uno::Sequence< rtl::OUString > &rNames )
		{
			return ConfigItem::GetProperties(rNames);
		}

    com::sun::star::uno::Sequence< sal_Bool >
        GetReadOnlyStates(
            const com::sun::star::uno::Sequence< rtl::OUString > &rNames )
        {
            return ConfigItem::GetReadOnlyStates(rNames);
        }

	sal_Bool
		PutProperties(
 			const com::sun::star::uno::Sequence< rtl::OUString > &rNames,
			const com::sun::star::uno::Sequence<
				com::sun::star::uno::Any > &rValues)
		{
			return ConfigItem::PutProperties( rNames, rValues);
		}

	sal_Bool
		SetSetProperties(
			const rtl::OUString &rNode,
			com::sun::star::uno::Sequence<
				com::sun::star::beans::PropertyValue > rValues )
		{
			return ConfigItem::SetSetProperties( rNode, rValues );
		}

	sal_Bool
        ReplaceSetProperties(
			const rtl::OUString &rNode,
			com::sun::star::uno::Sequence<
				com::sun::star::beans::PropertyValue > rValues )
		{
            return ConfigItem::ReplaceSetProperties( rNode, rValues );
		}

	com::sun::star::uno::Sequence< rtl::OUString >
		GetNodeNames( const rtl::OUString &rNode )
		{
			return ConfigItem::GetNodeNames( rNode );
		}
};


//////////////////////////////////////////////////////////////////////


class SvtLinguConfig
{
	SvtLinguOptions		aOpt;
	BOOL				bIsModified;

	// disallow copy-constructor and assignment-operator for now
	SvtLinguConfig( const SvtLinguConfig & );
	SvtLinguConfig & operator = ( const SvtLinguConfig & );

 	static BOOL	GetHdlByName( INT32 &rnHdl, const rtl::OUString &rPropertyName );

	BOOL	LoadConfig();
	BOOL	SaveConfig();

protected:
	void		SetModified( BOOL bVal );
	inline BOOL	IsModified() const	{ return bIsModified; }

public:
	SvtLinguConfig();
	~SvtLinguConfig();

	com::sun::star::uno::Any
			GetProperty( const rtl::OUString &rPropertyName ) const;
	com::sun::star::uno::Any
			GetProperty( INT32 nPropertyHandle ) const;

	BOOL    SetProperty( const rtl::OUString &rPropertyName,
						 const com::sun::star::uno::Any &rValue );
	BOOL    SetProperty( INT32 nPropertyHandle,
						 const com::sun::star::uno::Any &rValue );

	BOOL	GetOptions( SvtLinguOptions &rOptions ) const;
	BOOL	SetOptions( const SvtLinguOptions &rOptions );

    BOOL    IsReadOnly( const rtl::OUString &rPropertyName ) const;
    BOOL    IsReadOnly( INT32 nPropertyHandle ) const;
};


//////////////////////////////////////////////////////////////////////

#endif

