/*************************************************************************
 *
 *  $RCSfile: tbxmgr.cxx,v $
 *
 *  $Revision: 1.36 $
 *
 *  last change: $Author: rt $ $Date: 2003/06/12 07:49:48 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifdef SOLARIS
// HACK: prevent conflict between STLPORT and Workshop headers on Solaris 8
#include <ctime>
#endif

#include <string> // HACK: prevent conflict between STLPORT and Workshop headers

#include <vcl/system.hxx>
#include <vcl/taskpanelist.hxx>
#include <svtools/miscopt.hxx>
#include <comphelper/processfactory.hxx>

#ifndef __FRAMEWORK_CLASSES_ADDONSOPTIONS_HXX_
#include <framework/addonsoptions.hxx>
#endif

#ifndef __FRAMEWORK_CLASSES_MENUCONFIGURATION_HXX_
#include <framework/menuconfiguration.hxx>
#endif

#ifndef __FRAMEWORK_CLASSES_ADDONMENU_HXX_
#include <framework/addonmenu.hxx>
#endif

#ifndef _COM_SUN_STAR_LANG_XSERVICEINFO_HPP_
#include <com/sun/star/lang/XServiceInfo.hpp>
#endif

#pragma hdrstop

#include "imagemgr.hxx"
#include "tbxmgr.hxx"
#include "dispatch.hxx"
#include "tbxctrl.hxx"
#include "resmgr.hxx"
#include "app.hxx"
#include "request.hxx"
#include "sfxtypes.hxx"
#include "bindings.hxx"
#include "toolbox.hrc"
#include "imgmgr.hxx"
#include "viewfrm.hxx"
#include "sfxresid.hxx"
#include "msgpool.hxx"
#include "macrconf.hxx"
#include "statcach.hxx"
#include "workwin.hxx"
#include "ipfrm.hxx"
#include "ipenv.hxx"
#include "tbxchild.hxx"
#include "tbxconf.hxx"
#include "arrdecl.hxx"
#include "cfgmgr.hxx"
#include "sfxsids.hrc"

static const USHORT nVersion = 13;

// ID's for AddOns toolbox buttons
static const USHORT nAddOnsStartID	= 2000;
static const USHORT nAddOnsEndID	= 2500;

static const char   TOOLBOXITEM_SEPARATOR_STR[] = "private:separator";
static const USHORT TOOLBOXITEM_SEPARATOR_STR_LEN = sizeof( TOOLBOXITEM_SEPARATOR_STR )-1;

using namespace framework;
using namespace com::sun::star::uno;
using namespace com::sun::star::beans;

//====================================================================

DECL_PTRARRAY(SfxToolBoxControlArr_Impl, SfxToolBoxControl*, 8, 8 );

//---------------------------------------------------------------------------
// Da SV den Customize-Handler nur an der Source-ToolBox aufruft, SFX aber
// auch der TargetBox etwas ausf"uhren mu\s (z.B. Controllererzeugung), stellt
// diese Klasse den public-Zugriff auf die protected-Methode Customize her.

class TbAccess_Impl : public SfxToolbox
{
public :

	TbAccess_Impl ( SfxToolBoxManager &rMgr, Window *pParent, WinBits nBits )
	  : SfxToolbox(rMgr,pParent,nBits)
	{}

	inline void CustomizeToolBox (const ToolBoxCustomizeEvent& rCEvt)
		{ Customize(rCEvt); }
};

// static array to define all runtime item ID's which should not be stored
// nor be configurable
USHORT SfxToolBoxManager::nRuntimeIDs[SFXTOOLBOX_RUNTIMEITEM_COUNT] =
{
	SID_ADDONS
};

// Structure to hold additional information about a runtime toolbox item
struct TbRuntimeItemData
{
	rtl::OUString	aImageId;
	rtl::OUString	aTarget;
};

//====================================================================
SfxToolBoxManager::SfxToolBoxManager( SfxConfigManager* pMgr, USHORT nId )
	: SfxConfigItem( nId, pMgr ),
	pParent(0),
	pBox(0),
	pControls(0),
	eSymbolSet(SFX_SYMBOLS_SMALL),
	nIteratorPos(0),
	pResMgr(0),
	pBindings(0),
	pFrame(0),
    pIFace(0),
    bInternal(FALSE),
	bHiContrast(FALSE),
	bConfigMode(FALSE)
{
}

// ctor for non-objectbars
// they are NOT configurable and so they are not inserted into the configmanager

SfxToolBoxManager::SfxToolBoxManager( Window* _pParent,
									  SfxBindings &rBindings,
									  const ResId& rResId  ) :
    SfxConfigItem(rResId.GetId(), /*rBindings.GetConfigManager( rResId.GetId() ) */ NULL ),
	pParent(_pParent),
	pBox(0),
	pControls(0),
	eSymbolSet(SFX_SYMBOLS_SMALL),
	nIteratorPos(0),
	pResMgr(rResId.GetResMgr()),
	pBindings(&rBindings),
	pFrame(0),
    pIFace(0),
    bInternal(TRUE),
	bHiContrast(FALSE),
	bConfigMode(FALSE)
{
	DBG_MEMTEST();

	// Dieser ctor ist f"ur nicht konfigurierbare Toolboxen; alle Daten
	// werden aus der Resource geladen und k"onnen nicht ver"andert werden
}

//--------------------------------------------------------------------

SfxToolBoxManager::SfxToolBoxManager( Window* _pParent,
									  SfxBindings &rBindings,
									  const ResId& rResId,
									  SfxInterface *pInterFace,
									  USHORT nPos, SfxShell* pTask )
/*
	Beschreibung
	ctor f"ur Objectbars; diese merken sich das Modul, aus dem sie erzeugt
	wurden.
*/

    : SfxConfigItem(rResId.GetId(), rBindings.GetConfigManager( rResId.GetId() ) ),
	pParent(_pParent),
	pBox(0),
	pControls(0),
	eSymbolSet(SFX_SYMBOLS_SMALL),
	nIteratorPos(0),
	pResMgr(rResId.GetResMgr()),
	pBindings(&rBindings),
	pFrame(0),
    pIFace(pInterFace),
    bInternal(FALSE),
	bHiContrast(FALSE),
	bConfigMode(FALSE)
{
	DBG_MEMTEST();

	if ( nPos != 0xFFFF )
	{
		SfxToolBoxConfig* pTbxCfg = GetBindings().GetToolBoxConfig();
		const ::framework::ToolBoxLayoutItemDescriptor* pItem = pTbxCfg->GetCfgItem_Impl( nPos );

		// Neue leere ToolBox anlegen; wenn pItem->bCustomize == FALSE ist,
		// kann zwar die Config, nicht aber der Inhalt ge"andert werden
		pBox = new SfxToolbox( *this, pParent, pTbxCfg->GetWinBits( nPos ) );
		((SfxToolbox*)pBox)->nPos = nPos;
		pBox->SetButtonType( pTbxCfg->GetButtonType(nPos) );
        pBox->SetOutStyle( SvtMiscOptions().GetToolboxStyle() );
		pBox->EnableCustomize( TRUE );
		pBox->SetText( pItem->aName );

        rBindings.GetImageManager()->RegisterToolBox(pBox, SFX_TOOLBOX_CHANGEOUTSTYLE );

		// Toolbox aus der Config initialisieren
        ((SfxToolbox*)pBox)->SetFloatingPosition( pItem->aFloatingPos );
		pBox->SetLineCount( pItem->nLines );
		if ( pItem->bFloating )
			pBox->SetFloatingMode( TRUE );
		pBox->SetFloatingLines( pItem->nFloatingLines );
        ((SfxToolbox*)pBox)->nFloatLines = pItem->nFloatingLines;
		((SfxToolbox*)pBox)->SetToolBoxAlignment_Impl( pTbxCfg->GetAlignment( nPos ) );

		String aStr;
		if ( GetNextToolBox_Impl( &aStr ) )
			pBox->SetNextToolBox( aStr );
		else
			pBox->SetNextToolBox( String() );
	}
	else
	{
        bInternal = TRUE;
	}

	if ( pBox )
		pBox->SetUniqueId( rResId.GetId() );
}

//--------------------------------------------------------------------

SfxToolBoxManager::SfxToolBoxManager( Window* _pParent,
									  SfxBindings &rBindings,
									  const ResId& rResId,
									  SfxInterface *pInterFace,
									  USHORT nPos, SfxShell* pTask,
									  BOOL bConfigurationMode )
/*
	Beschreibung
	ctor f"ur Objectbars; diese merken sich das Modul, aus dem sie erzeugt
	wurden.
*/

    : SfxConfigItem(rResId.GetId(), rBindings.GetConfigManager( rResId.GetId() ) ),
	pParent(_pParent),
	pBox(0),
	pControls(0),
	eSymbolSet(SFX_SYMBOLS_SMALL),
	nIteratorPos(0),
	pResMgr(rResId.GetResMgr()),
	pBindings(&rBindings),
	pFrame(0),
    pIFace(pInterFace),
    bInternal(FALSE),
	bHiContrast(FALSE),
	bConfigMode(bConfigurationMode)
{
	DBG_MEMTEST();

	if ( nPos != 0xFFFF )
	{
		SfxToolBoxConfig* pTbxCfg = GetBindings().GetToolBoxConfig();
		const ::framework::ToolBoxLayoutItemDescriptor* pItem = pTbxCfg->GetCfgItem_Impl( nPos );

		// Neue leere ToolBox anlegen; wenn pItem->bCustomize == FALSE ist,
		// kann zwar die Config, nicht aber der Inhalt ge"andert werden
		pBox = new SfxToolbox( *this, pParent, pTbxCfg->GetWinBits( nPos ) );
		((SfxToolbox*)pBox)->nPos = nPos;
		pBox->SetButtonType( pTbxCfg->GetButtonType(nPos) );
        pBox->SetOutStyle( SvtMiscOptions().GetToolboxStyle() );
		pBox->EnableCustomize( TRUE );
		pBox->SetText( pItem->aName );

        rBindings.GetImageManager()->RegisterToolBox(pBox, SFX_TOOLBOX_CHANGEOUTSTYLE );

		// Toolbox aus der Config initialisieren
        ((SfxToolbox*)pBox)->SetFloatingPosition( pItem->aFloatingPos );
		pBox->SetLineCount( pItem->nLines );
		if ( pItem->bFloating )
			pBox->SetFloatingMode( TRUE );
		pBox->SetFloatingLines( pItem->nFloatingLines );
        ((SfxToolbox*)pBox)->nFloatLines = pItem->nFloatingLines;
		((SfxToolbox*)pBox)->SetToolBoxAlignment_Impl( pTbxCfg->GetAlignment( nPos ) );

		String aStr;
		if ( GetNextToolBox_Impl( &aStr ) )
			pBox->SetNextToolBox( aStr );
		else
			pBox->SetNextToolBox( String() );
	}
	else
	{
        bInternal = TRUE;
	}

	if ( pBox )
		pBox->SetUniqueId( rResId.GetId() );
}

//-------------------------------------------------------------------------

SfxToolBoxManager::SfxToolBoxManager( const ResId& rResId,
		SfxInterface *pInterFace,
		const String& rName, SfxToolBoxManager *pTbx, SfxShell *pTask)
    : SfxConfigItem(rResId.GetId(), pTbx->pBindings->GetConfigManager( rResId.GetId() ) ),
	pParent(pTbx->pParent),
	pBox(pTbx->pBox),
	pControls(pTbx->pControls),
	eSymbolSet(pTbx->eSymbolSet),
	nIteratorPos(0),
	pResMgr(rResId.GetResMgr()),
	pBindings(pTbx->pBindings),
	pFrame(0),
    pIFace(pInterFace),
    bInternal(FALSE),
	bHiContrast(FALSE),
	bConfigMode(FALSE)

/*
	Beschreibung
	copy-ctor f"ur Objectbars; diese merken sich das Modul, aus dem sie erzeugt
	wurden.
*/

{
	DBG_MEMTEST();

	pTbx->StoreConfig();

	if ( ((SfxToolbox*)pBox)->bActivated || ((SfxToolbox*)pBox)->HasChildPathFocus() )
	{
		// Wenn diese ToolBox aktiv ist, stehen wir noch mitten im SV.
		// Daher d"urfen ihre Items nicht angetastet werden.

		pTbx->Hide();
		pBox->Disable();
		pBox = 0;
		pControls = 0;

		// Alte ToolBox zum Deleten vormerken
		SfxToolbox& rTbx = *((SfxToolbox*)pTbx->pBox);
		rTbx.bDeleteToolBox = TRUE;
        GetpApp()->PostUserEvent( LINK(&rTbx, SfxToolbox, Delete), (void*)0 );
        // Remove from the task pane list, otherwise we will crash afterwards!
        pParent->GetSystemWindow()->GetTaskPaneList()->RemoveWindow( pTbx->pBox );

		// Neue leere ToolBox anlegen
		SfxToolBoxConfig* pTbxCfg = GetBindings().GetToolBoxConfig();
		const ::framework::ToolBoxLayoutItemDescriptor *pItem = pTbxCfg->GetCfgItem_Impl( rTbx.nPos );

        pBox = new SfxToolbox( *this, pParent, pTbxCfg->GetWinBits( rTbx.nPos ) );
		((SfxToolbox*)pBox)->nPos = rTbx.nPos;
		pBox->SetButtonType( BUTTON_SYMBOL );
        pBox->SetOutStyle( SvtMiscOptions().GetToolboxStyle() );
		pBox->EnableCustomize( rTbx.IsCustomize() );
		pBox->SetText( rName );

		// Toolbox aus der Config initialisieren
		pBox->SetFloatingLines( rTbx.GetFloatingLines() );
        ((SfxToolbox*)pBox)->nFloatLines = rTbx.nFloatLines;
        ((SfxToolbox*)pBox)->SetFloatingPosition( rTbx.GetFloatingPosition() );
		pBox->SetLineCount( rTbx.GetLineCount() );
		if ( rTbx.IsFloatingMode() )
			pBox->SetFloatingMode( TRUE );
		((SfxToolbox*)pBox)->SetToolBoxAlignment_Impl( rTbx.eAlignment );

		Initialize();
	}
	else
	{
		// Wenn diese ToolBox nicht aktiv ist, k"onnen ihre Items ausgetauscht
		// werden.
		((SfxToolbox*)pBox)->pMgr = this;
		((SfxToolbox*) pBox)->SetConstructed(FALSE);

		pBox->SetText( rName );
		pBox->SetUpdateMode(FALSE);
		Initialize();
		pBox->SetUpdateMode(TRUE);

		pTbx->pBox = 0;
		pTbx->pControls=0;
		delete pTbx;
	}

	String aStr;
	if ( GetNextToolBox_Impl( &aStr ) )
		pBox->SetNextToolBox( aStr );
	else
		pBox->SetNextToolBox( String() );

	pBox->SetUniqueId( rResId.GetId() );
}

//--------------------------------------------------------------------

SfxToolBoxManager::~SfxToolBoxManager()
{
	DBG_MEMTEST();

	// unregister bindings
	Clear();
	if (pBox)
	{
		Hide();

        SfxImageManager* pImgMgr = pBindings->GetImageManager();
        if ( pImgMgr )
            pImgMgr->ReleaseToolBox(pBox);

		// Remove runtime information
		USHORT nCount = pBox->GetItemCount();
		for ( USHORT nPos=0; nPos < nCount; nPos++ )
		{
			USHORT nId = pBox->GetItemId( nPos );
			if (( pBox->GetItemType(nPos) == TOOLBOXITEM_BUTTON ) && IsRuntimeItem( nId ))
			{
				TbRuntimeItemData* pRuntimeItemData = (TbRuntimeItemData*)pBox->GetItemData( nId );
				if ( pRuntimeItemData )
					delete pRuntimeItemData;
			}
		}

		delete pBox;
		pBox = 0;
	}
}

//--------------------------------------------------------------------

void SfxToolBoxManager::Construct()
{
	DBG_MEMTEST();

	// set the handlers
	pBox->SetSelectHdl( LINK(this, SfxToolBoxManager, Select) );
	pBox->SetActivateHdl( LINK(this, SfxToolBoxManager, Activate) );
	pBox->SetDeactivateHdl( LINK(this, SfxToolBoxManager, Deactivate) );

	// Nach dem Umkonfigurieren m"ussen die Hilfetexte neu geholt werden
	((SfxToolbox*)pBox)->bHelpInitialized = FALSE;
}

//--------------------------------------------------------------------

void SfxToolBoxManager::CreateFromSVToolBox()
{
	DBG_MEMTEST();

	if (pBox->GetItemCount() == 0)
	{
										// SV austricksen, damit die Groesse
										// stimmt
		((SfxToolbox*)pBox)->SetEmpty(TRUE);
		USHORT nId = SID_NEWDOC;
		pBox->InsertItem( nId, String());
        pBox->SetItemImage(nId, pBindings->GetImageManager()->GetImage(nId, pIFace ? pIFace->GetModule() : 0));
		pBox->HideItem(nId);
	}

	// reflect the StarView toolbox in a bindings table
	if (!pControls)
		pControls = new SfxToolBoxControlArr_Impl;
	SfxSlotPool& rSlotPool = pIFace && pIFace->GetModule() ? *pIFace->GetModule()->GetSlotPool() : SFX_APP()->GetSlotPool();
	((SfxToolbox*)pBox)->ClearItemText_Impl();
	pBindings->ENTERREGISTRATIONS();
	for ( USHORT nPos = 0; nPos < pBox->GetItemCount(); ++nPos )
	{
		if ( pBox->GetItemType(nPos) == TOOLBOXITEM_BUTTON )
		{
			// register binding
			USHORT nId = pBox->GetItemId(nPos);

#ifdef DBG_UTIL
			const SfxSlot *pSlot = rSlotPool.GetSlot( nId );
			if ( pSlot && !pSlot->IsMode( SFX_SLOT_TOOLBOXCONFIG ) )
			{
				ByteString aStr( "Slot " );
				aStr += ByteString::CreateFromInt32( nId );
				aStr += ByteString( " : ToolboxConfig fehlt!" );
				DBG_ERROR( aStr.GetBuffer() );
			}
#endif
            if ( !pBox->GetHelpId( nId ) )
                pBox->SetHelpId( nId, (ULONG) nId );
			if ( !pBox->GetItemText(nId).Len() )
				pBox->SetItemText( nId, rSlotPool.GetSlotName_Impl( nId ) );
			else
				((SfxToolbox*)pBox)->SetItemText_Impl( nId, TRUE );

			SfxToolBoxControl *pControl;
			if ( pBox->GetItemCommand( nId ).CompareToAscii(".uno:", 5 ) == COMPARE_EQUAL )
				pBox->SetItemCommand( nId, String() );	// Remove .uno commands to be compatible with 6.0/src641

            if ( pBox->GetItemCommand( nId ).Len() )
                pControl = SfxToolBoxControl::CreateControl( pBox->GetItemCommand( nId ), nId, pBox, *pBindings );
			else
                pControl = SfxToolBoxControl::CreateControl( nId, pBox, *pBindings, pIFace ? pIFace->GetModule() : 0 );

			pControls->Append( pControl );
			Window *pItemWin = pControl->CreateItemWindow(pBox);
			if ( pItemWin )
            {
                WindowType nType = pItemWin->GetType();
                if ( nType == WINDOW_LISTBOX || nType == WINDOW_MULTILISTBOX || nType == WINDOW_COMBOBOX )
                    pItemWin->SetAccessibleName( pBox->GetItemText( nId ) );
				pBox->SetItemWindow( nId, pItemWin );
            }
		}
	}

	if ( !bConfigMode )
		CreateRuntimeItems();

	pBindings->LEAVEREGISTRATIONS();
}

//--------------------------------------------------------------------

void SfxToolBoxManager::CreateRuntimeItems()
{
	if ( GetType() == 560 )
	{
		if ( framework::AddonsOptions().HasAddonsMenu() &&
			 pBox->GetItemPos( SID_ADDONS) == TOOLBOX_ITEM_NOTFOUND )
		{
		    Reference< com::sun::star::frame::XFrame > xFrame;
		    SfxDispatcher* pDisp = pBindings->GetDispatcher_Impl();
		    if ( pDisp )
			    xFrame = pDisp->GetFrame()->GetFrame()->GetFrameInterface();

            PopupMenu* pMenu = framework::AddonMenuManager::CreateAddonMenu( xFrame );
            
            // Check if there is at least one menu item for our addon menu. Due to context info
            // given in the configuration we can have an empty menu and then we shouldn't display
            // the addon menu button at all!
            if ( pMenu && pMenu->GetItemCount() > 0 )
            {
			    // Special handling for functionbar. Create a addons button for accessing the addons popup menu
			    SfxToolBoxControl *pControl;
			    String aAddonTbxString( SfxResId( STR_ADDONSBUTTONTEXT ));

			    // We need a separator before the Add-On button if there is none
			    USHORT nCount = pBox->GetItemCount();
			    if ( nCount > 0 && pBox->GetItemType( nCount-1 ) != TOOLBOXITEM_SEPARATOR )
				    pBox->InsertSeparator();

			    pBox->InsertItem( SID_ADDONS, aAddonTbxString );
			    pBox->SetItemImage( SID_ADDONS, pBindings->GetImageManager()->GetImage( SID_ADDONS, pBox->GetBackground().GetColor().IsDark(), pIFace ? pIFace->GetModule() : 0 ));
			    pBox->SetHelpId( SID_ADDONS, SID_ADDONS );
			    pControl = SfxToolBoxControl::CreateControl( SID_ADDONS, pBox, *pBindings, pIFace ? pIFace->GetModule() : 0 );
			    pControls->Append( pControl );
			}
			delete pMenu;
		}

		// Append Add-Ons toolbox items
		AppendAddOnsItems();
	}
}

//--------------------------------------------------------------------

static BOOL IsCorrectContext( Reference< com::sun::star::frame::XModel >& rModel, const rtl::OUString& aContextList )
{
	if ( rModel.is() )
	{
		Reference< com::sun::star::lang::XServiceInfo > xServiceInfo( rModel, UNO_QUERY );
		if ( xServiceInfo.is() )
		{
			sal_Int32 nIndex = 0;
			do
			{
				rtl::OUString aToken = aContextList.getToken( 0, ',', nIndex );

				if ( xServiceInfo->supportsService( aToken ))
					return TRUE;
			}
			while ( nIndex >= 0 );
		}
	}

	return ( aContextList.getLength() == 0 );
}

static Image RetrieveAddOnImage( Reference< com::sun::star::frame::XFrame >& rFrame,
								 const rtl::OUString& aImageId,
								 const rtl::OUString& aURL,
								 BOOL bBigImage,
								 BOOL bHiContrast )
{
	Image aImage;

	if ( aImageId.getLength() > 0 )
	{
		aImage = GetImage( rFrame, aImageId, bBigImage, bHiContrast );
		if ( !!aImage )
			return aImage;
	}

	aImage = GetImage( rFrame, aURL, bBigImage, bHiContrast );
	if ( !aImage )
		aImage = framework::AddonsOptions().GetImageFromURL( aURL, bBigImage, bHiContrast );

	return aImage;
}

//--------------------------------------------------------------------

void SfxToolBoxManager::AppendAddOnsItems()
{
	// Retrieve AddOns toolbar item data from AddonsOptions
	Sequence< Sequence< PropertyValue > > aToolBarSeq = framework::AddonsOptions().GetAddonsToolBarPart();
	if ( aToolBarSeq.getLength() > 0 )
	{
		USHORT	nId					= nAddOnsStartID;
		USHORT	nCount				= pBox->GetItemCount();
		USHORT  nElements           = 0;
		BOOL	bAppendSeparator	= FALSE;
		BOOL	bBigImages			= ( SfxImageManager::GetCurrentSymbolSet() == SFX_SYMBOLS_LARGE );

		if ( nCount > 0 && pBox->GetItemType( nCount-1 ) != TOOLBOXITEM_SEPARATOR )
			bAppendSeparator = TRUE;

		Reference< com::sun::star::frame::XFrame > xFrame;
		Reference< com::sun::star::frame::XModel > xModel;

		SfxDispatcher* pDisp = GetBindings().GetDispatcher_Impl();
		if ( pDisp )
			xFrame = pDisp->GetFrame()->GetFrame()->GetFrameInterface();

		if ( xFrame.is() )
		{
			Reference< com::sun::star::frame::XController >	xController( xFrame->getController(), UNO_QUERY );
			if ( xController.is() )
				xModel = Reference< com::sun::star::frame::XModel >( xController->getModel(), UNO_QUERY );
		}

		for ( sal_uInt32 n = 0; n < (sal_uInt32)aToolBarSeq.getLength(); n++ )
		{
			rtl::OUString	aValueName;

			rtl::OUString	aURL;
			rtl::OUString	aTitle;
			rtl::OUString	aImageId;
			rtl::OUString	aContext;
			rtl::OUString	aTarget;

			const Sequence< PropertyValue >& rSeq = aToolBarSeq[n];

			sal_uInt32 nIndex = 0;
			while ( nIndex < (sal_uInt32)rSeq.getLength() )
			{
				aValueName = rSeq[nIndex].Name;
				if ( aValueName.equalsAsciiL( "URL", 3 ))
					rSeq[nIndex].Value >>= aURL;
				else if ( aValueName.equalsAsciiL( "Title", 5 ))
					rSeq[nIndex].Value >>= aTitle;
				else if ( aValueName.equalsAsciiL( "ImageIdentifier", 15 ))
					rSeq[nIndex].Value >>= aImageId;
				else if ( aValueName.equalsAsciiL( "Context", 7 ))
					rSeq[nIndex].Value >>= aContext;
				else if ( aValueName.equalsAsciiL( "Target", 6 ))
					rSeq[nIndex].Value >>= aTarget;
				nIndex++;
			}

			if ( IsCorrectContext( xModel, aContext ))
			{
				// Add only toolbox items with correct context
				SfxToolBoxControl* pControl;

				if ( aURL.equalsAsciiL( TOOLBOXITEM_SEPARATOR_STR, TOOLBOXITEM_SEPARATOR_STR_LEN ))
				{
					USHORT nCount = pBox->GetItemCount();
					if ( nCount > 0 && ( pBox->GetItemType( nCount-1 ) != TOOLBOXITEM_SEPARATOR ) && nElements > 0 )
					{
                        nElements = 0;
						pBox->InsertSeparator();
					}
				}
				else
				{
                    USHORT nCount = pBox->GetItemCount();
			        if ( bAppendSeparator && nCount > 0 && ( pBox->GetItemType( nCount-1 ) != TOOLBOXITEM_SEPARATOR ))
				    {
				        // We have to append a separator first if the last item is not a separator
				        pBox->InsertSeparator();
			        }
				    bAppendSeparator = FALSE;

					pBox->InsertItem( nId, aTitle );

					Image aImage = RetrieveAddOnImage( xFrame, aImageId, aURL, bBigImages, bHiContrast );
					if ( !!aImage )
						pBox->SetItemImage( nId, aImage );

					// Create TbRuntimeItemData to hold additional information we will need in the future
					TbRuntimeItemData* pRuntimeItemData = new TbRuntimeItemData;
					pRuntimeItemData->aImageId	= aImageId;
					pRuntimeItemData->aTarget	= aTarget;
					pBox->SetItemData( nId, pRuntimeItemData );

					pBox->SetItemCommand( nId, aURL );
					pControl = SfxToolBoxControl::CreateControl( aURL, nId, pBox, *pBindings );
					pControls->Append( pControl );
					++nId;
					++nElements;
				}
			}
		}
	}
}

//--------------------------------------------------------------------

void SfxToolBoxManager::UseDefault()
{
	DBG_MEMTEST();

    SfxImageManager *pImgMgr = pBindings->GetImageManager();
	if ( pBox && pBox->GetItemCount() )
	{
		// reconfigure toolbox
		// remove controllers, item windows, items and item texts
		Clear();
		pBox->Clear();
		((SfxToolbox*)pBox)->ClearItemText_Impl();
	}

	// ResId f"ur die ToolBox zusammenbasteln
	// Wenn es keine passende Resource gibt, wird eine leere Toolbox erzeugt
	// Dies ist der Fall bei UserDefined Toolboxen.
	ResId aResId(GetType());
	aResId.SetRT(RSC_TOOLBOX);
	aResId.SetResMgr(pResMgr);

	if ( Resource::GetResManager()->IsAvailable(aResId) )
	{
		BOOL bOwnImageList = FALSE;
		if ( pBox )
		{
            pBindings->GetImageManager()->ReleaseToolBox( pBox );

			// Konfigurierbare Toolboxen sind SFX-Objectbars; sie laden nur
			// ihren Inhalt aus der Resource, der Rest kommt aus der
			// SfxToolboxConfig
			ToolBox *pTb = new ToolBox ( pParent, aResId );
			if ( pTb->GetImageList().GetImageCount() )
				bOwnImageList = TRUE;

			pBox->EnableCustomize( !bOwnImageList );

			pBox->CopyItems( *pTb );
			pBox->SetHelpId( pTb->GetHelpId() );
			pBox->SetHelpText( String() );
			delete pTb;
		}
		else
		{
			// Nicht konfigurierbare Toolboxen werden komplett aus der
			// Resource geladen
			pBox = new SfxToolbox( *this, pParent, aResId );
			pBox->SetUniqueId( aResId.GetId() );
			if ( pBox->GetImageList().GetImageCount() )
				bOwnImageList = TRUE;

			pBox->EnableCustomize( FALSE );
			pBox->SetButtonType( BUTTON_SYMBOL );
            pBox->SetOutStyle( SvtMiscOptions().GetToolboxStyle() );
		}

		if ( !bOwnImageList )
		{
			// Retrieve images and check for high contrast mode
			pImgMgr->SetImages( *pBox, pIFace ? pIFace->GetModule() : 0, pBox->GetBackground().GetColor().IsDark() );
            pImgMgr->RegisterToolBoxManager( this, 0xFFFF );
		}
		else
            pImgMgr->RegisterToolBox( pBox, SFX_TOOLBOX_CHANGEOUTSTYLE );
	}
	else if ( !pBox )
		DBG_ERROR( "Toolbox-Resource fehlt!" );

	// Handler setzen
	Construct();

	// Controller und ItemWindows erzeugen
	CreateFromSVToolBox();

	// Gr"o\se berechnen
	Align();
	((SfxToolbox*)pBox)->SetConstructed(TRUE);

	// StatusUpdate anwerfen
	Activate(0);

    SetDefault( TRUE );
}

//--------------------------------------------------------------------
int SfxToolBoxManager::Load( SotStorage& rStorage )
{
	DBG_MEMTEST();

	SotStorageStreamRef xStream =
            rStorage.OpenSotStream( GetStreamName(), STREAM_STD_READ );
	if ( xStream->GetError() )
		return ERR_READ;

	if ( pBox->GetItemCount() )
	{
		// reconfigure toolbox
		// remove controllers, item windows, items and item texts
		Clear();
		pBox->Clear();
		((SfxToolbox*)pBox)->ClearItemText_Impl();
	}

	SfxImageManager* pImgMgr = pBindings->GetImageManager();

	ToolBoxDescriptor aItems;
    int nRet = ERR_OK;
    if ( !::framework::ToolBoxConfiguration::LoadToolBox( *xStream, aItems ) )
        return ERR_READ;

	USHORT nPos;
	for ( nPos = 0; nPos<aItems.Count(); )
	{
		// watch: index variable is incremented here to allow to decrement in case of wrong configuration entries
		ToolBoxItemDescriptor *pItem = aItems[nPos++];
        if ( !pItem->nId && pItem->aURL.CompareToAscii("slot:",5) == COMPARE_EQUAL )
        {
	        pItem->nId = (USHORT) pItem->aURL.Copy( 5 ).ToInt32();
            if ( SfxMacroConfig::IsMacroSlot( pItem->nId ) )
			{
				// wrong configuration
				aItems.DeleteAndDestroy(nPos--);
				continue;
			}
			else
			{
	            pItem->aURL.Erase();
			}
        }
		else if ( !pItem->nId && pItem->aURL.CompareToAscii(".uno:", 5 ) == COMPARE_EQUAL )
		{
			// Map .uno command to ID
            SfxShell *pShell=0;
            USHORT nIdx;
            for (nIdx=0; (pShell=pBindings->GetDispatcher_Impl()->GetShell(nIdx)); nIdx++)
            {
                const SfxInterface *pIFace = pShell->GetInterface();
                const SfxSlot* pSlot = pIFace->GetSlot( pItem->aURL );
                if ( pSlot )
                {
                    pItem->nId = pSlot->GetSlotId();
                    break;
                }
            }
			pItem->aURL.Erase(); // Remove .uno command to be compatible with 6.0/src641
		}
        else if ( !pItem->nId && pItem->aURL.Len() /*pItem->aURL.CompareToAscii("macro:",6) == COMPARE_EQUAL*/ )
        {
            SfxMacroInfo aInfo( pItem->aURL );
            SFX_APP()->GetMacroConfig()->GetSlotId( &aInfo );
            pItem->nId = aInfo.GetSlotId();
        }

        if ( pItem->pBmp && !pImgMgr->IsUserDef_Impl( pItem->nId ) )
		{
//!MBA sollte jetzt nicht mehr passieren, da ja der ImageManager qualifiziert verwendet wird ?!
			// Wenn es f"ur die SlotId noch keine Bitmap am Imagemanager
			// gibt, wird die eingelesene Bitmap dort angmeldet.
			// So wird beim Konfigurieren einer Toolbox auch gleichzeitig
			// der ImageManager umkonfiguriert !
			// Diese Toolbox wird am ImageManager kurzfristig abgemeldet,
			// damit ReplaceImage nicht versucht, hier was auszutauschen
            pImgMgr->ReplaceImage( pItem->nId, pItem->pBmp );
			DBG_ERROR("UserDef Bitmap added!");
		}

		// ToolBoxItem einf"ugen
		switch ( (ToolBoxItemType) pItem->nItemType )
		{
			case TOOLBOXITEM_BUTTON:
			{
				pBox->InsertItem( pItem->nId, pItem->aItemText, pItem->nItemBits );
				if ( pItem->aURL.Len() )
					pBox->SetItemCommand( pItem->nId, pItem->aURL );
				if ( pItem->aHelpId.CompareToAscii("helpid:",7) == COMPARE_EQUAL )
					pBox->SetHelpId( pItem->nId, pItem->aHelpId.Copy( 7 ).ToInt32() );
				break;
			}

			case TOOLBOXITEM_SEPARATOR:
				pBox->InsertSeparator();
				break;

			case TOOLBOXITEM_SPACE:
				pBox->InsertSpace();
				break;

			case TOOLBOXITEM_BREAK:
				pBox->InsertBreak();
				break;

			default:
				DBG_ERROR( "invalid item-type in toolbox config" );
		}

		if ( !pItem->nVisible )
			pBox->HideItem( pItem->nId );
	}

	pImgMgr->ReleaseToolBox( pBox );
	pImgMgr->RegisterToolBoxManager( this, 0xFFFF );

	// Alle Images vom ImageManager holen
	pImgMgr->SetImages( *pBox, pIFace ? pIFace->GetModule() : 0, pBox->GetBackground().GetColor().IsDark() );

	// Handler setzen
	Construct();

	// Controller und ItemWindows anlegen
	CreateFromSVToolBox();

	USHORT nCount = pBox->GetItemCount();
	for ( nPos = 0; nPos<nCount; ++nPos )
	{
		const USHORT nId = pBox->GetItemId(nPos);
		if ( pBox->GetItemWindow( nId ) )
		{
			// Falls der Controller nur in einem anderen Context ein Itemwindow
			// hat, kann es auch NULL sein !
			USHORT nWidth = (USHORT)(ULONG) pBox->GetItemData( nId );
			pBox->SetItemData( nId, (void*)NULL );
			Size aSize = pBox->GetItemWindow(nId)->GetSizePixel();
			aSize.Width() = aItems[nPos]->nWidth;
			pBox->GetItemWindow(nId)->SetSizePixel(aSize);
		}
	}

	// Gr"o\se berechnen
	Align();
	((SfxToolbox*) pBox)->SetConstructed(TRUE);
	SetDefault( FALSE );

	// StatusUpdate anwerfen
	Activate(0);
	return SfxConfigItem::ERR_OK;
}

//--------------------------------------------------------------------

BOOL SfxToolBoxManager::Store( SotStorage& rStorage )
{
	DBG_MEMTEST();

	SotStorageStreamRef xStream =
            rStorage.OpenSotStream( GetStreamName(), STREAM_STD_READWRITE | STREAM_TRUNC );
	if ( !xStream->GetError() )
	{
		ToolBoxDescriptor aItems;
		if ( pBox && !((SfxToolbox*)pBox)->IsEmpty() )
		{
			USHORT          nPos, nCount = pBox->GetItemCount();
            ToolBoxItemType nSepToInsert = TOOLBOXITEM_DONTKNOW;
			for ( nPos = 0; nPos < nCount; ++nPos )
			{
				USHORT          nId     = pBox->GetItemId(nPos);
				ToolBoxItemType nType   = pBox->GetItemType(nPos);

                if ( nType != TOOLBOXITEM_BUTTON )
                    nSepToInsert = nType;
                else
                {
				    // Remove runtime toolbox items from the store/load process					    
				    if ( !IsRuntimeItem( nId ) )
				    {
                        // Insert separator before real item
					    if ( nSepToInsert != TOOLBOXITEM_DONTKNOW )
					    {
					        ToolBoxItemDescriptor* pItem = new ToolBoxItemDescriptor;
					        pItem->nItemType = nSepToInsert;
					        aItems.Insert( pItem, aItems.Count() );
					        nSepToInsert = TOOLBOXITEM_DONTKNOW;
					    }
					    
					    ToolBoxItemDescriptor* pItem = new ToolBoxItemDescriptor;
					    pItem->nId = nId;
					    aItems.Insert( pItem, aItems.Count() );
					    Window* pWindow = pBox->GetItemWindow( nId );
					    if ( pWindow )
						    pItem->nWidth = (USHORT) pWindow->GetSizePixel().Width();
					    if ( ((SfxToolbox*)pBox)->HasItemText_Impl( nId ) )
						    pItem->aItemText = pBox->GetItemText( nId );
					    pItem->aURL = pBox->GetItemCommand( nId );
					    if ( !pItem->aURL.Len() && nId )
					    {
						    pItem->aURL = String::CreateFromAscii("slot:");
						    pItem->aURL += String::CreateFromInt32( nId );
					    }

					    if ( pBox->GetHelpId( nId ) != nId )
					    {
						    pItem->aHelpId = String::CreateFromAscii("helpid:");
						    pItem->aHelpId += String::CreateFromInt32( pBox->GetHelpId( nId ) );
					    }

					    SfxImageManager* pImgMgr = GetBindings().GetImageManager();
					    pItem->nUserDef = pImgMgr->IsUserDef_Impl(nId);
					    if ( pItem->nUserDef )
					    {
						    pItem->pBmp = new Bitmap;
						    (*pItem->pBmp) = pImgMgr->GetUserDefBitmap_Impl(nId);
					    }

					    pItem->nItemBits = pBox->GetItemBits( nId );
					    pItem->nItemType = nType;
					    pItem->nVisible = pBox->IsItemVisible( nId );
					}
				}
			}
		}

        return ::framework::ToolBoxConfiguration::StoreToolBox( *xStream, aItems );
	}
	else
		return FALSE;
}

//--------------------------------------------------------------------

BOOL SfxToolBoxManager::Import( SvStream& rInStream, SvStream& rOutStream )
{
	DBG_MEMTEST();
	ToolBoxDescriptor aItems;

	USHORT nFileVersion, nLanguage;
	rInStream >> nFileVersion;
	if ( nFileVersion < 9 )
		return SfxConfigItem::WARNING_VERSION;

	USHORT nCount;
	rInStream >> nCount;

	USHORT nPos;
    rtl_TextEncoding nEnc = osl_getThreadTextEncoding();
	for ( nPos = 0; nPos < nCount; ++nPos )
	{
		ToolBoxItemDescriptor* pItem = new ToolBoxItemDescriptor;
		aItems.Insert( pItem, aItems.Count() );
		USHORT nUserDef;

		rInStream >> pItem->nItemType >> pItem->nId;
        rInStream.ReadByteString( pItem->aItemText, nEnc );
		rInStream >> nUserDef >> pItem->nItemBits;
		if ( nFileVersion>12 )
			rInStream >> pItem->nVisible;
		else
			pItem->nVisible = 1;

        if ( nUserDef && nFileVersion > 9 )
        {
            pItem->pBmp = new Bitmap;
            rInStream >> (*pItem->pBmp);
        }

		if ( SfxMacroConfig::IsMacroSlot( pItem->nId ) )
		{
			// Die SlotId von Macros ist nicht fest; wir besorgen uns eine
			SfxMacroInfo aInfo;
			rInStream >> aInfo;
//            pItem->nId = aInfo.GetSlotId();
			pItem->aURL = aInfo.GetURL();
		}
		else if ( pItem->nId )
		{
			// Keine Itemtexte aus "alteren Versionen
			pItem->aURL = String::CreateFromAscii("slot:");
			pItem->aURL += String::CreateFromInt32( pItem->nId );
			if ( nFileVersion<12 )
				pItem->aItemText.Erase();
		}
	}

	// ItemWindowbreiten einlesen
	USHORT nWidth=0;
	for ( nPos = 0; nPos<nCount; ++nPos )
	{
		ToolBoxItemDescriptor *pItem = aItems[nPos];
		rInStream >> pItem->nWidth;
	}

	if ( nFileVersion > 10 )
		rInStream >> nLanguage;

    LanguageType eLangType = Application::GetSettings().GetUILanguage();

	if ( eLangType != (LanguageType) nLanguage )
	{
		// language doesn't match to current settings; use default texts if available
		for ( USHORT n=0; n<aItems.Count(); n++ )
		{
			ToolBoxItemDescriptor *pItem = aItems[n];
            if ( pItem->nItemType == TOOLBOXITEM_BUTTON && !SfxMacroConfig::IsMacroSlot( pItem->nId ) )
				pItem->aItemText.Erase();
		}
	}

    return ::framework::ToolBoxConfiguration::StoreToolBox( rOutStream, aItems );
}

BOOL SfxToolBoxManager::Export( SvStream& rInStream, SvStream& rOutStream )
{
	ToolBoxDescriptor aItems;
    if ( !::framework::ToolBoxConfiguration::LoadToolBox( rInStream, aItems ) )
		return FALSE;

	USHORT nCount = aItems.Count();
	rOutStream 	<< (USHORT) nVersion
				<< nCount;

	USHORT nPos;
    rtl_TextEncoding nEnc = osl_getThreadTextEncoding();
	SfxMacroConfig *pMC = SfxMacroConfig::GetOrCreate();
	SvUShorts aMacroSlots;
	for ( nPos = 0; nPos < nCount; ++nPos )
	{
		ToolBoxItemDescriptor *pItem = aItems[nPos];
        if ( !pItem->nId && pItem->aURL.CompareToAscii("slot:",5) == COMPARE_EQUAL )
        {
            pItem->nId = (USHORT) pItem->aURL.Copy( 5 ).ToInt32();
            pItem->aURL.Erase();
        }
        else if ( !pItem->nId && pItem->aURL.CompareToAscii("macro:",6) == COMPARE_EQUAL )
        {
            SfxMacroInfo aInfo( pItem->aURL );
            pMC->GetSlotId( &aInfo );
            pItem->nId = aInfo.GetSlotId();
			aMacroSlots.Insert( pItem->nId, aMacroSlots.Count() );
        }

		rOutStream 	<< pItem->nItemType
					<< pItem->nId;
        rOutStream.WriteByteString( pItem->aItemText, nEnc );
		rOutStream	<< pItem->nUserDef
					<< pItem->nItemBits
					<< pItem->nVisible;

        if ( pItem->pBmp )
        {
            DBG_ASSERT( !pItem->nUserDef, "Wrong configuration!" );
            rOutStream << (*pItem->pBmp);
        }

		if ( SfxMacroConfig::IsMacroSlot( pItem->nId ) )
			rOutStream << *pMC->GetMacroInfo( pItem->nId );
	}

	for ( nPos = 0; nPos < nCount; ++nPos )
		rOutStream << aItems[nPos]->nWidth;

	for ( USHORT n=0; n<aMacroSlots.Count(); n++ )
		pMC->ReleaseSlotId( aMacroSlots[n] );

    LanguageType eLangType = Application::GetSettings().GetUILanguage();
	rOutStream << (USHORT) eLangType;
	return TRUE;
}

//--------------------------------------------------------------------

void SfxToolBoxManager::Align()
{
	DBG_MEMTEST();

	if ( pBox->IsFloatingMode() )
		return;

	Size aOldSize = pBox->GetSizePixel();
	Size aSize = pBox->CalcWindowSizePixel();
    if ( !aSize.Width() )
        aSize.Width() = aOldSize.Width();
    else if ( !aSize.Height() )
        aSize.Height() = aOldSize.Height();

	if (aSize.Width() && aSize.Width() != pBox->GetSizePixel().Width() ||
            aSize.Height() && aSize.Height() != pBox->GetSizePixel().Height())
		pBox->SetPosSizePixel( pBox->GetPosPixel(), aSize );
}

//--------------------------------------------------------------------

void SfxToolBoxManager::RefreshImages_Impl()
{
    pBindings->GetImageManager()->SetImages( *pBox, pIFace ? pIFace->GetModule() : 0, bHiContrast );

	Reference< com::sun::star::frame::XFrame > xFrame;
	SfxDispatcher* pDisp = pBindings->GetDispatcher_Impl();
	if ( pDisp )
		xFrame = pDisp->GetFrame()->GetFrame()->GetFrameInterface();
	BOOL bBigImages	= ( SfxImageManager::GetCurrentSymbolSet() == SFX_SYMBOLS_LARGE );

	USHORT nCount = pBox->GetItemCount();
	for ( USHORT nPos=0; nPos<nCount; nPos++ )
	{
		USHORT nId = pBox->GetItemId( nPos );
		if ( pBox->GetItemType(nPos) == TOOLBOXITEM_BUTTON )
		{
			SfxStateCache *pCache = pBindings->GetStateCache( nId );
			if ( pCache )
				pCache->SetCachedState();
			else if ( IsRuntimeItem( nId ))
			{
				// Runtime items can use different image managers
				rtl::OUString aImageId;

				if ( pBox->GetItemData( nId ))
					aImageId = ((TbRuntimeItemData*)pBox->GetItemData( nId ))->aImageId;

				Image aImage = RetrieveAddOnImage( xFrame, aImageId, pBox->GetItemCommand( nId ), bBigImages, bHiContrast );
				if ( !!aImage )
					pBox->SetItemImage( nId, aImage );
			}
		}
	}
}

//-------------------------------------------------------------------------

void SfxToolBoxManager::Clear()
{
	if (pControls)
	{
		pBindings->ENTERREGISTRATIONS();
		for ( USHORT n = 0; n < pControls->Count(); ++n )
		{
			SfxToolBoxControl *pControl = pControls->GetObject(n);
			USHORT nId = pControl->GetId();
			Window *pItemWin = pBox->GetItemWindow(nId);
			if ( pItemWin )
			{
				pItemWin->Hide();
				delete pItemWin;
				pBox->SetItemWindow( nId, 0 );
			}
			delete pControl;
		}
		pControls->Clear();
		DELETEZ(pControls);
		pBindings->LEAVEREGISTRATIONS();
	}
}


//--------------------------------------------------------------------

SfxToolBoxControl* SfxToolBoxManager::FindControl_Impl( USHORT nId ) const
{
	for ( USHORT nPos = 0; nPos < pControls->Count(); ++nPos )
		if ( pControls->GetObject(nPos)->GetId() == nId )
			return pControls->GetObject(nPos);
	return 0;
}

//--------------------------------------------------------------------

// updates all state-information

IMPL_LINK( SfxToolBoxManager, Activate, ToolBox *, pSVBox )
{
	DBG_MEMTEST();

	SfxToolbox *pTbx = (SfxToolbox*) pBox;
	SfxBindings *pBindinx = pBindings;

	// Es kann passieren, da\s diese Toolbox im Verlauf des jetzt erzwungenen
	// Updates ausgetauscht werden m"u\ste. Daher merken wir uns, da\s wir auf
	// keinen Fall ausgetauscht oder gel"oscht werden wollen.
	if ( pSVBox )
		pTbx->bActivated = TRUE;

	if ( !pBindinx->GetDispatcher_Impl()->IsLocked() && !pTbx->bReconfigure)
	{
		pBindinx->GetDispatcher_Impl()->Flush();
		if (!pTbx->bDeleteToolBox)			// noch nicht versucht zu deleten
		{
			// update all states-information of each item in this menu
			for ( short nPos = pTbx->GetItemCount(); nPos >= 0; --nPos )
			{	USHORT nId = pTbx->GetItemId(nPos);
				if ( nId != 0 )
					pBindinx->Update( nId );
			}
		}

		SfxStateCache *pCache = pBindinx->GetStateCache( SID_IMAGE_ORIENTATION );
		if ( pCache )
			pCache->SetCachedState();
	}

	return 0;
}

//--------------------------------------------------------------------

// removes the context

IMPL_LINK( SfxToolBoxManager, Deactivate, ToolBox *, pToolBox )
{
	DBG_MEMTEST();
	((SfxToolbox*)pBox)->bActivated = FALSE;
	return 0;
}


//--------------------------------------------------------------------

// executes the selected function

IMPL_LINK( SfxToolBoxManager, Select, ToolBox *, pBox )
{
	DBG_MEMTEST();

	// Wenn die ToolBox zum Deleten vorgemerkt ist, soll nichts mehr
	// selektiert werden koennen.
	if ( ((SfxToolbox*)pBox)->bDeleteToolBox )
		return 0;

	SfxToolBoxControl *pControl = FindControl_Impl( pBox->GetCurItemId() );
	if ( pControl )
	{
		SfxToolbox *pTbx = (SfxToolbox*) pBox;
		// Auch beim Select darf nicht zwischendurch die ToolBox oder das
		// selektierte Item verschwinden; da Select erst nach Deactivate kommt,
		// mu\s die ToolBox noch einmal "geblockt" werden.
		pTbx->bActivated = 2;
		pControl->Select( pBox->GetModifier() );
		pTbx->bActivated = FALSE;
	}
	return 0;
}


//--------------------------------------------------------------------

// resets the item iterator, FALSE if none

BOOL SfxToolBoxManager::FirstItem()
{
	nIteratorPos = 0;
	return nIteratorPos < pBox->GetItemCount();
}


//--------------------------------------------------------------------

// skips to the next item, FALSE if no more

BOOL SfxToolBoxManager::NextItem()
{
	++nIteratorPos;
	return nIteratorPos < pBox->GetItemCount();
}


//--------------------------------------------------------------------

// TRUE if current item is a binding

BOOL SfxToolBoxManager::IsBinding() const
{
	return pBox->GetItemType(nIteratorPos) == TOOLBOXITEM_BUTTON;
}


//--------------------------------------------------------------------

// TRUE if current item is a separator

BOOL SfxToolBoxManager::IsSeparator() const
{
	return pBox->GetItemType( pBox->GetItemId(nIteratorPos) ) ==
		   TOOLBOXITEM_SEPARATOR;
}


//--------------------------------------------------------------------

// id of current binding if IsBinding()

USHORT SfxToolBoxManager::GetId() const
{
	return pBox->GetItemId( nIteratorPos );
}

//--------------------------------------------------------------------

void SfxToolBoxManager::InsertItem( USHORT nId, Image& aImage, USHORT nTargetPos, USHORT nHelpId, String aItemText )
{
	if (((SfxToolbox*)pBox)->IsEmpty())
	{
		// Das DummyItem in leeren ToolBoxen entfernen
		pBox->RemoveItem(0);
		((SfxToolbox*)pBox)->SetEmpty(FALSE);
	}

	// Habe ich das Item noch nicht ?
	if (pBox->GetItemPos(nId) == TOOLBOX_ITEM_NOTFOUND)
	{
		// Der SFX steckt die Source-Toolbox in die User-Daten
        pBox->InsertItem( nId, aImage, String(), 0, nTargetPos );
		SetItemText( nId, aItemText );

		// Macros m"u\sen einen Slot anfordern
		if ( SfxMacroConfig::IsMacroSlot( nId ) )
        {
			SFX_APP()->GetMacroConfig()->RegisterSlotId(nId);
            pBox->SetItemCommand( nId, SFX_APP()->GetMacroConfig()->GetMacroInfo(nId)->GetURL() );
        }

		pBindings->ENTERREGISTRATIONS();

		SfxSlotPool &rSlotPool = SFX_SLOTPOOL();
		pBox->SetHelpText( nId, rSlotPool.GetSlotHelpText_Impl(nId) );

		SfxToolBoxControl *pControl =
			SfxToolBoxControl::CreateControl( nId, pBox, *pBindings, pIFace ? pIFace->GetModule() : 0 );
		pControls->Append( pControl );

		Window *pItemWin = pControl->CreateItemWindow(pBox);
		if ( pItemWin )
			pBox->SetItemWindow( nId, pItemWin );
        pBox->SetHelpId( nId, nHelpId );

		pBindings->LEAVEREGISTRATIONS();

		SetDefault(FALSE);
	}
	else if( !pBox->IsItemVisible( nId ) )
	{
		pBox->ShowItem( nId );
		pBox->MoveItem( nId, nTargetPos );

		SetDefault(FALSE);
	}
}

void SfxToolBoxManager::RemoveItem( USHORT nId, USHORT nSourcePos )
{
	// Es wurde ein Item entfernt
	SfxToolBoxControl *pControl=0;

	USHORT nPos;
	for ( nPos=0; nPos<pControls->Count(); ++nPos )
		if ( pControls->GetObject(nPos)->GetId() == nId )
	{
		pControl = pControls->GetObject(nPos);
		break;
	}

	if (pControl)
	{
		pBindings->ENTERREGISTRATIONS();

		Window *pItemWin = pBox->GetItemWindow(nId);
		if ( pItemWin )
		{
			pItemWin->Hide();
			delete pItemWin;
			pBox->SetItemWindow( nId, 0 );
		}

		delete pControl;
		pControls->Remove(nPos);

		pBindings->LEAVEREGISTRATIONS();
	}

	pBox->RemoveItem( nSourcePos );

	if ( (pBox->GetItemType( nSourcePos ) == TOOLBOXITEM_SEPARATOR) &&
		 ((pBox->GetItemType( nSourcePos-1 ) == TOOLBOXITEM_SEPARATOR) ||
		  (pBox->GetItemType( nSourcePos+1 ) == TOOLBOXITEM_SEPARATOR) ||
		   pBox->GetItemCount() == 1 ) )
		pBox->RemoveItem( nSourcePos );

	if (pBox->GetItemCount() == 0)
	{
		// SV austricksen, damit die Gr"o\se stimmt
		((SfxToolbox*)pBox)->SetEmpty(TRUE);
		USHORT nId = SID_NEWDOC;
		pBox->InsertItem( nId, String());
        pBox->SetItemImage(nId, pBindings->GetImageManager()->GetImage(nId, pIFace ? pIFace->GetModule() : 0));
		pBox->HideItem(nId);
	}

	SetDefault(FALSE);
}

//--------------------------------------------------------------------

BOOL SfxToolBoxManager::IsRuntimeItem( USHORT nId )
{
	// Return true for ID's which are created during runtime and shouldn't be stored nor
	// accessible through the configuration dialogs!
	if (( nId >= nAddOnsStartID ) && ( nAddOnsEndID > nId ))
		return TRUE;
	else
	{
		for ( USHORT n = 0; n < SFXTOOLBOX_RUNTIMEITEM_COUNT; n++ )
			if ( nId == nRuntimeIDs[n] )
				return TRUE;
	}

	return FALSE;
}

//--------------------------------------------------------------------

void SfxToolBoxManager::Customize( const ToolBoxCustomizeEvent& rCEvt )
{
	USHORT nSourcePos = pBox->GetItemPos( rCEvt.GetSourceId() );
	USHORT nTargetPos = rCEvt.GetTargetPos();

	// Ab SV303 : Customize-Handler wird auch beim Resizen der ItemWindows
	// gerufen
	if ( rCEvt.IsResized() )
	{
		// Merken, da\s umkonfiguriert wurde, die ItemWindowBreite wird beim
		// Abspeichern vom ItemWindow direkt abgeholt
		SetDefault(FALSE);
		return;
	}

	if ( rCEvt.GetTargetBox() == NULL )
	{
		// Es wurde ein Item entfernt
		USHORT nId = rCEvt.GetSourceId();

		if ( IsRuntimeItem( nId ))
			return; // Don't enable configuration of runtime items

		SfxToolBoxControl *pControl=0;

		USHORT nPos;
		for ( nPos=0; nPos<pControls->Count(); ++nPos )
			if ( pControls->GetObject(nPos)->GetId() == nId )
		{
			pControl = pControls->GetObject(nPos);
			break;
		}

		if (pControl)
		{
			pBindings->ENTERREGISTRATIONS();

			Window *pItemWin = pBox->GetItemWindow(nId);
			if ( pItemWin )
			{
				pItemWin->Hide();
				delete pItemWin;
				pBox->SetItemWindow( nId, 0 );
			}

			delete pControl;
			pControls->Remove(nPos);

			pBindings->LEAVEREGISTRATIONS();
		}

		pBox->RemoveItem( nSourcePos );
	}
	else if ( rCEvt.GetTargetBox() == pBox )
	{
		// Ich bin das Target.
		// Achtung: diesen Aufruf generiert der SFX, nicht SV (s.u.) !!
		if (rCEvt.GetData() != 0)
		{
			if (((SfxToolbox*)pBox)->IsEmpty())
			{
				// Das DummyItem in leeren ToolBoxen entfernen
				pBox->RemoveItem(0);
				((SfxToolbox*)pBox)->SetEmpty(FALSE);
			}

			USHORT nId = rCEvt.GetSourceId();

			// Habe ich das Item noch nicht ?
			if (pBox->GetItemPos(nId) == TOOLBOX_ITEM_NOTFOUND)
			{
				// Der SFX steckt die Source-Toolbox in die User-Daten
				ToolBox *pSource = (ToolBox*) rCEvt.GetData();

				pBox->InsertItem( nId, pBindings->GetImageManager()->GetAndLockImage_Impl( nId,
						bHiContrast,
						pIFace ? pIFace->GetModule() : 0), String(), 0, nTargetPos );

				SetItemText( nId, pSource->GetItemText( nId ) );

				// Macros m"u\sen einen Slot anfordern
				if ( SfxMacroConfig::IsMacroSlot( nId ) )
                {
					SFX_APP()->GetMacroConfig()->RegisterSlotId(nId);
                    pBox->SetItemCommand( nId, SFX_APP()->GetMacroConfig()->GetMacroInfo(nId)->GetURL() );
                }

				pBindings->ENTERREGISTRATIONS();

				SfxSlotPool &rSlotPool = SFX_SLOTPOOL();
				pBox->SetHelpText( nId, rSlotPool.GetSlotHelpText_Impl(nId) );

				SfxToolBoxControl *pControl =
					SfxToolBoxControl::CreateControl( nId, pBox, *pBindings, pIFace ? pIFace->GetModule() : 0 );
				pControls->Append( pControl );

				Window *pItemWin = pControl->CreateItemWindow(pBox);
				if ( pItemWin )
					pBox->SetItemWindow( nId, pItemWin );
                pBox->SetHelpId( nId, pSource->GetHelpId( nId ) );

				pBindings->LEAVEREGISTRATIONS();
			}
			else if( !pBox->IsItemVisible( nId ) )
			{
				pBox->ShowItem( nId );
				pBox->MoveItem( nId, nTargetPos );
			}
		}
		else if ( nSourcePos+1 == nTargetPos )
		{
			if ( pBox->GetItemType( nSourcePos-1 ) == TOOLBOXITEM_BUTTON )
				pBox->InsertSeparator( nSourcePos );
		}
		else
		{
			if ( (nSourcePos == nTargetPos)  &&
				 (pBox->GetItemType( nSourcePos-1 ) == TOOLBOXITEM_SEPARATOR) )
				pBox->RemoveItem( nSourcePos-1 );
			else
				pBox->MoveItem( rCEvt.GetSourceId(), nTargetPos );
		}
	}
	else
	{
		// Eines meiner Items wird in eine andere ToolBox kopiert; also rufe
		// ich dort den CustomizeHandler auf
		ToolBox* pTarget = rCEvt.GetTargetBox();
		if ( pTarget )
		{
			USHORT nId = rCEvt.GetSourceId();

			if ( IsRuntimeItem( nId ))
				return; // Don't enable configuration of runtime items

			// Der Zugriff auf eine protected method ...
			ToolBoxCustomizeEvent aEvnt (pTarget, nId, nTargetPos, pBox);
			((TbAccess_Impl*)pTarget)->CustomizeToolBox(aEvnt);
		}

		return;
	}

	if ( (pBox->GetItemType( nSourcePos ) == TOOLBOXITEM_SEPARATOR) &&
		 ((pBox->GetItemType( nSourcePos-1 ) == TOOLBOXITEM_SEPARATOR) ||
		  (pBox->GetItemType( nSourcePos+1 ) == TOOLBOXITEM_SEPARATOR) ||
		   pBox->GetItemCount() == 1 ) )
		pBox->RemoveItem( nSourcePos );

	if (pBox->GetItemCount() == 0)
	{
		// SV austricksen, damit die Gr"o\se stimmt
		((SfxToolbox*)pBox)->SetEmpty(TRUE);
		USHORT nId = SID_NEWDOC;
		pBox->InsertItem( nId, String());
        pBox->SetItemImage(nId, pBindings->GetImageManager()->GetImage(nId, pIFace ? pIFace->GetModule() : 0));
		pBox->HideItem(nId);
	}

	SetDefault(FALSE);
//    if ( !pBox->IsInCustomizeMode() )
	SfxConfigManager* pCfgMgr = GetConfigManager();

	pCfgMgr->StoreConfigItem( *this );
	pCfgMgr->StoreConfiguration();
	pCfgMgr->ReInitialize( GetType() );

//	StoreConfig();
//	ReInitialize(); // Notify all toolbox managers that the configuration has changed!

	// Es k"onnte sein, da\s sich durch das neue Item die Gr"o\se der
	// ToolBox ge"andert hat
	SfxDispatcher* pDisp = GetBindings().GetDispatcher_Impl();
	if ( pDisp )
	{
		SfxViewFrame  *pFrame  = pDisp->GetFrame();
		SfxWorkWindow *pWorkWin = SFX_APP()->GetWorkWindow_Impl(pFrame);
		pWorkWin->ConfigChild_Impl
			( SFX_CHILDWIN_OBJECTBAR, SFX_ALIGNDOCKINGWINDOW, GetType() );
	}
}

//--------------------------------------------------------------------

void SfxToolBoxManager::UpdateControls_Impl()

/*	Interne Methode zum erneuten Updaten aller SfxToolBoxContoller in
	diesem SfxToolBoxManager. Z.B. nach Umschaltung der Button-Art.
*/

{
	for ( USHORT n = 0; n < pControls->Count(); ++n )
	{
		SfxToolBoxControl *pControl = pControls->GetObject(n);
		if ( pControl->IsBound() )
			pBindings->GetStateCache( pControl->GetId() )->SetCachedState();
	}
}

//--------------------------------------------------------------------

void SfxToolBoxManager::Show()
{
//	  if (pBox->IsFloatingMode() == FALSE)
		pBox->Show();
}


//--------------------------------------------------------------------

void SfxToolBoxManager::Hide()
{
//	  if (pBox->IsFloatingMode() == FALSE)
		pBox->Hide();
}


// ------------------------------------------------------------------------

String SfxToolBoxManager::GetStreamName() const
{
/*
	if (pBox)
		return pBox->GetText();

	ResId aResId(GetType());
	aResId.SetRT(RSC_STRING);
	aResId.SetResMgr(pResMgr);
	if (Resource::GetResManager()->IsAvailable(aResId))
		return String(aResId);
	else
		return String();
*/
    return SfxConfigItem::GetStreamName( GetType() );
}

BOOL SfxToolBoxManager::ReInitialize()
{
	SfxToolbox *pTbx = (SfxToolbox*) pBox;
	pTbx->bReconfigure = TRUE;
    BOOL bRet = SfxConfigItem::ReInitialize();
	pTbx->bReconfigure = FALSE;
	const Link& aChangedListener = pTbx->GetChangedListener();
	if ( aChangedListener.IsSet() )
		aChangedListener.Call( this );
	return bRet;
}

void SfxToolBoxManager::Reconfigure_Impl( SfxToolBoxConfig* pTbxCfg )
{
	BOOL bChanged = FALSE;
	SfxToolbox* pTbx = (SfxToolbox*) pBox;
	USHORT nPos = ((SfxToolbox*)pBox)->nPos;
	const ::framework::ToolBoxLayoutItemDescriptor *pItem = pTbxCfg->GetCfgItem_Impl( nPos );

	// Check if we have a different config manager through our bindings. This can happen
	// when we exchanged a unmodified document with already created toolboxes. We have
	// to reconnect the configuration manager to get the correct configuration!!
	if ( GetBindings().GetConfigManager( GetType() ) != GetConfigManager() )
		ReConnect( GetBindings().GetConfigManager( GetType() ));

    if ( pItem->eType != pTbx->GetButtonType() )
	{
		bChanged = TRUE;
        pTbx->SetButtonType( pItem->eType );
		if ( !pTbx->IsFloatingMode() )
		{
			Size aActSize( pTbx->GetSizePixel() );
			Size aSize( pTbx->CalcWindowSizePixel() );
			if ( pTbx->IsHorizontal() )
				aSize.Width() = aActSize.Width();
			else
				aSize.Height() = aActSize.Height();

			pTbx->SetSizePixel( aSize );
		}
	}

    if ( pTbx->GetFloatingPosition() != pItem->aFloatingPos )
	{
        pTbx->SetFloatingPosition( pItem->aFloatingPos );
		bChanged = TRUE;
	}
	if ( pTbx->GetLineCount() != pItem->nLines )
	{
		pTbx->SetLineCount( pItem->nLines );
		bChanged = TRUE;
	}
	if ( pTbx->GetFloatingLines() != pItem->nFloatingLines )
	{
		pTbx->SetFloatingLines( pItem->nFloatingLines );
        pTbx->nFloatLines = pItem->nFloatingLines;
		bChanged = TRUE;
	}
	if ( pTbx->GetAlignment() != pItem->eAlign )
	{
		pTbx->SetToolBoxAlignment_Impl( pTbxCfg->GetAlignment( nPos ) );
		bChanged = TRUE;
	}

	SfxDispatcher* pDisp = GetBindings().GetDispatcher_Impl();
	if ( pDisp )
	{
		SfxViewFrame  *pFrame  =  pDisp->GetFrame();
		SfxWorkWindow *pWorkWin = SFX_APP()->GetWorkWindow_Impl(pFrame);
		if ( pItem->bFloating != pBox->IsFloatingMode() )
		{
			pTbx->SetFloatingMode( pItem->bFloating );
			pWorkWin->ConfigChild_Impl
				( SFX_CHILDWIN_OBJECTBAR, SFX_TOGGLEFLOATMODE, GetType() );
		}
		else if ( bChanged )
		{
			pWorkWin->ConfigChild_Impl
				( SFX_CHILDWIN_OBJECTBAR, SFX_ALIGNDOCKINGWINDOW, GetType() );
		}
	}
}

//---------------------------------------------------------------------------
// ObjectBars werden niemals direkt "uber den dtor, sondern nur "uber diese
// Methode gel"oscht. Falls diese Toolbox gerade aktiv ist, stehen wir mitten
// im SV und m"u\sen daher asynchron l"oschen.


void SfxToolBoxManager::Delete()
{
	if ( ((SfxToolbox*)pBox)->bActivated || ((SfxToolbox*)pBox)->HasChildPathFocus() )
	{
		((SfxToolbox*)pBox)->bDeleteToolBox = TRUE;
        GetpApp()->PostUserEvent(LINK(pBox, SfxToolbox, Delete), (void*)0);
	}
	else
		delete this;
}

//-------------------------------------------------------------------------
// Diese statische Methode erkennt an der "ubergebenen Id, ob es sich um eine
// benutzerdefinierte Toolbox handelt.


BOOL SfxToolBoxManager::IsUserDefToolBox_Impl(USHORT nId)
{
	if ( nId >= RID_SFX_TOOLBOX_USERSTART && nId <= RID_SFX_TOOLBOX_USEREND )
		return TRUE;
	else
		return FALSE;
}

//-------------------------------------------------------------------------
// Mit dieser statischen Methode kann eine f"ur die Lebensdauer der Toolbox
// g"ultige, eindeutige Id f"ur eine benutzerdefinierte ToolBox angefordert
// werden.


USHORT SfxToolBoxManager::GetUserDefToolBoxId_Impl()
{
	USHORT nRet=0;
	for ( USHORT nId=RID_SFX_TOOLBOX_USERSTART;
			nId <= RID_SFX_TOOLBOX_USEREND; nId++ )
	{
		for (SfxInterface *pIFace = SFX_SLOTPOOL().FirstInterface(); pIFace != 0;
				pIFace = SFX_SLOTPOOL().NextInterface())
		{
			// Nur Interfaces mit Namen d"urfen welche bekommen
			if ( pIFace->HasName())
			{
				if ( pIFace->HasObjectBar(nId) )
					break;
				else
					nRet = nId;
			}
		}

		// Hurra, gefunden !
		if ( nRet )
			break;
	}

	return nRet;
}

void SfxToolBoxManager::ReInitControllers_Impl()
{
	if ( IsDefault() )
		return;
	if (pControls)
	{
		pBindings->ENTERREGISTRATIONS();
		for ( USHORT n = 0; n < pControls->Count(); ++n )
		{
			SfxToolBoxControl *pControl = pControls->GetObject(n);
			if ( !pControl->IsBound() )
				continue;
			SfxToolBoxControl *pNew = pControl->ReInit_Impl();
			if ( pNew != pControl )
			{
				USHORT nId = pNew->GetId();

				Window *pNewItemWin = pNew->CreateItemWindow( pBox );

				Window *pItemWin = pBox->GetItemWindow( nId );
				if ( pItemWin )
				{
					pItemWin->Hide();
					delete pItemWin;
				}

				pBox->SetItemWindow( nId, pNewItemWin );

				pControls->GetObject(n) = pNew;
				delete pControl;
			}
		}
		pBindings->LEAVEREGISTRATIONS();
	}
}

void SfxToolBoxManager::NextToolBox()
{
	SfxDispatcher* pDisp = GetBindings().GetDispatcher_Impl();
	if ( pDisp )
		pDisp->ShowObjectBar( GetNextToolBox_Impl() );
}

USHORT SfxToolBoxManager::GetNextToolBox_Impl( String *pStr )
{
	SfxDispatcher* pDisp = GetBindings().GetDispatcher_Impl();
	if ( pDisp )
		return pDisp->GetNextToolBox_Impl( ((SfxToolbox*)pBox)->nPos, GetType(), pStr );
	else
		return 0;
}

void SfxToolBoxManager::SetItemText( USHORT nId, const String& rText )
{
	if ( SfxMacroConfig::IsMacroSlot( nId ) )
	{
		( (SfxToolbox*)pBox )->SetItemText_Impl( nId, TRUE );
	}
	else
	{
		SfxSlotPool& rSlotPool = pIFace && pIFace->GetModule()
			? *pIFace->GetModule()->GetSlotPool() : SFX_APP()->GetSlotPool();
		if ( rSlotPool.GetSlotName_Impl( nId ) != rText )
			( (SfxToolbox*)pBox )->SetItemText_Impl( nId, TRUE );
		else
			( (SfxToolbox*)pBox )->SetItemText_Impl( nId, FALSE );
	}

	pBox->SetItemText( nId, rText );
}

BOOL SfxToolBoxManager::IsInternal()
{
    return bInternal;
}

void SfxToolBoxManager::CreateConfiguration( SfxConfigManager* pMgr, USHORT nId )
{
	if ( !pMgr->HasConfigItem( nId ) )
	{
		SfxToolBoxManager* pTbx = new SfxToolBoxManager( pMgr, nId );
		pTbx->SetDefault( FALSE );
		pTbx->StoreConfig();
		delete pTbx;
	}
}

void SfxToolBoxManager::RemoveConfiguration( SfxConfigManager* pMgr, USHORT nId )
{
	if ( pMgr->HasConfigItem( nId ) )
	{
		pMgr->RemovePersistentConfigItem( nId );
	}
}
