/*************************************************************************
 *
 *  $RCSfile: tbxchild.hxx,v $
 *
 *  $Revision: 1.11 $
 *
 *  last change: $Author: cd $ $Date: 2002/09/05 15:38:38 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _TIMER_HXX //autogen
#include <vcl/timer.hxx>
#endif
#ifndef _TOOLBOX_HXX //autogen
#include <vcl/toolbox.hxx>
#endif

#ifndef SVTOOLS_ASYNCLINK_HXX
#include <svtools/asynclink.hxx>
#endif

#define _SVSTDARR_USHORTS
#include <svtools/svstdarr.hxx>		// SvUShorts

#include "chalign.hxx"
#include "sfxtypes.hxx"

class SfxToolBoxControl;
class SfxToolBox_Impl;

struct SfxChildWinInfo;

class SfxToolbox: public ToolBox
{
friend class SfxToolBoxManager;

	SvUShorts			aItems;
	BOOL                bConstructed;
	BOOL                bEmpty;
	BOOL				bHelpInitialized;
	BOOL				bWaitSuppressed;
	SfxToolBoxManager*	pMgr;
	SfxToolBoxControl*	pControl;
	Timer				aTimer;
	Timer				aAsyncStoreCfgTimer;
	SfxChildAlignment   eAlignment;
	WindowAlign			eAlign;
	Point               aFloatPos;
	USHORT              nLines;
	USHORT              nFloatLines;
	BOOL				bCopyCtor;
	BOOL				bActivated;
	BOOL				bDeleteToolBox;
	BOOL				bReconfigure;
	BOOL				bMod1;
	BOOL				bMod2;
	BOOL				bShift;
	USHORT 				nPos;
    svtools::AsynchronLink	aLink;
	SfxToolBox_Impl*	pImp;
	Link				aChangedListener;
	int					nActivated;

protected:
    virtual void    Move();
	virtual void	MouseButtonDown( const MouseEvent& rMEvt );
	virtual void	MouseMove( const MouseEvent& rMEvt );
	virtual void	MouseButtonUp( const MouseEvent& rMEvt );
	virtual void	DoubleClick();
	virtual void	Click();
	virtual void    Deactivate();
	virtual void	Highlight();
	virtual void	Command ( const CommandEvent& rCEvt );
	virtual void    StartDocking();
	virtual BOOL    Docking(const Point&, Rectangle&);
	virtual void    EndDocking(const Rectangle& rRect, BOOL bFloatMode);
	virtual BOOL    PrepareToggleFloatingMode();
	virtual void    ToggleFloatingMode();
	virtual void    RequestHelp( const HelpEvent& rHEvt );
	virtual void    Customize( const ToolBoxCustomizeEvent& rCEvt );
	virtual void    Resize();
	virtual BOOL    Close();
	virtual long	Notify( NotifyEvent& rNEvt );
	virtual void 	NextToolBox();
    virtual void	StateChanged( StateChangedType nType );
	virtual void	DataChanged( const DataChangedEvent& rDCEvt );
	DECL_LINK( 		Delete, void * );

	void			Construct();
	void			CheckAndUpdateImages();
	DECL_LINK( 		TimeHdl, Timer * );
	DECL_LINK( 		AsyncStoreCfgHdl, Timer * );
	ULONG			nEventId;


public:
					SfxToolbox( SfxToolBoxManager &rMgr, Window *pParent, WinBits nBits );
					SfxToolbox( SfxToolBoxManager &rMgr, Window *pParent, ResId &rResId );
					~SfxToolbox();

	void 			SetConstructed(BOOL bCon) {bConstructed = bCon; }
	void 			SetEmpty(BOOL bOn) {bEmpty = bOn; }
	BOOL 			IsEmpty() {return bEmpty; }
	BOOL 			IsConstructed() {return bConstructed; }
	USHORT 			GetItemAt( const CommandEvent &rMEvt);
	virtual void    FillInfo(SfxChildWinInfo&) const;
	SfxChildAlignment	GetAlignment() const	{ return eAlignment; }
	void			SetToolBoxAlignment_Impl( SfxChildAlignment );
	void			SetChildAlignment_Impl( WindowAlign eAlign );
	USHORT 			GetPosition_Impl() const	{ return nPos; }
	void			ClearItemText_Impl();
	void			SetItemText_Impl( USHORT, BOOL );
	BOOL			HasItemText_Impl( USHORT );
	void			SetChangedListener( const Link& aLink ) { aChangedListener = aLink; }
	const Link&		GetChangedListener() const { return aChangedListener; }
	BOOL			IsHiContrastMode();
    void            SetFloatingPosition( const Point& rPos );
    Point           GetFloatingPosition() const;
};


