/*************************************************************************
 *
 *  $RCSfile: ptoplvl.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/27 11:09:14 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif

#include "maindlg.hxx"
#include "environ.hxx"
#include "script.hxx"

#include "ptoplvl.hxx"
#include "ptoplvl.hrc"

PageTopLevel::PageTopLevel( SvAgentDlg* pParent, const ResId& rResId ) :
	SvAgentPage		( pParent, rResId ),
	aFTInfo1		( this, ResId(FT_INFO1, rResId.GetResMgr()) ),
	aModuleView		( this, ResId(LB_MODVIEW, rResId.GetResMgr()), TRUE ),
	aGBDescription	( this, ResId(GB_DESCRIPTION, rResId.GetResMgr()) ),
	aFTDescription  ( this, ResId(FT_DESCRIPTION, rResId.GetResMgr()) )
{
	String aTitle( ResId(STR_TITLE, rResId.GetResMgr()) );
	aTitle.SearchAndReplace( UniString::CreateFromAscii("%1"),
			UniString::CreateFromAscii(GETDLG()->GetEnv()->GetProductName().GetBuffer()) );

	pParent->SetTitleStr( aTitle );
	FreeResource();

	aModuleView.SetSelectHdl( LINK(this, PageTopLevel, SelectHdl) );
	aModuleView.SetCheckButtonHdl( LINK(this, PageTopLevel, CheckHdl) );

	aModuleView.List( GETDLG()->GetCScript()->GetRootModule(), 0, FALSE );
}

PageTopLevel::~PageTopLevel()
{
}

SvAgentPage* PageTopLevel::Create( SvAgentDlg* pParent, const ResId& rResId )
{
	return new PageTopLevel( pParent, rResId );
}

IMPL_LINK(PageTopLevel, SelectHdl, SiModuleView*, EMPTYARG)
{
	SvLBoxEntry *pEntry = aModuleView.GetCurEntry();
	if( pEntry != NULL )
	{
		SiModule* pModule = (SiModule*) pEntry->GetUserData();
		aFTDescription.SetText( UniString::CreateFromAscii(pModule->GetDescription().GetBuffer()) );
	}
	return 0;
}

IMPL_LINK(PageTopLevel, CheckHdl, SiModuleView*, EMPTYARG)
{
	SvLBoxEntry *pEntry = aModuleView.GetCurEntry();

	if( pEntry == NULL )
		return 0;

	BOOL		bChecked  = aModuleView.GetCheckButtonState(pEntry) == SV_BUTTON_CHECKED;
	SiModule*	pModule   = (SiModule*) pEntry->GetUserData();

	if( pModule == NULL )
		return 0;

	SelectHdl( &aModuleView );

	ByteString aInfoText = bChecked ? pModule->GetOnSelect() : pModule->GetOnDeselect();
	if( aInfoText.Len() > 0 )
	{
		InfoBox aIBox( NULL, UniString::CreateFromAscii(aInfoText.GetBuffer()) );
		aIBox.Execute();
	}

	return 0;
}

