/*************************************************************************
 *
 *  $RCSfile: compiler.cxx,v $
 *
 *  $Revision: 1.26.92.1 $
 *
 *  last change: $Author: hr $ $Date: 2004/01/09 18:52:22 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <stdlib.h>

#ifndef _VOS_SECURITY_HXX_ //autogen
#include <vos/security.hxx>
#endif

#ifndef _SV_SVAPP_HXX //autogen
#include <vcl/svapp.hxx>
#endif

#include "compiler.hxx"
#include "decltor.hxx"
#include "script.hxx"
#include "fields.hxx"
#include "os.hxx" // GetGUIPath() und GetSystemPath()

#ifdef UNX
#include <stdlib.h>
#include <unistd.h>
#include <pwd.h>
#endif

SiCompiler::SiCompiler
(
	SvStream& aStream,
	com::sun::star::setup::OSType eOsType,
    int nLanguage
)
: SiParser(aStream)
, m_Constants(100)
{
	m_pCompiledScript           = NULL;
    m_pCurrentDeclarator        = NULL;
    m_nCurrentPropertyLanguage  = LANG_DEFAULT;
	m_eOsType					= eOsType;
    m_bSymanticError            = FALSE;
	m_bIgnoreError				= FALSE;
	m_bScpMode					= FALSE;

	// Dictionary fr Konstanten aufbauen.
	// TRUE gibt nur an, da etwas enthalten ist (wird bei Find zurckgegeben)
	// allgemein:
	USHORT i = 0;

	while (ALL_VALUES[i] != NULL)
	{
		m_Constants.Insert(ALL_VALUES[i],ALL_VALUES[i]);
		i++;
	}
}

SiCompiler::~SiCompiler()
{
    if (m_pCurrentDeclarator != NULL)
    {
        DBG_ERROR("current declarator deleted");
        DELETEZ(m_pCurrentDeclarator);
    }
}

void SiCompiler::DisplayError
(
	int			  nLine,
    ByteString const& ErrorType,
    ByteString const& Message
) const
// alles ausser Warnungen ausgeben
{
	ByteString anErrorType = ErrorType;
	anErrorType.ToLowerAscii();

	if( !m_bIgnoreError &&
		ErrorType.Search("warning") == STRING_NOTFOUND )
	{
		SiParser::DisplayError(nLine, ErrorType, Message);
	}
}

void SiCompiler::SymanticError(ByteString const& aErrorMessage)
{
    m_bSymanticError = TRUE;
    DisplayError(GetLine(), "error:", aErrorMessage);
}

void SiCompiler::Warning(ByteString const& anWarningMessage)
{
    DisplayError(GetLine(), "warning:", anWarningMessage);
}

SiDeclarator* SiCompiler::CheckLanguage()
{
	if( !m_pCompiledScript->IsSecondLevel() &&
		m_nCurrentPropertyLanguage != LANG_DEFAULT &&
		m_pCompiledScript && m_pCompiledScript->GetInstallation() )
	{
		ByteString aLanguages( m_pCompiledScript->GetInstallation()->GetLanguages() );
		ByteString aSrch = ByteString::CreateFromInt32( m_nCurrentPropertyLanguage );
		if( aSrch.Len() == 1 )
			aSrch.Insert( "0", 0 );
		if( aLanguages.Search(aSrch) == STRING_NOTFOUND )
			return NULL;
	}

	SiDeclarator* pDecl = m_pCurrentDeclarator->GetInternalLangRef(m_nCurrentPropertyLanguage);
	if( !pDecl ) m_bOpenRefs = TRUE;
	return pDecl;
}

BOOL SiCompiler::SecondLevelCompile( SiCompiledScript *pCC )
{
	pCC->SetSecondLevel( TRUE );
	m_bOpenRefs = FALSE;

	CompileTo( pCC, USHRT_MAX );

	pCC->SetSecondLevel( FALSE );
	return m_bOpenRefs;
}

BOOL SiCompiler::CompileTo( SiCompiledScript *pCC, int nMaxErrors )
{
    m_pCompiledScript = pCC;
    m_bSymanticError  = FALSE;

	AddSystemObjectsTo(pCC);

    int nErrors = 0;
    if( !ParseScript() )
    {
        do
        {
            nErrors++;
            if (IsSyntaxError())
            {
                Recover();
                if (m_pCurrentDeclarator!=NULL)
                    OnDeclarationEnd();
            }

            ResetError();
        }
        while (nErrors < nMaxErrors
           && !Continue());
    }
    m_pCompiledScript->AddUnlinkedObjectsToRoot();
    return nErrors == 0 && !m_bSymanticError;
}

void SiCompiler::AddSystemObjectsTo(SiCompiledScript *pScript)
{
	DBG_ASSERT( GetOsType() != com::sun::star::setup::OSType_INVALID, "SiCompiler::AddSystemObjectsTo() unknown os" );
	SiDirectory* pDir = NULL;

	// PREDEFINED_AUTOSTART
	SiFolder *pFolder = new SiFolder( SiIdentifier("PREDEFINED_AUTOSTART"), this, TRUE);
	pFolder->SetPredefined();
#ifdef OS2
	pFolder->SetProperty( PROPERTY_OS2_ID, Os2OS::GetAutostartFolderID() );
#elif defined WIN || defined WNT
	pFolder->SetUniProperty( PROPERTY_NAME, WinOS::SHGetAutostartFolderName() );
#endif
	pScript->Add(pFolder,this);

	// PREDEFINED_OS2_PROGRAMCLASS
	SiOs2Class *pOs2Class = new SiOs2Class( SiIdentifier("PREDEFINED_OS2_PROGRAMCLASS"), this, TRUE );
	pOs2Class->SetProperty( PROPERTY_NAME, "WPProgram" );
	pScript->Add( pOs2Class, this );

	// PREDEFINED_OSLIBDIR
	pDir = new SiDirectory( SiIdentifier("PREDEFINED_OSLIBDIR"), this, TRUE, TRUE );
	pScript->Add( pDir, this );
	SiDirEntry aEntry( OS::GetGUIPath() );
	aEntry += ByteString( "dll" );
	pDir->SetProperty( PROPERTY_HOSTNAME, aEntry.GetFull() );

/*
 * 	geht mit WEB Install nicht mehr; ko"nnte unter OS2 Probleme mit IconDir geben!!!
*/
	// PREDEFINED_STARTDIR
	SiDirEntry anAppEntry( Application::GetAppFileName() );
	anAppEntry.ToAbs();
	pDir = new SiDirectory( SiIdentifier("PREDEFINED_STARTDIR"), this, TRUE , FALSE );
    pScript->Add( pDir, this );
    pDir->SetProperty( PROPERTY_HOSTNAME, ByteString(anAppEntry.GetPath().GetFull(), osl_getThreadTextEncoding()) );


	// PREDEFINED_OUTERPATH
    pDir = new SiDirectory( SiIdentifier( "PREDEFINED_OUTERPATH" ), this, TRUE, FALSE );
    pScript->Add( pDir, this );
	#ifdef MAC
	pDir->SetProperty( PROPERTY_HOSTNAME, ":" );
	#else
	pDir->SetProperty( PROPERTY_HOSTNAME, "." );
	#endif

	// PREDEFINED_OSDIR
    pDir = new SiDirectory( SiIdentifier("PREDEFINED_OSDIR"), this, TRUE , TRUE );
    pScript->Add( pDir, this );
    pDir->SetProperty( PROPERTY_HOSTNAME,OS::GetGUIPath() );

    // PREDEFINED_OSSYSTEMDIR
	pDir = new SiDirectory( SiIdentifier("PREDEFINED_OSSYSTEMDIR"), this, TRUE, TRUE );
    pScript->Add( pDir, this );
    pDir->SetProperty( PROPERTY_HOSTNAME, OS::GetSystemPath() );

	// PREDEFINED_OSSYSTEMFONTDIR
    pDir = new SiDirectory( SiIdentifier("PREDEFINED_OSSYSTEMFONTDIR"), this, TRUE, TRUE );
    pScript->Add( pDir, this );
    pDir->SetProperty( PROPERTY_HOSTNAME, OS::GetSystemFontPath() );

	// PREDEFINED_IEDIR
    pDir = new SiDirectory( SiIdentifier("PREDEFINED_IEDIR"), this, TRUE, TRUE );
    pScript->Add( pDir, this );
    pDir->SetProperty( PROPERTY_HOSTNAME, OS::GetIEDir() );

	// PREDEFINED_IEPLUGINDIR
    pDir = new SiDirectory( SiIdentifier("PREDEFINED_IEPLUGINDIR"), this, TRUE, TRUE );
    pScript->Add( pDir, this );
    pDir->SetProperty( PROPERTY_HOSTNAME, OS::GetIEPluginDir() );

	// PREDEFINED_HOMEDIR
	NAMESPACE_VOS(OSecurity) aSecurity;
	::rtl::OUString aHomeDir;
	aSecurity.getHomeDir(aHomeDir);

#ifdef WNT
    if ( aHomeDir.getLength() == 0 )
        aHomeDir = WinOS::SHGetPersonalFolderName();
#endif

    ::rtl::OString oStrHomeDir = ::rtl::OUStringToOString( aHomeDir, osl_getThreadTextEncoding() );

	pDir = new SiDirectory( SiIdentifier("PREDEFINED_HOMEDIR"), this, TRUE, TRUE );
	pDir->SetProperty( PROPERTY_HOSTNAME, ByteString(oStrHomeDir) );
	pScript->Add( pDir, this );
    
    // PREDEFINED_KDEHOME
#ifdef UNX
    char * kdehome = getenv("KDEHOME");

    pDir = new SiDirectory( SiIdentifier("PREDEFINED_KDEHOME"), this, TRUE, TRUE );
    
    if( NULL != kdehome )
    {
    	pDir->SetProperty( PROPERTY_HOSTNAME, ByteString(kdehome) );
    }
    else
    {
        ByteString oKDEHome(getpwuid(getuid())->pw_dir);
        oKDEHome+="/.kde";
    	pDir->SetProperty( PROPERTY_HOSTNAME, oKDEHome );
    }
        
	pScript->Add( pDir, this );
#endif        

	// PREDEFINED_CONFIGDIR
	::rtl::OUString aConfigDir;
	aSecurity.getConfigDir(aConfigDir);
	::rtl::OString oStrConfigDir = ::rtl::OUStringToOString( aConfigDir, osl_getThreadTextEncoding() );

	pDir = new SiDirectory( SiIdentifier("PREDEFINED_CONFIGDIR"), this, TRUE, TRUE );
	pDir->SetProperty( PROPERTY_HOSTNAME, ByteString(oStrConfigDir) );
	pScript->Add( pDir, this );

	// PREDEFINED_SERVICEDIR
	pDir = new SiDirectory( SiIdentifier("PREDEFINED_SERVICEDIR"), this, TRUE, TRUE );
	pScript->Add(pDir, this);
	#if defined(WNT)
	ByteString aOS( WinOS::GetOSVersion() );
	if( aOS == "NT35" || aOS == "NT4" || aOS == "NT5" )
	{
		SiDirEntry aDir( OS::GetSystemPath() );
		aDir += ByteString( "drivers\\etc\\" );
		pDir->SetProperty( PROPERTY_HOSTNAME, aDir.GetFull() );
	}
	else
	{
		SiDirEntry aDir( OS::GetGUIPath() );
		pDir->SetProperty( PROPERTY_HOSTNAME, aDir.GetFull() );
	}
	#endif

	// PREDEFINED_OSSHELLNEWDIR
	pDir = new SiDirectory( SiIdentifier("PREDEFINED_OSSHELLNEWDIR"), this, TRUE, TRUE );
	pScript->Add(pDir, this);
	#if defined(WNT)
	SiDirEntry aDir( WinOS::SHGetTemplateFolderName( FALSE ) );
	if( !aDir.Exists() )
	{
		aDir  = OS::GetGUIPath();
		aDir += ByteString("shellnew");
		aDir.MakeDir();
	}
	pDir->SetProperty( PROPERTY_HOSTNAME, aDir.GetFull() );
	#endif

	// PREDEFINED_OSDESKTOPDIR
	pDir = new SiDirectory( SiIdentifier("PREDEFINED_OSDESKTOPDIR"), this, TRUE, TRUE );
	pScript->Add( pDir, this );
	#if defined WIN || defined WNT
	pDir->SetProperty( PROPERTY_HOSTNAME, ByteString(WinOS::SHGetSystemDesktopFolderName(), osl_getThreadTextEncoding()) );
	#endif

	// PREDEFINED_BOOKMARKDIR
	pDir = new SiDirectory( SiIdentifier("PREDEFINED_BOOKMARKDIR"), this, TRUE, TRUE );
	pScript->Add( pDir, this );
	#if defined WIN || defined WNT
	pDir->SetProperty( PROPERTY_HOSTNAME, ByteString(WinOS::SHGetFavoritesFolderName(), osl_getThreadTextEncoding()) );
	#elif defined(OS2)
	pDir->SetProperty( PROPERTY_HOSTNAME, Os2OS::GetFavoritesFolderName() );
	#endif

	// PREDEFINED_PERSONALDIR
	pDir = new SiDirectory( SiIdentifier("PREDEFINED_MYDOCUMENTS"), this, TRUE, TRUE );
	pScript->Add( pDir, this );
	#if defined WIN || defined WNT
	pDir->SetProperty( PROPERTY_HOSTNAME, ByteString(WinOS::SHGetPersonalFolderName(), osl_getThreadTextEncoding()) );
	#endif
	#if defined UNX
	pDir->SetProperty( PROPERTY_HOSTNAME, ByteString(oStrHomeDir) );
	#endif

	// PREDEFINED_PROGDIR
    pDir = new SiDirectory( SiIdentifier("PREDEFINED_PROGDIR"), this, TRUE, FALSE );
    pScript->Add( pDir, this );
	#ifdef MAC
	pDir->SetProperty( PROPERTY_HOSTNAME, ":" );
	#else
	pDir->SetProperty( PROPERTY_HOSTNAME, "." );
	#endif

	// PREDEFINED_WORKDIR
    pDir = new SiDirectory( SiIdentifier("PREDEFINED_WORKDIR"), this, TRUE, FALSE );
    pScript->Add( pDir, this );
	#ifdef MAC
    pDir->SetProperty(PROPERTY_HOSTNAME,":");
	#else
    pDir->SetProperty(PROPERTY_HOSTNAME,".");
	#endif
    pDir->SetProperty( PROPERTY_FLAGS, VALUE_WORKSTATION );

	// RegistryItems
	SiRegistryItem *pItem = NULL;

	// PREDEFINED_HKEY_CLASSES_ROOT
	pItem = new SiRegistryItem(SiIdentifier("PREDEFINED_HKEY_CLASSES_ROOT"),this,TRUE);
	pItem->SetKey("HKEY_CLASSES_ROOT");
	pScript->Add(pItem,this);

	// PREDEFINED_HKEY_CURRENT_USER
	pItem = new SiRegistryItem(SiIdentifier("PREDEFINED_HKEY_CURRENT_USER"),this,TRUE);
	pItem->SetKey("HKEY_CURRENT_USER");
	pScript->Add(pItem,this);

	// PREDEFINED_HKEY_LOCAL_MACHINE
	pItem = new SiRegistryItem(SiIdentifier("PREDEFINED_HKEY_LOCAL_MACHINE"),this,TRUE);
	pItem->SetKey("HKEY_LOCAL_MACHINE");
	pScript->Add(pItem,this);

	// PREDEFINED_HKEY_USERS
	pItem = new SiRegistryItem(SiIdentifier("PREDEFINED_HKEY_USERS"),this,TRUE);
	pItem->SetKey("HKEY_USERS");
	pScript->Add(pItem,this);

	// PREDEFINED_HKEY_CURRENT_CONFIG
	pItem = new SiRegistryItem(SiIdentifier("PREDEFINED_HKEY_CURRENT_CONFIG"),this,TRUE);
	pItem->SetKey("HKEY_CURRENT_CONFIG");
	pScript->Add(pItem,this);

	// PREDEFINED_HKEY_DYN_DATA
	pItem = new SiRegistryItem(SiIdentifier("PREDEFINED_HKEY_DYN_DATA"),this,TRUE);
	pItem->SetKey("HKEY_DYN_DATA");
	pScript->Add(pItem,this);
}

void SiCompiler::OnDeclaration(SiLexemType Type, SiIdentifier const& ID)
{
	if( m_pCompiledScript->IsSecondLevel() )
	{
		SiDeclarator* pFnd = m_pCompiledScript->Find(ID.AsByteString());
		if( pFnd )
		{
			m_pCurrentDeclarator = pFnd;
			return;
		}
	}

	switch( Type )
	{
		case LT_INSTALLATION:
            m_pCurrentDeclarator = new SiInstallation(ID,this);
			if( m_aDefDefaultLanguage.Len() )  // uebersteuern bei particel zip
			{
				m_pCurrentDeclarator->SetProperty( PROPERTY_DEFLANGUAGE, m_aDefDefaultLanguage );
				m_pCurrentDeclarator->SetProperty( PROPERTY_LANGUAGES, m_aDefLanguages );
			}
			break;

        case LT_MODULE:
            m_pCurrentDeclarator = new SiModule(ID,this);
            break;

        case LT_MODULELIST:
            m_pCurrentDeclarator = new SiModuleIds( ID, this );
            break;

        case LT_MODULESET:
            m_pCurrentDeclarator = new SiModulesSet( ID, this );
            break;

        case LT_FILE:
            m_pCurrentDeclarator = new SiFile(ID,this);
            break;

        case LT_DIRECTORY:
            m_pCurrentDeclarator = new SiDirectory(ID,this);
            break;

        case LT_DATACARRIER:
            m_pCurrentDeclarator = new SiDataCarrier(ID,this);
            break;

        case LT_FOLDER:
            m_pCurrentDeclarator = new SiFolder(ID,this);
            break;

        case LT_FOLDERITEM:
            m_pCurrentDeclarator = new SiFolderItem(ID,this);
            break;

        case LT_PROFILE:
            m_pCurrentDeclarator = new SiProfile(ID,this);
            break;

        case LT_PROFILEITEM:
            m_pCurrentDeclarator = new SiProfileItem(ID,this);
            break;

        case LT_PROCEDURE:
            m_pCurrentDeclarator = new SiProcedure(ID,this);
            break;

        case LT_CUSTOM:
            m_pCurrentDeclarator = new SiCustom(ID,this);
            break;

        case LT_SLIDE:
            m_pCurrentDeclarator = new SiSlide(ID,this);
            break;

		case LT_SCPACTION:
            m_pCurrentDeclarator = new SiScpAction(ID,this);
            break;

		case LT_HELPTEXT :
            m_pCurrentDeclarator = new SiHelpText(ID,this);
            break;

		case LT_STARREGISTRY :
            m_pCurrentDeclarator = new SiStarRegistry(ID,this);
            break;

		case LT_STARREGISTRY_ITEM :
            m_pCurrentDeclarator = new SiStarRegistryItem(ID,this);
            break;

		case LT_CONFIGURATION_ITEM :
			m_pCurrentDeclarator = new SiConfigurationItem(ID,this);
			break;

		case LT_REGISTRYITEM:
		{
            m_pCurrentDeclarator = new SiRegistryItem(ID,this);

			if (GetOsType() != com::sun::star::setup::OSType_WIN)
				Warning("wrong operating system for <RegistryItem>");

            break;
		}

        case LT_REGISTRYAREA:
		{
            m_pCurrentDeclarator = new SiRegistryArea(ID,this);

			if (GetOsType() != com::sun::star::setup::OSType_WIN)
				Warning("wrong operating system for <RegistryArea>");

            break;
		}

        case LT_OS2_CLASS:
		{
            m_pCurrentDeclarator = new SiOs2Class(ID,this);

			if (GetOsType() != com::sun::star::setup::OSType_OS2)
				Warning("wrong operating system for <Os2Class>");

            break;
		}

        case LT_OS2_CREATOR:
		{
            m_pCurrentDeclarator = new SiOs2Creator(ID,this);

			if (GetOsType() != com::sun::star::setup::OSType_OS2)
				Warning("wrong operating system for <Os2Creater>");

            break;
		}

        case LT_OS2_TEMPLATE:
		{
            m_pCurrentDeclarator = new SiOs2Template(ID,this);

			if (GetOsType() != com::sun::star::setup::OSType_OS2)
				Warning("wrong operating system for <Os2Template>");

            break;
		}

        case LT_SHORTCUT:
		{
            m_pCurrentDeclarator = new SiShortcut(ID,this);
			break;
		}

        default:
            DBG_ERROR("SiCompiler::OnDeclaration() unkown declarator");
    }
}

void SiCompiler::OnDeclarationEnd()
{
    if( !m_pCurrentDeclarator->Check() )
        m_pCompiledScript->SetUncomplete();

    if( !m_pCompiledScript->Add(m_pCurrentDeclarator,this) &&
		!m_pCompiledScript->IsSecondLevel() )
    {
		ByteString aMsg("duplicate identifier <");
		aMsg += m_pCurrentDeclarator->GetID();
		aMsg += ">";
        SymanticError( aMsg );
        delete m_pCurrentDeclarator;
    }

    m_pCurrentDeclarator = NULL;
}

void SiCompiler::OnProperty (ByteString const& aProperty, int nLanguage)
{
    m_CurrentPropertyname       = aProperty;
    m_nCurrentPropertyLanguage  = nLanguage;
}

void SiCompiler::OnSingleValue (ByteString const& aValue)
{
	SiDeclarator* pDecl = CheckLanguage();
	if( pDecl )
	{
		ByteString aModValue = aValue;

		if( !m_pCompiledScript->IsSecondLevel() && !m_bScpMode )
		{
			if( !m_aSuiteName.Len() && m_CurrentPropertyname == PROPERTY_SUITENAME )
				m_aSuiteName = aValue;
			if( !m_aProductName.Len() && m_CurrentPropertyname == PROPERTY_PRODUCTNAME )
				m_aProductName = aValue;
			if( !m_aProductVersion.Len() && m_CurrentPropertyname == PROPERTY_PRODUCTVERSION )
				m_aProductVersion = aValue;
			if( !m_aVendorName.Len() && m_CurrentPropertyname == PROPERTY_VENDORNAME )
				m_aVendorName = aValue;
			if( !m_aVendorVersion.Len() && m_CurrentPropertyname == PROPERTY_VENDORVERSION )
				m_aVendorVersion = aValue;

			// #102476#
			if (m_aProductExtension.Len() == 0 && m_CurrentPropertyname == PROPERTY_PRODUCTEXTENSION )
				m_aProductExtension = aValue;
			// if (m_aPatchLevel.Len() == 0 && m_CurrentPropertyname == PROPERTY_PATCHLEVEL )
			//	m_aPatchLevel = aValue;
			if (m_aProductPatch.Len() == 0 && m_CurrentPropertyname == PROPERTY_PRODUCTPATCH )
				m_aProductPatch = aValue;


			aModValue.SearchAndReplaceAll( "%SUITENAME", m_aSuiteName );
			aModValue.SearchAndReplaceAll( "%PRODUCTNAME", m_aProductName );
			aModValue.SearchAndReplaceAll( "%PRODUCTVERSION", m_aProductVersion );
			aModValue.SearchAndReplaceAll( "%VENDORNAME", m_aVendorName );
			aModValue.SearchAndReplaceAll( "%VENDORVERSION", m_aVendorVersion );

			aModValue.SearchAndReplaceAll( "%PRODUCTEXTENSION", m_aProductExtension );
			// aModValue.SearchAndReplaceAll( "%PATCHLEVEL",       m_aPatchLevel );
			aModValue.SearchAndReplaceAll( "%PRODUCTPATCH",     m_aProductPatch );
		}
		pDecl->SetProperty( m_CurrentPropertyname, aModValue );
	}
}

void SiCompiler::OnSingleValue (SiIdentifier const& aValue)
{
	SiDeclarator* pDecl = CheckLanguage();
	if( !pDecl )
        return;

    // Referenz auf anderes Object?
	ByteString aFnd("PREDEFINED_");
	aFnd += aValue.AsByteString().Copy(3);

	SiDeclarator *pFndDec = m_pCompiledScript->Find(aValue.AsByteString());
	if( pFndDec == NULL && aValue.AsByteString().Match("PD_") == 3 )
		pFndDec = m_pCompiledScript->Find( aFnd );

	if( m_pCompiledScript->IsSecondLevel() && !pFndDec &&
		(m_CurrentPropertyname == PROPERTY_PROFILEID	||
		m_CurrentPropertyname == PROPERTY_MODULEID		||
		m_CurrentPropertyname == PROPERTY_CARRIER		||
		m_CurrentPropertyname == PROPERTY_DIR 			||
		m_CurrentPropertyname == PROPERTY_PARENTID		||
		m_CurrentPropertyname == PROPERTY_NETDIR		||
		m_CurrentPropertyname == PROPERTY_REGISTRYID	||
		m_CurrentPropertyname == PROPERTY_FILES			||
		m_CurrentPropertyname == PROPERTY_MODULEIDS		||
		m_CurrentPropertyname == PROPERTY_CUSTOMS		||
		m_CurrentPropertyname == PROPERTY_FILEID		||
		m_CurrentPropertyname == PROPERTY_SHORTCUTID	||
		m_CurrentPropertyname == PROPERTY_FOLDERID		||
		m_CurrentPropertyname == PROPERTY_ID			||
		m_CurrentPropertyname == PROPERTY_OS2_CREATORID	||
		m_CurrentPropertyname == PROPERTY_OS2_CLASSID	||
		m_CurrentPropertyname == PROPERTY_OS2_ID		||
		m_CurrentPropertyname == PROPERTY_OS2_REFERENCEID ||
		m_CurrentPropertyname == PROPERTY_PROCEDURES))
	{
		m_bOpenRefs = TRUE;
		return ;
	}

    if( pFndDec != NULL || aValue.AsByteString() == VALUE_NULL )
    {
        pDecl->SetProperty(m_CurrentPropertyname,pFndDec);
    }
	else
		OnSingleValue(aValue.AsByteString());
}

void SiCompiler::OnSingleValue( sal_Int32 nValue )
{
	SiDeclarator* pDecl = CheckLanguage();
	if( pDecl ) pDecl->SetProperty( m_CurrentPropertyname, nValue );
}

void SiCompiler::OnSingleValue( sal_uInt32 nValue )
{
	SiDeclarator* pDecl = CheckLanguage();
	if( pDecl ) pDecl->SetProperty( m_CurrentPropertyname, nValue );
}

void SiCompiler::OnListValue( ByteString const& aValue )
{
	SiDeclarator* pDecl = CheckLanguage();
	if( pDecl )
        pDecl->SetProperty(m_CurrentPropertyname,aValue);
}

void SiCompiler::OnListValue( SiIdentifier const& aValue )
{
	OnSingleValue(aValue);
}

void SiCompiler::OnListValue( sal_Int32 nValue )
{
	SiDeclarator* pDecl = CheckLanguage();
	if( pDecl )
		pDecl->SetProperty(m_CurrentPropertyname,nValue);
}
