/*************************************************************************
 *
 *  $RCSfile: action.cxx,v $
 *
 *  $Revision: 1.82.44.6 $
 *
 *  last change: $Author: vg $ $Date: 2004/10/12 10:44:37 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <tools/svwin.h>

#ifdef UNX
#include "sys/stat.h"
#include "unistd.h"
#endif

#ifndef _REGISTRY_REGISTRY_HXX_
#include <registry/registry.hxx>
#endif

#ifndef NOOLDSV //autogen
#include <vcl/system.hxx>
#endif

#ifndef _SV_WRKWIN_HXX //autogen
#include <vcl/wrkwin.hxx>
#endif

#ifndef _SV_CONFIG_HXX //autogen
#include <tools/config.hxx>
#endif

#ifndef _VOS_MUTEX_HXX_
#include <vos/mutex.hxx>
#endif

#ifndef _OSL_FILE_HXX_
#include <osl/file.hxx>
#endif

#ifndef _SVARRAY_HXX
#include <svtools/svarray.hxx>
#endif

#ifndef _COM_SUN_STAR_LANG_XSINGLESERVICEFACTORY_HPP_
#include <com/sun/star/lang/XSingleServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_REGISTRY_XSIMPLEREGISTRY_HPP_
#include <com/sun/star/registry/XSimpleRegistry.hpp>
#endif
#ifndef _COM_SUN_STAR_UTIL_XCHANGESBATCH_HPP_
#include <com/sun/star/util/XChangesBatch.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XNAMEREPLACE_HPP_
#include <com/sun/star/container/XNameReplace.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTYVALUE_HPP_
#include <com/sun/star/beans/PropertyValue.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XNAMECONTAINER_HPP_
#include <com/sun/star/container/XNameContainer.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XHIERARCHICALNAMEACCESS_HPP_
#include <com/sun/star/container/XHierarchicalNameAccess.hpp>
#endif

#include <cppuhelper/extract.hxx>
#include <tools/l2txtenc.hxx>


#include "action.hxx"
#include "environ.hxx"
#include "agenda.hxx"
#include "decltor.hxx"
#include "sicustom.hxx"
#include "script.hxx"
#include "event.hxx"
#include "sihelp.hxx"
#include "fields.hxx"
#include "critical.hxx"

#include "main.hxx"

#include "zipfile.hxx"
#include "os.hxx"
#include "sistream.hxx"
#include "sibasic.hxx"

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::util;
using namespace ::com::sun::star::container;
using namespace ::com::sun::star::registry;
using namespace ::com::sun::star::beans;
using namespace ::cppu;

char SEP[] = ", ";

#define DEFAULT_UNIX_RIGHTS     755
#define GID_SVERSION_INI        "gid_Profile_Sversion_Ini"
#define IGNORE_LIST             "ignore.txt"

SV_DECL_PTRARR_SORT( SortedIgnoreList, ByteString*, 1, 3 );
SV_IMPL_OP_PTRARR_SORT( SortedIgnoreList, ByteString* );

ULONG _SubstituteInFile( const ByteString& rFilename, const SiEnvironment& rEnv )
{
	SvFileStream aReadStrm( UniString(rFilename, osl_getThreadTextEncoding()), STREAM_READ );
	char* pBuf = new char[32001];

	ULONG nRead = aReadStrm.Read( pBuf, 32000 );
	aReadStrm.Close();
	pBuf[nRead] = 0x00;

	ByteString aBuffer(pBuf);
	delete[] pBuf;

	const SiReplacementList& rLst = rEnv.GetReplacementList();
    xub_StrLen nStartPos = aBuffer.Search( '<' );

    while ( nStartPos != STRING_NOTFOUND )
    {
    	for( ULONG i = 0; i < rLst.Count(); i++ )
        {
		    ReplacementEntry* pEntry = rLst.GetObject(i);
            USHORT nTagLength = pEntry->aTag.Len();
            if ( aBuffer.EqualsIgnoreCaseAscii( pEntry->aTag, nStartPos, nTagLength ) )
            {
                aBuffer.Replace( nStartPos, nTagLength, pEntry->aValue );
                break;
            }
        }
        // We don't replace recursive, so nStartPos should be incremented
        nStartPos = aBuffer.Search( '<', nStartPos+1 );
    }

	SiDirEntry aToKill( rFilename );
	aToKill.Kill();

	SvFileStream aWriteStrm( UniString(rFilename, osl_getThreadTextEncoding()), STREAM_WRITE );

	aWriteStrm.Write( aBuffer.GetBuffer(), aBuffer.Len() );
	aWriteStrm.Close();

	return aBuffer.Len();
}

// SiAction ----------------------------------------------------------------
//
SiAction::SiAction(SiAgenda *pAgenda, SiActionType eType /* = AT_UNKNOWN */ )
{
	m_pAgenda       = pAgenda;
	m_pDependsOn    = NULL;
	m_bSucceeded    = FALSE;
	m_bMayExecute	= TRUE;
	m_eType			= eType;
}

SiAction::~SiAction() // virtual
{}

SiLogStream& SiAction::GetLogfile()
{
	return m_pAgenda->GetLogfile();
}

SiInstallMode SiAction::GetInstallMode() const
{
	return m_pAgenda->GetInstallMode();
}

BOOL SiAction::DoRecoverOnly() const
{
	return m_pAgenda->DoRecoverOnly();
}

sal_Int16 SiAction::ReplaceMeta( ByteString& rValue,
                                 BOOL bDecode )
{
    sal_Int16 nEncoding = ENCODING_DEFAULT;
	rtl_TextEncoding eDefault = osl_getThreadTextEncoding();

	USHORT nBeginTpl = rValue.Search('<');
	while( nBeginTpl != STRING_NOTFOUND )
	{
		USHORT nEndTpl = rValue.Search( '>', nBeginTpl+1 );
		if( nEndTpl != STRING_NOTFOUND )
		{
			ByteString aTpl = rValue.Copy( nBeginTpl, nEndTpl-nBeginTpl+1 );
			QueryTemplateResult aResult = GetAgenda()->QueryTemplateValue( aTpl );
            ByteString aValue( aResult.sValue );
            if ( bDecode )
            {
                switch ( aResult.nEncoding )
                {
                    case LANGCODE2TEXTENCODING:     break;
                    case RTL_TEXTENCODING_UTF8:     aValue.Convert( RTL_TEXTENCODING_UTF8, eDefault ); break;
                    case OSL_GETTHREADTEXTENCODING:
                    default:                        break;
                }
            }
			rValue.Replace( nBeginTpl, aTpl.Len(), aValue );
            nEncoding = aResult.nEncoding;
		}
		nBeginTpl = rValue.Search( '<', nBeginTpl+1 );
	}

    return nEncoding;
}

BOOL SiAction::DoesTargetExist(SiEnvironment const& Env) const
// Prueft im Falle von Abhaengigkeiten die Targets.
// Sonst wird FALSE zurueckgeben, damit die Aktion bei Recover
// ausgefuehrt wird.
{
	if (m_pDependsOn != NULL)
		return m_pDependsOn->DoesTargetExist(Env);

	return CheckTarget(Env);
}

BOOL SiAction::CheckTarget(SiEnvironment const& Env) const
// Prueft das Ziel nur fuer diese Aktion (ohne Abhaengigkeiten)
{
	return FALSE; // Default: lieber ausfuehren als nicht
}

void SiAction::SetDependence(SiAction *pAction)
// pre:  es gibt noch keine Abhaengigkeit
// post: Abhaengigkeit wurde gesetzt
{
	DBG_ASSERT(m_pDependsOn == NULL, "SiAction::SetDependence() more than one dependence");
	m_pDependsOn = pAction;
}

BOOL SiAction::Succeeded() const
// Abfrage ob Aktion erfolgreich ausgefuehrt wurde
{
	return m_bSucceeded;
}

BOOL SiAction::SetSuccess(BOOL b)
{
	m_bSucceeded = b;
	return b;       // wegen Schreibweise: return SetSuccess(lErr==0);
}

SortedIgnoreList* SiAction::GetIgnoreList( SiEnvironment& rEnv )
{
    static SortedIgnoreList *pIgnoreList = NULL;

    if ( ! pIgnoreList )
    {
        pIgnoreList = new SortedIgnoreList;
    
        SiDirEntry aIgnoreFile  = rEnv.GetSourcePath();
                aIgnoreFile += SiDirEntry( "program" );
                aIgnoreFile += SiDirEntry( IGNORE_LIST );
        aIgnoreFile.ToAbs();
        FILE *pIgnore = fopen( aIgnoreFile.GetFull().GetBuffer(), "rt" );

        char pBuf[80];
        char *pStr;

        if ( pIgnore )
        {
            while ( fgets( pBuf, 79, pIgnore ) )
            {
                int i = 0;
                pBuf[79] = '\0';
                while ( ( pBuf[i] == 0x0a ) || ( pBuf[i] == 0x0d ) )
                    i += 1;
                pStr = &(pBuf[i]);
                i = strlen( pStr );
                while ( i && ( ( pStr[ i-1 ] == 0x0a ) || ( pStr[ i-1 ] == 0x0d ) ) )
                {
                    i -= 1;
                    pStr[i] = '\0';
                }
                if ( pStr[0] == '\0' )
                    continue;

                ByteString *pFile = new ByteString( pStr );
                pIgnoreList->C40_PTR_INSERT( ByteString, pFile );
            }
            fclose( pIgnore );
        }
    }

    return pIgnoreList;
}

// MakeDirAction ---------------------------------------------------------
//
SiMakeDirAction::SiMakeDirAction(SiAgenda *pAgenda, ByteString const& aDirName, int nRights)
: SiAction(pAgenda, AT_MAKEDIR)
{
	m_aDirName = aDirName;
	m_nUnixRights = nRights;
}

BOOL SiMakeDirAction::CheckTarget(SiEnvironment const& Env) const
{
	SiDirEntry aSiDirEntry  = Env.GetDestPath();
			 aSiDirEntry += m_aDirName;

	return aSiDirEntry.Exists();
}

BOOL SiMakeDirAction::Execute(SiEnvironment& Env)
{
	BOOL bSuccess = TRUE;
    SiDirEntry aSiDirEntry  = Env.GetDestPath();
			 aSiDirEntry += m_aDirName;

	if( aSiDirEntry.Exists() )
    {
        #ifdef UNX
        if ( m_nUnixRights )
        {
            bSuccess = UnixOS::SetRights( aSiDirEntry.GetFull(), m_nUnixRights );
            GetLogfile().Success( bSuccess ) << "chmod " << aSiDirEntry.GetFull()
                << " " << (long)m_nUnixRights << endl;
        }
        #endif
		return TRUE;
    }

	bSuccess = aSiDirEntry.MakeDir();

	GetLogfile().Success(bSuccess) << "mkdir " << aSiDirEntry.GetFull()
		<< (bSuccess ? " OK" : " ERR") << endl;

    #ifdef UNX
    if ( !m_nUnixRights )
        m_nUnixRights = DEFAULT_UNIX_RIGHTS;

    bSuccess = UnixOS::SetRights( aSiDirEntry.GetFull(), m_nUnixRights );

    GetLogfile().Success(bSuccess) << "chmod " << aSiDirEntry.GetFull()
        << " " << (long)m_nUnixRights << endl;
    #endif

	#ifdef OS2
	ItemIDPath aID( aSiDirEntry.GetFull(FSYS_STYLE_URL) );
	ItemIDPath aPar, aChild;
	if( aID.Split( aPar, aChild ) )
	{
		Folder aFolder( aPar );
		ItemIDPath aNewID;
		aFolder.RenameItem( aChild, aNewID, aSiDirEntry.GetName() );
		GetLogfile().Success(TRUE) << "write OS2-EA " <<
			aSiDirEntry.GetFull() << " ==> " << aSiDirEntry.GetName() << endl;
	}
	#endif

	return SetSuccess(bSuccess);
}

// TransferAction---------------------------------------------------------
//
SiTransferAction::SiTransferAction
(
	SiAgenda    *pAgenda,
	SiActionType eType,
	SiDataCarrier const* pDataCarrier,
	ByteString const& aSourcePath,
	ByteString const& aSourceFile,
	ByteString const& aDestPath,
	ByteString const& aDestFile,
	Date   const& aDate,
	Time   const& aTime,
	SiFileFlags   Flags,
	int           nUnixRights,
	SiOs2Creator const *pOs2Creator
)
: SiAction(pAgenda, eType)
{
	m_pDataCarrier   = pDataCarrier;
	m_aSourcePath    = aSourcePath;
	m_aSourceFile    = aSourceFile;
	m_aDestPath      = aDestPath;
	m_aDestFile      = aDestFile;
	m_aDate          = aDate;
	m_aTime          = aTime;
	m_Flags          = Flags;
	m_nUnixRights    = nUnixRights;
	m_pOs2Creator	 = pOs2Creator;
    m_bMoveAfterReboot = FALSE;
}

BOOL SiTransferAction::CheckTarget(SiEnvironment const& Env) const
{
	SiDirEntry aDest  = Env.GetDestPath();
			 aDest += m_aDestPath;
			 aDest += m_aDestFile;

	BOOL bExists = aDest.Exists();
	if( bExists && Env.GetInstallMode() == IM_PATCH )
	{
		ByteString aFolderName( "Backup_PP" );
		aFolderName += ByteString::CreateFromInt32(
				GetAgenda()->GetCScript()->GetInstallation()->GetPatchLevel() );

		SiDirEntry aBakFile( Env.GetDestPath() );
		aBakFile += aFolderName;
		if( !aBakFile.Exists() ) aBakFile.MakeDir();

		aBakFile += m_aDestPath;
		if( !aBakFile.Exists() ) aBakFile.MakeDir();

		aBakFile += m_aDestFile;

        // Don't overwrite existing backup files when called twice
        if ( !aBakFile.Exists() )
        {
            FileCopier aFileCopier( aDest, aBakFile );
            aFileCopier.Execute();
        }
	}

	return bExists;
}

int SiTransferAction::GetDiskNo() const
{
	return m_pDataCarrier == NULL ? 9999 : m_pDataCarrier->GetDiskNo();
}

void SiTransferAction::RenameFile( ByteString const& aFrom, ByteString const& aTo )
{
	#if defined(WNT)
	rename( aFrom.GetBuffer(), aTo.GetBuffer() );
	#elif defined(UNX)
	if( aFrom != aTo )
		rename( aFrom.GetBuffer(), aTo.GetBuffer() );
	#endif
}

void SiTransferAction::TouchVirtual( ByteString& rName )
{
	char cSysDelim = (char) SiDirEntry::GetAccessDelimiter().GetChar(0);
	if( rName.GetChar(rName.Len()-1) == '/' ||
		rName.GetChar(rName.Len()-1) == cSysDelim )
		return ;

	SiDirEntry aEntry(rName);
	aEntry.ToAbs();
	aEntry.GetPath().MakeDir();

	FILE* pNull = fopen( aEntry.GetFull().GetBuffer(), "w" );
	fclose( pNull );
}

void SiTransferAction::SetDateTime(ByteString const& aFile, BOOL bLog)
{
	USHORT nLen = aFile.Len();
#ifdef UNX
	if( aFile.GetChar(nLen-9) == 0x6C && aFile.GetChar(nLen-8) == 0x69 &&
		aFile.GetChar(nLen-7) == 0x62 && aFile.GetChar(nLen-6) == 0x74 &&
		aFile.GetChar(nLen-5) == 0x61 && aFile.GetChar(nLen-4) == 0x62 &&
		aFile.GetChar(nLen-3) == 0x2E && aFile.GetChar(nLen-2) == 0x73 &&
		aFile.GetChar(nLen-1) == 0x6F )
#else
	if( aFile.GetChar(nLen-7) == 0x74 && aFile.GetChar(nLen-6) == 0x61 &&
		aFile.GetChar(nLen-5) == 0x62 && aFile.GetChar(nLen-4) == 0x2E &&
		aFile.GetChar(nLen-3) == 0x64 && aFile.GetChar(nLen-2) == 0x6C &&
		aFile.GetChar(nLen-1) == 0x6C )
#endif
	{
		SvFileStream aSrcStrm( UniString(aFile, osl_getThreadTextEncoding()), STREAM_READ );
		aSrcStrm.Seek( STREAM_SEEK_TO_END );

		ULONG nSize = aSrcStrm.Tell();
    	aSrcStrm.Seek( 0L );

    	char *cBuf = new char[ nSize ];
    	ULONG nRead = aSrcStrm.Read( cBuf, nSize );
		aSrcStrm.Close();

		if( nRead == nSize )
    	{
			BOOL bb = FALSE;
			for( ULONG i = 0; i < nRead; i++ )
    		{
				if( cBuf[i]   == 0x70 && i < nSize - 6 &&
					cBuf[i+1] == 0x70 && cBuf[i+2] == 0x61 &&
					cBuf[i+3] == 0x72 && cBuf[i+4] == 0x4B &&
					cBuf[i+5] == 0x4f )
				{
					bb = TRUE;
					break;
				}
			}

			if( bb )
			{
		        TimeValue aTime;
				osl_getSystemTime( &aTime );

				aTime.Seconds += (3*30*86400);

				ULONG d = aTime.Seconds % 256;
				aTime.Seconds = (aTime.Seconds-d)/256;
    			ULONG c = aTime.Seconds % 256;
				aTime.Seconds = (aTime.Seconds-c)/256;
   		   		ULONG b = aTime.Seconds % 256;
				aTime.Seconds = (aTime.Seconds-b)/256;
   		   		ULONG a = aTime.Seconds;

				for( ULONG i = 0; i < nRead; i++ )
    			{
					if( cBuf[i]   == 0x4F && i < nSize - 12 &&
						cBuf[i+1] == 0x52 && cBuf[i+2] == 0x54 &&
						cBuf[i+3] == 0x52 && cBuf[i+4] == 0x54 &&
						cBuf[i+5] == 0x41 )
					{
						cBuf[i+6]  = (char)a;
						cBuf[i+8]  = (char)b;
						cBuf[i+10] = (char)c;
						cBuf[i+12] = (char)d;
						break;
					}
				}

				SiDirEntry aSrc( aFile );
				SiDirEntry aDest( aFile );
				aDest.SetExtension( UniString::CreateFromAscii("tmp") );

				SvFileStream aDstStrm( aDest.GetFullUni(), STREAM_WRITE | STREAM_TRUNC );
				aDstStrm.Write( cBuf, nRead );
			    aDstStrm.Close();

				aSrc.Kill();
				aDest.MoveTo( aSrc );
			}
    	}
       	delete [] cBuf;
	}

	if (m_aDate.GetYear() != 0)
	{
		if (bLog)
		{
			International anInt;
			GetLogfile() << SEP << ByteString(anInt.GetDate(m_aDate), osl_getThreadTextEncoding()) << SEP
						 << ByteString(anInt.GetTime(m_aTime), osl_getThreadTextEncoding());
		}
		SiDirEntry 	aEntry( aFile );
		BOOL 		bWasReadOnly = FALSE;

		if( FileStat::HasReadOnlyFlag() &&
			FileStat::GetReadOnlyFlag(aEntry) )
		{
			FileStat::SetReadOnlyFlag( aEntry, FALSE );
			bWasReadOnly = TRUE;
		}
		OS::SetDateTime(aFile, m_aDate, m_aTime);
		if( bWasReadOnly )
			FileStat::SetReadOnlyFlag( aEntry, TRUE );
	}
}

void SiTransferAction::SetUnixRights(ByteString const& aFile, BOOL bLog)
{
	if (m_nUnixRights != 0)
	{
		#ifdef UNX
		UnixOS::SetRights(aFile, m_nUnixRights);
		if (bLog)
			GetLogfile() << SEP << ByteString( m_nUnixRights );
		#else
		//! DBG_ERROR("cannot set rights on this platform");
		#endif
	}
}

void SiTransferAction::SetOs2Creator(ByteString const& aFile,
									 SiEnvironment const& rEnv, BOOL bLog)
{
	if( m_pOs2Creator )
	{
#ifdef OS2
		SiDirEntry anIconDir;

		if (GetInstallMode() == IM_WORKSTATION)
			anIconDir = rEnv.GetProgPath(GetInstallMode());
		else
			anIconDir = rEnv.GetWorkPath(GetInstallMode());

		anIconDir += m_pOs2Creator->GetIconDir()->GetName();
		anIconDir += m_pOs2Creator->GetIcon();

		ByteString anIcon = anIconDir.GetFull();
		BOOL bSuccess = Os2OS::SetFileTypeAndIcon(aFile,
						m_pOs2Creator->GetName(), anIcon);

		if( bLog )
		{
			GetLogfile().Success(bSuccess)
				<< "set os/2 creator: "
				<< aFile       				  << SEP
				<< m_pOs2Creator->GetName()   << SEP
				<< anIcon       			  << endl;
		}
#else
		DBG_ERROR("SiTransferAction::SetOs2Creator(...) wrong platform");
#endif
	}
}

BOOL SiTransferAction::DeregisterFont( const ByteString &rFilename,
                                       const SiDirEntry& rFile )
{
#if defined(WNT) || defined(WIN)
    if ( ! WinOS::DeregisterFont( rFilename ) )
    {
        SiDirEntry aNewDest( OS::GetSystemPath() );
                   aNewDest += m_aDestFile;

        if ( aNewDest.Exists() )
        {
            OS::MakeWritable( aNewDest.GetFull().GetBuffer() );
			aNewDest.Kill();
        }

        m_bMoveAfterReboot = TRUE;
        m_aMoveDestination = rFile.GetFull().GetBuffer();
        m_aMoveSource      = aNewDest.GetFull().GetBuffer();

        return FALSE;
    }
#else
	OS::MakeWritable( rFile.GetFull() );
	rFile.Kill();
#endif

    return TRUE;
}


void SiTransferAction::DoMigration( const ByteString& rFilename,
									const SiEnvironment& rEnv )
{
}

void SiTransferAction::Substitute( const ByteString& rFilename,
								   const SiEnvironment& rEnv )
{
	ULONG nLen = _SubstituteInFile( rFilename, rEnv );
	GetLogfile().Success(TRUE)
		<< "substitue: "
		<< rFilename
		<< " filesize (limit 32k): "
		<< nLen
		<< endl;
}

void SiTransferAction::MoveSystemFileAfterReboot( const ByteString& rSource, const ByteString& rDest )
{
#if defined(WNT) || defined(WIN)
	if( WinOS::GetOSVersion() == "W95" ||
		WinOS::GetOSVersion() == "W98" )
	{
		SiDirEntry aEntry(OS::GetGUIPath());
		aEntry += ByteString("wininit.ini");

		Config aWinInit( aEntry.GetFullUni() );
		aWinInit.SetGroup( "rename" );
		aWinInit.WriteKey( rDest, rSource );
	}
	else
		MoveFileEx( rSource.GetBuffer(), rDest.GetBuffer(), MOVEFILE_DELAY_UNTIL_REBOOT | MOVEFILE_REPLACE_EXISTING );

	GetLogfile().Success(TRUE)
		<< "move file after boot: "
		<< rSource
		<< " ==> "
		<< rDest
		<< endl;
#endif
}

BOOL SiTransferAction::SpecialFontHandling( SiEnvironment& Env,
                                            SiFile *pFile )
{
    BOOL bRet = FALSE;
#ifdef WNT
    // When a font couldn't be copied, we will try to copy it into the
    // <destdir>\share\fonts\truetype folder assuming that we could not
    // copy the font into the windows font folder

    ByteString aNewDest( LOCAL_FONT_PATH );
    aNewDest.Erase( 0, 1 );

    if ( m_aDestPath != aNewDest )
    {
        static BOOL bMadeDir = FALSE;

        if ( !bMadeDir )
        {
            ByteString aDir( Env.GetDestPath() );
            aDir += LOCAL_FONT_PATH;
            SiMakeDirAction aFontDir( GetAgenda(), aDir );
            aFontDir.Execute( Env );
            bMadeDir = TRUE;
        }
        m_aDestPath = aNewDest;
        pFile->SetFontFlag( FALSE );
        bRet = Execute( Env );
        pFile->SetFontFlag( TRUE );
    }
#endif
    return bRet;
}

// CopyAction ------------------------------------------------------------
//
SiCopyAction::SiCopyAction
(
	SiAgenda    * pAgenda,
	SiDataCarrier
		   const* pDataCarrier,
	ByteString const& aSourcePath,
	ByteString const& aSourceFile,
	ByteString const& aDestPath,
	ByteString const& aDestFile,
	Date   const& aDate,
	Time   const& aTime,
	SiFileFlags   Flags,
	int           nUnixRights,
	SiFile* 	  pFile,
	SiOs2Creator const* pOs2Creator
)
: SiTransferAction (pAgenda, AT_COPY, pDataCarrier, aSourcePath, aSourceFile,
	 aDestPath, aDestFile, aDate, aTime, Flags, nUnixRights, pOs2Creator)
{
	m_pFile = pFile;
}

BOOL SiCopyAction::Execute(SiEnvironment& Env)
{
    BOOL bTargetExists = CheckTarget(Env);

	if (m_Flags.bDontOverwrite
	&&  bTargetExists)
		return TRUE;

	if (m_Flags.bOverwriteOnly
	&& !bTargetExists)
		return TRUE;

	SiDirEntry aBigModeTemp;
	if( !m_Flags.bSetupZip && Env.IsBigMode() )
	{
		aBigModeTemp = Env.GetStartPath();
		aBigModeTemp += m_aSourceFile;

		if( !Env.GetArchive() )
			GetAgenda()->GetCallback()->RequestBigFile( m_pDataCarrier->GetName() );

		BOOL bSucc = Env.GetArchive()->GetFile( m_aSourceFile.GetBuffer(), Env.GetStartPath().GetBuffer() );
		if( !bSucc )
			return TRUE;
	}
	else if( !m_Flags.bSetupZip && !GetAgenda()->RequestDisk(m_aSourceFile,
			 m_pFile? m_pFile->IsNoWarning() : FALSE,
			 m_pDataCarrier->GetDiskNo(), m_pDataCarrier->GetName()) )
		{
			GetLogfile().Success(FALSE) << "source file not found: " << m_aSourceFile << endl;
			return TRUE; // Keine Quelle (weil Abbruch), aber auch kein Fehler beim Kopieren
		}

	SiDirEntry    aSource;
	if( !GetAgenda()->InstallFromNet() && (m_Flags.bSetupZip || Env.IsBigMode()) )
		aSource = Env.GetStartPath();
	else
		aSource = Env.GetSourcePath();

				aSource     += m_aSourcePath;
				aSource     += m_aSourceFile;
	ByteString  aSourceStr   = aSource.GetFull();

	SiDirEntry  aDest        = Env.GetDestPath();
				aDest       += m_aDestPath;
				aDest       += m_aDestFile;
	ByteString  aDestStr     = aDest.GetFull();

	if( m_Flags.bCheckVersion )
	{
		#if defined WIN || defined WNT
			SiDirEntry aDestFile  = aDest;
					 aDestFile += m_aDestFile;

			if( !WinOS::IsSourceFileNewerVersion(aSourceStr,FALSE/*PACKED*/,aDestStr) )
				return TRUE; // nicht ueberschreiben
		#else
			DBG_ERROR("SiCopyAction::Execute() cannot check version");
		#endif
	}

    if (aDest.Exists())
	{
        if ( Env.InstallFromNet() && ( Env.GetInstallMode() == IM_STANDALONE ) )
        {
            SortedIgnoreList *pIgnoreList = GetIgnoreList( Env );
            ByteString aName = aSource.GetName();

            if ( pIgnoreList && pIgnoreList->Seek_Entry( &aName ) )
                return TRUE;
        }

		if( GetAgenda()->GetCallback()->OverwriteFile(aDest.GetFull(), m_pFile) )
		{
			if( m_pFile && m_pFile->IsFont() )
            {
                if ( ! DeregisterFont( m_pFile->GetName(), aDest ) )
                {
                    aDestStr = GetMoveSource();
                    aDest  = SiDirEntry( aDestStr );
                }
            }
            else
			{
				OS::MakeWritable( aDestStr );
				aDest.Kill();
			}
		}
		else
		{
			GetAgenda()->AddCanceledFileSize( m_pFile, FALSE );
			return TRUE;
		}
	}

	FSysError anError = 0;
	if( Env.IsVirtualMode() )
	{
		ByteString aTemp( aDest.GetFull() );
		TouchVirtual( aTemp );
		GetAgenda()->AddCanceledFileSize( m_pFile, FALSE );
	}
	else
	{
		FileCopier aFileCopier( aSource, aDest );
		aFileCopier.SetProgressHdl( LINK(GetAgenda(),SiAgenda,CopyProgressHdl) );
		anError = aFileCopier.Execute();

        if ( anError && Env.InstallFromNet() && ( Env.GetInstallMode() == IM_STANDALONE ) )
        {
            SortedIgnoreList *pIgnoreList = GetIgnoreList( Env );
            ByteString aName = aSource.GetName();

            if ( pIgnoreList && pIgnoreList->Seek_Entry( &aName ) )
                return TRUE;
        }
	}

#ifdef WNT
    if ( anError && m_pFile->IsFont() )
        return SpecialFontHandling( Env, m_pFile );
    else
#endif

#ifdef OS2
	if( anError )
	{
		BOOL bErr = Os2OS::ReplaceModule( aDestStr.GetBuffer(), aSourceStr.GetBuffer() );
		anError = bErr ? 1 : 0;

		GetLogfile().Success(anError)
			<< "OS2 DosReplaceModule "
			<< aSourceStr << SEP
			<< aDestStr;
	}
	else
#endif
	{
		GetLogfile().Success(anError==0)
			<< "copy  "
			<< aSourceStr << SEP
			<< aDestStr;
	}

	if( m_Flags.bDoMigration )
		DoMigration( aDestStr, Env );

	if( m_Flags.bSubstitute )
		Substitute( aDestStr, Env );

#ifdef WNT
    if ( m_Flags.bPatchSOName )
        WinOS::PatchProductName( SiDirEntry( aDestStr ), Env.GetProductName() );
#endif

	// Datei stempeln und unter Unix evtl. Rechte setzen
	if( m_pFile && !m_pFile->IsNoTimeStamp() ) SetDateTime(aDestStr);
	SetUnixRights(aDestStr);
	SetOs2Creator(aDestStr, Env);

	// UnoComponent
	if( m_pFile && m_pFile->IsUnoComponent() )
		GetAgenda()->AddUnoComponent( m_pFile );

	if( Env.IsBigMode() )
		aBigModeTemp.Kill();

    if ( MoveFileAfterReboot() )
        MoveSystemFileAfterReboot( GetMoveSource(), GetMoveDestination() );

    GetLogfile() << SEP << "FSysError = " << ByteString::CreateFromInt32(anError) << endl;

	return SetSuccess(anError == 0);
}

// UnzipAction ------------------------------------------------------------
//
SiUnzipAction::SiUnzipAction
(
	SiAgenda    * pAgenda,
	SiDataCarrier
		   const* pDataCarrier,
	ByteString const& aArchiveFile,
	ByteString const& aSourcePath,
	ByteString const& aSourceFile,
	ByteString const& aDestPath,
	ByteString const& aDestFile,
	Date   const& aDate,
	Time   const& aTime,
	SiFileFlags   Flags,
	int           nUnixRights,
	SiFile      * pFile,
	SiOs2Creator const* pOs2Creator
)
: SiTransferAction(pAgenda, AT_UNZIP, pDataCarrier, aSourcePath, aSourceFile,
			aDestPath, aDestFile, aDate, aTime, Flags, nUnixRights, pOs2Creator)
{
	m_aArchiveFile	= aArchiveFile;
	m_pFile			= pFile;
}

BOOL SiUnzipAction::CheckTarget(SiEnvironment const& Env) const
{
	if (m_Flags.bArchive) // viele Zieldateien
	{
		SiDirEntry aDestPath  = Env.GetDestPath();
				 aDestPath += m_aDestPath;

		SiSubfileList const& sfList = m_pFile->GetSubfileList();

		for (USHORT i=0; i<sfList.Count(); i++)
		{
			SiDirEntry aFile  = aDestPath;
					 aFile += sfList.GetObject(i)->aFilename;

			if (!aFile.Exists())
				return FALSE; // min. eine Datei fehlt
		}

		return TRUE; // alles vorhanden
	}
	else // eine Zieldatei
		return SiTransferAction::CheckTarget(Env);
}

BOOL SiUnzipAction::Execute(SiEnvironment& Env)
{
	SiDirEntry aBigModeTemp;
	if( Env.IsBigMode() )
	{
		aBigModeTemp = Env.GetStartPath();
		aBigModeTemp += m_aSourceFile;

		if( !Env.GetArchive() )
			GetAgenda()->GetCallback()->RequestBigFile( m_pDataCarrier->GetName() );

		BOOL bSucc = Env.GetArchive()->GetFile( m_aSourceFile.GetBuffer(), Env.GetStartPath().GetBuffer() );
		if( !bSucc )
			return TRUE;
	}
	else
	{
		if( m_pDataCarrier != NULL &&
			!GetAgenda()->RequestDisk( m_aArchiveFile.Len() != 0 ? m_aArchiveFile : m_aSourceFile,
			m_pFile? m_pFile->IsNoWarning() : FALSE,
			m_pDataCarrier->GetDiskNo(), m_pDataCarrier->GetName()) )
		{
			GetLogfile().Success(FALSE) << "source file not found: " << (m_aArchiveFile.Len()!=0? m_aArchiveFile :
										m_aSourceFile) << endl;
			return TRUE;
		}
	}

	SiDirEntry aSource;
	if (m_pDataCarrier != NULL)
	{
		// Entpacken vom Datentraeger
		if( Env.IsBigMode() )
			aSource  = Env.GetStartPath();
		else
			aSource  = Env.GetSourcePath();

		aSource += m_aSourcePath;

		// Eine Datei aus einem Archiv extrahieren
		if (m_aArchiveFile.Len() != 0)
			aSource += m_aArchiveFile;
	}
	else
	{
		// Entpacken im Zielverzeichnis
		aSource  = Env.GetDestPath();
		aSource += m_aDestPath;
	}

	if (m_aArchiveFile.Len() == 0)
		aSource += m_aSourceFile;

	ByteString aSourceStr = aSource.GetFull();

	SiDirEntry aDest      = Env.GetDestPath();
			   aDest     += m_aDestPath;
	ByteString aDestStr   = aDest.GetFull();

	if (m_Flags.bCheckVersion)
	{
		#if defined WIN || defined WNT
			SiDirEntry aDestFile  = aDest;
					 aDestFile += m_aDestFile;

			if (!WinOS::IsSourceFileNewerVersion(aSourceStr,TRUE/*PACKED*/,aDestFile.GetFull()))
			{
				if( Env.IsBigMode() )
					aBigModeTemp.Kill();
				return TRUE; // nicht ueberschreiben
			}
		#else
			DBG_ERROR("SiUnzipAction::Execute() cannot check version");
		#endif
	}

	// ins Zielverzeichnis wechseln
	BOOL bCWD = aDest.SetCWD();

	GetLogfile().Success(bCWD)
		<< "cd    "
		<< aDestStr
		<< endl;

	// wenn es um ein Archive geht muss die SubFileListe aufbaut werden und
	// event. alle Dateien schreibbar machen.
	if( m_Flags.bArchive )
	{
		ByteString aPattern;
		SiDirEntry aTemp;

		if (m_aArchiveFile.Len() != 0)
		{
			aTemp = SiDirEntry(m_aSourceFile) + SiDirEntry(OS::GetAllFilesWildCard());
			aPattern = aTemp.GetFull();
		}

		SiZipFile aZipFile;
		BOOL bSuccess = aZipFile.AddSubfileListTo( aSourceStr, m_pFile, aPattern.GetBuffer() );
	}

	BOOL bIsSpecialWNTSystemFile = FALSE;
	BOOL bTargetExists = CheckTarget(Env);

	if( m_Flags.bDontOverwrite &&  bTargetExists )
		return TRUE;

	if( m_Flags.bOverwriteOnly && !bTargetExists )
		return TRUE;

	BOOL bDoDontOverwriteUnzip = FALSE;
	BOOL bExplicitArchiveUnzip = FALSE;
	// wenn es Datei schon gibt, diese zuerst schreibbar machen.
	if( !m_Flags.bArchive  )
	{
		SiDirEntry aDestFile  = aDest;
				   aDestFile += m_aDestFile;

		#ifdef WNT
		if( m_aDestFile.CompareIgnoreCaseToAscii("trayhook.dll") == COMPARE_EQUAL ||
			m_aDestFile.CompareIgnoreCaseToAscii("sointgr.exe") == COMPARE_EQUAL )
			bIsSpecialWNTSystemFile = TRUE;
		#endif

		if( aDestFile.Exists() && !bIsSpecialWNTSystemFile )
		{
			if( GetAgenda()->GetCallback()->OverwriteFile(aDestFile.GetFull(), m_pFile) )
			{
			    if( m_pFile && m_pFile->IsFont() )
                {
                    if ( ! DeregisterFont( m_pFile->GetName(), aDestFile ) )
                    {
                        // when the font file couldn't be deregistered and removed,
                        // we will copy it into the system directory and move it with the next
                        // reboot into the font directory
                        aDest = SiDirEntry( GetMoveSource() );
                        aDest.CutName();
                        aDestStr = aDest.GetFull().GetBuffer();
                        bCWD = aDest.SetCWD();
                       	GetLogfile().Success(bCWD)
                            << "cd    "
                            << aDestStr
                            << endl;
                    }
                }
                else
                {
				    OS::MakeWritable(aDestFile.GetFull());
				    aDestFile.Kill();
                }
			}
			else
			{
				GetAgenda()->AddCanceledFileSize( m_pFile );
				return TRUE;
			}
		}
	}
	else
	{
		for( USHORT i=0; i < m_pFile->GetSubfileList().Count(); i++ )
		{
			SiDirEntry aFile( aDest );
			aFile += m_pFile->GetSubfileList().GetObject(i)->aFilename;
			if( aFile.Exists() )
			{
				bExplicitArchiveUnzip = TRUE;
				if( ( ! m_pFile->Overwrite() ) && 
                    ( Env.IsUpdateOldVersion() || Env.IsUpgradeOldVersion() ) )
					bDoDontOverwriteUnzip = TRUE;
				break;
			}
		}
	}

	SiZipFile	aZipFile;
	ByteString	aExtractName;
	int			anError = 0;
	aZipFile.SetProgressHdl(LINK(GetAgenda(),SiAgenda,UnzipProgressHdl));

	if( bExplicitArchiveUnzip )
	{
		for( USHORT i=0; i < m_pFile->GetSubfileList().Count(); i++ )
		{
			SiSubfile* pSubFile = m_pFile->GetSubfileList().GetObject(i);
			if( !pSubFile )
				continue;

			SiDirEntry aFile( aDest );
			aFile += pSubFile->aFilename;

			BOOL bDoUnzip = TRUE;
			FileStat aFileStat(aFile);
			if( aFile.Exists() && aFileStat.GetKind() == FSYS_KIND_FILE )
			{
				if ( bDoDontOverwriteUnzip )
                {
					bDoUnzip = FALSE;
					GetLogfile().Success(anError==0) << "unzip (should not overwrite) " << aFile.GetFull() << endl;
                }
                else if( ! GetAgenda()->GetCallback()->OverwriteFile(aFile.GetFull(), m_pFile) )
				{
					bDoUnzip = FALSE;
					GetAgenda()->AddCanceledFileSize( (ULONG)pSubFile->nSize, TRUE );
					GetLogfile().Success(anError==0) << "unzip (cancel by user) " << aFile.GetFull() << endl;
				}
				else
				{
			        if( m_pFile && m_pFile->IsFont() )
                    {
                        if ( ! DeregisterFont( m_pFile->GetName(), aFile ) )
                        {
                            DBG_ERRORFILE( "SiUnzipAction::Execute(): Can't handle font files in archives" );
                        }
                    }
                    else
                    {
					    OS::MakeWritable(aFile.GetFull());
					    aFile.Kill();
                    }
				}
			}

			if( bDoUnzip )
			{
				anError = 0;
				if( Env.IsVirtualMode() )
				{
					TouchVirtual( pSubFile->aFilename );
					GetAgenda()->AddCanceledFileSize( (ULONG)pSubFile->nSize, TRUE );
				}
				else
					anError = aZipFile.Unzip( aSourceStr, pSubFile->aFilename, bDoDontOverwriteUnzip );

				GetLogfile().Success(anError==0) << "unzip (explicit) " << aSourceStr << SEP << aFile.GetFull() << endl;
			}
		}
	}
	else if( m_aArchiveFile.Len() != 0 )
	{
		SiDirEntry aTmp( m_aSourceFile );
		aTmp += ByteString( OS::GetAllFilesWildCard() );
		aExtractName = aTmp.GetFull();
	}
	else
	{
		if( m_pFile->IsSetupZip() && Env.GetInstallType() == IT_CHANGE )
			aExtractName = m_aDestFile;
		else
			aExtractName = OS::GetAllFilesWildCard();
	}

	if( Env.IsVirtualMode() )
	{
		if( m_pFile->IsArchive() )
		{
			for( USHORT i = 0; i < m_pFile->GetSubfileList().Count(); i++ )
			{
				SiSubfile* pSubFile = m_pFile->GetSubfileList().GetObject(i);
				TouchVirtual( pSubFile->aFilename );
			}
		}
		else
		{
			ByteString aTemp( m_pFile->GetName() );
			TouchVirtual( aTemp );
		}
		GetAgenda()->AddCanceledFileSize( m_pFile, TRUE );
	}
	else
		anError = aZipFile.Unzip( aSourceStr, aExtractName, bDoDontOverwriteUnzip );

#ifdef OS2
	/*************************
	 *		Fehler OS2
	 *************************/
	if( !m_Flags.bArchive && anError != 0 )
	{
		SiDirEntry aCurDir( "." );
		aCurDir.ToAbs();

		SiDirEntry aFooWPS( SiDirEntry("fo*") );
		SiDirEntry aTmpWPS( aFooWPS.TempName().GetPath() );
		aTmpWPS.ToAbs();
		BOOL bSuccCWD = aTmpWPS.SetCWD();

		if( bSuccCWD )
		{
			anError = aZipFile.Unzip(aSourceStr, OS::GetAllFilesWildCard() );
			aCurDir.SetCWD();

			SiDirEntry aSrcWPS( aTmpWPS.GetFull() );
			aSrcWPS += m_aDestFile;
			aSrcWPS.ToAbs();

			SiDirEntry aDestWPS( aDestStr );
			aDestWPS += m_aDestFile;
			aDestWPS.ToAbs();

			BOOL bErr = Os2OS::ReplaceModule( aDestWPS.GetFull(), aSrcWPS.GetFull() );
			aSrcWPS.Kill();

			GetLogfile().Success(bErr) << "OS2 DosReplaceModule " << aDestWPS.GetFull() << SEP << aSrcWPS.GetFull() << endl;
		}
	}
	else
#elif WNT
	/*************************
	 *		Fehler WNT
	 *************************/
	if( bIsSpecialWNTSystemFile &&
		anError != 0  )
	{
		SiDirEntry aCurDir( "." );
		aCurDir.ToAbs();

		SiDirEntry aFoo( SiDirEntry("fo*") );
		SiDirEntry aTmp( aFoo.TempName().GetPath() );
		aTmp.ToAbs();
		BOOL bSuccCWD = aTmp.SetCWD();

		if( bSuccCWD )
		{
			anError = aZipFile.Unzip( aSourceStr, OS::GetAllFilesWildCard() );
			aCurDir.SetCWD();

			aTmp += m_aDestFile;

			SiDirEntry _Destination( aDestStr );
			_Destination += m_aDestFile;

			SiDirEntry _TempDestination( _Destination );
			_TempDestination.SetExtension( UniString::CreateFromAscii("~") );

			FileCopier aFileCopier( aTmp, _TempDestination );
			aFileCopier.Execute();

			MoveSystemFileAfterReboot( _TempDestination.GetFull(), _Destination.GetFull() );
			if( m_pFile && !m_pFile->IsNoTimeStamp() ) SetDateTime( _TempDestination.GetFull() );
			Env.SetReboot(TRUE);

			aTmp.Kill();
		}
		anError = 0;
	}
    else if ( anError && m_pFile->IsFont() )
    {
        return SpecialFontHandling( Env, m_pFile );
    }
	else
#endif
	{
		GetLogfile().Success(anError==0) << "unzip " << aSourceStr << SEP << aDestStr;
	}

	// (optional) Datei stempeln und unter Unix evtl. Rechte setzen
	if (!m_Flags.bArchive)
	{
		ByteString aLower( m_aDestFile );
        SiDirEntry aFrom(aDest);
		SiDirEntry aTo(aDest);
		aFrom   += aLower.ToLowerAscii();
		aTo     += m_aDestFile;
		RenameFile( aFrom.GetFull(), aTo.GetFull() );	// Grosskleinschreibung unter W32 und UNX

		aDestStr = aTo.GetFull();

		if( m_Flags.bDoMigration )
			DoMigration( aDestStr, Env );
		if( m_Flags.bSubstitute )
			Substitute( aDestStr, Env );

#ifdef WNT
        if ( m_Flags.bPatchSOName )
            WinOS::PatchProductName( SiDirEntry( aDestStr ), Env.GetProductName() );
#endif

		if( m_pFile && !m_pFile->IsNoTimeStamp() ) SetDateTime(aDestStr);
		SetUnixRights(aDestStr);
		SetOs2Creator(aDestStr, Env);
	}
	else    // We have an archive and have to touch some files
	{       // but not if we did not overwrite some files
        for (USHORT i=0; i<m_pFile->GetSubfileList().Count(); i++)
        {
            SiDirEntry aFile  = aDest;
                       aFile += m_pFile->GetSubfileList().GetObject(i)->aFilename;
            ByteString aFileStr = aFile.GetFull();

#ifdef UNX
            // Verzeichnisse duerfenn unter UNX nicht das
            // Recht gesetzt bekommen!
            FileStat aStat( aFile );
            if( aStat.GetKind() != FSYS_KIND_DIR )
                SetUnixRights(aFileStr,i==0);
#endif

            if( !bDoDontOverwriteUnzip && m_Flags.bDoMigration )
                DoMigration( aFileStr, Env );

            if( m_Flags.bSubstitute )
                Substitute( aFileStr, Env );
#ifdef WNT
            if ( !bDoDontOverwriteUnzip && m_Flags.bPatchSOName )
                WinOS::PatchProductName( SiDirEntry( aFileStr ), Env.GetProductName() );
#endif
            if ( !bDoDontOverwriteUnzip )
            {
                if( m_pFile && !m_pFile->IsNoTimeStamp() )
                    SetDateTime(aFileStr, i==0 );
                SetOs2Creator(aFileStr, Env,i==0);
            }
        }
    }

	// UnoComponent
	if( m_pFile && m_pFile->IsUnoComponent() )
		GetAgenda()->AddUnoComponent( m_pFile );

	if( Env.IsBigMode() )
		aBigModeTemp.Kill();

    if ( MoveFileAfterReboot() )
        MoveSystemFileAfterReboot( GetMoveSource(), GetMoveDestination() );

	if( anError != 0 )
		GetLogfile() << " Error = " << ByteString::CreateFromInt32(anError);

	GetLogfile() << endl;

	return SetSuccess(anError == 0 && bCWD);
}

// AppendAction ------------------------------------------------
//
SiAppendAction::SiAppendAction
(
	SiAgenda    * pAgenda,
	ByteString const& aSourcePath,
	ByteString const& aSourceFile,
	ByteString const& aDestPath,
	ByteString const& aDestFile,
	SiFile const* pBaseFile,
	int           nPart
)
: SiAction(pAgenda)
{
	m_aSourcePath  = aSourcePath;
	m_aSourceFile  = aSourceFile;
	m_aDestPath    = aDestPath;
	m_aDestFile    = aDestFile;

	m_pBaseFile    = pBaseFile; // zum Sortieren
	m_nPart        = nPart;
}

BOOL SiAppendAction::Execute(SiEnvironment& Env)
{
	SiDirEntry aAbsPath1 = SiDirEntry(Env.GetDestPath()) + SiDirEntry(m_aSourcePath);
	SiDirEntry aAbsPath2 = SiDirEntry(Env.GetDestPath()) + SiDirEntry(m_aDestPath);
	SiDirEntry aTempSrc  = aAbsPath1 + SiDirEntry(m_aSourceFile);
	SiDirEntry aTempDest = aAbsPath2 + SiDirEntry(m_aDestFile);
	ByteString   aSource   = aTempSrc.GetFull();
	ByteString   aDest     = aTempDest.GetFull();
	SiDirEntry aDestDir  = aDest;

	// Ausfuehrung wird ueber Abhaengigkeiten geregelt
	//
	// if (DoRecoverOnly()
	// &&  aDestDir.Exists()) // Zielabfrage macht bei Append keinen Sinn
	//     return TRUE;

	SvFileStream  aReadStream;
	SvFileStream  aWriteStream;

	aReadStream.Open( UniString::CreateFromAscii(aSource.GetBuffer()), STREAM_STD_READ);
	aWriteStream.Open( UniString::CreateFromAscii(aDest.GetBuffer()), STREAM_STD_WRITE);

	// Pruefen, ob Dateien offen sind und Zieldatei
	// ueberschreibbar ist
	//
	if (!aWriteStream.IsOpen())
	{
		GetLogfile()
			.Success(FALSE)
			<< "append " << aSource << SEP << aDest
			<< " Error(cannot open for writing)" << endl;
		return SetSuccess(FALSE);
	}

	if (!aWriteStream.IsWritable())
	{
		GetLogfile()
			.Success(FALSE)
			<< "append " << aSource << SEP << aDest
			<< " Error(file is write protected)" << endl;
		return SetSuccess(FALSE);
	}

	if (!aReadStream.IsOpen())
	{
		GetLogfile()
			.Success(FALSE)
			<< "append " << aSource << SEP << aDest
			<< " Error(cannot open for reading)" << endl;
		return SetSuccess(FALSE);
	}

	// Beide Dateien konnten geoeffnet werden.
	// Jetzt Daten anhaengen
	//
	aWriteStream.Seek(STREAM_SEEK_TO_END);              // Append
	ULONG lToDo = aReadStream.Seek(STREAM_SEEK_TO_END); // Laenge ermitteln
	aReadStream.Seek(STREAM_SEEK_TO_BEGIN);

	while (lToDo > 0
	   &&  aReadStream.GetError() == 0
	   &&  aWriteStream.GetError() == 0)
	{
		char Buffer[100];
		ULONG nTransfer = Min((ULONG)sizeof(Buffer),lToDo);
		aReadStream.Read(Buffer,nTransfer);
		aWriteStream.Write(Buffer,nTransfer);
		lToDo -= nTransfer;
	}

	GetLogfile()
		.Success(aReadStream.GetError()==0 && aWriteStream.GetError()==0)
		<< "append " << aSource << SEP << aDest;

	// Ausgabe eines evtl Fehlercodes
	//
	if (aReadStream.GetError() != 0)
	{
		GetLogfile() << " read error " << aReadStream.GetError() << endl;
		return SetSuccess(FALSE);
	}

	if (aWriteStream.GetError() != 0)
	{
		GetLogfile() << " write error " << aWriteStream.GetError() << endl;
		return SetSuccess(FALSE);
	}

	GetLogfile() << endl;
	return SetSuccess(TRUE);
}

// SiActiveXAction --------------------------------------------------
//
SiActiveXAction::SiActiveXAction( SiAgenda* pAgenda, SiFile* pFile, BOOL bRegister ) :
	SiAction( pAgenda, AT_ACTIVEX )
{
	m_pFile = pFile;
	m_bRegister = bRegister;
}

BOOL SiActiveXAction::Execute(SiEnvironment& rEnv)
{
#ifdef WNT
	SiDirEntry aLibFile;

	aLibFile = rEnv.GetDestPath();
	aLibFile += GetAgenda()->GetDestDir(m_pFile);
	aLibFile += m_pFile->GetName();

	WinOS::registerActiveX( aLibFile.GetFull(), m_bRegister );

#endif
	return TRUE;
}

// InstallFontAction ------------------------------------------------
//
SiInstallFontAction::SiInstallFontAction
(
	SiAgenda       * pAgenda,
	ByteString  const& aFontName,
	ByteString  const& aFontFile  // ohne Pfad
)
: SiAction(pAgenda, AT_REGISTER)
{
	m_aFontName = aFontName;
	m_aFontFile = aFontFile;
}

BOOL SiInstallFontAction::CheckTarget(SiEnvironment const&) const
{
	return OS::IsFontInstalled(m_aFontFile,m_aFontName);
}

BOOL SiInstallFontAction::Execute(SiEnvironment&)
// pre/post:  siehe OS::InstallFont()
{
	BOOL bSuccess = OS::InstallFont(m_aFontFile,m_aFontName);

	#ifdef MAC
	GetAgenda()->ForceRestart();
	#endif

	GetLogfile()
		.Success(bSuccess)
		<< "install font " << m_aFontName << SEP
		<< m_aFontFile     << endl;

	return SetSuccess(bSuccess);
}

// ProfileItemAction ------------------------------------------------
//
SiProfileItemAction::SiProfileItemAction
(
	SiAgenda           * pAgenda,
	PIA                  ePIA,
	SiProfile     const* pProfile,
	ByteString    const& aSection,
	ByteString    const& aKey,
	ByteString    const& aValue,
	ByteString    const& aWorkstationValue,
	ByteString    const& aStandaloneValue,
	int 				 nOrder,
	BOOL    			 bInstInf,
    BOOL                 bDontOverwrite,
	SiProfileItem      * pItem
)
: SiAction(pAgenda, ePIA == PIA_CREATE ? AT_REGISTER : AT_UNREGISTER)
{
	m_pProfile			= (SiProfile*)pProfile;
	m_pProfileItem		= pItem;
	m_ePIA				= ePIA;
	m_aSection			= aSection;
	m_aKey				= aKey;
	m_aValue			= aValue;
	m_aWorkstationValue = aWorkstationValue;
	m_aStandaloneValue  = aStandaloneValue;
	m_nOrder   			= nOrder;
	m_bInstallInfo		= bInstInf;
    m_bDontOverwrite    = bDontOverwrite;
}

BOOL SiProfileItemAction::Execute(SiEnvironment& rEnv)
{
	SiDirEntry aFile = SiDirEntry(rEnv.GetDestPath())
		   + SiDirEntry(m_pProfile->GetDirectory()->GetName())
		   + SiDirEntry(m_pProfile->GetName());

	// InstallInfoItem nicht bei Netinstallation, AppServer und AppServerClient
	// schreiben.
	if( m_bInstallInfo )
		if( (GetInstallMode() == IM_NETWORK) || rEnv.IsAutoWorkstation() ||
            (GetInstallMode() == IM_PATCH) )
			return TRUE;

	Config* pConfig = GetAgenda()->GetOpenProfile( aFile.GetFull() );
	pConfig->SetGroup(m_aSection);

	switch (m_ePIA)
	{
		case PIA_CREATE:
		{
//          We will always write the ini file keys now (#91312#)
/*			if ( DoRecoverOnly() )
			&&  pConfig->ReadKey(m_aKey,"__empty__") != "__empty__")
				return TRUE;
*/
			ByteString aActValue;
			BOOL bUseWrkValue = FALSE;
            BOOL bUseStandalone = FALSE;

            if( GetInstallMode() == IM_WORKSTATION && m_aWorkstationValue.Len() )
			{
				bUseWrkValue = TRUE;
				aActValue = m_aWorkstationValue;
			}
            else if( GetInstallMode() == IM_STANDALONE && m_aStandaloneValue.Len() )
            {
				bUseStandalone = TRUE;
				aActValue = m_aStandaloneValue;
            }
			else
				aActValue = m_aValue;

			// Templatefelder im Value ersetzen
			BOOL	bOpenSubs = FALSE;
			BOOL 	bSubst = FALSE;
			USHORT	nBeginTpl = aActValue.Search('<');

			while( nBeginTpl != STRING_NOTFOUND )
			{
				USHORT nNested = 0;
				USHORT nEndTpl = STRING_NOTFOUND;
				for( USHORT i = nBeginTpl + 1; i <= aActValue.Len(); ++i )
				{
					if( aActValue.GetChar(i) == '<' )
						nNested++;
					if( aActValue.GetChar(i) == '>' )
						if( nNested )
							nNested--;
						else
						{
							nEndTpl = i;
							break;
						}
				}

				if( nEndTpl != STRING_NOTFOUND )
				{
					ByteString aTpl = aActValue.Copy( nBeginTpl, nEndTpl-nBeginTpl+1 );

					if( (rEnv.IsUpdateOldVersion() || rEnv.IsUpgradeOldVersion()) &&
					   (aTpl.CompareIgnoreCaseToAscii("<useraddress>") == COMPARE_EQUAL ||
						aTpl.CompareIgnoreCaseToAscii("<userfirstname>") == COMPARE_EQUAL ||
						aTpl.CompareIgnoreCaseToAscii("<username>") == COMPARE_EQUAL ||
						aTpl.CompareIgnoreCaseToAscii("<userid>") == COMPARE_EQUAL ||
						aTpl.CompareIgnoreCaseToAscii("<customernr>") == COMPARE_EQUAL) )
						return TRUE;

					QueryTemplateResult aResult = GetAgenda()->QueryTemplateValue(aTpl);
					aActValue.SearchAndReplace( aTpl, aResult.sValue );
					bSubst = TRUE;
				}
				nBeginTpl = aActValue.Search( '<', nBeginTpl+1 ); // weitersuchen
			}
			if( bSubst && aActValue.Len() )
            {
                if ( bUseWrkValue )
				    m_pProfileItem->SetProperty( PROPERTY_WORKSTATIONVALUE, aActValue );
                else if ( bUseStandalone )
				    m_pProfileItem->SetProperty( PROPERTY_STANDALONEVALUE, aActValue );
                else
				    m_pProfileItem->SetProperty( PROPERTY_VALUE, aActValue );
            }

            if ( m_bDontOverwrite )
            {
                ByteString aOldVal;
                aOldVal = pConfig->ReadKey( m_aKey, aOldVal );
                if ( aOldVal.Len() )
                {
                    aOldVal += ',';
                    aActValue = aOldVal + aActValue;
                }
            }
            // Eintrag setzen
			pConfig->WriteKey( m_aKey, aActValue );

			#ifdef UNX
			UnixOS::SetRights(aFile.GetFull(), m_pProfile->GetUnixRights());
			#endif

			GetLogfile().Success(TRUE)
				<< "set profile item: " << ByteString(pConfig->GetPathName(), osl_getThreadTextEncoding()) << SEP
				<< m_aSection << SEP << m_aKey  << SEP << aActValue << endl;
			break;
		}

		case PIA_REMOVE:
			if (aFile.Exists())     // damit keine 0-byte Datei erzeugt wird
				pConfig->DeleteKey(m_aKey);
			GetLogfile()
				.Success(TRUE)
				<< "remove profile item: " << ByteString(pConfig->GetPathName(), osl_getThreadTextEncoding()) << SEP
			<< m_aSection << SEP << m_aKey << endl;
			break;

		default:
			DBG_ERROR("ProfileItemAction::Execute(): unknown action");
			return FALSE;
	}

	return SetSuccess(TRUE);
}

// SiStarRegistryAction ----------------------------------------------

SiStarRegistryAction::SiStarRegistryAction( SiAgenda* pAgenda,
	PIA eActType, const SiStarRegistryItem* pItem ) :
	SiAction( pAgenda, eActType == PIA_CREATE ? AT_REGISTER : AT_UNREGISTER )
{
	m_pItem = pItem;
	m_ePIA = eActType;
}

BOOL SiStarRegistryAction::Execute(SiEnvironment& rEnv)
{
	SiDirEntry aRegistryFile( rEnv.GetDestPath() );
	aRegistryFile += m_pItem->GetRegistry()->GetDir()->GetName();
	aRegistryFile += m_pItem->GetRegistry()->GetName();
	aRegistryFile.ToAbs();

	RegistryLoader* static_RegLoader = SiHelp::GetStaticRegistryLoader(rEnv);
	if( !static_RegLoader )
	{
		GetLogfile().Success(FALSE) << "star registry: can't load Registry-DLL" << endl;
		return FALSE;
	}

	::rtl::OUString regURL;
	FileBase::getFileURLFromSystemPath( ::rtl::OStringToOUString( aRegistryFile.GetFull().GetBuffer(),
					osl_getThreadTextEncoding() ), regURL );

	BOOL bOpen = FALSE;
	Registry aRegistry( *static_RegLoader );
	if( !aRegistryFile.Exists() &&
		aRegistry.create(regURL) == REG_NO_ERROR )
		bOpen = TRUE;
	else if( aRegistry.open(regURL, REG_READWRITE) == REG_NO_ERROR )
		bOpen = TRUE;

	if( !bOpen )
	{
		GetLogfile().Success(FALSE) << "star registry: can't open/create Registryfile '" <<
			aRegistryFile.GetFull() << "'" << endl;
		return FALSE;
	}

	RegistryKey aRootKey;
	if( aRegistry.openRootKey(aRootKey) != REG_NO_ERROR )
	{
		GetLogfile().Success(FALSE) << "star registry: can't open ROOT-Key for '" <<
			aRegistryFile.GetFull() << "'" << endl;
		return FALSE;
	}

	ByteString aActValue;
	::rtl::OUString aEmpty;
	switch( m_ePIA )
	{
		case PIA_CREATE :
		{
			RegistryKey aKey;
			if( aRootKey.createKey(UniString(m_pItem->GetKey(), osl_getThreadTextEncoding()),
				aKey) != REG_NO_ERROR )
			{
				GetLogfile().Success(FALSE) << "star registry: can't open Key '" <<
					m_pItem->GetKey() << "' in '" << aRegistryFile.GetFull() << "'" << endl;
				return FALSE;
			}

			if( m_pItem->HasNumValue() || m_pItem->HasStrValue() || m_pItem->HasSeqValue() )
			{
				RegValueType	eType;
				RegValue		pValue = NULL;
				UINT32 			nValueLen = 0;
				long			nVal;
				BOOL 			bErr = FALSE;

				if( m_pItem->HasNumValue() )
				{
					eType = RG_VALUETYPE_LONG;
					nVal = m_pItem->GetNumValue();
					pValue = (RegValue) &nVal;
					nValueLen = sizeof(long);

					bErr = aKey.setValue(aEmpty, eType, pValue, nValueLen) != REG_NO_ERROR;
				}
				else if( m_pItem->HasStrValue() )
				{
					eType = RG_VALUETYPE_STRING;
					aActValue = m_pItem->GetStrValue();

					ReplaceMeta( aActValue, TRUE );

					pValue = (RegValue) aActValue.GetBuffer();
					nValueLen = aActValue.Len() + 1;

					bErr = aKey.setValue(aEmpty, eType, pValue, nValueLen) != REG_NO_ERROR;
				}
				else if( m_pItem->HasSeqValue() )
				{
					eType = RG_VALUETYPE_STRINGLIST;

					ByteString aSeqValue( m_pItem->GetSeqValue() );
					USHORT nDelimTok = 0;
					USHORT nTokCount = aSeqValue.GetTokenCount( '|' );

					sal_Char** pList = new sal_Char * [nTokCount];

					for( USHORT i = 0; i < nTokCount; ++i )
					{
						ByteString aActValue( aSeqValue.GetToken(0, '|', nDelimTok) );
						ReplaceMeta( aActValue, TRUE );

						pList[i] = new sal_Char[ aActValue.Len() + 1 ];
						strncpy( pList[i], aActValue.GetBuffer(), aActValue.Len() + 1 );
					}

					bErr = aKey.setStringListValue(aEmpty	, pList, nTokCount) != REG_NO_ERROR;
					for( USHORT x = 0; x < nTokCount; ++x )
						delete[] pList[x];
					delete[] pList;
				}

				if( bErr )
				{
					GetLogfile().Success(FALSE) << "star register: can't set Key/Value '" <<
						m_pItem->GetKey() << " == " <<
						((eType==RG_VALUETYPE_LONG)? ByteString::CreateFromInt32(m_pItem->GetNumValue()) :
						(eType==RG_VALUETYPE_STRINGLIST)? ByteString(m_pItem->GetSeqValue()) :
						m_pItem->GetStrValue()) << "' in '" << aRegistryFile.GetFull() << "'" << endl;
					return FALSE;
				}
				else
				{
					GetLogfile().Success(TRUE) << "star register: set Key/Value '" <<
						m_pItem->GetKey() << " == " <<
						((eType==RG_VALUETYPE_LONG)? ByteString::CreateFromInt32(m_pItem->GetNumValue()) : m_pItem->GetStrValue()) <<
						"' in '" << aRegistryFile.GetFull() << "'" << endl;
				}
			}
			else
			{	// wenn nur der blanke Key registriert wurde!
				GetLogfile().Success(TRUE) << "star register: set Key '" << m_pItem->GetKey() <<
					"' in '" << aRegistryFile.GetFull() << "'" << endl;
			}
		} break;

		case PIA_REMOVE :
		{
			if( aRootKey.deleteKey(UniString(m_pItem->GetKey(), osl_getThreadTextEncoding())) != REG_NO_ERROR )
			{
				GetLogfile().Success(FALSE) << "star deregister: can't delete Key '" <<
					m_pItem->GetKey() << "' in '" << aRegistryFile.GetFull() << "'" << endl;
				return FALSE;
			}
			else
			{
				GetLogfile().Success(TRUE) << "star deregister: delete Key '" << m_pItem->GetKey() <<
					"' in '" << aRegistryFile.GetFull() << "'" << endl;
			}
		} break;
	}

	return TRUE;
}

//-- SiConfigurationAction CREATE helpers -----------------------------------
static const sal_Unicode c_chDelimiter = '/';
static const sal_Unicode c_uchCreateMarker[3] = { '/', '*', '[' };
static const sal_Unicode c_uchCreateEnd = ']';
static const sal_Int32 c_nCreateMarkerLen = sizeof c_uchCreateMarker/ sizeof *c_uchCreateMarker;
//----------
static sal_Int32 lcl_findCreateItem(::rtl::OUString const& _aItemPath, sal_Int32 & _rnStartPos)
{
    OUString const sCreateMarker = OUString(c_uchCreateMarker, c_nCreateMarkerLen);

    sal_Int32 nFound = _aItemPath.indexOf(sCreateMarker,_rnStartPos);
    if (nFound >= 0)
    {
        sal_Unicode chQuote = _aItemPath[nFound + c_nCreateMarkerLen];

        sal_Int32 nEnd = _aItemPath.indexOf(chQuote, nFound + c_nCreateMarkerLen +1);

        DBG_ASSERT(0 <= nEnd && nEnd+1 < _aItemPath.getLength(), "Invalid CreateItem Name format");
        DBG_ASSERT(_aItemPath[nEnd + 1] == c_uchCreateEnd, "Invalid CreateItem Name format");

        _rnStartPos = nEnd +2;

        DBG_ASSERT(_rnStartPos == _aItemPath.getLength() || _aItemPath[_rnStartPos] == c_chDelimiter, "Invalid CreateItem Name format");
    }
    else if (_rnStartPos == 0)
    {
        _rnStartPos = _aItemPath.lastIndexOf(c_chDelimiter);
        DBG_ASSERT(0 <= _rnStartPos, "No delimiter in complete path");
    }

    return nFound;
}
//----------
static sal_Int32 lcl_findFirstCreateItem(::rtl::OUString const& _aItemPath)
{
    sal_Int32 nPos = 0;
    sal_Int32 nRet = lcl_findCreateItem(_aItemPath,nPos);

    return nRet>= 0 ? nRet : nPos;
}
//----------
static OUString lcl_getCreateItemName(::rtl::OUString const& _aItemPath, sal_Int32 _nFoundPos, sal_Int32 _nNextPos)
{
    if (_nFoundPos >= 0)
    {
        sal_Int32 nNameStart = _nFoundPos + c_nCreateMarkerLen + 1;
        sal_Int32 nNameEnd   = _nNextPos - 2;

        return  _aItemPath.copy(nNameStart,nNameEnd-nNameStart);
    }
    else
    {
        return  _aItemPath.copy(_nNextPos + 1);
    }
}
//----------
static OUString lcl_getCreateItemPath(::rtl::OUString const& _aItemPath, sal_Int32 _nFoundPos)
{
    if ( _nFoundPos >= 0 )
        return  _aItemPath.copy(0,_nFoundPos);
    else
        return _aItemPath;
}

//----------
Reference<XInterface> lcl_createConfigurationItem(
                            Reference<XHierarchicalNameAccess> const & _xBaseItemAccess,
                            ::rtl::OUString const& _aItemPath)
{
    sal_Int32 nCurrent = 0;
    sal_Int32 nCreateItemStart = lcl_findCreateItem(_aItemPath,nCurrent);

    Reference<XHierarchicalNameAccess> xItemAccess = _xBaseItemAccess;

    while (xItemAccess.is())
    {
        OUString sCreateName = lcl_getCreateItemName(_aItemPath,nCreateItemStart,nCurrent);

        Reference < XNameContainer > xContainer( xItemAccess, UNO_QUERY );
        if (xContainer.is())
        {
            if (!xContainer->hasByName(sCreateName))
            {
		        Reference < XSingleServiceFactory > xFactory( xContainer, UNO_QUERY );

                DBG_ASSERT(xFactory.is(),"ERROR: No element factory for configuration Set");

		        if( !xFactory.is() ) break; // fail

		        Reference < XInterface > xNewNode = xFactory->createInstance();

		        xContainer->insertByName( sCreateName, makeAny(xNewNode) );
            }
        }
        else // No container ?
        {
	        Reference< XNameAccess > xSimpleAccess( xItemAccess, UNO_QUERY );
            DBG_ASSERT(xSimpleAccess.is(),"ERROR: No XNameAccess for configuration object");

            if (!xSimpleAccess.is() || !xSimpleAccess->hasByName(sCreateName)) break; // fail
        }

        nCreateItemStart = lcl_findCreateItem(_aItemPath,nCurrent);

        if (nCreateItemStart < 0) break;

        ::rtl::OUString aNextItemPath = lcl_getCreateItemPath(_aItemPath,nCreateItemStart);
        Any aNextItem = xItemAccess->getByHierarchicalName( aNextItemPath );
        if (!(aNextItem >>= xItemAccess)) break;
    }

    Reference< XInterface > xResult;
    if (xItemAccess.is())
    {
        xItemAccess->getByHierarchicalName(_aItemPath) >>= xResult;
    }
    return xResult;
}

// SiConfigurationAction ----------------------------------------------
//
SiConfigurationAction::SiConfigurationAction( SiAgenda* pAgenda,
                                              PIA eActType,
                                              const SiConfigurationItem* pItem,
                                              USHORT nLanguage ) :
	SiAction( pAgenda, eActType == PIA_CREATE ? AT_REGISTER : AT_UNREGISTER )
{
	m_pItem = pItem;
	m_ePIA = eActType;
    m_nLanguage = nLanguage;
}

SiConfigurationAction::SiConfigurationAction( SiAgenda* pAgenda,
                                              PIA eActType,
                                              const SiConfigurationItem* pItem ) :
	SiAction( pAgenda, eActType == PIA_CREATE ? AT_REGISTER : AT_UNREGISTER )
{
	m_pItem = pItem;
	m_ePIA = eActType;
    m_nLanguage = pAgenda->GetAppLanguage();
}

BOOL SiConfigurationAction::Execute(SiEnvironment& rEnv)
{
	Sequence< Any > aCPArgs(2);
	Any aAny;

    ::rtl::OUString aItemPath = ::rtl::OUString::createFromAscii( m_pItem->GetPath().GetBuffer() );

	if (aItemPath.indexOf(c_chDelimiter) != 0)  // need to make a proper absolute path, so a later getByHierarchicalName works
	{
        sal_Unicode const chDelimiter = c_chDelimiter;
		aItemPath = OUString( &chDelimiter, 1).concat( aItemPath );
	}


    ::rtl::OUString aBaseItemPath = aItemPath;
	if( m_pItem->IsCreate() )
	{
		aBaseItemPath = lcl_getCreateItemPath(aItemPath,lcl_findFirstCreateItem(aItemPath));
	}

	sal_Int32 nLocalStart = aBaseItemPath.indexOf(c_chDelimiter,1);
	if (nLocalStart >= 1)
	{
		aAny <<= aBaseItemPath.copy(0,nLocalStart);
	}
	else
		aAny <<= aBaseItemPath;

	PropertyValue aPropertyUser( ::rtl::OUString::createFromAscii("nodepath"), -1, aAny, PropertyState_DIRECT_VALUE );
	aCPArgs[0] <<= aPropertyUser;

	aAny <<= (sal_Bool)TRUE;
	aPropertyUser = PropertyValue( ::rtl::OUString::createFromAscii("lazywrite"), -1, aAny, PropertyState_DIRECT_VALUE );
	aCPArgs[1] <<= aPropertyUser;

	if( rEnv.IsResponsefileMode() && rEnv.GetResponseStep() == 2 )
	{
		aCPArgs.realloc(aCPArgs.getLength() + 1);

		ByteString aUsername = m_pItem->GetUserName();
		if( !aUsername.Len() ) aUsername = ByteString("Administrator");

		aAny <<= ::rtl::OUString::createFromAscii( aUsername.GetBuffer() );
		PropertyValue aPropertyUser( ::rtl::OUString::createFromAscii("user"), -1, aAny, PropertyState_DIRECT_VALUE );
		aCPArgs[2] <<= aPropertyUser;
	}

	Reference< XInterface > xRoot, xItem;
	try
	{
		xRoot = xCfgProvider->createInstanceWithArguments(
			::rtl::OUString::createFromAscii("com.sun.star.configuration.ConfigurationUpdateAccess"),
			aCPArgs);

		Reference< XHierarchicalNameAccess > xRootAccess( xRoot, UNO_QUERY );
		if (xRootAccess.is())
		{
			xRootAccess->getByHierarchicalName( aBaseItemPath ) >>= xItem;
		}

	}
	catch(RuntimeException& e) {
		GetLogfile().Success(FALSE) << ByteString(UniString(e.Message), osl_getThreadTextEncoding()) << endl;

        ByteString aStr(UniString(e.Message), osl_getThreadTextEncoding());
		Critical_Log( aStr );
		return FALSE;
	}
	catch(Exception& e) {
		GetLogfile().Success(FALSE) << ByteString(UniString(e.Message), osl_getThreadTextEncoding()) << endl;
        ByteString aStr(UniString(e.Message), osl_getThreadTextEncoding());
		Critical_Log( aStr );
		return FALSE;
	}


	// config item which where created with factory->createInstance should be removed
    // when removing, all other items will only change there name
    if ( ( m_ePIA == PIA_REMOVE ) && m_pItem->IsCreate() )
    {
        BOOL bEntryRemoved = FALSE;

        try
        {
            sal_Int32 nCreateItemEnd = aBaseItemPath.getLength();
            sal_Int32 nCreateItemStart = lcl_findCreateItem(aItemPath,nCreateItemEnd);

            rtl::OUString aName = lcl_getCreateItemName(aItemPath,nCreateItemStart,nCreateItemEnd);
            Reference < XNameContainer > xContainer( xItem, UNO_QUERY );

            if ( !xContainer.is() )
            {
                // Don't remove the parent set but the value
                Reference < XHierarchicalNameAccess > xItemAccess( xItem, UNO_QUERY );
                if (xItemAccess.is() )
                {
                    xItemAccess->getByHierarchicalName(aItemPath) >>= xContainer;
                    aName = ::rtl::OUString::createFromAscii(m_pItem->GetKey().GetBuffer());
                }
            }

            if ( xContainer.is() && xContainer->hasByName( aName ) )
            {
                xContainer->removeByName( aName );
                bEntryRemoved = TRUE;
            }
        }
	    catch( Exception& e )
	    {
		    GetLogfile().Success(FALSE) << ByteString( UniString(e.Message), osl_getThreadTextEncoding() ) << endl;
            ByteString aStr( UniString(e.Message), osl_getThreadTextEncoding() );
            Critical_Log( aStr );
            return FALSE;
	    }

        if ( !bEntryRemoved )
        {
    		GetLogfile().Success(FALSE) << "Configuration: can't delete Key '" << m_pItem->GetPath() <<
                "' in '" << m_pItem->GetKey() << endl;
            return TRUE;
        }
    }
    else
    {
        if( m_pItem->IsCreate() )
        try
	    {
		    Reference < XHierarchicalNameAccess > xItemAccess( xItem, UNO_QUERY );

            xItem.clear();
            if (!xItemAccess.is())
            {
                DBG_ERROR("No XHierarchicalNameAccess for configuration object");
		        return FALSE;
            }
            else if (xItemAccess->hasByHierarchicalName(aItemPath))
		    {
                xItemAccess->getByHierarchicalName(aItemPath) >>= xItem;
                DBG_ASSERT(xItem.is(),"ERROR: Existing object cannot be retrieved from XHierarchicalNameAccess for configuration object");
		    }
            else
            {
                xItem = lcl_createConfigurationItem(xItemAccess,aItemPath);
                DBG_ASSERT(xItem.is(),"ERROR: Missing object cannot be created in configuration");
            }
	    }
	    catch(Exception& e)
	    {
		    GetLogfile().Success(FALSE) << ByteString(UniString(e.Message), osl_getThreadTextEncoding()) << endl;
            ByteString aStr(UniString(e.Message), osl_getThreadTextEncoding());
            Critical_Log( aStr );
		    return FALSE;
	    }

	    Any anyValue;
	    switch( m_pItem->GetValueType() )
	    {
		    case SiConfigurationItem::BOOLEAN:
		    {
			    sal_Bool b = m_pItem->GetValue().CompareIgnoreCaseToAscii("true") == COMPARE_EQUAL ||
						     m_pItem->GetValue().ToInt32() == 1 ? sal_True : sal_False;
			    anyValue.setValue( &b, ::getBooleanCppuType() );
		    } break;

		    case SiConfigurationItem::STRING:
		    case SiConfigurationItem::STRINGLIST:
		    {
			    ByteString aActValue( GetInstallMode() == IM_WORKSTATION && m_pItem->GetWorkstationValue().Len()?
								      m_pItem->GetWorkstationValue() : m_pItem->GetValue() );
                sal_Int16 nEncoding = ReplaceMeta( aActValue, FALSE );

			    if( m_pItem->GetValueType() == SiConfigurationItem::STRING )
			    {
                    OUString s;
                    switch( nEncoding )
                    {
                        case LANGCODE2TEXTENCODING:     s = UniString( aActValue, Langcode2TextEncoding( m_nLanguage ) ); break;
                        case RTL_TEXTENCODING_UTF8:     s = UniString( aActValue, RTL_TEXTENCODING_UTF8 ); break;
                        case OSL_GETTHREADTEXTENCODING: s = UniString( aActValue, osl_getThreadTextEncoding() ); break;
                        default: s = UniString( aActValue, osl_getThreadTextEncoding() );
                                 DBG_ERRORFILE( "Unknown encoding for Configuration Item!" );
					}
				    anyValue.setValue( &s, ::getCppuType((const ::rtl::OUString*)0) );
			    }
			    else
			    {
				    USHORT nDelimTok = 0;
				    USHORT nTokCount = aActValue.GetTokenCount( '|' );

				    Sequence< OUString > seqStrList;
				    seqStrList.realloc( nTokCount );

				    for( USHORT i = 0; i < nTokCount; ++i )
				    {
                        OUString s;
                        switch( nEncoding )
                        {
                            case LANGCODE2TEXTENCODING:     s = UniString( aActValue.GetToken(0, '|', nDelimTok), Langcode2TextEncoding( m_nLanguage ) ); break;
                            case RTL_TEXTENCODING_UTF8:     s = UniString( aActValue.GetToken(0, '|', nDelimTok), RTL_TEXTENCODING_UTF8 ); break;
                            case OSL_GETTHREADTEXTENCODING: s = UniString( aActValue.GetToken(0, '|', nDelimTok), osl_getThreadTextEncoding() ); break;
                            default: s = UniString( aActValue.GetToken(0, '|', nDelimTok), osl_getThreadTextEncoding() );
                                    DBG_ERRORFILE( "Unknown encoding for Configuration Item!" );
					    }
                        seqStrList[i] = s;
				    }
				    anyValue <<= seqStrList;
			    }
		    } break;

		    case SiConfigurationItem::BINARY:
		    {
			    ByteString aActValue( GetInstallMode() == IM_WORKSTATION && m_pItem->GetWorkstationValue().Len()?
								      m_pItem->GetWorkstationValue() : m_pItem->GetValue() );
			    
                aActValue.Convert( Langcode2TextEncoding( m_nLanguage ), osl_getThreadTextEncoding() );
                
                ReplaceMeta( aActValue, FALSE );
                OUString aOUStr = UniString( aActValue, osl_getThreadTextEncoding() );

			    Sequence< sal_Int8 > aBinarySeq;
			    aBinarySeq.realloc( aOUStr.getLength() / 2 );

			    sal_Int16 nHex8;
			    sal_Bool nHigh = true;
			    sal_Int8 *pBinarySeq = aBinarySeq.getArray();

			    for(sal_Int32 nPos = 0; nPos < aOUStr.getLength() ; nPos++ )
			    {
				    sal_Char aHex = (sal_Char) aOUStr[nPos];
				    sal_Int8 nHex4 = 0;
				    if (aHex >= '0' && aHex <= '9') nHex4 = aHex - '0';
				    else if (aHex >= 'a' && aHex <= 'f') nHex4 = aHex - 'a' + 10;
				    else if (aHex >= 'A' && aHex <= 'F') nHex4 = aHex - 'A' + 10;
				    if (nHigh)
				    {
					    nHex8 = nHex4 << 4;
					    nHigh = false;
				    }
				    else
				    {
					    nHex8 |= nHex4;
					    nHigh = true;
					    *pBinarySeq++ = (sal_Int8) nHex8;
				    }
			    }

			    anyValue <<= aBinarySeq;
		    } break;

		    case SiConfigurationItem::NUMERIC:
		    {
			    sal_Int32 n = m_pItem->GetValue().ToInt32();
			    anyValue.setValue( &n, ::getCppuType((const sal_Int32*)0) );
		    } break;
	    }

	    Reference< XNameReplace > xReplaceAccess(xItem, UNO_QUERY);
	    if( !xReplaceAccess.is() )
	    {
		    DBG_ERROR("No XNameReplace for configuration object");
            return FALSE;
	    }
	    try
	    {
		    ::rtl::OUString aInsKey = ::rtl::OUString::createFromAscii(m_pItem->GetKey().GetBuffer());
		    if( xReplaceAccess->hasByName(aInsKey) )
                xReplaceAccess->replaceByName( aInsKey, anyValue );
		    else
		    {
			    Reference< XNameContainer > xNC(xReplaceAccess, UNO_QUERY);
			    if (!xNC.is())
                {
                    DBG_ERROR("No XNameContainer for configuration object");
				    return FALSE;
                }
			    xNC->insertByName( aInsKey, anyValue );
		    }
	    }
	    catch(Exception& e)
	    {
		    GetLogfile().Success(FALSE) << ByteString(UniString(e.Message), osl_getThreadTextEncoding());
            ByteString aStr(UniString(e.Message), osl_getThreadTextEncoding());
            Critical_Log( aStr );
		    return FALSE;
	    }
    }
	Reference< XChangesBatch > xChangesAccess(xRoot, UNO_QUERY);

	if( !xChangesAccess.is() )
    {
        DBG_ERROR("No XChangesBatch for configuration object");
		return FALSE;
    }

	try
	{
		xChangesAccess->commitChanges();
	}
	catch(RuntimeException& e) {
		GetLogfile().Success(FALSE) << ByteString(UniString(e.Message), osl_getThreadTextEncoding());
        ByteString aStr(UniString(e.Message), osl_getThreadTextEncoding());
        Critical_Log( aStr );
		return FALSE;
	}
	catch(Exception& e) {
		GetLogfile().Success(FALSE) << ByteString(UniString(e.Message), osl_getThreadTextEncoding());
		ByteString aStr(UniString(e.Message), osl_getThreadTextEncoding());
        Critical_Log( aStr );
		return FALSE;
	}

	GetLogfile().Success(TRUE) << "configuration: write Key '" << m_pItem->GetKey() <<
                "' in '" << m_pItem->GetPath() << endl;
	return TRUE;
}


// SiCustomAction ----------------------------------------------------
//
static SiCustomAction* static_pCustomAction = NULL;

SiCustomAction::SiCustomAction( SiAgenda* pAgenda, SiModule* pRoot,
	const ByteString& aDllName, const ByteString& aExePath, BOOL bInst,
    BOOL bPre, SiCustom* pCustom, SiCompiledScript* pCScript ) :
	SiAction(pAgenda, AT_CUSTOM)
{
	m_pCScript          = pCScript;
    m_pCustom			= pCustom;
	m_aDllName			= aDllName;
	m_aExePath			= aExePath;
	m_bInstallation 	= bInst;
    m_bModify           = FALSE;
    m_bRepair           = FALSE;
	m_bPre				= bPre;
	m_pCustomDll		= NULL;
	m_bKeepAlive 		= FALSE;

	pModuleInfoList		= NULL;
	pRootModule			= pRoot;
	bInternalError		= FALSE;
}

SiCustomAction::~SiCustomAction()
{
	if(pModuleInfoList)
	{
		for( USHORT i = 0; i < pModuleInfoList->Count(); ++i )
			delete pModuleInfoList->GetObject(i);
		delete pModuleInfoList;
	}

	static_pCustomAction = NULL;

    if( m_pCustomDll && !m_bKeepAlive )
	{
		m_pCustomDll->unload();
		delete m_pCustomDll;
	}

	if( m_aTempFile.Len() )
	{
		SiDirEntry aEntry(m_aTempFile);
		aEntry.Kill();
		m_aTempFile = "";
	}
}

void SiCustomAction::AddModuleInfo(SiModule* pModule)
{
	SiCustomModuleInfo* pNew = new SiCustomModuleInfo;

	pNew->SetModuleID(pModule->GetID());
	pNew->SetModuleName(pModule->GetName());
    pNew->SetInstalled( pModule->IsInstalled() );
	if(pModule->IsSelected())
		pNew->SelectModule();
	else
		pNew->DeselectModule();

	if(!pModuleInfoList)
		pModuleInfoList = new SiCustomModuleList;
	pModuleInfoList->Insert(pNew, LIST_APPEND);

	const SiModuleList* pModuleList = pModule->GetModuleList();
	for( USHORT x = 0; x < pModuleList->Count(); ++x )
		AddModuleInfo( pModuleList->GetObject(x) );
}

void _SV_CALL ShowSetup()
{
	static_pCustomAction->GetAgenda()->GetWindowHideLink().Call( static_pCustomAction );
}

void _SV_CALL HideSetup()
{
	static_pCustomAction->GetAgenda()->GetWindowHideLink().Call( 0 );
}

ByteString _SV_CALL GetCodeFilename()
{
	ByteString aFilename;
	if( static_pCustomAction )
		aFilename = static_pCustomAction->WriteCodeFile();
	return aFilename;
}

BOOL SiCustomAction::Execute( SiEnvironment& rEnv )
{
	bInternalError	= FALSE;
	m_aTempFile		= "";

	// We will look for the custom dll in the start path first
    // to avoid problems with customs which shall be called before
    // and after installation

    SiDirEntry aCustom( rEnv.GetStartPath() );
	aCustom += m_aDllName;

#ifdef UNX
    if( !aCustom.Exists() )
    {
        aCustom = rEnv.GetStartPath();
        aCustom += ByteString("../lib/");
        aCustom += m_aDllName;
    }
#endif
	if( !aCustom.Exists() )
	{
        aCustom = m_aExePath;
        aCustom += m_aDllName;
    }

	if( !aCustom.Exists() )
	{
		bInternalError = TRUE;
		return TRUE;
	}

	SiDirEntry aOldDir(".");
	SiDirEntry aCwd( aCustom.GetPath() );
	aCwd.SetCWD();

	if( m_pCustomDll )
	{
		m_pCustomDll->unload();
		delete m_pCustomDll;
	}

	rtl::OUString aNormalizedPath;

    FileBase::getFileURLFromSystemPath( aCustom.GetFullUni(), aNormalizedPath );

    m_pCustomDll = new OModule( aNormalizedPath );
	if( !m_pCustomDll->isLoaded() )
	{
		aOldDir.SetCWD();
		delete m_pCustomDll;
		m_pCustomDll = NULL;
		bInternalError = TRUE;
		return TRUE;
	}

	ByteString aEntryPoint;
	#if defined(OS2) || defined(WIN)
	aEntryPoint = "_CustomInit";
	#else
	aEntryPoint = "CustomInit";
	#endif

	FncPtrCustomInit pInitFnc = (FncPtrCustomInit)
								m_pCustomDll->getSymbol( UniString::CreateFromAscii(aEntryPoint.GetBuffer()) );
	if( !pInitFnc )
	{
		delete m_pCustomDll;
		m_pCustomDll = NULL;
		aOldDir.SetCWD();
		bInternalError = TRUE;
		return TRUE;
	}

	memset( &m_aCustomFnc, 0, sizeof(SiCustomFnc) );
	m_aCustomFnc.nVersion		  	= SICUSTOM_VERSION;

	m_aSetupFnc.nVersion			= SICUSTOM_VERSION;
	m_aSetupFnc.fncHideSetup		= (FncPtrHideSetup)HideSetup;
	m_aSetupFnc.fncShowSetup		= (FncPtrShowSetup)ShowSetup;
	m_aSetupFnc.fncGetCodeFilename	= (FncPtrGetCodeFilename)GetCodeFilename;

	static_pCustomAction = this;

	if( !pInitFnc(&m_aSetupFnc, &m_aCustomFnc) )
	{
		m_pCustomDll->unload();
		delete m_pCustomDll;
		m_pCustomDll = NULL;
		aOldDir.SetCWD();

		bInternalError = TRUE;
		static_pCustomAction = NULL;
		return TRUE;
	}

	m_aCustEnv.SetResponse			( rEnv.IsResponsefileMode() );
	m_aCustEnv.SetResponseFileName	( rEnv.GetResponseFilename() );
	m_aCustEnv.SetPreFlag			( m_bPre );
	m_aCustEnv.SetInstallContext	( m_bInstallation );
    m_aCustEnv.SetModifyContext     ( m_bModify );
    m_aCustEnv.SetRepairContext     ( m_bRepair );
	m_aCustEnv.SetFirstInstallation	( rEnv.IsFirstInstallation() );
	m_aCustEnv.SetStartPath			( rEnv.GetStartPath() );
	m_aCustEnv.SetSourcePath		( rEnv.GetSourcePath() );
	m_aCustEnv.SetDestPath			( rEnv.GetDestPath() );
	m_aCustEnv.SetInstalledPath		( rEnv.GetInstalledPath() );
	m_aCustEnv.SetEnvPtr			( &rEnv );
	m_aCustEnv.SetCompiledScript    ( m_pCScript );

	AddModuleInfo(pRootModule);
	BOOL bSucc;

	if ( rEnv.HasVCL() )
    {
        NAMESPACE_VOS(OGuard) aGuard(Application::GetSolarMutex());
        bSucc = m_aCustomFnc.fncMain(&m_aCustEnv, pModuleInfoList);
    }
    else
        bSucc = m_aCustomFnc.fncMain(&m_aCustEnv, pModuleInfoList);

	if( !m_bKeepAlive )
	{
		m_pCustomDll->unload();
		delete m_pCustomDll;
		m_pCustomDll = NULL;
		static_pCustomAction = NULL;

		if( m_aTempFile.Len() )
		{
			SiDirEntry aEntry(m_aTempFile);
			aEntry.Kill();
			m_aTempFile = "";
		}
	}

	aOldDir.SetCWD();
	return bSucc;
}

ByteString SiCustomAction::WriteCodeFile()
{
	SiDirEntry		aFoo( SiDirEntry("sic*") );
	SiDirEntry		aTemp( aFoo.TempName() );

	SvFileStream	aWriteStrm( aTemp.GetFullUni(), STREAM_WRITE );
	ByteString		aCode( m_pCustom->GetCode() );

	aTemp.ToAbs();

	aWriteStrm.Write( aCode.GetBuffer(), aCode.Len() );
	aWriteStrm.Close();

	m_aTempFile = aTemp.GetFull();
	return m_aTempFile;
}


// SimpleProcedureAction ---------------------------------------------
SimpleProcedureAction::SimpleProcedureAction( const ByteString& aProcName, const ByteString& aCode ) :
	m_aProcName	( aProcName ),
	m_aCode	( aCode )
{
}

BOOL SimpleProcedureAction::Execute(SiCompiledScript* pCS, SiEnvironment& rEnv)
{
	SiBasic aBasic(*pCS, rEnv);

    if ( rEnv.HasVCL() )
    {
        NAMESPACE_VOS(OGuard) aGuard(Application::GetSolarMutex());
        return aBasic.Call(m_aProcName,m_aCode);
    }
    else
        return aBasic.Call(m_aProcName,m_aCode);
}

// RunProcedureAction ------------------------------------------------
SiRunProcedureAction::SiRunProcedureAction
(
	SiAgenda       * pAgenda,
	ByteString    const& aProcName,
	ByteString    const& aCode,
	SiCompiledScript *pCS
)
: SiAction(pAgenda, AT_PROCEDURE)
{
	m_aProcName = aProcName;
	m_aCode     = aCode;
	m_pCS		= pCS;
}

BOOL SiRunProcedureAction::Execute(SiEnvironment& rEnv)
{
	BOOL bOk = FALSE;

	SiBasic aBasic(*m_pCS, rEnv);

    if ( rEnv.HasVCL() )
    {
        NAMESPACE_VOS(OGuard) aGuard(Application::GetSolarMutex());
    	bOk = aBasic.Call(m_aProcName,m_aCode);
    }
    else
        bOk = aBasic.Call(m_aProcName,m_aCode);

	return SetSuccess(bOk);
}

// ------------------------------------------------------------------------
// PLATTFORMABHAENGIGE FUNKTIONEN -----------------------------------------
// ------------------------------------------------------------------------

// MakeFolderAction -------------------------------------------------
//
SiMakeFolderAction::SiMakeFolderAction
(
	SiAgenda      * pAgenda,
	ByteString const& aName     // Titel im Folder
)
: SiAction(pAgenda, AT_REGISTER)
{
	m_aName = aName;        // Titel im Folder
}


BOOL SiMakeFolderAction::Execute( SiEnvironment& rEnv )
{
#ifdef WNT
	if( rEnv.IsAutoWorkstation() )
		return TRUE;

    OUString    aDirnameUNC;
	UniString   aDirname = WinOS::SHGetProgramFolder( rEnv.InstallForAllUser() );

    aDirname += UniString::CreateFromAscii( "\\" );
	aDirname += UniString( m_aName, osl_getThreadTextEncoding() );

	FileBase::getFileURLFromSystemPath( aDirname, aDirnameUNC );

    BOOL bSuccess;
    FileBase::RC eRet = Directory::create( aDirnameUNC );

    if ( eRet == FileBase::E_None || eRet == FileBase::E_EXIST )
        bSuccess = TRUE;
    else
        bSuccess = FALSE;

	GetLogfile().Success(bSuccess) << "make folder " << m_aName << (bSuccess ? " OK" : " ERR") << endl;

	return bSuccess;
#else
	return FALSE;
#endif
}

// MakeFolderItemAction ---------------------------------------------------
//

SiMakeFolderItemAction::SiMakeFolderItemAction(
		SiAgenda      * pAgenda,
		UniString const& _suFolderName,
		ByteString const& anItemName,
		BOOL          bNetwork,
		ByteString const& aPath,
		ByteString const& aFileName,
		ByteString const& aParameter,
        const UniString&  rIconFile,
        sal_Int32         nIconIndex,
        SiFolderItem*    pItem )
: SiAction(pAgenda, AT_REGISTER)
{
	m_suFolderName  = _suFolderName;
	m_anItemName   = anItemName;
	m_bNetwork     = bNetwork;
	m_aPath        = aPath;
	m_aFileName    = aFileName;
	m_aParameter   = aParameter;
    m_aIconFile    = rIconFile;
    m_nIconIndex   = nIconIndex;
	m_pItem 	   = pItem;
}

BOOL SiMakeFolderItemAction::Execute(SiEnvironment& rEnv)
{
#ifdef WNT
	if( rEnv.IsAutoWorkstation() )
		return TRUE;

	BOOL bSuccess = TRUE;

	USHORT nLanguage = m_pItem->GetLanguage();
	if( nLanguage == LANG_DEFAULT ) nLanguage = rEnv.GetDefLanguage();

	UniString aUniFolderName( m_suFolderName);
	/*, !m_pItem->GetFolder()->IsPredefined()?
	  Langcode2TextEncoding(nLanguage) : osl_getThreadTextEncoding() );*/

	UniString aUniItemName( m_anItemName, Langcode2TextEncoding(nLanguage) );

	UniString aLinkPathname;
	if( !m_pItem->GetFolder()->IsPredefined() )
	{
		aLinkPathname = WinOS::SHGetProgramFolder( rEnv.InstallForAllUser() );
		aLinkPathname += UniString::CreateFromAscii( "\\" );
		aLinkPathname += aUniFolderName;
	}
	else
		aLinkPathname = aUniFolderName;
	aLinkPathname += UniString::CreateFromAscii( "\\" );

	UniString aLinkFilename = aUniItemName;
	aLinkFilename += UniString::CreateFromAscii( ".lnk" );

	UniString aAbsLink = aLinkPathname;
	aAbsLink += aLinkFilename;

	SiDirEntry aObject;
	if( m_bNetwork )
		aObject = rEnv.GetProgPath( GetInstallMode() );
	else
		aObject = rEnv.GetWorkPath( GetInstallMode() );

	aObject += m_aPath;
	aObject += m_aFileName;
	aObject.ToAbs();

	bSuccess = WinOS::CreateShortcut( aObject.GetFullUni(),
									  ((const SiDirEntry&)aObject.GetPath()).GetFullUni(),
									  aAbsLink,
									  aUniItemName,
									  UniString(m_aParameter, osl_getThreadTextEncoding()),
                                      m_aIconFile, m_nIconIndex );

	GetLogfile().Success(bSuccess) << "make folder item " << aObject.GetFull()
		<< " "  << m_anItemName << " " << m_aParameter << endl;

	return bSuccess;
#else
	return FALSE;
#endif
}

// RegistryItemAction -----------------------------------------------
//
SiRegistryItemAction::SiRegistryItemAction
(
	SiAgenda          * pAgenda,
	RIA                 eRIA,
    USHORT              nLanguage,
	ByteString const&   aKey,
	ByteString const&   aSubkey,
	ByteString const&   aName,
	ByteString const&   aValue,
	BOOL		        bHexValue,
	BOOL		        bDeleteAll
)
: SiAction(pAgenda, eRIA == RIA_CREATE ? AT_REGISTER : AT_UNREGISTER)
{
	m_eRIA       = eRIA;
	m_aKey       = aKey;
    m_nLanguage  = nLanguage;
	m_aSubkey    = aSubkey;
	m_aName      = aName;
	m_aValue     = aValue;
	m_bHexValue	 = bHexValue;
	m_bDeleteAll = bDeleteAll;
}


#if defined (WIN) || defined (WNT)

BOOL SiRegistryItemAction::Execute(SiEnvironment& rEnv)
{
	switch (m_eRIA)
	{
		case RIA_CREATE:
		{
/*			if (DoRecoverOnly()
			&&  WinOS::IsRegistered(m_aKey,m_aSubkey,m_aName, m_aValue.Len() != 0))
				return TRUE;
*/
			// Templatefelder im Value, Key, ... ersetzen
			//
			sal_Int16 nEncoding;
            ReplaceMeta( m_aKey, TRUE );
            ReplaceMeta( m_aSubkey, TRUE );
            ReplaceMeta( m_aName, TRUE );
            nEncoding = ReplaceMeta( m_aValue, TRUE );

            UniString aSubkey( m_aSubkey, Langcode2TextEncoding( m_nLanguage ) );
            UniString aName( m_aName, Langcode2TextEncoding( m_nLanguage ) );
            UniString aValue( m_aValue, nEncoding==OSL_GETTHREADTEXTENCODING ? osl_getThreadTextEncoding() : Langcode2TextEncoding( m_nLanguage ) );

            long lErr = WinOS::Register( m_aKey, aSubkey, aName, aValue,
                                         m_bHexValue, FALSE, !rEnv.InstallForAllUser() );

			GetLogfile()
				.Success(lErr==0)
				<< "register: "
				<< m_aKey       << SEP
				<< m_aSubkey;

			if (m_aValue.Len()!=0)
			{
				GetLogfile()
					<< SEP
					<< (m_aName.Len() != 0 ? m_aName : ByteString("(Standard)")) << SEP
					<< m_aValue;
			}

			GetLogfile() << " Error = " << lErr << endl;
			return SetSuccess(lErr==0);
		}

		case RIA_REMOVE:
		{
			UniString aSubkey( m_aSubkey, Langcode2TextEncoding( m_nLanguage ) );
			UniString aName( m_aName, Langcode2TextEncoding( m_nLanguage ) );
            BOOL      bUseUserSection = !rEnv.InstallForAllUser();

            // When we update a old 6.0 installation, bUseUserSection has to be set
            // to FALSE, because the 6.0 didn't know anything about that
            if ( ( GetAgenda()->GetInstallSubMode() == ISM_DELETE ) &&
                 rEnv.IsUpdateOldVersion() )
                bUseUserSection = FALSE;

            long lErr = WinOS::Deregister( m_aKey, aSubkey, m_aValue.Len()==0,
                                           aName, m_bDeleteAll, bUseUserSection );
            // When we can't deregister with the current setting of bUseUserSection
            // we will try with the opposite value ( because we don't know whether
            // we update a OOo 1.1.1 to something else or an old StarOffice 6 to SO 7
            if ( lErr )
                lErr = WinOS::Deregister( m_aKey, aSubkey, m_aValue.Len()==0,
                                           aName, m_bDeleteAll, !bUseUserSection );

			GetLogfile()
				.Success(lErr==0)
				<< "unregister: "
				<< m_aKey               << SEP
				<< m_aSubkey;

			if (m_aValue.Len()!=0)
			{
				GetLogfile()
					<< SEP
					<< (m_aName.Len() != 0 ? m_aName : ByteString("(Standard)")) << SEP
					<< m_aValue;
			}

			GetLogfile() << " Error = " << lErr << endl;
			return lErr==0;
		}

		default:
			DBG_ERROR("RegistryItemAction::Execute(): unknown action");
			return FALSE;
	}
}

#else // WIN/WNT

BOOL SiRegistryItemAction::Execute(SiEnvironment&)
{
	DBG_ERROR("RegistryItemAction::Execute()");
	GetLogfile() << "error: RegistryItemAction::Execute() called" << endl;
	return FALSE;
}

#endif // WIN/WNT

// ------------------------------------------------------------------
// OS/2 Aktionen
// ------------------------------------------------------------------

// Os2RegisterClassAction -------------------------------------------
//

SiOs2RegisterClassAction::SiOs2RegisterClassAction
(
	SiAgenda    * pAgenda,
	ByteString const& aName,
	BOOL          bNetwork,
	ByteString const& aDLLPath,
	ByteString const& aDLLName
)
:SiAction(pAgenda, AT_REGISTER)
{
	m_aName     = aName;
	m_bNetwork  = bNetwork;
	m_aDLLPath  = aDLLPath;
	m_aDLLName  = aDLLName;
}

#ifdef OS2

BOOL SiOs2RegisterClassAction::Execute(SiEnvironment& rEnv)
// pre: DLL wurde schon kopiert
{
	if (DoRecoverOnly()
	/* && Os2OS::IsClassRegistered*/)
		return TRUE;

	SiDirEntry aDLLDir;

	if (m_bNetwork)
		aDLLDir = rEnv.GetProgPath(GetInstallMode());
	else
		aDLLDir = rEnv.GetWorkPath(GetInstallMode());

	aDLLDir += m_aDLLPath;
	aDLLDir += m_aDLLName;

	ByteString   aDLL = aDLLDir.GetFull();
	ULONG    lErr = Os2OS::RegisterClass(m_aName, aDLL);

	GetLogfile()
	   .Success(lErr==0)
		<< "register os/2 class: "
		<< m_aName   << SEP
		<< aDLL;

	if (lErr != 0)
		GetLogfile() << " Err = " << lErr;

	GetLogfile()
		<< endl;

	return SetSuccess(lErr==0);
}

#else

BOOL SiOs2RegisterClassAction::Execute(SiEnvironment&)
{
	DBG_ERROR("Os2RegisterClassAction::Execute() wrong platform");
	return TRUE;
}

#endif

// Os2CreateTemplateAction ------------------------------------------
//

SiOs2CreateTemplateAction::SiOs2CreateTemplateAction
(
	SiAgenda    * pAgenda,
	ByteString const& anID,
	BOOL          bNetwork,
	ByteString const& anIconPath,
	ByteString const& anIconName,
	SiOs2Class*   pOs2Class
)
: SiAction(pAgenda, AT_REGISTER)
{
	m_anID          = anID;
	m_bNetwork      = bNetwork;
	m_anIconPath    = anIconPath;
	m_anIconName    = anIconName;
	m_pOs2Class		= pOs2Class;
}

#ifdef OS2

BOOL SiOs2CreateTemplateAction::Execute(SiEnvironment& rEnv)
// Hinweis: Das Template wurde schon durch register class durch
//          die wpswrt3.dll erzeugt (aber ohen Icon).
//
// pre:  DLL wurde schon kopiert
//       Template existiert schon
// post: Template enthaelt Icon
{
	if (DoRecoverOnly())
		return TRUE;

	SiDirEntry anIconDir;

	if (m_bNetwork)
		anIconDir = rEnv.GetProgPath(GetInstallMode());
	else
		anIconDir = rEnv.GetWorkPath(GetInstallMode());

	anIconDir += m_anIconPath;
	anIconDir += m_anIconName;

	ByteString  anIcon = anIconDir.GetFull();
	BOOL	bSuccess = Os2OS::RegisterTemplateIcon(m_pOs2Class->GetName(), m_anID, anIcon);

	GetLogfile().Success(bSuccess)
		<< "create os/2 template: "
		<< m_pOs2Class->GetName() << ", " << m_anID << SEP << anIcon << endl;

	return SetSuccess(bSuccess);
}

#else

BOOL SiOs2CreateTemplateAction::Execute(SiEnvironment&)
{
	DBG_ERROR("Os2CreateTemplateAction::Execute() wrong platform");
	return TRUE;
}

#endif

// Os2CreateTemplateAction ------------------------------------------
//

SiOs2JoinEAsAction::SiOs2JoinEAsAction
(
	SiAgenda    * pAgenda,
	ByteString const& aFileDir,
	ByteString const& aFileName,
	ByteString const& anEAFileDir,
	ByteString const& anEAFileName
)
: SiAction(pAgenda, AT_REGISTER)
{
	m_aFileDir          = aFileDir;
	m_aFileName         = aFileName;
	m_anEAFileDir       = anEAFileDir;
	m_anEAFileName  = anEAFileName;
}

#ifdef OS2

BOOL SiOs2JoinEAsAction::Execute(SiEnvironment& rEnv)
{
	SiDirEntry aFileDir  = rEnv.GetDestPath();
			 aFileDir += m_aFileDir;
			 aFileDir += m_aFileName;
	ByteString   aFile     = aFileDir.GetFull();

	SiDirEntry anEAFileDir;

	if (GetInstallMode() == IM_WORKSTATION)
		anEAFileDir = rEnv.GetProgPath(GetInstallMode());
	else
		anEAFileDir = rEnv.GetWorkPath(GetInstallMode());

	anEAFileDir += m_anEAFileDir;
	anEAFileDir += m_anEAFileName;

	ByteString anEAFile = anEAFileDir.GetFull();

	BOOL bSuccess = Os2OS::JoinEAs(aFile, anEAFile);

	GetLogfile()
		.Success(bSuccess)
		<< "set os/2 ea: "
		<< aFile     << SEP
		<< anEAFile  << endl;

	return SetSuccess(bSuccess);
}

#else

BOOL SiOs2JoinEAsAction::Execute(SiEnvironment&)
{
	DBG_ERROR("Os2JoinEAsAction::Execute() wrong platform");
	return TRUE;
}

#endif

// Os2SetCreatorAction ------------------------------------------
//
/****
SiOs2SetCreatorAction::SiOs2SetCreatorAction
(
	SiAgenda    * pAgenda,
	ByteString const& aFileDir,
	ByteString const& aFileName,
	ByteString const& anIconDir,
	ByteString const& anIconName,
	ByteString const& aCreator
)
: SiAction(pAgenda, AT_REGISTER)
{
	m_aFileDir   = aFileDir;
	m_aFileName  = aFileName;
	m_anIconDir  = anIconDir;
	m_anIconName = anIconName;
	m_aCreator   = aCreator;
}

#ifdef OS2

BOOL SiOs2SetCreatorAction::Execute(SiEnvironment& rEnv)
{
	SiDirEntry aFileDir  = rEnv.GetDestPath();
			 aFileDir += m_aFileDir;
			 aFileDir += m_aFileName;
	ByteString   aFile     = aFileDir.GetFull();

	SiDirEntry anIconDir;

	if (GetInstallMode() == IM_WORKSTATION)
		anIconDir = rEnv.GetProgPath(GetInstallMode());
	else
		anIconDir = rEnv.GetWorkPath(GetInstallMode());

	anIconDir += m_anIconDir;
	anIconDir += m_anIconName;

	ByteString anIcon = anIconDir.GetFull();

	BOOL bSuccess = Os2OS::SetFileTypeAndIcon(aFile, m_aCreator, anIcon);

	GetLogfile()
		.Success(bSuccess)
		<< "set os/2 creator: "
		<< aFile        << SEP
		<< m_aCreator   << SEP
		<< anIcon       << endl;

	return SetSuccess(bSuccess);
}

#else

BOOL SiOs2SetCreatorAction::Execute(SiEnvironment&)
{
	DBG_ERROR("Os2SetCreatorAction::Execute() wrong platform");
	return TRUE;
}

#endif
****/
// ------------------------------------------------------------------
// Unix Aktionen
// ------------------------------------------------------------------

// UnixCreateSoftLinkAction -----------------------------------------
//
SiUnixCreateSoftLinkAction::SiUnixCreateSoftLinkAction
(
	SiAgenda      * pAgenda,
	ByteString const& aSourcePath,
	ByteString const& aName,
	ByteString const& aDestPath
)
: SiAction(pAgenda, AT_REGISTER)
{
	m_aSourcePath = aSourcePath;
	m_aName           = aName;
	m_aDestPath       = aDestPath;
}

#ifdef UNX

BOOL SiUnixCreateSoftLinkAction::Execute(SiEnvironment& Env)
{
	SiDirEntry	aSource	    = Env.GetSourcePath();
				aSource    += m_aSourcePath; // Env.GetSourcePath(m_aSourcePath, GetInstallMode());
				aSource    += m_aName;
	ByteString      aSourceStr  = aSource.GetFull();

	SiDirEntry    aDest       = Env.GetDestPath();
				aDest      += m_aDestPath;
				aDest      += m_aName;
	ByteString      aDestStr    = aDest.GetFull();

	if (DoRecoverOnly()
	&&  aDest.Exists())
		return TRUE;

	BOOL bSuccess = UnixOS::CreateSoftLink(aSourceStr,aDestStr);

	GetLogfile()
		.Success(bSuccess)
		<< "slink " << aSourceStr << SEP
		<< aDestStr << endl;

	return SetSuccess(bSuccess);
}

#else

BOOL SiUnixCreateSoftLinkAction::Execute(SiEnvironment&)
{
	DBG_ERROR("UnixCreateSoftLinkAction::Execute() wrong platform");
	return TRUE;
}

#endif

// UnixCreateHardLinkAction -----------------------------------------
//

SiShortcutAction::SiShortcutAction( SiAgenda* pAgenda, ByteString const& aAbsFilename,
	ByteString const& aAbsShortcutName ) :
	SiAction(pAgenda, AT_REGISTER)
{
	m_aAbsFilename      = aAbsFilename;
	m_aAbsShortcutName  = aAbsShortcutName;
    m_nIconIndex        = 0;
}

SiShortcutAction::SiShortcutAction( SiAgenda* pAgenda,
                                    const ByteString& rAbsFilename,
                                    const ByteString& rAbsShortcutName,
                                    const UniString& rParameter,
                                    const UniString& rDescription,
                                    const UniString& rWorkDir,
                                    const UniString& rIconFile,
                                    sal_Int32        nIconIndex) :
	SiAction(pAgenda, AT_REGISTER)
{
	m_aAbsFilename      = rAbsFilename;
	m_aAbsShortcutName  = rAbsShortcutName;
    m_aParameter        = rParameter;
    m_aDescription      = rDescription;
    m_aWorkDir          = rWorkDir;
    m_aIconFile         = rIconFile;
    m_nIconIndex        = nIconIndex;
}

BOOL SiShortcutAction::Execute(SiEnvironment& rEnv)
{
	BOOL		bSuccess = TRUE;
	SiDirEntry	aSrc( m_aAbsFilename );
	SiDirEntry	aDst( m_aAbsShortcutName );

#ifdef WNT
	UniString aSource = aSrc.GetFullUni();
    UniString aDestination = aDst.GetFullUni();
    UniString aWorkDir;

    if ( m_aWorkDir.Len() )
        aWorkDir = m_aWorkDir;
    else
        aWorkDir = ((const SiDirEntry&)aSrc.GetPath()).GetFullUni();
    
    bSuccess = WinOS::CreateShortcut( aSource, aWorkDir, aDestination,
                                      m_aDescription, m_aParameter,
                                      m_aIconFile, m_nIconIndex );
#endif
#ifdef UNX
  	bSuccess = UnixOS::CreateSoftLink( aSrc.GetFull(), aDst.GetFull() );
#endif

	GetLogfile().Success(bSuccess) << "make shortcut " << aSrc.GetFull() <<
									  " to " << aDst.GetFull() << endl;
	return SetSuccess(bSuccess);
}

// ------------------------------------------------------------------
// Mac Aktionen
// ------------------------------------------------------------------

// MacAddApplicationAction ------------------------------------------
//

SiMacAddApplicationAction::SiMacAddApplicationAction
(
	SiAgenda      * pAgenda,
	ByteString const& aRelDir,
	ByteString const& aFileName,
	ByteString const& aCreator
)
: SiAction(pAgenda, AT_REGISTER)
{
	m_aRelDir    = aRelDir;
	m_aFileName  = aFileName;
	m_aCreator   = aCreator;
}

#ifdef MAC

BOOL SiMacAddApplicationAction::Execute(SiEnvironment& rEnv)
{
	SiDirEntry aFileDir  = rEnv.GetDestPath();
			 aFileDir += m_aRelDir;
			 aFileDir += m_aFileName;
	ByteString   aFile     = aFileDir.GetFull();

	if (DoRecoverOnly()
	&&  MacOS::SearchApplication(m_aCreator).Len() != 0)
		return TRUE;

	BOOL bSuccess = MacOS::AddApplication(aFile);

	GetLogfile()
		.Success(bSuccess)
		<< "mac add app: "
		<< aFile
		<< endl;

	return SetSuccess(bSuccess);
}

#else

BOOL SiMacAddApplicationAction::Execute(SiEnvironment&)
{
	DBG_ERROR("MacAddApplicationAction::Execute() wrong platform");
	return TRUE;
}

#endif
