/*************************************************************************
 *
 *  $RCSfile: pguard.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: dv $ $Date: 2002/12/13 07:45:19 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#define INCL_DOSSESMGR
#define INCL_DOSMODULEMGR
#define INCL_DOSQUEUES
#define INCL_DOSPROCESS
#define INCL_DOSFILEMGR
#define INCL_WIN
#define INCL_GPI
#define INCL_DOSERRORS
#define INCL_DOS

#define _MT 1

// include ----------------------------------------------------------------

#include <os2.h>

#include <io.h>
#include <stdio.h>
#include <stdlib.h>
#include <direct.h>
#include <string.h>
#include <process.h>
#include <ctype.h>
#include <sys\stat.h>
#include <fcntl.h>

#include <svunzip.h>

#include <algorithm>

#include "pguard.h"

// prototypes ------------------------------------------------------------

#define ERROR_LEN			300
#define AGLOADER_FILENAME   "\\agloader.exe"

HAB 	hab;				// Anchor block Handle
HWND	hWndFrame;			// Handle des AppWindows
int 	nArgs;				// Anzahl der Kommandoparameter
char*	pArg0;				// Kommandoparameter 1
char*	pArg1;				// Kommandoparameter 2
char*	pArg2;				// Kommandoparameter 3
char	cError[ERROR_LEN];	// globaler Fehlerstring
char	cOffPath[ERROR_LEN];	// globaler Fehlerstring


///////////////////////////////////////////////////////////////////////////////
//	void ErrorBox( PSZ pError )

void ErrorBox( PSZ pError )
{
	char cTitle[ERROR_LEN];
	WinLoadByteString( hab, 0, IDS_TITLE, ERROR_LEN, cTitle );

	WinMessageBox( HWND_DESKTOP, HWND_DESKTOP, pError, (PSZ)cTitle, 0,
		MB_MOVEABLE | MB_ERROR | MB_OK );
}


///////////////////////////////////////////////////////////////////////////////
//	MRESULT EXPENTRY LoaderProc( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )

MRESULT EXPENTRY LoaderProc( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
  return WinDefWindowProc( hwnd, msg, mp1, mp2 );
}


///////////////////////////////////////////////////////////////////////////////
//	BOOL InitSVersionINI()

BOOL InitSVersionINI()
{
	char 	cDrive[5];
	char	cIniFileName[ERROR_LEN];
	APIRET	rc;

	rc = DosQuerySysInfo( QSV_BOOT_DRIVE, QSV_BOOT_DRIVE, cDrive, sizeof(cDrive) );

	if( rc )
		return FALSE;

	cIniFileName[0] = (char)(cDrive[0] + 'A' - 1);
	strcat( cIniFileName, ":\\os2\\sversion.ini" );     // unsupported os #100211# - checked

	int nLen = GetPrivateProfileByteString ( "Versions", "StarOffice 4.0", "",
		cOffPath, ERROR_LEN, cIniFileName );

	if( !nLen || nLen == -1 )
		return FALSE;

	return TRUE;
}


///////////////////////////////////////////////////////////////////////////////
//	void Trim(char *p)

void Trim(char *p)
{
	int i=0;

	while(isspace(p[i]))
		i++;

	if (i > 0)
		strcpy(p,p+i);      // unsupported os #100211# - checked
}


///////////////////////////////////////////////////////////////////////////////
//	BOOL CheckDotInLibpath()

BOOL CheckDotInLibpath()
{
	BOOL bFound		= FALSE;
	char szFile[20] = "";

	DosQuerySysInfo(QSV_BOOT_DRIVE, QSV_BOOT_DRIVE, szFile, sizeof(szFile));

	szFile[0] = (char)(szFile[0] + 'A' - 1);
	strcat(szFile, ":\\config.sys");     // unsupported os #100211# - checked

	FILE *pFile = fopen(szFile, "r");

	if (pFile == 0)
		return FALSE;

	char* szLine = new char[2048];

	while (fgets(szLine, 2048, pFile) != NULL
		&& !bFound)
	{
		strlwr(szLine);
		Trim(szLine);

		char *p = szLine;

		if (strncmp(p,"set ", 4) == 0)
		{
			p += 4;
			Trim(p);
		}

		if (strncmp(p,"libpath", 7) == 0)
		{
			p += 7;
			Trim(p);

			if (*p == '=')
			{
				p++;
				Trim(p);

				strlwr( cOffPath );
				strlwr( p );

				char* pDot = strstr( p, ".;" );
				if( !pDot )
				{
					BOOL bLF = p[strlen(p)-1] == 0x0a ? TRUE : FALSE;
					if( bLF && p[strlen(p)-2] == '.' )
						pDot = &(p[strlen(p)-2]);
					else if( !bLF && p[strlen(p)-1] == '.' )
						pDot = &(p[strlen(p)-1]);
				}

				char* pOff = strstr( p, cOffPath );
				if( !pDot || (pOff && (pOff < pDot)) )
					bFound = FALSE;
				else
					bFound = TRUE;
			}
		}
	}

	fclose(pFile);
	delete szLine;
	return bFound;
}


///////////////////////////////////////////////////////////////////////////////
//	int AddDotToLibpath()

int AddDotToLibpath()
{
	// read config.sys
	int	 bFound		= 0;
	char szFile[20] = "";
	char szOld[20]  = "";

	DosQuerySysInfo(QSV_BOOT_DRIVE, QSV_BOOT_DRIVE, szFile, sizeof(szFile));

	szFile[0] = (char)(szFile[0] + 'A' - 1);

	strcpy(szOld,szFile);                       // unsupported os #100211# - checked
	strcat(szFile, ":\\config.sys");            // unsupported os #100211# - checked
	strcat(szOld,  ":\\config.pre");            // unsupported os #100211# - checked
	DosCopy(szFile, szOld, DCPY_EXISTING);

	FILE *pOld  = fopen(szOld, "r");
	FILE *pFile = fopen(szFile,"w");

	if (pFile == 0
	||  pOld  == 0)
		return 0;

	char* szLine = new char[2048];
	char* szOrg  = new char[2048];

	while (fgets(szOrg, 2048, pOld) != NULL)
	{
		strcpy(szLine,szOrg);                   // unsupported os #100211# - checked
		strlwr(szLine);
		Trim(szLine);

		char *p = szLine;

		if (strncmp(p,"set ", 4) == 0)
		{
			p += 4;
			Trim(p);
		}

		if (strncmp(p,"libpath", 7) == 0)
		{
			p += 7;
			Trim(p);

			if (*p == '=')
			{
				p++;
				Trim(p);
				bFound = 1;

				if(strncmp(p,".;", 2) != 0)
				{
					fputs("LIBPATH=.;",pFile);

					char* pDot = strstr( p, ".;" );
					if( !pDot )
						pDot = strstr( p, ";." );
					if( pDot )
					{
						long nLen = strlen(pDot) - 1;
						memmove( (void*)pDot, (void*)(pDot+2), nLen );
					}
				}
				else
					fputs("LIBPATH=",pFile);

				fputs(p,pFile);
			}
		}
		else
			fputs(szOrg, pFile);
	}

	// "Libpath =" wurde gar nicht gefunden
	if (!bFound)
		fputs("LIBPATH=.\n", pFile);

	fclose(pFile);
	fclose(pOld);
	delete szLine;
	delete szOrg;
	return 1;
}


///////////////////////////////////////////////////////////////////////////////
//	BOOL ModuleRuns( const char* pModuleName )

BOOL ModuleRuns( const char* pModuleName )
{
	char	cModuleName[ERROR_LEN];
	HMODULE	hModule;

	strcpy( cModuleName, cOffPath );            // unsupported os #100211# - checked
	strcat( cModuleName, "\\" );                // unsupported os #100211# - checked
	strcat( cModuleName, pModuleName );         // unsupported os #100211# - checked

	APIRET aReturnCode = DosQueryModuleHandle( cModuleName, &hModule );

	if( aReturnCode != 0 )
		return FALSE;

	return TRUE;
}


///////////////////////////////////////////////////////////////////////////////
//	int main( int argc, char* argv[] )

int main( int argc, char* argv[] )
{
	HMQ 	hmq;
	QMSG	qmsg;

	nArgs = argc;
	pArg0 = argv[0];
	pArg1 = argv[1];
	pArg2 = argv[2];

	hab = WinInitialize( 0 );

	if ( !hab )
		return 0;

	hmq = WinCreateMsgQueue( hab, 0 );

	if ( !hmq )
		return 0;

	if ( !WinRegisterClass( hab, (PSZ)"isetupWnd", (PFNWP)LoaderProc,
		 CS_SIZEREDRAW, 0 ) )
	{
		WinDestroyMsgQueue( hmq );
		WinTerminate( hab );
		return 0;
	}

	HWND 	hWndClient;
	ULONG 	nFlags = FCF_DLGBORDER;
	hWndFrame = WinCreateStdWindow( HWND_DESKTOP, 0, &nFlags,
									(PSZ)"isetupWnd",
									(PSZ)"ISetup",
									0, (HMODULE)0L,
									ID_WINDOW,&hWndClient );
	if ( !hWndFrame )
	{
		WinDestroyMsgQueue( hmq );
		WinTerminate( hab );
		return 0;
	}

	if( !InitSVersionINI() )
	{
		WinDestroyMsgQueue( hmq );
		WinTerminate( hab );
		return 0;
	}

/******
	Nachdem wir einen FallBack beim UnZip oder Copy auf DosReplaceModule haben,
	ist folgendes hinfaellig. Der OSetupAgent kann gerne die DLL's des zu
	updatenden Office anziehen.

	if( !CheckDotInLibpath() )
	{
		AddDotToLibpath();
		WinLoadByteString( hab, 0, IDS_ERRDOTLIBPATH, ERROR_LEN, cError );
		ErrorBox( cError );
		WinDestroyMsgQueue( hmq );
		WinTerminate( hab );
		return 0;
	}
******/

	if( ModuleRuns("soffice.exe") )
	{
		WinLoadByteString( hab, 0, IDS_OFFICE, ERROR_LEN, cError );
		ErrorBox( cError );
		WinDestroyMsgQueue( hmq );
		WinTerminate( hab );
		return 0;
	}

	if( ModuleRuns("download.exe") )
	{
		WinLoadByteString( hab, 0, IDS_DOWNLOADER, ERROR_LEN, cError );
		ErrorBox( cError );
		WinDestroyMsgQueue( hmq );
		WinTerminate( hab );
		return 0;
	}

	char aMyPath[256];
	strcpy( aMyPath, pArg0 );                   // unsupported os #100211# - checked

	long nMyPathLen = strlen( aMyPath );
	for( long nIdx = nMyPathLen; nIdx >= 0; --nIdx )
		if( aMyPath[nIdx] == '\\' )
		{
			aMyPath[nIdx] = 0;
			break;
		}

	DosSetCurrentDir( aMyPath );

	strcat( aMyPath, AGLOADER_FILENAME );       // unsupported os #100211# - checked

	HQUEUE		hQueue = 0;
	STARTDATA	aStartData;
	DosCreateQueue( &hQueue, 0, (PSZ)"\\QUEUES\\SVISETUP.QUE" );

	memset( &aStartData, 0, sizeof( STARTDATA ) );
	aStartData.Length	   = sizeof( STARTDATA );
	aStartData.Related	   = SSF_RELATED_INDEPENDENT;
	aStartData.FgBg 	   = SSF_FGBG_BACK;
	aStartData.TraceOpt    = SSF_TRACEOPT_NONE;
	aStartData.PgmName	   = (PSZ)(const char*)aMyPath;
#ifdef ICC
	aStartData.TermQ	   = (BYTE*)"\\QUEUES\\SVISETUP.QUE";
#else
	aStartData.TermQ	   = (unsigned char*)"\\QUEUES\\SVISETUP.QUE";
#endif
	aStartData.InheritOpt  = SSF_INHERTOPT_PARENT;
	aStartData.SessionType = SSF_TYPE_PM;
	aStartData.PgmControl  = SSF_CONTROL_VISIBLE;

	ULONG	nSessionID;
	PID  	nPID;

	DosStartSession( &aStartData, &nSessionID, &nPID );

	WinDestroyWindow(hWndFrame);
	WinDestroyMsgQueue( hmq );
	WinTerminate( hab );
	return 0;
}


#ifdef VAXELN
#  include <eln$include/$vaxelnc.h>
#  include <eln$include/stdio.h>
#  include <eln$include/stdlib.h>
#else
#  include <stdio.h>
#  include <stdlib.h>
#endif

#include <ctype.h>
#include <string.h>

#ifndef TRUE
#  define TRUE  1
#  define FALSE 0
#endif

#define __toupper(c)	((c) >= 'a' && (c) <= 'z' ? (c) & 0x5F:(c))

int GetPrivateProfileByteString (
  const char *lpszSection,
  const char *lpszEntry,
  const char *lpszDefault,
		char *lpszReturnBuffer,
		int   cbReturnBuffer,
  const char *lpszFilename)
{

#define STATE_ENTRY   0
#define STATE_SECTION 1
#define NSTATES       (STATE_SECTION + 1)

  const char cComment = ';';
  const char cSection = '[';
  const char sDelim[NSTATES + 1] = "=]";

  int  i, ll, itmlen, cmpok, state, cb;
  FILE *f;
  char line[80];
  char *lptr, *itmptr;

  /*
   * Check arguments.
   */
  if (lpszSection == NULL) return -1;
/*  if (lpszEntry == NULL) return -1; */ /* NULL: list of entries. */
  if (lpszDefault == NULL) return -1;
  if ((lpszReturnBuffer == NULL) || (cbReturnBuffer <= 0)) return -1;
  if (lpszFilename == NULL) return -1;

  /*
   * Open the specified file.
   */
  f = fopen (lpszFilename, "r");
  if (f == NULL) return -1;

  /*
   * Initialize search.
   */
  state = STATE_SECTION;
  itmptr = (char *)lpszSection;
  itmlen = strlen (itmptr);
  cb = 0;

  /*
   * Read lines from file until error or eof.
   */
  while (fgets (line, sizeof (line), f) != NULL) {
	/* Compute line length. */
	ll = strlen (line);

	/* Replace terminating '\n' by '\0' character. */
	if (line[ll - 1] == '\n') line[--ll] = '\0';

	/* Remove comments. */
	for (i = 0; i < ll; i++) {
	  if (line[i] != cComment) continue;
	  line[i] = '\0';
	  ll = i;
	  break;
	}

	/* If nothing is left, read next line. */
	if (ll == 0) continue;

	/* Check for opening delimiter. */
	if ((state == STATE_SECTION) && (line[0] != cSection)) continue;
	if ((state == STATE_ENTRY  ) && (line[0] == cSection)) goto done;

	/* Check for closing delimiter. */
	lptr = (char *)strchr (&line[state], sDelim[state]);
	if (lptr == NULL) continue;

	/* Check item length. */
	ll = lptr - &line[state];
	if ((itmlen > 0) && (ll != itmlen)) continue;

	/* Case blind compare item names. */
	cmpok = (itmlen == 0) ? TRUE : FALSE;
	for (i = 0; i < itmlen; i++) {
	  cmpok = (__toupper (itmptr[i]) == __toupper ( *(&line[state + i]) ) );
	  if (!cmpok) break;
	}
	if (!cmpok) continue;

	/* Requested item found. Process it. */
	if (state == STATE_SECTION) {
	  state = STATE_ENTRY;
	  itmptr = (char *)lpszEntry;
	  itmlen = (itmptr == NULL) ? 0 : strlen (itmptr);
	}
	else {
	  if (itmlen > 0) {
		/* Single Entry's value, starting after delimiter. */
		state = STATE_SECTION;
		lptr++;
		ll = strlen (lptr);
	  }
	  else {
		/* List of Entry names, each ending before delimiter. */
		*lptr = '\0';
		lptr = line;
		ll = strlen (lptr) + 1; /* including zero. */
	  }
	  for (i = 0; i < std::min (ll, cbReturnBuffer - cb - 1); i++)
		lpszReturnBuffer[cb + i] = lptr[i];
	  cb += i;
	}
  }

  /* Done. */
done:
  fclose (f);

  if (cb == 0) {
	ll = strlen (lpszDefault);
	if (lpszEntry == NULL) ll++;
	ll = std::min (ll, cbReturnBuffer - 1);
	for (i = 0; i < ll ; i++, cb++)
	  lpszReturnBuffer[i] = lpszDefault[i];
  }

  lpszReturnBuffer[cb++] = '\0';
  return cb;
}

