/*************************************************************************
 *
 *  $RCSfile: effect.cxx,v $
 *
 *  $Revision: 1.24 $
 *
 *  last change: $Author: vg $ $Date: 2003/05/22 10:30:42 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <string> // HACK: prevent conflict between STLPORT and Workshop headers

#ifndef _COM_SUN_STAR_PRESENTATION_ANIMATIONEFFECT_HPP_
#include <com/sun/star/presentation/AnimationEffect.hpp>
#endif
#ifndef _COM_SUN_STAR_PRESENTATION_ANIMATIONSPEED_HPP_
#include <com/sun/star/presentation/AnimationSpeed.hpp>
#endif

#define ITEMID_COLOR SID_COLOR_TABLE

#include <svx/gallery.hxx>
#include <svx/colritem.hxx>
#ifndef _SFXDISPATCH_HXX //autogen
#include <sfx2/dispatch.hxx>
#endif
#ifndef _AEITEM_HXX //autogen
#include <svtools/aeitem.hxx>
#endif
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif

#include "sdattr.hxx"
#ifdef MAC
#ifdef ITEMID_COLOR
#undef ITEMID_COLOR
#endif
#endif

#define ITEMID_COLOR		ATTR_ANIMATION_COLOR

#define VALUESET_BACKGROUND	Color( 255, 255, 255 )

#include "effect.hxx"
#include "slidechg.hxx"	// fuer PreviewController
#include "effect.hrc"
#include "app.hrc"
#include "strings.hrc"
#include "res_bmp.hrc"
#include "sdresid.hxx"
#include "sdview.hxx"
#include "drawdoc.hxx"

using namespace ::com::sun::star;

SFX_IMPL_DOCKINGWINDOW( SdEffectChildWindow, SID_EFFECT_WIN)

/*************************************************************************
|*	SdAnimationWin - FloatingWindow
\************************************************************************/

SdEffectWin::SdEffectWin( SfxBindings* pInBindings,
				SfxChildWindow *pCW, Window* pParent, const SdResId& rSdResId ) :
		SfxDockingWindow    ( pInBindings, pCW, pParent, rSdResId ),

		aBtnVTEffect	( this, SdResId( BTN_VT_EFFECT ) ),
		aBtnVTTextEffect( this, SdResId( BTN_VT_TEXT_EFFECT ) ),
		aBtnVTExtras	( this, SdResId( BTN_VT_EXTRAS ) ),
		aBtnVTOrder		( this, SdResId( BTN_VT_ORDER ) ),
		aBtnPreview		( this, SdResId( BTN_PREVIEW ) ),
		aBtnUpdate		( this, SdResId( BTN_UPDATE ) ),
		aBtnAssign		( this, SdResId( BTN_ASSIGN ) ),

		aLbEffect		( this, SdResId( LB_EFFECT ) ),
		aCtlEffect		( this, SdResId( CTL_EFFECT ) ),
		aLbSpeed		( this, SdResId( LB_SPEED ) ),
		aGrpEffect		( this, SdResId( GRP_EFFECT ) ),

		aLbTextEffect	( this, SdResId( LB_TEXT_EFFECT ) ),
		aCtlTextEffect	( this, SdResId( CTL_TEXT_EFFECT ) ),

		aBtnInvisible	( this, SdResId( BTN_INVISIBLE ) ),
		aBtnFadeOut   	( this, SdResId( BTN_FADEOUT ) ),
		aLbFadeOutColor	( this, SdResId( LB_FADEOUT_COLOR ) ),
		aBtnSound   	( this, SdResId( BTN_SOUND ) ),
		aBtnPlayFull  	( this, SdResId( BTN_PLAY_FULL ) ),
		aBtnSearch    	( this, SdResId( BTN_SEARCH ) ),
		aLbSound     	( this, SdResId( LB_SOUND ) ),

		aTlbOrder    	( this, SdResId( TLB_ORDER ), pInBindings ),

		bBreakEven		( FALSE ),
		bUpdate			( FALSE ),
		bPathEffectAvailable( FALSE ),
		bCount			( FALSE ),
		eViewType		( VIEWTYPE_EFFECT ),

		pBindings		( pInBindings ),
		ppStringIdList	( NULL ),
		ppStringIdListTE( NULL ),
		ppBitmapIdList	( NULL ),
		ppBitmapIdListTE( NULL ),
		pSoundList		( NULL ),
		bTextEffectsAllowed( FALSE )
{
	FreeResource();

	// set high contrast images
	
	aBtnVTEffect.SetModeImage( Image( SdResId( IMG_EFFECT_H ) ), BMP_COLOR_HIGHCONTRAST );
	aBtnVTTextEffect.SetModeImage( Image( SdResId( IMG_TEXT_H ) ), BMP_COLOR_HIGHCONTRAST );
	aBtnVTExtras.SetModeImage( Image( SdResId( IMG_EXTRAS_H ) ), BMP_COLOR_HIGHCONTRAST );
	aBtnVTOrder.SetModeImage( Image( SdResId( IMG_EFFECT_ORDER_H ) ), BMP_COLOR_HIGHCONTRAST );
	aBtnPreview.SetModeImage( Image( SdResId( IMG_PREVIEW_H ) ), BMP_COLOR_HIGHCONTRAST );
	aBtnUpdate.SetModeImage( Image( SdResId( IMG_PIPETTE_H ) ), BMP_COLOR_HIGHCONTRAST );
	aBtnAssign.SetModeImage( Image( SdResId( IMG_APPLY_H ) ), BMP_COLOR_HIGHCONTRAST );
	aBtnInvisible.SetModeImage( Image( SdResId( IMG_INVISIBLE_H ) ), BMP_COLOR_HIGHCONTRAST );
	aBtnFadeOut.SetModeImage( Image( SdResId( IMG_FADEOUT_H ) ), BMP_COLOR_HIGHCONTRAST );
	aBtnSound.SetModeImage( Image( SdResId( IMG_SOUND_H ) ), BMP_COLOR_HIGHCONTRAST );
	aBtnPlayFull.SetModeImage( Image( SdResId( IMG_PLAYFULL_H ) ), BMP_COLOR_HIGHCONTRAST );
	aBtnSearch.SetModeImage( Image( SdResId( IMG_BROWSE_H ) ), BMP_COLOR_HIGHCONTRAST );

	pControllerItem = new SdEffectCtrlItem( SID_EFFECT_STATE, this, pBindings );
	pEffectPrevCtrlItem = new SdEffectPrevCtrlItem( SID_PREVIEW_WIN, this, pBindings );

	Link aLink( LINK( this, SdEffectWin, ClickViewTypeHdl ) );
	aBtnVTEffect.SetClickHdl( aLink );
	aBtnVTTextEffect.SetClickHdl( aLink );
	aBtnVTExtras.SetClickHdl( aLink );
	aBtnVTOrder.SetClickHdl( aLink );

	aBtnPreview.SetClickHdl( LINK( this, SdEffectWin, ClickPreviewHdl ) );
	aBtnAssign.SetClickHdl( LINK( this, SdEffectWin, ClickAssignHdl ) );
	aBtnUpdate.SetClickHdl( LINK( this, SdEffectWin, ClickUpdateHdl ) );

	// Effekte
	aLbEffect.SetSelectHdl( LINK( this, SdEffectWin, SelectEffectHdl ) );
	aCtlEffect.SetSelectHdl( LINK( this, SdEffectWin, SelectEffectHdl ) );
	aCtlEffect.SetDoubleClickHdl( LINK( this, SdEffectWin, DoubleClickHdl ) );

	// TextEffekte
	aLbTextEffect.SetSelectHdl( LINK( this, SdEffectWin, SelectTextEffectHdl ) );
	aCtlTextEffect.SetSelectHdl( LINK( this, SdEffectWin, SelectTextEffectHdl ) );
	aCtlTextEffect.SetDoubleClickHdl( LINK( this, SdEffectWin, DoubleClickHdl ) );

	// Extras
	aBtnInvisible.SetClickHdl( LINK( this, SdEffectWin, ClickInvisibleHdl ) );
	aBtnFadeOut.SetClickHdl( LINK( this, SdEffectWin, ClickFadeOutHdl ) );
	aBtnSound.SetClickHdl( LINK( this, SdEffectWin, ClickSoundHdl ) );
	aBtnSearch.SetClickHdl( LINK( this, SdEffectWin, ClickSearchHdl ) );
	aLbSound.SetSelectHdl( LINK( this, SdEffectWin, SelectSoundHdl ) );

	// "normale" CheckButtons
	aBtnPlayFull.SetClickHdl( LINK( this, SdEffectWin, ClickImageButtonHdl ) );

	aSize = GetOutputSizePixel();
	SetMinOutputSizePixel( aSize );

	aValueSetHeight = (USHORT) aCtlEffect.GetOutputSizePixel().Height();
	// Hoehe der Extras-Gruppe berechnen
	aExtrasHeight = aLbSound.GetPosPixel().Y() + 18 + 20;
	aBreakEvenHeight = aSize.Height() + aExtrasHeight;

	// Y-Position der Extras-Controls
	aBtnInvisiblePosY = (USHORT) aBtnInvisible.GetPosPixel().Y();
	aBtnFadeOutPosY = (USHORT) aBtnFadeOut.GetPosPixel().Y();
	aLbFadeOutColorPosY = (USHORT) aLbFadeOutColor.GetPosPixel().Y();
	aBtnSoundPosY = (USHORT) aBtnSound.GetPosPixel().Y();
	aBtnPlayFullPosY = (USHORT) aBtnPlayFull.GetPosPixel().Y();
	aBtnSearchPosY = (USHORT) aBtnSearch.GetPosPixel().Y();
	aLbSoundPosY = (USHORT) aLbSound.GetPosPixel().Y();

	Construct();

	// ViewType-Button initialisieren
	ClickViewTypeHdl( NULL );

	Reset();

	// Initiierung der Initialisierung der ColorLBs
	SfxBoolItem aItem( SID_EFFECT_INIT, TRUE );
	GetBindings().GetDispatcher()->Execute( 
		SID_EFFECT_INIT, SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD, &aItem, 0L );

	// set to default
	ClickViewTypeHdl( &aBtnVTEffect );
	aBtnVTExtras.Enable( FALSE );
	aBtnVTOrder.Enable( FALSE );
	aBtnVTTextEffect.Enable( FALSE );

}

// -----------------------------------------------------------------------

SdEffectWin::~SdEffectWin()
{
	delete pControllerItem;
	delete pEffectPrevCtrlItem;

	// Listen bereinigen
	List* pList;
	ULONG i;

	for( pList = (List*) ppStringIdList->First();
		 pList;
		 pList = (List*) ppStringIdList->Next() )
	{
		pList->Clear();
		// identische Zeiger werden entfernt
		ppStringIdListTE->Remove( pList );

		delete pList;
	}
	ppStringIdList->Clear();

	// TextListen koennen andere Listen besitzen (siehe Sonstiges)
	ULONG nCount = ppStringIdListTE->Count();
	if( nCount > 0 )
	{
		for( i = 0, pList = (List*) ppStringIdListTE->First();
			 i < nCount;
			 i++, pList = (List*) ppStringIdListTE->Next() )
		{
			if( pList )
			{
				pList->Clear();
				delete pList;
			}
		}
	}
	ppStringIdListTE->Clear();

	for( pList = (List*) ppBitmapIdList->First();
		 pList;
		 pList = (List*) ppBitmapIdList->Next() )
	{
		pList->Clear();
		// identische Zeiger werden entfernt
		ppBitmapIdListTE->Remove( pList );

		delete pList;
	}
	ppBitmapIdList->Clear();

	for( pList = (List*) ppHCBitmapIdList->First();
		 pList;
		 pList = (List*) ppHCBitmapIdList->Next() )
	{
		pList->Clear();
		// identische Zeiger werden entfernt
		ppHCBitmapIdListTE->Remove( pList );

		delete pList;
	}
	ppHCBitmapIdList->Clear();

	// TextListen koennen andere Listen besitzen (siehe Sonstiges)
	nCount = ppBitmapIdListTE->Count();
	if( nCount > 0 )
	{
		for( i = 0, pList = (List*) ppBitmapIdListTE->First();
			 i < nCount;
			 i++, pList = (List*) ppBitmapIdListTE->Next() )
		{
			if( pList )
			{
				pList->Clear();
				delete pList;
			}
		}
	}
	ppBitmapIdListTE->Clear();

	// --
	nCount = ppHCBitmapIdListTE->Count();
	if( nCount > 0 )
	{
		for( i = 0, pList = (List*) ppHCBitmapIdListTE->First();
			 i < nCount;
			 i++, pList = (List*) ppHCBitmapIdListTE->Next() )
		{
			if( pList )
			{
				pList->Clear();
				delete pList;
			}
		}
	}
	ppHCBitmapIdListTE->Clear();


	// Soundliste
	ClearSoundList();

	delete ppStringIdList;
	delete ppBitmapIdList;
	delete ppStringIdListTE;
	delete ppBitmapIdListTE;
	delete pSoundList;
}

// -----------------------------------------------------------------------

void SdEffectWin::Construct()
{
	// Listen aufbauen
	ppStringIdList = new List();
	ppBitmapIdList = new List();
	ppHCBitmapIdList = new List();

	// Listen fuer TextEffekte
	ppStringIdListTE = new List();
	ppBitmapIdListTE = new List();
	ppHCBitmapIdListTE = new List();

	// Kein Effekt (Jetzt Favoriten (nur fuer Effekte))
	List* pStringList = new List();
	ppStringIdList->Insert( pStringList, LIST_APPEND );

	List* pBitmapList = new List();
	ppBitmapIdList->Insert( pBitmapList, LIST_APPEND );
	
	List* pHCBitmapList = new List();
	ppHCBitmapIdList->Insert( pHCBitmapList, LIST_APPEND );

	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_FAVOURITES), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_NONE), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_NONE), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_NONE_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_DISCARD_FROM_L), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_DISCARD_FROM_L), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_DISCARD_FROM_L_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_LASER_FROM_UR), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_LASER_FROM_UR), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_LASER_FROM_UR_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_PATH), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_PATH), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_PATH_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_DISCARD_FROM_T), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_DISCARD_FROM_T), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_DISCARD_FROM_T_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_DISCARD_FROM_T), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_TEXTEFFECT_DISCARD_FROM_T), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_TEXTEFFECT_DISCARD_FROM_T_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_DISSOLVE), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_DISSOLVE), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_DISSOLVE_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_FADE_FROM_CENTER), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_FADE_FROM_CENTER), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_FADE_FROM_CENTER_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_FADE_FROM_CENTER), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_TEXTEFFECT_FADE_FROM_CENTER), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_TEXTEFFECT_FADE_FROM_CNTR_H), LIST_APPEND );

	// Kein Effekt (nur fuer Texteffekte)
	pStringList = new List();
	ppStringIdListTE->Insert( pStringList, LIST_APPEND );

	pBitmapList = new List();
	ppBitmapIdListTE->Insert( pBitmapList, LIST_APPEND );

	pHCBitmapList = new List();
	ppHCBitmapIdListTE->Insert( pHCBitmapList, LIST_APPEND );

	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_NONE), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	
	for( USHORT i = 1; i <= 9; i++ )
	{
		pStringList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
		pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
		pHCBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	}

	// Ueberblenden
	pStringList = new List();
	ppStringIdList->Insert( pStringList, LIST_APPEND );
	ppStringIdListTE->Insert( pStringList, LIST_APPEND );

	pBitmapList = new List();
	ppBitmapIdList->Insert( pBitmapList, LIST_APPEND );
	ppBitmapIdListTE->Insert( pBitmapList, LIST_APPEND );

	pHCBitmapList = new List();
	ppHCBitmapIdList->Insert( pHCBitmapList, LIST_APPEND );
	ppHCBitmapIdListTE->Insert( pHCBitmapList, LIST_APPEND );

	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_FADEFROM), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );

	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_FADE_FROM_UL), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_FADE_FROM_UL), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_FADE_FROM_UL_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_FADE_FROM_T), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_FADE_FROM_T), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_FADE_FROM_T_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_FADE_FROM_UR), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_FADE_FROM_UR), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_FADE_FROM_UR_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_FADE_FROM_L), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_FADE_FROM_L), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_FADE_FROM_L_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_FADE_FROM_R), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_FADE_FROM_R), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_FADE_FROM_R_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_FADE_FROM_LL), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_FADE_FROM_LL), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_FADE_FROM_LL_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_FADE_FROM_B), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_FADE_FROM_B), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_FADE_FROM_B_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_FADE_FROM_LR), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_FADE_FROM_LR), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_FADE_FROM_LR_H), LIST_APPEND );

	// Aufdecken (Jetzt auch TextEffekt)
	pStringList = new List();
	ppStringIdList->Insert( pStringList, LIST_APPEND );
	ppStringIdListTE->Insert( pStringList, LIST_APPEND );

	pBitmapList = new List();
	ppBitmapIdList->Insert( pBitmapList, LIST_APPEND );
	ppBitmapIdListTE->Insert( pBitmapList, LIST_APPEND );

	pHCBitmapList = new List();
	ppHCBitmapIdList->Insert( pHCBitmapList, LIST_APPEND );
	ppHCBitmapIdListTE->Insert( pHCBitmapList, LIST_APPEND );

	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_DISCARD), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );

	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_DISCARD_FROM_UL), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_DISCARD_FROM_UL), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_DISCARD_FROM_UL_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_DISCARD_FROM_T), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_DISCARD_FROM_T), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_DISCARD_FROM_T_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_DISCARD_FROM_UR), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_DISCARD_FROM_UR), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_DISCARD_FROM_UR_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_DISCARD_FROM_L), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_DISCARD_FROM_L), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_DISCARD_FROM_L_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_DISCARD_FROM_R), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_DISCARD_FROM_R), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_DISCARD_FROM_R_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_DISCARD_FROM_LL), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_DISCARD_FROM_LL), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_DISCARD_FROM_LL_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_DISCARD_FROM_B), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_DISCARD_FROM_B), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_DISCARD_FROM_B_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_DISCARD_FROM_LR), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_DISCARD_FROM_LR), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_DISCARD_FROM_LR_H), LIST_APPEND );

	// verkuerzt Aufdecken (auch TextEffekt)
	pStringList = new List();
	ppStringIdList->Insert( pStringList, LIST_APPEND );
	ppStringIdListTE->Insert( pStringList, LIST_APPEND );

	pBitmapList = new List();
	ppBitmapIdList->Insert( pBitmapList, LIST_APPEND );
	ppBitmapIdListTE->Insert( pBitmapList, LIST_APPEND );

	pHCBitmapList = new List();
	ppHCBitmapIdList->Insert( pHCBitmapList, LIST_APPEND );
	ppHCBitmapIdListTE->Insert( pHCBitmapList, LIST_APPEND );

	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_DISCARD_SHORT), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );

	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_DISCARD_S_FROM_UL), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_DISCARD_S_FROM_UL), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_DISCARD_S_FROM_UL_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_DISCARD_S_FROM_T), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_DISCARD_S_FROM_T), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_DISCARD_S_FROM_T_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_DISCARD_S_FROM_UR), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_DISCARD_S_FROM_UR), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_DISCARD_S_FROM_UR_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_DISCARD_S_FROM_L), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_DISCARD_S_FROM_L), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_DISCARD_S_FROM_L_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_DISCARD_S_FROM_R), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_DISCARD_S_FROM_R), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_DISCARD_S_FROM_R_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_DISCARD_S_FROM_LL), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_DISCARD_S_FROM_LL), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_DISCARD_S_FROM_LL_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_DISCARD_S_FROM_B), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_DISCARD_S_FROM_B), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_DISCARD_S_FROM_B_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_DISCARD_S_FROM_LR), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_DISCARD_S_FROM_LR), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_DISCARD_S_FROM_LR_H), LIST_APPEND );

	// Dehnen (auch TextEffekt)
	pStringList = new List();
	ppStringIdList->Insert( pStringList, LIST_APPEND );
	ppStringIdListTE->Insert( pStringList, LIST_APPEND );

	pBitmapList = new List();
	ppBitmapIdList->Insert( pBitmapList, LIST_APPEND );
	ppBitmapIdListTE->Insert( pBitmapList, LIST_APPEND );

	pHCBitmapList = new List();
	ppHCBitmapIdList->Insert( pHCBitmapList, LIST_APPEND );
	ppHCBitmapIdListTE->Insert( pHCBitmapList, LIST_APPEND );

	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_STRTCH), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );

	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_STRTCH_FROM_UL), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_STRTCH_FROM_UL), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_STRTCH_FROM_UL_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_STRTCH_FROM_T), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_STRTCH_FROM_T), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_STRTCH_FROM_T_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_STRTCH_FROM_UR), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_STRTCH_FROM_UR), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_STRTCH_FROM_UR_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_STRTCH_FROM_L), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_STRTCH_FROM_L), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_STRTCH_FROM_L_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_STRTCH_FROM_R), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_STRTCH_FROM_R), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_STRTCH_FROM_R_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_STRTCH_FROM_LL), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_STRTCH_FROM_LL), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_STRTCH_FROM_LL_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_STRTCH_FROM_B), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_STRTCH_FROM_B), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_STRTCH_FROM_B_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_STRTCH_FROM_LR), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_STRTCH_FROM_LR), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_STRTCH_FROM_LR_H), LIST_APPEND );

	// Dehnen und Rotieren (auch TextEffekt)
	pStringList = new List();
	ppStringIdList->Insert( pStringList, LIST_APPEND );
	ppStringIdListTE->Insert( pStringList, LIST_APPEND );

	pBitmapList = new List();
	ppBitmapIdList->Insert( pBitmapList, LIST_APPEND );
	ppBitmapIdListTE->Insert( pBitmapList, LIST_APPEND );

	pHCBitmapList = new List();
	ppHCBitmapIdList->Insert( pHCBitmapList, LIST_APPEND );
	ppHCBitmapIdListTE->Insert( pHCBitmapList, LIST_APPEND );

	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_STRTCH_ROTATE), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );

	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_STRTCH_HORIZONTAL), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_STRTCH_HORIZONTAL), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_STRTCH_HORIZONTAL_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_STRTCH_VERTICAL), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_STRTCH_VERTICAL), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_STRTCH_VERTICAL_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_ROTATE_HORIZONTAL), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_ROTATE_HORIZONTAL), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_ROTATE_HORIZONTAL_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_ROTATE_VERTICAL), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_ROTATE_VERTICAL), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_ROTATE_VERTICAL_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );

	// Blenden
	pStringList = new List();
	ppStringIdList->Insert( pStringList, LIST_APPEND );
	ppStringIdListTE->Insert( pStringList, LIST_APPEND );

	pBitmapList = new List();
	ppBitmapIdList->Insert( pBitmapList, LIST_APPEND );
	ppBitmapIdListTE->Insert( pBitmapList, LIST_APPEND );

	pHCBitmapList = new List();
	ppHCBitmapIdList->Insert( pHCBitmapList, LIST_APPEND );
	ppHCBitmapIdListTE->Insert( pHCBitmapList, LIST_APPEND );

	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_FADE), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );

	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_FADE_TO_CENTER), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_FADE_TO_CENTER), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_FADE_TO_CENTER_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_FADE_FROM_CENTER), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_FADE_FROM_CENTER), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_FADE_FROM_CENTER_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_VERTICAL_STRIPES), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_VERTICAL_STRIPES), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_VERTICAL_STRIPES_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_HORIZONTAL_STRIPES), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_HORIZONTAL_STRIPES), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_HORIZONTAL_STRIPES_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_CLOCKWISE), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_CLOCKWISE), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_CLOCKWISE_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_COUNTERCLOCKWISE), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_COUNTERCLOCKWISE), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_COUNTERCLOCKWISE_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );

	// Oeffnen / Schliessen
	pStringList = new List();
	ppStringIdList->Insert( pStringList, LIST_APPEND );
	ppStringIdListTE->Insert( pStringList, LIST_APPEND );

	pBitmapList = new List();
	ppBitmapIdList->Insert( pBitmapList, LIST_APPEND );
	ppBitmapIdListTE->Insert( pBitmapList, LIST_APPEND );

	pHCBitmapList = new List();
	ppHCBitmapIdList->Insert( pHCBitmapList, LIST_APPEND );
	ppHCBitmapIdListTE->Insert( pHCBitmapList, LIST_APPEND );

	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_OPEN_CLOSE), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );

	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_OPEN_VERTICAL), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_OPEN_VERTICAL), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_OPEN_VERTICAL_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_OPEN_HORIZONTAL), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_OPEN_HORIZONTAL), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_OPEN_HORIZONTAL_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_CLOSE_VERTICAL), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_CLOSE_VERTICAL), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_CLOSE_VERTICAL_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_CLOSE_HORIZONTAL), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_CLOSE_HORIZONTAL), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_CLOSE_HORIZONTAL_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );

	// Schlangenlinie
	pStringList = new List();
	ppStringIdList->Insert( pStringList, LIST_APPEND );
	ppStringIdListTE->Insert( pStringList, LIST_APPEND );

	pBitmapList = new List();
	ppBitmapIdList->Insert( pBitmapList, LIST_APPEND );
	ppBitmapIdListTE->Insert( pBitmapList, LIST_APPEND );

	pHCBitmapList = new List();
	ppHCBitmapIdList->Insert( pHCBitmapList, LIST_APPEND );
	ppHCBitmapIdListTE->Insert( pHCBitmapList, LIST_APPEND );

	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_WAVYLINE), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );

	pStringList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_WAVYLINE_FROM_T), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_WAVYLINE_FROM_T), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_WAVYLINE_FROM_T_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_WAVYLINE_FROM_L), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_WAVYLINE_FROM_L), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_WAVYLINE_FROM_L_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_WAVYLINE_FROM_R), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_WAVYLINE_FROM_R), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_WAVYLINE_FROM_R_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_WAVYLINE_FROM_B), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_WAVYLINE_FROM_B), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_WAVYLINE_FROM_B_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );

	// Spirale
	pStringList = new List();
	ppStringIdList->Insert( pStringList, LIST_APPEND );
	ppStringIdListTE->Insert( pStringList, LIST_APPEND );

	pBitmapList = new List();
	ppBitmapIdList->Insert( pBitmapList, LIST_APPEND );
	ppBitmapIdListTE->Insert( pBitmapList, LIST_APPEND );

	pHCBitmapList = new List();
	ppHCBitmapIdList->Insert( pHCBitmapList, LIST_APPEND );
	ppHCBitmapIdListTE->Insert( pHCBitmapList, LIST_APPEND );

	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_SPIRAL), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_SPIRALIN_L), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_SPIRALIN_L), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_SPIRALIN_L_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_SPIRALIN_R), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_SPIRALIN_R), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_SPIRALIN_R_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_SPIRALOUT_L), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_SPIRALOUT_L), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_SPIRALOUT_L_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_SPIRALOUT_R), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_SPIRALOUT_R), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_SPIRALOUT_R_H), LIST_APPEND );

	// Laser (nur TextEffekt (zumindest fuer den Benutzer) )
	pStringList = new List();
	ppStringIdListTE->Insert( pStringList, LIST_APPEND );

	pBitmapList = new List();
	ppBitmapIdListTE->Insert( pBitmapList, LIST_APPEND );

	pHCBitmapList = new List();
	ppHCBitmapIdListTE->Insert( pHCBitmapList, LIST_APPEND );

	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_LASER), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );

	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_LASER_FROM_UL), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_LASER_FROM_UL), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_LASER_FROM_UL_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_LASER_FROM_T), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_LASER_FROM_T), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_LASER_FROM_T_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_LASER_FROM_UR), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_LASER_FROM_UR), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_LASER_FROM_UR_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_LASER_FROM_L), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_LASER_FROM_L), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_LASER_FROM_L_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_LASER_FROM_R), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_LASER_FROM_R), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_LASER_FROM_R_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_LASER_FROM_LL), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_LASER_FROM_LL), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_LASER_FROM_LL_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_LASER_FROM_B), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_LASER_FROM_B), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_LASER_FROM_B_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_LASER_FROM_LR), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_LASER_FROM_LR), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_LASER_FROM_LR_H), LIST_APPEND );

	// Extras ("An Kurve entlang" und "Automatisch" nicht fuer TextEffekt)
	pStringList = new List();
	ppStringIdList->Insert( pStringList, LIST_APPEND );

	pBitmapList = new List();
	ppBitmapIdList->Insert( pBitmapList, LIST_APPEND );

	pHCBitmapList = new List();
	ppHCBitmapIdList->Insert( pHCBitmapList, LIST_APPEND );

	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_EXTRA), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );

	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_VERTICAL_LINES), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_VERTICAL_LINES), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_VERTICAL_LINES_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_HORIZONTAL_LINES), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_HORIZONTAL_LINES), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_HORIZONTAL_LINES_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_DISSOLVE), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_DISSOLVE), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_DISSOLVE_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_VERTICAL_CHECKERBOARD), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_VERTICAL_CHECKERBOARD), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_VERT_CHECKBRD_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_HORIZONTAL_CHECKERBOARD), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_HORIZONTAL_CHECKERBOARD), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_HOR_CHECKBRD_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_APPEAR), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_APPEAR), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_APPEAR_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_HIDE), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_HIDE), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_HIDE_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_PATH), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_PATH), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_PATH_H), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_RANDOM), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_RANDOM), LIST_APPEND );
	pHCBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_RANDOM_H), LIST_APPEND );

	// Extras fuer Texteffekte
	List* pStringListTE = new List( *pStringList );
	List* pBitmapListTE = new List( *pBitmapList );
	List* pHCBitmapListTE = new List( *pHCBitmapList );

	pStringListTE->Replace( (void*) ((ULONG) 0), 7 ); // Ausblenden
	pBitmapListTE->Replace( (void*) ((ULONG) 0), 7 );
	pHCBitmapListTE->Replace( (void*) ((ULONG) 0), 7 );
	pStringListTE->Replace( (void*) ((ULONG) 0), 8 ); // Pfad
	pBitmapListTE->Replace( (void*) ((ULONG) 0), 8 );
	pHCBitmapListTE->Replace( (void*) ((ULONG) 0), 8 );
	pStringListTE->Replace( (void*) ((ULONG) 0), 9 ); // Automatisch
	pBitmapListTE->Replace( (void*) ((ULONG) 0), 9 );
	pHCBitmapListTE->Replace( (void*) ((ULONG) 0), 9 );

	ppStringIdListTE->Insert( pStringListTE, LIST_APPEND );
	ppBitmapIdListTE->Insert( pBitmapListTE, LIST_APPEND );
	ppHCBitmapIdListTE->Insert( pHCBitmapListTE, LIST_APPEND );

	const Color aValueSetColor( VALUESET_BACKGROUND ); 

	// ValueSet Effect
	aCtlEffect.SetStyle( aCtlEffect.GetStyle() | WB_3DLOOK | WB_ITEMBORDER | WB_DOUBLEBORDER | WB_FLATVALUESET | WB_NAMEFIELD );
//	aCtlEffect.SetBackground( Wallpaper( aValueSetColor ) );
//	aCtlEffect.SetControlBackground( aValueSetColor );
//	aCtlEffect.SetColor( aValueSetColor );
	aCtlEffect.SetColCount( 3 );
	aCtlEffect.SetLineCount( 3 );
	aCtlEffect.SetExtraSpacing( 2 );
	aCtlEffect.Show();

	// Listbox Effect
	for( i = 0; i < ppStringIdList->Count(); i++ )
		aLbEffect.InsertEntry( String( SdResId( GetStringId( 0, i, &aCtlEffect ) ) ) );

	// ValueSet TextEffect
	aCtlTextEffect.SetStyle( aCtlTextEffect.GetStyle() | WB_3DLOOK | WB_ITEMBORDER | WB_DOUBLEBORDER | WB_FLATVALUESET | WB_NAMEFIELD );
//	aCtlTextEffect.SetBackground( Wallpaper( aValueSetColor ) );
//	aCtlTextEffect.SetControlBackground( aValueSetColor );
//	aCtlTextEffect.SetColor( aValueSetColor );
	aCtlTextEffect.SetColCount( 3 );
	aCtlTextEffect.SetLineCount( 3 );
	aCtlTextEffect.SetExtraSpacing( 2 );
	//aCtlTextEffect.Show();

	// Listbox TextEffect
	for( i = 0; i < ppStringIdListTE->Count(); i++ )
		aLbTextEffect.InsertEntry( String( SdResId( GetStringId( 0, i, &aCtlTextEffect ) ) ) );

	// Sound-Namenliste aufbauen
	pSoundList = new List();
	FillSoundListAndBox();

    // Set the quick help text as accessibility name.  This avoids changing
    // the resource.  This, by copying QuickHelpText to Text, should be done
    // sometime in the future.
    aBtnVTEffect.SetAccessibleName (aBtnVTEffect.GetQuickHelpText());
    aBtnVTTextEffect.SetAccessibleName (aBtnVTTextEffect.GetQuickHelpText());
    aBtnVTExtras.SetAccessibleName (aBtnVTExtras.GetQuickHelpText());
    aBtnVTOrder.SetAccessibleName (aBtnVTOrder.GetQuickHelpText());
    aBtnUpdate.SetAccessibleName (aBtnUpdate.GetQuickHelpText());
    aBtnAssign.SetAccessibleName (aBtnAssign.GetQuickHelpText());
    aBtnPreview.SetAccessibleName (aBtnPreview.GetQuickHelpText());
}

// -----------------------------------------------------------------------

void SdEffectWin::Reset()
{
	ClickUpdateHdl( NULL );

	aLbSpeed.SelectEntryPos( 1 );
	aLbEffect.SelectEntryPos( 0 );
	aLbTextEffect.SelectEntryPos( 0 );

	SelectEffectHdl( NULL );
	SelectTextEffectHdl( NULL );
	//ClickAnimationHdl( NULL );
	ClickInvisibleHdl( NULL );
	ClickFadeOutHdl( NULL );
	ClickSoundHdl( NULL );
}

// -----------------------------------------------------------------------

void SdEffectWin::Update( SfxItemSet& rAttrs )
{
	presentation::AnimationEffect   eAE = presentation::AnimationEffect_NONE;
	presentation::AnimationEffect   eTE = presentation::AnimationEffect_NONE;
	presentation::AnimationSpeed    eAS;

	// *** Effekt ***
	if( rAttrs.GetItemState( ATTR_ANIMATION_EFFECT ) != SFX_ITEM_UNKNOWN &&
        rAttrs.GetItemState( ATTR_ANIMATION_EFFECT ) != SFX_ITEM_DONTCARE &&
        rAttrs.GetItemState( ATTR_ANIMATION_EFFECT ) != SFX_ITEM_DISABLED )
	{
		eAE = (presentation::AnimationEffect) ( ( const SfxAllEnumItem& ) rAttrs.Get( ATTR_ANIMATION_EFFECT ) ).GetValue();

		if( eAE != presentation::AnimationEffect_NONE )
		{
			// Animation (ja/nein) wird jetzt hier ausgewertet und ueber Effekte dargestellt
			if( rAttrs.GetItemState( ATTR_ANIMATION_ACTIVE ) != SFX_ITEM_UNKNOWN &&
                rAttrs.GetItemState( ATTR_ANIMATION_ACTIVE ) != SFX_ITEM_DONTCARE &&
				!(( const SfxBoolItem& ) rAttrs.Get( ATTR_ANIMATION_ACTIVE )).GetValue() )
            {
				eAE = presentation::AnimationEffect_NONE;
            }
		}
		
        SetAnimationEffect( eAE, &aCtlEffect );
	}
	else
	{
		aLbEffect.SetNoSelection();
		aCtlEffect.Hide();
	}

	// *** TextEffekt ***
	if( rAttrs.GetItemState( ATTR_ANIMATION_TEXTEFFECT ) != SFX_ITEM_UNKNOWN &&
        rAttrs.GetItemState( ATTR_ANIMATION_TEXTEFFECT ) != SFX_ITEM_DONTCARE &&
        rAttrs.GetItemState( ATTR_ANIMATION_TEXTEFFECT ) != SFX_ITEM_DISABLED &&
        rAttrs.GetItemState( ATTR_ANIMATION_ACTIVE ) != SFX_ITEM_UNKNOWN &&
		rAttrs.GetItemState( ATTR_ANIMATION_ACTIVE ) != SFX_ITEM_DONTCARE  &&
		rAttrs.GetItemState( ATTR_ANIMATION_ACTIVE ) != SFX_ITEM_DISABLED )
	{
		eTE = (presentation::AnimationEffect) ( ( const SfxAllEnumItem& ) rAttrs.Get( ATTR_ANIMATION_TEXTEFFECT ) ).GetValue();

		if( eTE != presentation::AnimationEffect_NONE )
		{
			// Animation (ja/nein) wird jetzt hier ausgewertet und ueber Effekte dargestellt
			if( rAttrs.GetItemState( ATTR_ANIMATION_ACTIVE ) != SFX_ITEM_UNKNOWN &&
                rAttrs.GetItemState( ATTR_ANIMATION_ACTIVE ) != SFX_ITEM_DONTCARE &&
				!(( const SfxBoolItem& ) rAttrs.Get( ATTR_ANIMATION_ACTIVE )).GetValue() )
            {
				eTE = presentation::AnimationEffect_NONE;
            }
		}
		
        SetAnimationEffect( eTE, &aCtlTextEffect );
	}
	else
	{
		aLbTextEffect.SetNoSelection();
		aCtlTextEffect.Hide();
	}

	if( ( eAE != presentation::AnimationEffect_NONE ) || ( eTE != presentation::AnimationEffect_NONE ) )
	{
		// Animation Speed
		if( rAttrs.GetItemState( ATTR_ANIMATION_SPEED ) != SFX_ITEM_DONTCARE )
		{
			eAS = (presentation::AnimationSpeed) ( ( const SfxAllEnumItem& ) rAttrs.Get( ATTR_ANIMATION_SPEED ) ).GetValue();

			aLbSpeed.SelectEntryPos( eAS );
		}
		else
			aLbSpeed.SetNoSelection();

		/*** Extras ***/

		// Ausblenden (ja/nein)
		if( rAttrs.GetItemState( ATTR_ANIMATION_FADEOUT ) != SFX_ITEM_DONTCARE )
			aBtnFadeOut.Check( ( ( const SfxBoolItem& ) rAttrs.Get( ATTR_ANIMATION_FADEOUT ) ).GetValue() );
		else
			aBtnFadeOut.SetState( STATE_DONTKNOW );

		// Unsichtbar
		if( rAttrs.GetItemState( ATTR_ANIMATION_INVISIBLE ) != SFX_ITEM_DONTCARE )
			aBtnInvisible.Check( ( ( const SfxBoolItem& ) rAttrs.Get( ATTR_ANIMATION_INVISIBLE ) ).GetValue() );
		else
			aBtnInvisible.SetState( STATE_DONTKNOW );

		// unsichtbare Farbe
		const SfxPoolItem* pPoolItem;
		if( SFX_ITEM_DONTCARE != rAttrs.GetItemState( ATTR_ANIMATION_COLOR, FALSE, &pPoolItem ) )
		{
			Color aColor = ( ( const SvxColorItem* ) pPoolItem )->GetValue();
			aLbFadeOutColor.SelectEntry( aColor );
		}
		else
			aLbFadeOutColor.SetNoSelection();

		// Klang (ja/nein)
		if( rAttrs.GetItemState( ATTR_ANIMATION_SOUNDON ) != SFX_ITEM_DONTCARE )
        {
            const BOOL bSoundOn = ( ( const SfxBoolItem& ) rAttrs.Get( ATTR_ANIMATION_SOUNDON ) ).GetValue();
			aBtnSound.Check( bSoundOn );
        }
		else
			aBtnSound.SetState( STATE_DONTKNOW );

		if( rAttrs.GetItemState( ATTR_ANIMATION_SOUNDFILE ) != SFX_ITEM_DONTCARE )
		{
			String aStr( ( ( const SfxStringItem& ) rAttrs.Get( ATTR_ANIMATION_SOUNDFILE ) ).GetValue() );
			if( aStr.Len() )
			{
				long nPos = GetSoundObject( aStr );
				if( nPos < 0 )
				{
					ClearSoundList();
					aLbSound.Clear();

					GalleryExplorer::InsertURL( GALLERY_THEME_USERSOUNDS, aStr );
					FillSoundListAndBox();
					nPos = GetSoundObject( aStr );
					DBG_ASSERT( nPos >= 0, "Sound nicht in Liste!" );
				}
				if( nPos >= 0 )
					aLbSound.SelectEntryPos( (USHORT) nPos );
			}
			else
				aLbSound.SetNoSelection();
		}
		else
			aLbSound.SetNoSelection();

		// vollstaendig abspielen
		if( SFX_ITEM_DONTCARE != rAttrs.GetItemState( ATTR_ANIMATION_PLAYFULL, FALSE, &pPoolItem ) )
			aBtnPlayFull.Check( ( ( const SfxBoolItem& ) rAttrs.Get( ATTR_ANIMATION_PLAYFULL ) ).GetValue() );
		else
			aBtnPlayFull.SetState( STATE_DONTKNOW );

        if( !aBtnVTOrder.IsChecked() )
        {
            if( eAE != presentation::AnimationEffect_NONE )
    		    ClickViewTypeHdl( &aBtnVTEffect );
            else
    		    ClickViewTypeHdl( &aBtnVTTextEffect );
        }
	}
	else
	{
		if( !aBtnVTOrder.IsChecked() )
			ClickViewTypeHdl( &aBtnVTEffect );
	}

    const BOOL bEnableExtras = ( eAE != presentation::AnimationEffect_NONE ) || ( eTE != presentation::AnimationEffect_NONE );

	aBtnVTExtras.Enable( bEnableExtras );
	Resize(); // Because perhaps the elements of the extra paper are shown/not shown
	aBtnVTOrder.Enable( bEnableExtras );

	bTextEffectsAllowed = ( rAttrs.GetItemState( ATTR_ANIMATION_TEXTEFFECT ) != SFX_ITEM_DISABLED );

	//ClickAnimationHdl( NULL );
	SelectEffectHdl( &aCtlEffect );
	ClickInvisibleHdl( NULL );
	ClickFadeOutHdl( NULL );
	ClickSoundHdl( NULL );

	if( ( eAE != presentation::AnimationEffect_NONE && eViewType == VIEWTYPE_EFFECT ) ||
		( eTE != presentation::AnimationEffect_NONE && eViewType == VIEWTYPE_TEXT ) )
	{
		SelectSoundHdl( NULL );

		// Sicht wird geprueft und ggfs. geaendert
		// Text-Sicht ist aktiv aber kein Texteffekt aber ein normaler Effekt
		if( eTE == presentation::AnimationEffect_NONE && eViewType == VIEWTYPE_TEXT &&
			eAE != presentation::AnimationEffect_NONE )
		{
			if( !aBtnVTOrder.IsChecked() )
				ClickViewTypeHdl( &aBtnVTEffect );
		}
		else if( eAE == presentation::AnimationEffect_NONE && eTE != presentation::AnimationEffect_NONE )
		{
			USHORT nPos = aLbEffect.GetSelectEntryPos();
			// Favorit ?
			if( nPos == 0  )
			{
				USHORT nId  = aCtlEffect.GetSelectItemId();
				// Text-Favorit ?
				if( eViewType == VIEWTYPE_EFFECT && nId == 1 )
				{
					if( !aBtnVTOrder.IsChecked() )
						ClickViewTypeHdl( &aBtnVTTextEffect );
				}
				if( eViewType == VIEWTYPE_TEXT && nId > 1 ) // ausgew. Favorit
				{
					if( !aBtnVTOrder.IsChecked() )
						ClickViewTypeHdl( &aBtnVTEffect );
				}
			}
		}
	}

    if( aBtnVTOrder.IsChecked() )
        aTlbOrder.Update();
}

// -----------------------------------------------------------------------

void SdEffectWin::GetAttr( SfxItemSet& rAttrs )
{
	TriState eAE = STATE_DONTKNOW;
	TriState eTAE= STATE_DONTKNOW;

	// Effekt
	USHORT nPos = aLbEffect.GetSelectEntryPos();
	USHORT nId  = aCtlEffect.GetSelectItemId();

	// Favorit ?
	if( nPos == 0 && nId != 1 )
	{
		presentation::AnimationEffect eTmp = GetAnimationEffect( &aCtlEffect);
		switch( nId ) // Effekt
		{
			case 2:
			case 4:
			case 5:
			case 7:
			case 8:
				// Effekt ohne Texteffekt mit Sound
				rAttrs.Put( SfxAllEnumItem( ATTR_ANIMATION_EFFECT, eTmp ) );
				rAttrs.Put( SfxAllEnumItem( ATTR_ANIMATION_TEXTEFFECT, presentation::AnimationEffect_NONE ) );
				eAE = STATE_CHECK;
			break;

			case 3:
			case 6:
			case 9:
				// Texteffekt ohne Effekt mit Sound
				rAttrs.Put( SfxAllEnumItem( ATTR_ANIMATION_TEXTEFFECT, eTmp ) );
				rAttrs.Put( SfxAllEnumItem( ATTR_ANIMATION_EFFECT, presentation::AnimationEffect_NONE ) );
				eTAE = STATE_CHECK;
			break;
		}
	}
	else
	{
		// Effekt
		if( aBtnVTEffect.IsEnabled() && aLbEffect.GetSelectEntryCount() )
		{
			presentation::AnimationEffect eTmp = GetAnimationEffect( &aCtlEffect);
			rAttrs.Put( SfxAllEnumItem( ATTR_ANIMATION_EFFECT, eTmp ) );
			if( eTmp == presentation::AnimationEffect_NONE )
			{
				eAE = STATE_NOCHECK;
				// Hier wird jetzt der Sound zurueckgenommen, da dies
				// bei den Favoriten keinen Sinn macht (?!)
				//aBtnSound.SetState( STATE_NOCHECK );
				//aLbSound.SetNoSelection();
				//aLbSound.Enable( FALSE ); ...
				ClickSoundHdl( NULL );
			}
			else
				eAE = STATE_CHECK;
		}
		else
			rAttrs.InvalidateItem( ATTR_ANIMATION_EFFECT );

		// TextEffekt
		if( aBtnVTTextEffect.IsEnabled() && aLbTextEffect.GetSelectEntryCount() )
		{
			presentation::AnimationEffect eTmp = GetAnimationEffect( &aCtlTextEffect );
			rAttrs.Put( SfxAllEnumItem( ATTR_ANIMATION_TEXTEFFECT, eTmp ) );
			if( eTmp == presentation::AnimationEffect_NONE )
				eTAE = STATE_NOCHECK;
			else
				eTAE = STATE_CHECK;
		}
		else
			rAttrs.InvalidateItem( ATTR_ANIMATION_TEXTEFFECT );
	}
	// Animation (ja/nein) wird jetzt ueber Effekte ausgewertet
	if( eAE == STATE_NOCHECK && eAE == eTAE )
		rAttrs.Put( SfxBoolItem( ATTR_ANIMATION_ACTIVE, FALSE ) );
	else if( eAE == STATE_CHECK || eTAE == STATE_CHECK )
		rAttrs.Put( SfxBoolItem( ATTR_ANIMATION_ACTIVE, TRUE ) );
	else
		rAttrs.InvalidateItem( ATTR_ANIMATION_ACTIVE );


	// EffektSpeed
	nPos = aLbSpeed.GetSelectEntryPos();
	if( nPos == LISTBOX_ENTRY_NOTFOUND )
		rAttrs.InvalidateItem( ATTR_ANIMATION_SPEED );
	else
		rAttrs.Put( SfxAllEnumItem( ATTR_ANIMATION_SPEED, (presentation::AnimationSpeed) nPos ) );

	// Ausblenden (ja/nein)
	if( aBtnFadeOut.GetState() == STATE_DONTKNOW )
		rAttrs.InvalidateItem( ATTR_ANIMATION_FADEOUT );
	else
		rAttrs.Put( SfxBoolItem( ATTR_ANIMATION_FADEOUT, aBtnFadeOut.IsChecked() ) );

	// Unsichtbar
	if( aBtnInvisible.GetState() == STATE_DONTKNOW )
		rAttrs.InvalidateItem( ATTR_ANIMATION_INVISIBLE );
	else
		rAttrs.Put( SfxBoolItem( ATTR_ANIMATION_INVISIBLE, aBtnInvisible.IsChecked() ) );

	// unsichtbare Farbe
	if( aLbFadeOutColor.GetSelectEntryCount()  )
	{
		SvxColorItem aColorItem( aLbFadeOutColor.GetSelectEntryColor(),
								 ATTR_ANIMATION_COLOR );
		rAttrs.Put( aColorItem );
	}
	else
		rAttrs.InvalidateItem( ATTR_ANIMATION_COLOR );

	// Klang (ja/nein)
	if( aBtnSound.GetState() == STATE_DONTKNOW )
		rAttrs.InvalidateItem( ATTR_ANIMATION_SOUNDON );
	else
		rAttrs.Put( SfxBoolItem( ATTR_ANIMATION_SOUNDON, aBtnSound.IsChecked() ) );

	// Klang Name
	nPos = aLbSound.GetSelectEntryPos();
	if( nPos != LISTBOX_ENTRY_NOTFOUND )
	{
		String aName( *(String*)pSoundList->GetObject( (long)nPos ) );
		rAttrs.Put( SfxStringItem( ATTR_ANIMATION_SOUNDFILE, aName ) );
	}
	else
		rAttrs.InvalidateItem( ATTR_ANIMATION_SOUNDFILE );

	// vollstaendig abspielen
	if( aBtnPlayFull.GetState() == STATE_DONTKNOW )
		rAttrs.InvalidateItem( ATTR_ANIMATION_PLAYFULL );
	else
		rAttrs.Put( SfxBoolItem( ATTR_ANIMATION_PLAYFULL, aBtnPlayFull.IsChecked() ) );
}

// -----------------------------------------------------------------------

void SdEffectWin::Resize()
{
	if ( !IsFloatingMode() ||
		 !GetFloatingWindow()->IsRollUp() )
	{
		Size aWinSize( GetOutputSizePixel() ); // vorher rSize im Resizing()

		if( aWinSize.Height() >= GetMinOutputSizePixel().Height() &&
			aWinSize.Width() >= GetMinOutputSizePixel().Width() )
		{
            const BOOL bShowAll = aWinSize.Height() > aBreakEvenHeight;

			// Wenn mehr als eine Sicht angezeigt werden kann und
			// "Extras" aktiv ist, wird auf "Effekt" umgeschaltet
			if( bShowAll && eViewType == VIEWTYPE_EXTRAS )
				eViewType = VIEWTYPE_EFFECT;

			const BOOL  bCtlEffectVisible = ( VIEWTYPE_EFFECT == eViewType ) && aCtlEffect.IsVisible();
			const BOOL  bCtlTextEffectVisible = ( VIEWTYPE_TEXT == eViewType ) && aCtlTextEffect.IsVisible();

			Size aDiffSize;
			aDiffSize.Width() = aWinSize.Width() - aSize.Width();
			aDiffSize.Height() = aWinSize.Height() - aSize.Height();

			Point aXPt;
			Point aYPt;
			aXPt.X() = aDiffSize.Width();
			aYPt.Y() = aDiffSize.Height();

			// Verschieben der anderen Controls
			Size aObjSize;

			aBtnVTEffect.Hide();
			aBtnVTTextEffect.Hide();
			aBtnVTExtras.Hide();
			aBtnVTOrder.Hide();
			aBtnPreview.Hide();
			aBtnUpdate.Hide();
			aBtnAssign.Hide();
			aLbEffect.Hide();
			aCtlEffect.Hide();
			aLbSpeed.Hide();
			aGrpEffect.Hide();

			aLbTextEffect.Hide();
			aCtlTextEffect.Hide();

			aBtnInvisible.Hide();
			aBtnFadeOut.Hide();
			aLbFadeOutColor.Hide();
			aBtnSound.Hide();
			aBtnPlayFull.Hide();
			aBtnSearch.Hide();
			aLbSound.Hide();

			aTlbOrder.Hide();

			aBtnPreview.SetPosPixel( aBtnPreview.GetPosPixel() + aXPt );
			aBtnUpdate.SetPosPixel( aBtnUpdate.GetPosPixel() + aXPt );
			aBtnAssign.SetPosPixel( aBtnAssign.GetPosPixel() + aXPt );
			aBtnSearch.SetPosPixel( aBtnSearch.GetPosPixel() + aXPt );

			/*** TextEffekte ***/
			// LB TextEffect
			aObjSize = aLbTextEffect.GetOutputSizePixel();
			aObjSize.Width() += aDiffSize.Width();
			aLbTextEffect.SetOutputSizePixel( aObjSize );
			// ValueSet Effect
			aObjSize = aCtlTextEffect.GetOutputSizePixel();
			aObjSize.Width() += aDiffSize.Width();
			aObjSize.Height() += aDiffSize.Height();
			if( bBreakEven != bShowAll )
			{
				if( bShowAll )
					aObjSize.Height() -= aExtrasHeight;
				else
					aObjSize.Height() += aExtrasHeight;
			}
			// Um die minimale Groesse nicht zu unterschreiten
			if( aObjSize.Height() < aValueSetHeight )
			{
				long nTmp = aValueSetHeight - aObjSize.Height();
				aObjSize.Height() = aValueSetHeight;
			}
			aCtlTextEffect.SetOutputSizePixel( aObjSize );

			/*** Effekte ***/
			// LB Effect
			aObjSize = aLbEffect.GetOutputSizePixel();
			aObjSize.Width() += aDiffSize.Width();
			aLbEffect.SetOutputSizePixel( aObjSize );
			// ValueSet Effect
			aObjSize = aCtlEffect.GetOutputSizePixel();
			aObjSize.Width() += aDiffSize.Width();
			aObjSize.Height() += aDiffSize.Height();
			if( bBreakEven != bShowAll )
			{
				if( bShowAll )
				{
					aObjSize.Height() -= aExtrasHeight;
					aYPt.Y() -= aExtrasHeight;
				}
				else
				{
					aObjSize.Height() += aExtrasHeight;
					aYPt.Y() += aExtrasHeight;
				}
			}
			// Um die minimale Groesse nicht zu unterschreiten
			if( aObjSize.Height() < aValueSetHeight )
			{
				long nTmp = aValueSetHeight - aObjSize.Height();
				aObjSize.Height() = aValueSetHeight;
				aDiffSize.Height() += nTmp;
				aYPt.Y() = aDiffSize.Height();
			}
			aCtlEffect.SetOutputSizePixel( aObjSize );

			// LB Speed
			aObjSize = aLbSpeed.GetOutputSizePixel();
			aObjSize.Width() += aDiffSize.Width();
			aLbSpeed.SetPosPixel( aLbSpeed.GetPosPixel() + aYPt );
			aLbSpeed.SetOutputSizePixel( aObjSize );

			// TLB Order
			aObjSize = aTlbOrder.GetSizePixel();
			aObjSize.Width() += aDiffSize.Width();
			aObjSize.Height() += aDiffSize.Height();
			aTlbOrder.SetSizePixel( aObjSize );

			// GroupBox Effect
			aObjSize = aGrpEffect.GetOutputSizePixel();
			aObjSize.Width() += aDiffSize.Width();
			aGrpEffect.SetOutputSizePixel( aObjSize );


			if( bShowAll )
			{
				//aYPt.Y() = aCtlEffect.GetSizePixel().Height() - aValueSetHeight;
				//aYPt.Y() += aExtrasHeight;
				// Hoehe der Effekte-Gruppe berechnen
				USHORT aEffectsHeight = ( aLbSpeed.GetPosPixel().Y() -
								aLbEffect.GetPosPixel().Y() ) +
								aLbSpeed.GetSizePixel().Height() +
								20;
				aYPt.Y() = aEffectsHeight;
			}
			else
			{
				aYPt.Y() = 0;
			}

			/*** Extras ***/
			// LB FadeOutColor
			aObjSize = aLbFadeOutColor.GetOutputSizePixel();
			aObjSize.Width() += aDiffSize.Width();
			aLbFadeOutColor.SetOutputSizePixel( aObjSize );
			// Edit Sound
			aObjSize = aLbSound.GetSizePixel();
			aObjSize.Width() += aDiffSize.Width();
			aLbSound.SetSizePixel( aObjSize );

			// Y-Position der Extras Controls
			aBtnInvisible.SetPosPixel( Point(
				aBtnInvisible.GetPosPixel().X(), aBtnInvisiblePosY + aYPt.Y() ) );
			aBtnFadeOut.SetPosPixel( Point(
				aBtnFadeOut.GetPosPixel().X(), aBtnFadeOutPosY + aYPt.Y() ) );
			aLbFadeOutColor.SetPosPixel( Point(
				aLbFadeOutColor.GetPosPixel().X(), aLbFadeOutColorPosY + aYPt.Y() ) );
			aBtnSound.SetPosPixel( Point(
				aBtnSound.GetPosPixel().X(), aBtnSoundPosY + aYPt.Y() ) );
			aBtnPlayFull.SetPosPixel( Point(
				aBtnPlayFull.GetPosPixel().X(), aBtnPlayFullPosY + aYPt.Y() ) );
			aLbSound.SetPosPixel( Point(
				aLbSound.GetPosPixel().X(), aLbSoundPosY + aYPt.Y() ) );
			aBtnSearch.SetPosPixel( Point(
				aBtnSearch.GetPosPixel().X(), aBtnSearchPosY + aYPt.Y() ) );


			if( eViewType == VIEWTYPE_ORDER )
			{
				aTlbOrder.Show();
			}
			else
			{
				if( eViewType == VIEWTYPE_EFFECT )//|| bShowAll )
				{
					aLbEffect.Show();

                    if( bCtlEffectVisible )
					    aCtlEffect.Show();

					aLbSpeed.Show();
				}
				if( eViewType == VIEWTYPE_TEXT )//|| bShowAll )
				{
					aLbTextEffect.Show();

                    if( bCtlTextEffectVisible )
    					aCtlTextEffect.Show();

					aLbSpeed.Show(); // mal sehen...
				}
				if( eViewType == VIEWTYPE_EXTRAS || ( bShowAll && aBtnVTExtras.IsEnabled() ) )
				{
					aBtnInvisible.Show();
					aBtnFadeOut.Show();
					aLbFadeOutColor.Show();
					aBtnSound.Show();
					aBtnPlayFull.Show();
					aBtnSearch.Show();
					aLbSound.Show();
				}
			}

			//if( !bShowAll )
			aBtnVTEffect.Show();
			aBtnVTTextEffect.Show();
			aBtnVTExtras.Show();
			aBtnVTOrder.Show();
			aBtnPreview.Show();
			aBtnUpdate.Show();
			aBtnAssign.Show();
			aGrpEffect.Show();

			// Wurde der Zustand der Sichten geaendert
			if( bBreakEven != bShowAll )
			{
				String aStr;
				if( bShowAll && eViewType != VIEWTYPE_ORDER )
				{
					aStr  = String( SdResId( GetViewTypeResId( eViewType ) ) );
					aStr.AppendAscii( RTL_CONSTASCII_STRINGPARAM( " + " ) );
					aStr += String( SdResId( GetViewTypeResId( VIEWTYPE_EXTRAS ) ) );
				}
				else
					aStr  = String( SdResId( GetViewTypeResId( eViewType ) ) );

				aGrpEffect.SetText( aStr );
			}

			bBreakEven = bShowAll;

			aSize = aWinSize;

			ClickViewTypeHdl( NULL );
		}
	}
	SfxDockingWindow::Resize();
}

// -----------------------------------------------------------------------

BOOL SdEffectWin::Close()
{
	return( SfxDockingWindow::Close() );
}

/*************************************************************************
|*
|* Ableitung vom SfxChildWindow als "Behaelter" fuer Effekte
|*
\************************************************************************/

SdEffectChildWindow::SdEffectChildWindow( Window* pParent,
														 USHORT nId,
														 SfxBindings* pBindings,
														 SfxChildWinInfo* pInfo ) :
	SfxChildWindow( pParent, nId )
{
	SdEffectWin* pAnimWin = new SdEffectWin( pBindings, this, pParent,
										SdResId( FLT_WIN_EFFECT ) );
	pWindow = pAnimWin;

	eChildAlignment = SFX_ALIGN_NOALIGNMENT;

	pAnimWin->Initialize( pInfo );
}

/*************************************************************************
|*
|* ControllerItem fuer EffectStatus
|*
\************************************************************************/

SdEffectCtrlItem::SdEffectCtrlItem( USHORT nId,
								SdEffectWin* pWin,
								SfxBindings* pBindings) :
	SfxControllerItem( nId, *pBindings ),
	pEffectWin( pWin )
{
}

// -----------------------------------------------------------------------

void SdEffectCtrlItem::StateChanged( USHORT nSId,
						SfxItemState eState, const SfxPoolItem* pItem )
{
	if( eState >= SFX_ITEM_AVAILABLE && nSId == SID_EFFECT_STATE )
	{
		const SfxUInt32Item* pStateItem = PTR_CAST( SfxUInt32Item, pItem );
		DBG_ASSERT( pStateItem, "SfxUInt32Item erwartet");
		UINT32 nState = pStateItem->GetValue();

		pEffectWin->bCount = (BOOL) (nState & EFFECT_COUNT);
		pEffectWin->bPathEffectAvailable = (BOOL) (nState & EFFECT_PATH);

		pEffectWin->SelectEffectHdl( &pEffectWin->aCtlEffect );
		pEffectWin->SelectTextEffectHdl( &pEffectWin->aCtlTextEffect );

		// Reihenfolge updaten
		pEffectWin->aTlbOrder.Update();
	}
}

/*************************************************************************
|*
|* ControllerItem fuer Preview
|*
\************************************************************************/

SdEffectPrevCtrlItem::SdEffectPrevCtrlItem( USHORT nId,
								SdEffectWin* pInWin,
								SfxBindings* pBindings) :
	SfxControllerItem	( nId, *pBindings ),
	pWin				( pInWin )
{
}

// -----------------------------------------------------------------------

void SdEffectPrevCtrlItem::StateChanged( USHORT nSId,
						SfxItemState eState, const SfxPoolItem* pItem )
{
	if( eState >= SFX_ITEM_AVAILABLE && nSId == SID_PREVIEW_WIN )
	{
		const SfxBoolItem* pStateItem = PTR_CAST( SfxBoolItem, pItem );
		DBG_ASSERT( pStateItem, "SfxBoolItem erwartet");
		BOOL bState = pStateItem->GetValue();

		pWin->aBtnPreview.Check( bState );
	}
}


void SdEffectWin::DataChanged( const DataChangedEvent& rDCEvt )
{
	if ( (rDCEvt.GetType() == DATACHANGED_SETTINGS) && (rDCEvt.GetFlags() & SETTINGS_STYLE) )
	{
		if( eViewType == VIEWTYPE_EFFECT )
		{
			FillValueSet( &aCtlEffect );
		}
		else if( eViewType == VIEWTYPE_TEXT )
		{
			FillValueSet( &aCtlTextEffect );
		}
	}

    SfxDockingWindow::DataChanged( rDCEvt );
}
