/*************************************************************************
 *
 *  $RCSfile: dlggraut.hxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: bm $ $Date: 2002/08/28 11:24:16 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SCH_DLGGRAUT_HXX
#define _SCH_DLGGRAUT_HXX
//------------------------------------------------------------------
//
// dieses Define dient nur zum Testen und darf auf keinen Fall aktiv bleiben
// Bei Umstellungen alle Files nach SIG_CHARTMODELDEFSCHDOC durchsuchen
// #define ChartModel SchChartDocument
//------------------------------------------------------------------
#ifndef _SV_EDIT_HXX //autogen
#include <vcl/edit.hxx>
#endif

#ifndef _SFXITEMSET_HXX //autogen
#include <svtools/itemset.hxx>
#endif
#ifndef _SV_TIMER_HXX //autogen
#include <vcl/timer.hxx>
#endif
#ifndef _SV_FIXED_HXX //autogen
#include <vcl/fixed.hxx>
#endif
#ifndef _SV_BUTTON_HXX //autogen
#include <vcl/button.hxx>
#endif
#ifndef _VALUESET_HXX //autogen
#include <svtools/valueset.hxx>
#endif
#ifndef _SV_DIALOG_HXX //autogen
#include <vcl/dialog.hxx>
#endif
#ifndef _SVX_CHRTITEM_HXX //autogen
#include <svx/chrtitem.hxx>
#endif
#ifndef _SFXAPP_HXX
#include <sfx2/app.hxx>
#endif


class SchControlList;
class SchChartView;
class SchChartDocShell;
class ChartModel;
class SfxPreviewWin;
class SchMemChart;

#define SCH_MAX_PAGES	3

enum ChType
{
	CHTYPE_2D_LINE = 1,
	CHTYPE_2D_LINESYMB,
	CHTYPE_2D_AREA,
	CHTYPE_2D_COLUMN,
	CHTYPE_2D_BAR,
	CHTYPE_2D_PIE,
	CHTYPE_2D_XY,
	CHTYPE_3D_STRIPE,
	CHTYPE_3D_AREA,
	CHTYPE_3D_COLUMN,
	CHTYPE_3D_PIE,
	CHTYPE_3D_XYZ,
	CHTYPE_3D_BAR,
	CHTYPE_2D_NET,
	CHTYPE_2D_STOCK
};

enum ChVariant
{
	CHVARIANT_INVALID,
	CHVARIANT_2D_LINE = 1,
	CHVARIANT_2D_LINE_STACKED,
	CHVARIANT_2D_LINE_PERCENT,
	CHVARIANT_2D_LINESYMB,
	CHVARIANT_2D_LINESYMB_STACKED,
	CHVARIANT_2D_LINESYMB_PERCENT,
	CHVARIANT_2D_COLUMN,
	CHVARIANT_2D_COLUMN_STACKED,
	CHVARIANT_2D_COLUMN_PERCENT,
	CHVARIANT_2D_BAR,
	CHVARIANT_2D_BAR_STACKED,
	CHVARIANT_2D_BAR_PERCENT,
	CHVARIANT_2D_AREA,
	CHVARIANT_2D_AREA_STACKED,
	CHVARIANT_2D_AREA_PERCENT,
	CHVARIANT_2D_PIE,
	CHVARIANT_2D_PIE_SEGOFS_1,
	CHVARIANT_2D_PIE_SEGOFS_ALL,
	CHVARIANT_2D_XY_SYMB,
	CHVARIANT_2D_XY,
	CHVARIANT_3D_STRIPE,
	CHVARIANT_3D_COLUMN,
	CHVARIANT_3D_COLUMN_FLAT,
	CHVARIANT_3D_COLUMN_FLAT_STACKED,
	CHVARIANT_3D_COLUMN_FLAT_PERCENT,
	CHVARIANT_3D_AREA,
	CHVARIANT_3D_AREA_STACKED,
	CHVARIANT_3D_AREA_PERCENT,
	CHVARIANT_3D_PIE,
	CHVARIANT_3D_XYZ_SYMB,
	CHVARIANT_3D_XYZ,
	CHVARIANT_2D_DONUT1,
	CHVARIANT_2D_DONUT2,
	CHVARIANT_3D_BAR,
	CHVARIANT_3D_BAR_FLAT,
	CHVARIANT_3D_BAR_FLAT_STACKED,
	CHVARIANT_3D_BAR_FLAT_PERCENT,
	CHVARIANT_3D_SURFACE,
	CHVARIANT_2D_NET,
	CHVARIANT_2D_NETSYMB,
	CHVARIANT_2D_NET_STACK,
	CHVARIANT_2D_NETSYMB_STACK,
	CHVARIANT_2D_NET_PERCENT,
	CHVARIANT_2D_NETSYMB_PERCENT,
	CHVARIANT_2D_CUBIC_SPLINE,
	CHVARIANT_2D_CUBIC_SPLINE_SYMBOL,
	CHVARIANT_2D_B_SPLINE,
	CHVARIANT_2D_B_SPLINE_SYMBOL,
	CHVARIANT_2D_CUBIC_SPLINE_XY,
	CHVARIANT_2D_CUBIC_SPLINE_SYMBOL_XY,
	CHVARIANT_2D_B_SPLINE_XY,
	CHVARIANT_2D_B_SPLINE_SYMBOL_XY,
	CHVARIANT_2D_XY_LINE,
	CHVARIANT_2D_LINE_COLUMN,
	CHVARIANT_2D_LINE_STACKEDCOLUMN,
	CHVARIANT_2D_STOCK_1,
	CHVARIANT_2D_STOCK_2,
	CHVARIANT_2D_STOCK_3,
	CHVARIANT_2D_STOCK_4
};

class SchDiagramAutoPilotDlg : public ModalDialog
{
private:
	SchControlList		*arrPage[SCH_MAX_PAGES];
	SchControlList		*pButtonList;
	SfxObjectShellLock  pDocSh;
	SfxItemSet*			pOutSet;

	ChartModel    *pDoc;

	BOOL bStored;
	void StoreTextSettings();

	SvxChartLegendPos   eLegendPos;

// 	String aXAxisTitle;
// 	String aYAxisTitle;
// 	BOOL bXYTitleAutoChanged;
// 	BOOL bXTitleAutoChanged;
// 	BOOL bYTitleAutoChanged;

    SchMemChart         *pOriginalData,*pReducedData;

	USHORT			nCurPageNr;
	Timer			aPreviewDelay;
	BOOL			bHasPrePage;
	BOOL            bNoText;
// 	BOOL            bXAxisChanged;
// 	BOOL            bYAxisChanged;

	BOOL            bReducedData;


/*    UINT32 	nValForm at;
	UINT32  nPercentValF ormat;
	UINT32  nDescrFor mat;
	UINT32  nPercentDe  scrFormat;
*/
	BOOL    bShowMainTitle;
	BOOL    bShowSubTitle;
	BOOL    bShowXAxisTitle;
	BOOL	bShowYAxisTitle;
	BOOL	bShowZAxisTitle;
	BOOL	bShowXDescr;
	BOOL	bShowYDescr;
	BOOL	bShowZDescr;
	BOOL    bShowLegend;

	void    RestoreTextSettings();
	void    SetTextSettings(BOOL bON);


	DECL_LINK(NoTextClickHdl, Button*);
	DECL_LINK(PagerClickHdl, Button*);
	DECL_LINK(ExecuteClickHdl, Button*);
	DECL_LINK(EditLoseFocusHdl, Control*);
	DECL_LINK(RadioButtonClickHdl, Button*);
	DECL_LINK(CheckBoxClickHdl, CheckBox*);
	DECL_LINK(SelectChartTypeHdl, void*);
	DECL_LINK(SelectChartVariantHdl, void*);
	DECL_LINK(PreviewDelayHdl, Timer*);


	void            BuildChart();
	void            construct(BOOL bDataInRows);
	void			SetCurrentPage( USHORT nNewPageNr );
	void			SelectVariantSet( USHORT nNewId, ChVariant eVariant );
	void			InitFromModel();
	void			SetupModel();
	void			ScalePreview();
	void			ExecuteVariant();
	ChType			GetTypeFromStyle( SvxChartStyle eStyle );
	void			EnableOverlap();
	void			FillOutputItemSet();
	ChVariant       TranslateFromModel (SvxChartStyle eStyle);
    void            NewAxisText( const ChType & eOldType, const ChType & eNewType,
                                 bool bChangeRowCol = false );
	void            ChangeColRow ();

	// Reduzierung der Daten zur schnelleren Darstellung:
	void            SetDataToOrigin();
	SchMemChart*    ReduceData(SchMemChart& rData);
	void            ReduceDataAgain(BOOL bDontBuild=FALSE);
	void            CopyDataText(SchMemChart *pTarget,SchMemChart *pSource);
	void            CopyLegendText(SchMemChart *pTarget,SchMemChart *pSource,BOOL bCopyCols);
	BOOL            GetReduceStyle(SvxChartStyle eStyle);

	long			nShapeType;
	BOOL			bYAutoOrigin;

    void            FillValueSets();

protected:
//	PAGE 1
	FixedText*		pFT_1_CHARTTYPE;
	ValueSet*		pCT_1_CHARTTYPE;

//	PAGE 2
	FixedText*		pFT_2_CHARTVARIANT;
	ValueSet*		pCT_2_CHARTVARIANT;
	CheckBox*		pCB_2_XGRID;
	CheckBox*		pCB_2_YGRID;
	CheckBox*		pCB_2_ZGRID;
	FixedLine*		pFL_2_GRID;

//	PAGE 3

	FixedLine*		pFL_3_DISPLAY;
	CheckBox*		pCB_3_TEXTTITLE;
	Edit*			pET_3_TEXTTITLE;
    CheckBox*       pCB_3_LEGEND;
	FixedText*		pFT_3_AXES;
	CheckBox*		pCB_3_XTEXT;
	Edit*			pET_3_TEXTRUBRIK;
	CheckBox*		pCB_3_YTEXT;
	Edit*			pET_3_TEXTSIZE;
	CheckBox*		pCB_3_ZTEXT;
	Edit*			pET_3_TEXTSECOND;

//	all pages
	SfxPreviewWin*	pCT_PREVIEW;
	FixedLine		aFL_HORZLINE;
	CheckBox        aCB_NOTEXT;
	FixedText		aFT_DATAROWS;
	RadioButton		aRB_DATAROWS;
	RadioButton		aRB_DATACOLS;
	HelpButton		aPB_HELP;
	CancelButton	aPB_CANCEL;
	PushButton		aPB_PREV;
	PushButton		aPB_NEXT;
	PushButton		aPB_EXECUTE;

	String			aStrTitle;

    bool IsXAxisTitleDefault( bool bIsXYChart ) const;

public:
	SchDiagramAutoPilotDlg( Window* pParent, SchMemChart& rData,
							const SfxItemSet& rInAttrs,
							SfxItemSet& rOutAttrs, BOOL bPrePage = FALSE );
	SchDiagramAutoPilotDlg( Window* pParent,
							SfxObjectShellLock& rDocShellRef );
	virtual ~SchDiagramAutoPilotDlg();

	void ChangeChartData(SchMemChart& rData);

	void SetLegendPos(SvxChartLegendPos  ePos){eLegendPos=ePos;};

    virtual void	DataChanged( const DataChangedEvent& rDCEvt );
};

#endif //_SCH_DLGGRAUT_HXX

