/*************************************************************************
 *
 *  $RCSfile: chartdlg.cxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/26 18:06:18 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifdef PCH
#include "ui_pch.hxx"
#endif

#pragma hdrstop

//----------------------------------------------------------------------------

#include <sfx2/dispatch.hxx>
#include <sfx2/viewfrm.hxx>
#include <sch/schdll.hxx>
#include <sch/memchrt.hxx>
#include <vcl/msgbox.hxx>
#include <vcl/sound.hxx>

#ifndef _SFXSTRITEM_HXX //autogen
#include <svtools/stritem.hxx>
#endif



#define _CHARTDLG_CXX
#include "chartdlg.hxx"
#undef _CHARTDLG_CXX

#include "scresid.hxx"
#include "reffact.hxx"
#include "rangeutl.hxx"
#include "tabvwsh.hxx"
#include "chartarr.hxx"
#include "document.hxx"
#include "globstr.hrc"
#include "chartdlg.hrc"


//============================================================================

void	lcl_ChartDlgCheckEqual( String& rStr );


//============================================================================
//	class ScChartDlg

//----------------------------------------------------------------------------

ScChartDlg::ScChartDlg( SfxBindings* pB, SfxChildWindow* pCW, Window* pParent, ScViewData* pData )
	:	ScAnyRefDlg( pB, pCW, pParent, RID_SCDLG_CHARTRANGE ),
		aFT_TEXT		( this, ScResId( FT_TEXT ) ),
		aFT_RANGE		( this, ScResId( FT_RANGE ) ),
		aFT_TOTABLE		( this, ScResId( FT_TOTABLE ) ),
		aET_RANGE		( this, ScResId( ET_RANGE ) ),
		aRB_RANGE		( this, ScResId( RB_RANGE ), &aET_RANGE ),
		aCB_COLHEADER	( this, ScResId( CB_COLHEADER ) ),
		aCB_ROWHEADER	( this, ScResId( CB_ROWHEADER ) ),
		aLB_TOTABLE		( this, ScResId( LB_TOTABLE ) ),
		aBTN_HELP		( this, ScResId( BTN_HELP ) ),
		aBTN_CANCEL		( this, ScResId( BTN_CANCEL ) ),
		aBTN_PREV		( this, ScResId( BTN_PREV ) ),
		aBTN_NEXT		( this, ScResId( BTN_NEXT ) ),
		aBTN_FINISH		( this, ScResId( BTN_FINISH ) ),
        aFL_1           ( this, ScResId( FL_1 ) ),
        aFL_HLINE       ( this, ScResId( FL_HLINE ) ),
		//
		pViewData		( pData ),
		pDoc			( pData->GetDocument() ),
		//
		pRangeUtil		( new ScRangeUtil ),
		pScChartTestDlg	( NULL ),
		bChildOpen		( FALSE ),
		pInItemSet		( NULL ),
		pOutItemSet		( NULL ),
		pScChartArray	( NULL ),
		pMemChart		( NULL ),
		aRangeListRef	( NULL ),
		nCurTab			( NULL )
{
	SfxApplication* pSfxApp = SFX_APP();
	ScTabViewShell* pViewSh = pViewData->GetViewShell();
	bIsEditChart = pViewSh->IsChartDlgEdit();
	if (bIsEditChart)
		SetText(String(ScResId(STR_CHANGETITLE)));

//!	((ScApplication*)pSfxApp)->GetSchDLL();			///????????????????

	BOOL bOldCol = FALSE;
	BOOL bOldRow = FALSE;
	if (bIsEditChart)
	{
		aEditChartName = pViewSh->GetEditChartName();
		aBTN_NEXT.Disable();

		//	Quellbereich
		SchMemChart* pMem = pDoc->FindChartData(aEditChartName);
		DBG_ASSERT(pMem,"Chart-Daten nicht gefunden");
		if (pMem)
		{
			ScChartArray aArray( pDoc, *pMem );
			aRangeListRef = aArray.GetRangeList();
			bOldCol = aArray.HasColHeaders();
			bOldRow = aArray.HasRowHeaders();
		}
		else
			aRangeListRef = new ScRangeList;	// aRangeListRef must be initialized anyway
	}

	ScRangeListRef aSource;
	Rectangle aMarkDest;
	USHORT nMarkTab;
	BOOL bAreaMarked = pViewSh->GetChartArea( aSource, aMarkDest, nMarkTab );

	if ( bIsEditChart )
	{
		// aRangeListRef ist initialisiert
		ImpSetReferenceList( aRangeListRef, pDoc );
	}
	else
	{
		if ( !bAreaMarked )
		{
			ScMarkData& rMark = pViewData->GetMarkData();
			if ( !rMark.IsMarked() && !rMark.IsMultiMarked() )
				pViewData->GetView()->MarkDataArea( TRUE );
			pViewData->GetMultiArea(aSource);
		}
		pDoc->LimitChartIfAll( aSource );
		aRangeListRef = aSource;
		ImpSetReferenceList( aRangeListRef, pDoc );
	}

	nCurTab = bAreaMarked ? nMarkTab : pViewData->GetTabNo();

	aBTN_FINISH.SetClickHdl( LINK(this,ScChartDlg,ImpBtnClickHdl) );
	aBTN_NEXT.SetClickHdl( LINK(this,ScChartDlg,ImpBtnClickHdl) );
	aBTN_CANCEL.SetClickHdl( LINK(this,ScChartDlg,ImpBtnClickHdl) );

	ImpFillTableList();
	if (bAreaMarked || bIsEditChart)
    {
        aFT_TOTABLE.Disable();
		aLB_TOTABLE.Disable();
    }

	FreeResource();

//SID_ATTR_ROWHEADERS


	pInItemSet =  new SfxItemSet( pSfxApp->GetPool(),
								  SID_INSERT_DIAGRAM, SID_INSERT_DIAGRAM,
								  SID_ATTR_ROWHEADERS, SID_ATTR_COLHEADERS,
								  CHATTR_START, CHATTR_END,
								  0 );

	pOutItemSet =  new SfxItemSet( pSfxApp->GetPool(),
								   SID_INSERT_DIAGRAM, SID_INSERT_DIAGRAM,
								   SID_ATTR_ROWHEADERS, SID_ATTR_COLHEADERS,
								   CHATTR_START, CHATTR_END,
								   FN_PARAM_4, FN_PARAM_5,
								   0 );

	ImpCreateChartObject();

	if ( bIsEditChart )
		pScChartArray->SetHeaders( bOldCol, bOldRow );

	aCB_ROWHEADER.Check( pScChartArray->HasRowHeaders() );
	aCB_COLHEADER.Check( pScChartArray->HasColHeaders() );
	aCB_ROWHEADER.SaveValue();
	aCB_COLHEADER.SaveValue();

	pMemChart = pScChartArray->CreateMemChart();

	aET_RANGE.ClearModifyFlag();

	SetActive();
	// don't call Show() - must be called from SfxWorkWindow::ShowChilds_Impl
	// after initializing, so the position can be set in StateChanged
}


//----------------------------------------------------------------------------

__EXPORT ScChartDlg::~ScChartDlg()
{
	delete pRangeUtil;
	delete pScChartTestDlg;
	delete pScChartArray;
	delete pInItemSet;
	delete pOutItemSet;
	delete pMemChart;
}


//----------------------------------------------------------------------------

BOOL ScChartDlg::IsRefInputMode() const
{
	return TRUE;
}


//----------------------------------------------------------------------------

void ScChartDlg::SetReference( const ScRange& rRef, ScDocument* pDoc )
{
	if ( rRef.aStart != rRef.aEnd )
		RefInputStart(&aET_RANGE);
	// ohne Tabellennamen geht's schief, wenn beim Beenden des Dialogs
	// eine andere Tabelle aktiv ist
	String	aStr;
	rRef.Format( aStr, SCR_ABS_3D, pDoc );
	lcl_ChartDlgCheckEqual( aStr );
	String aVal( aET_RANGE.GetText() );
	Selection aSel( aET_RANGE.GetSelection() );
    aSel.Justify();
	aVal.Erase( (xub_StrLen)aSel.Min(), (xub_StrLen)aSel.Len() );
	aVal.Insert( aStr, (xub_StrLen)aSel.Min() );
	Selection aNewSel( aSel.Min(), aSel.Min()+aStr.Len() );
	aET_RANGE.SetRefString( aVal );
	aET_RANGE.SetSelection( aNewSel );
	aET_RANGE.SetModifyFlag();
}


//----------------------------------------------------------------------------

void ScChartDlg::ImpSetReferenceList( const ScRangeListRef& rList, ScDocument* pDoc )
{
	String	aStr;
	rList->Format( aStr, SCR_ABS_3D, pDoc );
	String aVal( aET_RANGE.GetText() );
	Selection aSel( aET_RANGE.GetSelection() );
	aVal.Erase( (xub_StrLen)aSel.Min(), (xub_StrLen)aSel.Len() );
	aVal.Insert( aStr, (xub_StrLen)aSel.Min() );
	Selection aNewSel( aSel.Min(), aSel.Min()+aStr.Len() );
	aET_RANGE.SetText( aVal );
	aET_RANGE.SetSelection( aNewSel );
	aET_RANGE.SetModifyFlag();
}


//----------------------------------------------------------------------------

void ScChartDlg::AddRefEntry()
{
	String aVal = aET_RANGE.GetText();
	aVal += ';';
	aET_RANGE.SetText(aVal);

	xub_StrLen nLen = aVal.Len();
	aET_RANGE.SetSelection( Selection( nLen, nLen ) );
	aET_RANGE.SetModifyFlag();
}


//----------------------------------------------------------------------------

void __EXPORT ScChartDlg::SetActive()
{
	theCurSel = aET_RANGE.GetSelection();
	aET_RANGE.GrabFocus();
	RefInputDone();
}

//----------------------------------------------------------------------------

void ScChartDlg::Activate()
{
	ScAnyRefDlg::Activate();

	if ( bChildOpen && pScChartTestDlg )
	{
		//	#107224# The ChildWindow's "hidden" state is reset if the view
		//	is activated (despite the locked dispatcher if it's the only view),
		//	so it is hidden again on activating if the child dialog is open.

		USHORT nChartDlgId=ScChartDlgWrapper::GetChildWindowId();
		SfxViewFrame* pViewFrm = pViewData->GetViewShell()->GetViewFrame();
		pViewFrm->ShowChildWindow(nChartDlgId,FALSE);

		pScChartTestDlg->GrabFocus();		// child dialog should have focus
	}
}

//----------------------------------------------------------------------------

BOOL __EXPORT ScChartDlg::Close()
{
	if ( bChildOpen )
	{
		//	same as in button handler: dialog must not be closed while in
		//	execute of child dialog
		Sound::Beep();
		return FALSE;
	}

	return DoClose( ScChartDlgWrapper::GetChildWindowId() );
}


//----------------------------------------------------------------------------

IMPL_LINK( ScChartDlg, ImpBtnClickHdl, Button*, pButton )
{
	if ( bChildOpen )
	{
		//	dialog may have become visible after switching documents
		//	don't react while child dialog is open
		Sound::Beep();
		return 0;
	}

	if( pButton == &aBTN_FINISH )
	{
		SetDispatcherLock( FALSE );
		SwitchToDocument();
//		Hide();

		BOOL bColHdr = aCB_COLHEADER.IsChecked();
		BOOL bRowHdr = aCB_ROWHEADER.IsChecked();
		String aDataAreaStr = aET_RANGE.GetText();

		if (bIsEditChart)			// Datenbereich aendern ?
		{
			SfxStringItem aNameItem( SID_CHART_NAME, aEditChartName );
			SfxStringItem aRangeItem( SID_CHART_SOURCE, aDataAreaStr );
			SfxBoolItem aColHdrItem( FN_PARAM_1, bColHdr );
			SfxBoolItem aRowHdrItem( FN_PARAM_2, bRowHdr );		//! SID_ATTR_ROWHEADERS
			GetBindings().GetDispatcher()->Execute( SID_CHART_SOURCE,
										SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD,
										&aRangeItem, &aNameItem,
										&aColHdrItem, &aRowHdrItem, (void*) NULL );
		}
		else						// neues Chart erzeugen
		{
			// Als 3. Parameter wird die Nummer der Tabelle uebergeben,
			// in der das Chart erzeugt werden soll. Liefert die ListBox
			// als selektierten Eintrag den letzten, so entspricht dies
			// ScDocument::GetTableCount(), was im fuins als Anlass
			// genommen wird eine neue Tabelle zu erzeugen.
			//!!! FN_PARAM_4 bei Gelegenheit durch eigene Id ersetzen?

			pOutItemSet->Put( SfxBoolItem  ( SID_ATTR_ROWHEADERS, bRowHdr ));
			pOutItemSet->Put( SfxBoolItem  ( SID_ATTR_COLHEADERS, bColHdr ));
			pOutItemSet->Put( SfxUInt16Item( FN_PARAM_4,	aLB_TOTABLE.GetSelectEntryPos() ));
			pOutItemSet->Put( SfxStringItem( FN_PARAM_5,	aDataAreaStr ));

			GetBindings().GetDispatcher()->Execute( SID_INSERT_DIAGRAM,
										SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD,
										*pOutItemSet );
		}
		Close();
	}
	else if( pButton == &aBTN_CANCEL )
	{
		Close();
	}
	else if( pButton == &aBTN_NEXT )
	{
		ImpSwitchToChart();
	}

	return 0;
}


//----------------------------------------------------------------------------

void ScChartDlg::ImpSwitchToChart()
{
	if(!pScChartTestDlg)
	{
		pScChartTestDlg = SchDLL::CreateAutoPilotDlg( GetParent(),
											pMemChart,
											*pInItemSet,
											*pOutItemSet,
											TRUE );
	}

	if( aET_RANGE.IsModified() ||
		aCB_ROWHEADER.IsChecked() != aCB_ROWHEADER.GetSavedValue() ||
		aCB_COLHEADER.IsChecked() != aCB_COLHEADER.GetSavedValue()
		)
	{
		aCB_ROWHEADER.SaveValue();
		aCB_COLHEADER.SaveValue();

		// wenn Tabelle nicht angegeben und gewechselt: dumm gelaufen..
		// Abhilfe: nMask |= SCA_TAB_3D		aber dann: Bug #28560
		aRangeListRef = new ScRangeList();
		USHORT nMask = SCA_VALID;
		USHORT nResult = aRangeListRef->Parse( aET_RANGE.GetText(), pDoc, nMask );
		if( (nResult & nMask) == nMask )
		{
			ImpCreateChartObject();
			pScChartArray->SetHeaders( aCB_COLHEADER.GetSavedValue(), aCB_ROWHEADER.GetSavedValue() );

			//SchMemChart* pOld = pMemChart;
			pMemChart = pScChartArray->CreateMemChart();
			SchDLL::ChangeChartData( pScChartTestDlg, pMemChart );
			//delete pOld;

			aET_RANGE.ClearModifyFlag();
		}
		else
		{
			String aErrStr = ScGlobal::GetRscString( STR_ERR_INVALID_TABREF );
			ErrorBox	aBox( this, WB_OK, aErrStr );
			aBox.Execute();
			return;
		}

	}

	pScChartTestDlg->SetWindowState( GetWindowState( WINDOWSTATE_MASK_POS ) );

	USHORT nChartDlgId=ScChartDlgWrapper::GetChildWindowId();
	SfxViewFrame* pViewFrm = pViewData->GetViewShell()->GetViewFrame();
	pViewFrm->ShowChildWindow(nChartDlgId,FALSE);

	bChildOpen = TRUE;
	short nChildRes = pScChartTestDlg->Execute();
	bChildOpen = FALSE;

	switch( nChildRes )
	{
		case RET_CANCEL:
		case BTN_CANCEL:
			Close();
		break;

		case BTN_FINISH:
		case RET_OK://XXX
			ImpBtnClickHdl( &aBTN_FINISH );
		break;

		default:
			//!	Setting the window position here doesn't work,
			//!	the position is overwritten in SfxModelessDialog::StateChanged.
			SetWindowState( pScChartTestDlg->GetWindowState( WINDOWSTATE_MASK_POS ) );
			pViewFrm->ShowChildWindow(nChartDlgId,TRUE);
		break;
	}
}


//----------------------------------------------------------------------------

void ScChartDlg::ImpSwitchFromChart()
{
}


//----------------------------------------------------------------------------

void ScChartDlg::ImpCreateChartObject()
{
	pScChartArray = new ScChartArray( pDoc, aRangeListRef, String() );
}


//----------------------------------------------------------------------------

void ScChartDlg::ImpFillTableList()
{
	USHORT	n = pDoc->GetTableCount();
	USHORT	i = 0;
	String  aName;

	aLB_TOTABLE.Clear();
	aLB_TOTABLE.SetUpdateMode( FALSE );

	for ( i=0; i<n; i++ )
	{
		pDoc->GetName( i, aName );
		aLB_TOTABLE.InsertEntry( aName );
	}

	aLB_TOTABLE.InsertEntry( String( ScResId( SCSTR_NEWTABLE ) ) );
	aLB_TOTABLE.SetUpdateMode( TRUE );
	aLB_TOTABLE.SelectEntryPos( nCurTab );
}


//----------------------------------------------------------------------------

void ScChartDlg::ImpSetRangeList( const ScRange& rRange )
{
	aRangeListRef = new ScRangeList();
	aRangeListRef->Append( rRange );
}


//----------------------------------------------------------------------------

void lcl_ChartDlgCheckEqual( String& rStr )
{
	if ( STRING_NOTFOUND == rStr.Search( ':' ) )
	{
		String aStrTmp = rStr;
		rStr += ':';
		rStr += aStrTmp;
	}
}




