/*************************************************************************
 *
 *  $RCSfile: shellw9x.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: tra $ $Date: 2001/07/11 13:43:20 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _WINDOWS_
#include <windows.h>
#endif

#ifndef _SHLOBJ_H_
#include <shlobj.h>
#endif

#ifndef _INC_SHELLAPI
#include <shellapi.h>
#endif

#include <systools/win32/AutoSystoolInit.hxx>
#include "..\inc\systsettings.h"

//------------------------------------------------------------------------
// forward declaration
//------------------------------------------------------------------------

static void WINAPI Shell9xInit( );
static void WINAPI Shell9xDeInit( );

//------------------------------------------------------------------------
// global object, used to automatically initialize the systools 
//------------------------------------------------------------------------

static OAutoSystoolInit initShell9x( Shell9xInit, Shell9xDeInit );

//------------------------------------------------------------------------
// function pointers, used instead of the real functions
//------------------------------------------------------------------------

extern "C" 
{

// begin comment --->
// the shell32.dll under Win95 doesn't contain the
// SHBrowseForFolderW and SHGetPathFromIDListW functions
// that's why building would fail if we would set the
// function pointers to the unicode function adresses

typedef LPITEMIDLIST ( WINAPI * SHBrowseForFolderW_Proc_T ) (
	LPBROWSEINFOW lpbi );
SHBrowseForFolderW_Proc_T lpfnSHBrowseForFolderW;


typedef BOOL ( WINAPI * SHGetPathFromIDListW_Proc_T ) (
	LPCITEMIDLIST pidl, LPWSTR pszPath );
SHGetPathFromIDListW_Proc_T lpfnSHGetPathFromIDListW;

//<--- end comment

typedef LPWSTR * ( WINAPI * CommandLineToArgvW_Proc_T ) (
  LPCWSTR lpCmdLine, int *pNumArgs );
CommandLineToArgvW_Proc_T lpfnCommandLineToArgvW;

typedef BOOL ( WINAPI * ShellExecuteExW_Proc_T ) (
    LPSHELLEXECUTEINFOW lpExecInfo );
ShellExecuteExW_Proc_T lpfnShellExecuteExW;

} // extern "C"

//------------------------------------------------------------------------
// initialize the shell9x systools
//------------------------------------------------------------------------

static void WINAPI Shell9xInit( )
{
	HMODULE			hModule;
	OSVERSIONINFO	OSVerInfo;
	
	OSVerInfo.dwOSVersionInfoSize = sizeof( OSVERSIONINFO );
	GetVersionEx( &OSVerInfo );	

	// if windows 95/98
	if ( VER_PLATFORM_WIN32_WINDOWS == OSVerInfo.dwPlatformId )
	{		
		hModule = LoadLibraryA( SYSTOOLS_DLL_NAME );
		if ( NULL != hModule )
		{
			lpfnSHBrowseForFolderW   = (SHBrowseForFolderW_Proc_T)GetProcAddress( 
											hModule, "SHBrowseForFolderW_9x" );
			lpfnSHGetPathFromIDListW = (SHGetPathFromIDListW_Proc_T)GetProcAddress( 
											hModule, "SHGetPathFromIDListW_9x" );
			lpfnCommandLineToArgvW   = (CommandLineToArgvW_Proc_T)GetProcAddress( 
											hModule, "CommandLineToArgvW_9x" );

            lpfnShellExecuteExW = (ShellExecuteExW_Proc_T)GetProcAddress(
                                        hModule, "ShellExecuteExW_9x" );
		}
	}
	else
	{
		// we explicitly have to set the function pointer to
		// the SHBrowseForFolderW and SHGetPathFromIDListW 
		// because these functions do not exist in the shell32.dll
		// under win95 (see above)
		hModule = LoadLibraryA( "Shell32.dll" );
		if ( NULL != hModule )
		{
			lpfnSHBrowseForFolderW   = (SHBrowseForFolderW_Proc_T)GetProcAddress( 
											hModule, "SHBrowseForFolderW" );
			lpfnSHGetPathFromIDListW = (SHGetPathFromIDListW_Proc_T)GetProcAddress( 
											hModule, "SHGetPathFromIDListW" );			
			lpfnCommandLineToArgvW   = (CommandLineToArgvW_Proc_T)GetProcAddress( 
											hModule, "CommandLineToArgvW" );

            lpfnShellExecuteExW = (ShellExecuteExW_Proc_T)GetProcAddress(
                                        hModule, "ShellExecuteExW" );
		}		
	}
}

//------------------------------------------------------------------------
// deinitialize the shell9x systools
//------------------------------------------------------------------------

static void WINAPI Shell9xDeInit()
{
	// we do not explicitly free the shell9x library but rely
	// on the fact that sal will not be unloaded while the 
	// office is running, so the library will be free at
	// the office shutdown

    // we use this approach in order to unload the w9xucwrp.dll
    // GetModuleHandle will be used in order to avoid a global
    // variable HMODULE which would be set in ...Init
    // if the module handle is valid a LoadLibrary should have
    // been successful
    // nobody should use any of the above function pointer after
    // this call
    HMODULE hModule = GetModuleHandleA( SYSTOOLS_DLL_NAME );
    if ( hModule )
        FreeLibrary( hModule );
}

