/*************************************************************************
 *
 *  $RCSfile: dirw9x.h,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: obr $ $Date: 2001/06/07 09:23:22 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

//--------------------------------------------------------------------------
// This file is created, because WIN95 and WIN98 can't handle with 
// UNICODE-Strings. If these operating systems are detected it is
// necessary to convert all UNICODE-Strings into ASCII-Strings and 
// to use filesystem functions using ASCII-Strings.
//--------------------------------------------------------------------------

#ifdef __cplusplus
extern "C"{
#endif

//--------------------------------------------------------------------------
// defines
//--------------------------------------------------------------------------

#define DIRW9X_API extern


// lpfnFindFirstFile points to the the function FindFirstFileW if WINDOWS NT/2000 is detected and
// points to the new function FindFirstFile_W9X if WIN9X is detected	

DIRW9X_API HANDLE ( WINAPI *lpfnFindFirstFile )( 
	LPCWSTR lpFileName, 
	LPWIN32_FIND_DATAW lpDataW 
);

// lpfnFindNextFile points to the the function FindNextFileW if WINDOWS NT/2000 is detected and
// points to the new function FindNextFile_W9X if WIN9X is detected	

DIRW9X_API BOOL ( WINAPI *lpfnFindNextFile )( 
	HANDLE hfile, 
	LPWIN32_FIND_DATAW lpDataW 
);

// lpfnSetFileAttributes points to the the function SetFileAttributesW if WINDOWS NT/2000 is detected and
// points to the new function SetFileAttributes_W9X if WIN9X is detected	

DIRW9X_API BOOL ( WINAPI *lpfnSetFileAttributes )( 
	LPCWSTR lpFileName, 
	DWORD dwFileAttributes
);

// lpfnSearcPath points to the the function SearchPathW if WINDOWS NT/2000 is detected and
// points to the new function SearchPath_W9X if WIN9X is detected	

DIRW9X_API DWORD ( WINAPI *lpfnSearchPath )( 
	LPCWSTR lpPath, 
	LPCWSTR lpFileName, 
	LPCWSTR lpExtension, 
	DWORD nBufferLength, 
	LPWSTR lpBuffer, 
	LPWSTR *lpFilePart 
);

// lpfnWNetAddConnection2 points to the the function WNetAddConnection2W if WINDOWS NT/2000 is detected and
// points to the new function WNetAddConnection2_W9X if WIN9X is detected	
DIRW9X_API DWORD ( WINAPI *lpfnWNetAddConnection2 )( 
	LPNETRESOURCEW lpNetResource, 
	LPCWSTR lpPassword, 
	LPCWSTR lpUsername, 
	DWORD dwFlags
);

// lpfnWNetCancelConnection2 points to the the function WNetCancelConnection2W if WINDOWS NT/2000 is detected and
// points to the new function WNetCancelConnection2_W9X if WIN9X is detected	
DIRW9X_API DWORD ( WINAPI *lpfnWNetCancelConnection2 )( 
	LPCWSTR lpName, 
	DWORD dwFlags, 
	BOOL fForce
);

// lpfnWNetGetUser points to the the function WNetGetUserW if WINDOWS NT/2000 is detected and
// points to the new function WNetGetUser_W9X if WIN9X is detected	
DIRW9X_API DWORD ( WINAPI *lpfnWNetGetUser )( 
	LPCWSTR lpName, 
	LPWSTR lpUserName, 
	LPDWORD lpnLength
);

// lpfnGetWindowsDirectory points to the the function GetWindowsDirectoryW if WINDOWS NT/2000 is detected and
// points to the new function GetWindowsDirectory_W9X if WIN9X is detected	
DIRW9X_API UINT ( WINAPI *lpfnGetWindowsDirectory )(
	LPWSTR lpBuffer, 
	UINT uSize
);

// lpfnWritePrivateProfileString points to the the function WritePrivateProfileStringW if WINDOWS NT/2000 is detected and
// points to the new function WritePrivateProfileString_W9X if WIN9X is detected	
DIRW9X_API BOOL ( WINAPI *lpfnWritePrivateProfileString )( 
	LPCWSTR lpAppName, 
	LPCWSTR lpKeyName, 
	LPCWSTR lpString, 
	LPCWSTR lpFileName 
);

// lpfnGetPrivateProfileString points to the the function GetPrivateProfileStringW if WINDOWS NT/2000 is detected and
// points to the new function GetPrivateProfileString_W9X if WIN9X is detected	
DIRW9X_API DWORD ( WINAPI *lpfnGetPrivateProfileString )( 
	LPCWSTR lpAppName, 
	LPCWSTR lpKeyName, 
	LPCWSTR lpDefault, 
	LPWSTR lpReturnedString, 
	DWORD nSize, 
	LPCWSTR lpFileName 
);

#ifdef __cplusplus
}
#endif

