/*************************************************************************
 *
 *  $RCSfile: file2.c,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:17:20 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#define INCL_DOSDEVIOCTL;
#include "system.h"

#include <osl/file.h>
#include <osl/diagnose.h>
#include <rtl/alloc.h>

#define UINT32MAX 0xFFFFFFFF
#define CCHMAXPATH 260

/* function pointers used to simulate object orientation in the data structs below */
typedef oslFileError (*PFNGETNEXT)(oslDirectory, oslDirectoryItem *, uLong, uLong *);
typedef oslFileError (*PFNSTATUS) (oslDirectoryItem, oslFileStatus *, sal_uInt32);

typedef struct
{
	ULONG      nRefCount;             /* refcount of this structure */
	PFNGETNEXT pfnGetNextItem;        /* getNextDirectoryItem member function */
} ImplDirectory;

typedef struct
{
	ULONG ulDriveMap;                 /* bit map representing the disk drives */
	ULONG ulNextDrive;                /* last recently reported drive */
} ImplDiskEnum;

typedef struct
{
	ULONG          nRefCount;         /* refcount of this structure */
    ImplDirectory *pDirectory;        /* pointer to the directory structure */
	PFNSTATUS      pfnGetFileStatus;  /* getFileStatus member function */
} ImplItemBlock;

typedef struct
{
	ImplItemBlock *pBlock;            /* pointer to the memory block and its refcount */
	PVOID          pImplData;         /* pointer to implementation specific data */
} ImplDirectoryItem;
	

#if 0

typedef struct
{
	HDIR  hDirectory;    /* system directory handle */
	PBYTE pFirstFile;    /* optional data structure containing first item */
} ImplDirData;

	

typedef struct
{
	BYTE        nType;         /* type fo directory */
	union
	{
		ImplDirData   dir;     /* directory specific data */
		ImplDriveData drive;   /* drive specific data */
	} data;

	rtl_String *strPath;       /* path as it is specified by openDirectory */
	CHAR        pszPath[1];    /* path converted to systems charset */
} ImplDirectory;


typedef struct
{
	BYTE           nType;      /* describes the type of the following data structure */
	ULONG          ulOffset;   /* offset to the specific data structure */
	ImplDirectory *pDirectory; /* pointer to directory structure */

#endif

/*****************************************************************************/
/* psz_from_rtl_String */
/*****************************************************************************/

/*
 * this implementation is subject to change without notice when switching
 * to unicode.
 */

ULONG psz_from_rtl_String(PSZ pszBuffer, ULONG ulSize, rtl_String *rtlString)
{
	ULONG ulLen;
	PSZ	pszPath;

	/* convert the first 4 characters to chars */
	pszPath = (PSZ) rtl_string_getStr(rtlString);

	/* if the path starts witch "//." or "//./", strip this down */
	if(pszPath[2] == '.')
	{
		if(pszPath[3] == '/')
			pszPath += 4;
		else
			pszPath += 3;
	}

	/* count the remaining string length */
	ulLen = strlen(pszPath);

	if(ulLen + 1 < ulSize)
	{
        /* convert the rest of the string to chars */
		strcpy(pszBuffer, pszPath);
		return ulLen;
	}

	return -1;
}

/*****************************************************************************/
/* rtl_String_from_psz */
/*****************************************************************************/

void rtl_String_from_psz(rtl_String **newString, PSZ pszString)
{
	rtl_string_newFromStr(newString, pszString);
}

/*****************************************************************************/
/* validatePath */
/*****************************************************************************/

oslFileError validatePath(rtl_String **validPath, rtl_String **nativePath, PCSZ toValidate)
{
	CHAR  szBuffer[CCHMAXPATH + 4];
	PSZ   pszPath = szBuffer;
	PCHAR pc = NULL;
	PSZ   pszToken;

	/* check if path is local or unc */
	if(toValidate[1] == ':')
	{
		/* path is local */
		strcpy(szBuffer, "//./");
		pszPath += 4;

		/* copy string because we are going to modify it */
		strcpy(pszPath, toValidate);

		/* upper case drive letter */

		/* find first token after drive letter */
		pszToken = pszPath + 3;
	}
	else
	{
		/* copy string because we are going to modify it */
		strcpy(pszPath, toValidate);

		/* extract server name */
		pc = strchr(pszPath + 2, '/');

		if(pc)
		{
            /* find resource name */
			PSZ pc2 = strchr(pc + 1, '/');

			if(pc2)
				pc = pc2;
		}

		/* upper case server and resource */
		if(pc)
		{
			*pc = '\0';


			*pc = '/';

			/* find first subdirectory token */
			pszToken = pszPath + 3;
		}
	}

	/* lookup path in correct case */
	while(pszToken)
	{
		/* find token delimiter */
		pc = strchr(pszToken, '/');

		/* set EOS here */
		if(pc)
			*pc = '\0';

		/* lookup actual file name in correct case */

		/* increase loop variable */
		pszToken = pc;

		/* remove temporary EOS */
		if(pc)
		{
			*pc = '/';
			pszToken++;
		}
	}

	/* convert valid path to unicode */
	rtl_String_from_psz(validPath, szBuffer);

	/* convert all slashes to backslashes */
	for(pc = strchr(pszPath, '/'); pc; pc = strchr(pc + 1, '/'))
	{
		*pc = '\\';
	}

	/* convert native path to unicode */
	rtl_String_from_psz(nativePath, pszPath);

    return osl_File_E_None;
}

/*****************************************************************************/
/* mapError */
/*****************************************************************************/

oslFileError mapError(APIRET apiRet)
{
	oslFileError nError;

	switch(apiRet)
	{
	case NO_ERROR:
		nError = osl_File_E_None;
		break;
	default:
		nError = osl_File_E_invalidError;
	}

	return nError;
}

/*****************************************************************************/
/* getDriveStatus */
/*****************************************************************************/

#define PITEM ((ImplDirectoryItem *) Item)

oslFileError getDriveStatus(oslDirectoryItem Item, oslFileStatus *pStatus,
							sal_uInt32 uFieldMask)
{
	CHAR szDrive[] = "//./A:/";

	/* correct drive letter with offset */
	szDrive[4] += *((PBYTE) PITEM->pImplData);

	/* type is volume */
	pStatus->eType = osl_File_Type_Volume;
	pStatus->uValidFields = osl_FileStatus_Mask_Type;

	/* file size is zero */
	pStatus->uFileSize = 0;
	pStatus->uValidFields |= osl_FileStatus_Mask_FileSize;

	/* does not have any attributes */
	pStatus->uAttributes = 0;
	pStatus->uValidFields |= osl_FileStatus_Mask_Attributes;

	/* set "file" name */
	rtl_string_newFromStr(&pStatus->strFileName, szDrive + 4);
	pStatus->uValidFields |= osl_FileStatus_Mask_FileName;

	/* set "file" path */
	rtl_string_newFromStr(&pStatus->strFileName, szDrive);
	pStatus->uValidFields |= osl_FileStatus_Mask_FilePath;

	/* set native path */
	szDrive[6] == '\\';
	rtl_string_newFromStr(&pStatus->strFileName, szDrive + 4);
	pStatus->uValidFields |= osl_FileStatus_Mask_NativePath;

	/* validate if drive is still valid */
	if(uFieldMask & osl_FileStatus_Mask_Validate)
	{
		BYTE nDrive = *((PBYTE) PITEM->pImplData);
		APIRET nRet;

		if(nDrive > 1)
		{
			/* drive is not a floppy */

			ULONG  ulCurrentDrive, ulDriveMap;

			/* get actual drive map */
			nRet = DosQueryCurrentDisk(&ulCurrentDrive, &ulDriveMap);

			if(nRet)
				return mapError(nRet);

			if((ulDriveMap >> nDrive) & 1 == 0)
				return osl_File_E_NFILE;
		}
		else
		{
			/* drive is floppy */

			BYTE nFloppy;

			/* query number of floppies */
			nRet = DosDevConfig((PVOID) &nFloppy, DEVINFO_FLOPPY);

			if(nFloppy < nDrive + 1)
				return osl_File_E_NFILE;
		}
	}

	return osl_File_E_None;
}

#undef PITEM

/*****************************************************************************/
/* getNextDrives */
/*****************************************************************************/

#define ITEMSIZE (sizeof(ImplDirectoryItem) + sizeof(BYTE))

oslFileError getNextDrive(oslDirectory Directory, oslDirectoryItem *pItems,
						  uLong uRequested, uLong *puRetrieved)
{
	ImplDiskEnum      *pDiskEnum;
	ImplItemBlock     *pBlock;
	ImplDirectoryItem *pDirItem;

	PBYTE pMem, pData;
	BYTE  nDrive;

	/* allocate memory block */
	pMem = (PBYTE) rtl_allocateMemory(sizeof(ULONG) + uRequested * ITEMSIZE);

	if(pMem == NULL)
		return osl_File_E_NOMEM;

	/* initialize the block header */
	pBlock = (ImplItemBlock *) pMem;
	pBlock->nRefCount = 0;
	pBlock->pfnGetFileStatus = &getDriveStatus;

	/* reserve 4 byes for refcount */
	pMem += sizeof(ULONG);
	pData = pMem + uRequested * sizeof(BYTE);
	pDiskEnum = (ImplDiskEnum *) ((ImplDirectory *) Directory + 1);
	pDirItem = (ImplDirectoryItem *) pMem;

	/* 0 == a: */
	nDrive = 0;
	*puRetrieved = 0;

	while((*puRetrieved < uRequested) && (pDiskEnum->ulNextDrive < 0x04000000))
	{
		if(pDiskEnum->ulNextDrive & pDiskEnum->ulDriveMap)
		{
			pItems[*puRetrieved] = pDirItem;

			/* increase refcount */
			pDirItem->pBlock = pBlock;
			pDirItem->pBlock->nRefCount++;

			/* save data  */
			pDirItem->pImplData = pData;
			*pData++ = nDrive;

			(*puRetrieved)++;
			pDirItem++;
		}

		pDiskEnum->ulNextDrive <<= 1;
		nDrive++;
	}

	/*  diskless workstation ?? */
	if(*puRetrieved == 0)
		rtl_freeMemory(pBlock);

	return osl_File_E_None;
}

#undef ITEMSIZE

/*****************************************************************************/
/* enumDrives */
/*****************************************************************************/

oslFileError enumDrives(oslDirectory *pDirectory)
{
	ImplDirectory *pDir;
	ImplDiskEnum  *pDiskEnum;

	BYTE   nFloppy = 0;
	APIRET nRet;

	/* allocate memory block for data structures */
	pDir = (ImplDirectory *) rtl_allocateMemory((sizeof(ImplDirectory)
												 + sizeof(ImplDiskEnum)
												 + 3)
												& ~3);
	if(!pDir)
		return osl_File_E_NOMEM;

	/* initialize ImplDirectory structure */
	pDir->nRefCount = 1;
	pDir->pfnGetNextItem = &getNextDrive;

	pDiskEnum = (ImplDiskEnum *) (pDir + 1);

	/* query actual drive map */
	nRet = DosQueryCurrentDisk(&pDiskEnum->ulNextDrive,
							   &pDiskEnum->ulDriveMap);
	if(nRet)
	{
		rtl_freeMemory(pDir);
		return mapError(nRet);
	}

	/* begin enumeration with drive a */
	pDiskEnum->ulNextDrive = 1;

	/* query number of floppies */
	nRet = DosDevConfig((PVOID) &nFloppy, DEVINFO_FLOPPY);

	if(nRet)
	{
		rtl_freeMemory(pDir);
		return mapError(nRet);
	}

	/* remove phantom floppy */
	if(nFloppy < 2)
		pDiskEnum->ulDriveMap &= (ULONG) (nFloppy-4);

	*pDirectory = (oslDirectory) pDir;
	return osl_File_E_None;
}

/*****************************************************************************/
/* osl_getFullPath */
/*****************************************************************************/

sal_Bool SAL_CALL osl_getFullPath(const sal_Char* pszFilename, sal_Char* pszPath, sal_uInt32 MaxLen)
{
	return NO_ERROR == DosQueryPathInfo( (sal_Char *)pszFilename, FIL_QUERYFULLNAME, pszPath, MaxLen);
}

/*****************************************************************************/
/* osl_openDirectory */
/*****************************************************************************/

oslFileError SAL_CALL osl_openDirectory(rtl_String *strDirectoryPath,
										oslDirectory *pDirectory)
{
	CHAR szPath[CCHMAXPATH];

	/* convert rtl strings to local path names */
	if(-1 == psz_from_rtl_String(szPath, sizeof(szPath), strDirectoryPath))
		return osl_File_E_NAMETOOLONG;

	/* conversation remove "//.", so an empty string means: enumerate disks */
	if(*szPath == '\0')
	{
		return enumDrives(pDirectory);
	}

	return osl_File_E_INVAL;
}

#if 0
	ImplDirectory *pDir;

	PSZ    pszPath;
	ULONG  nPathLen;
	APIRET nRet;


	nPathLen = strlen(pszPath);

    /* allocate ImplDirectory structure */
	pDir = (ImplDirectory *)
		rtl_allocateMemory((sizeof(ImplDirectory) + nPathLen) + 7) & ~3);

	if(!pDir)
		return osl_File_E_NOMEM;

	/* initialize ImplDirectory structure */
	pDir->nRefCount  = 1;
	pDir->strPath = strDirectoryPath;
	rtl_string_acquire(strDirectoryPath);

	/* save converted path information */
	strcpy(pDir->pszPath, pszPath);

	/*
	 * if the directory path was "//." or "//./", pszPath is an empty string.
	 * the items to return are the drive letters currently valid for the system.
	 */

	else
	{
		/*
		 * all the follwing cases deal with different kinds of directories,
		 * e.g. simple dirs, volume roots, network drive roots.
		 */

		PVOID  pffBuf;
		ULONG  ulCount;
		ULONG  ulBufSize;
        ULONG  nLast;
		BYTE   ffBuffer[64];

		/* complete initialization */
		pDir->nType = DIRTYPE_DIRECTORY;
		pDir->data.dir.pFirstFile = NULL;
		pDir->data.dir.hDirectory = HDIR_CREATE;

		/* remove trailing slash */
		nLast = nPathLen - 1;
		if(pDir->pszPath[nLast] != '/' && pDir->pszPath[nLast] != '\\')
		{
			pszPath[nLast] = '\0';
			nPathLen--;
		}

		/*
		 * the first case to seperate is a network drive root. It does not
		 * contain a . or .. item, so the first item received has to be
		 * save for later use.
		 */

		/* deceide if //server/volume or c: */
		if(pDir->pszPath[0] == pDir->pszPath[1])
		{
			/* maybe we add network browsing later, so handle this case seperatly */

			if(1)
			{
				/* allocate buffer for a single "find next" */
				PBYTE pMem = rtl_allocateMemory( sizeof(ImplDirectoryItem) +
												 sizeof(FILEFINDBUF3) +
												 sizeof(ULONG)
											   );
				if(pMem)
				{
					/* reserve 4 bytes for refcount */
					ImplDirectoryItem *pItem = (ImplDirectoryItem *) (pMem + sizeof(ULONG));

					/* initialize data structure */
					pItem->ulOffset  = sizeof(ImplDirectoryItem);
					pItem->nType = ITEMTYPE_FINDFILE;

					pItem->pRefCount = (PULONG) pMem;
					*pItem->pRefCount = 1;

					/* save first file for getNextDirectoryItem */
					pDir->pFirstFile = (PBYTE) (pItem);

					/* remember directory */
					pItem->pDirectory = pDir;
					pDir->nRefCount++;

					/* setup data for findfirst call */
					pffBuf = (PBYTE) pItem + pItem->ulOffset;
					ulBufSize = sizeof(FILEFINDBUF3);
					ulCount = 1;
				}
				else
				{
					osl_closeDirectory((oslDirectory) pDir);
					return osl_File_E_NOMEM;
				}
			}
			else
			{
				pffBuf    = ffBuffer;
				ulBufSize = sizeof(ffBuffer);
				ulCount   = 2;
			}
		}
				
		/*
		 * the other cases deal with local drives, e.g. a:/tmp.
		 * the volume root contains only ".", all others "." and ".."
		 */

		else
		{
			pffBuf    = ffBuffer;
			ulBufSize = sizeof(ffBuffer);

			if(pDir->pszPath[2] == '\0')
				ulCount = 1;
			else
				ulCount = 2;
		}

		/*
		 * append search mask
		 */
		strcpy(pszPath + nPathLen, "/*.*");

		nRet = DosFindFirst(pDir->pszPath, &pDir->data.dir.hDirectory,
							FILE_NORMAL | FILE_DIRECTORY | FILE_HIDDEN,
							pffBuf, ulBufSize, &ulCount, FILE_NORMAL);

		if(nRet != NO_ERROR)
		{
			osl_closeDirectory((oslDirectory) pDir);
			return 666;
		}
	}


	/* use pointer to ImplDirectory structure as handle */
	*pDirectory = (oslDirectory) pDir;

	return osl_File_E_None;
}
#endif

/*****************************************************************************/
/* osl_getNextDirectoryItem */
/*****************************************************************************/



oslFileError SAL_CALL osl_getNextDirectoryItem(oslDirectory Directory, oslDirectoryItem *pItems,
											   uLong uRequested, uLong *puRetrieved)
{
	ImplDirectory *pDir = (ImplDirectory *) Directory;

	return pDir->pfnGetNextItem(Directory, pItems, uRequested, puRetrieved);
}

#if 0

	/*
	 * enumerate valid drive letters
	 */

	if(pDir->nType == DIRTYPE_DISKENUM)
	{
	}

	/*
	 * no cached information, try to read from disk
	 */

	if(pDir->pFirstFile == NULL)
	{
		ULONG  ulRetrieved = uRequested;
		PBYTE  pMem, pffBuf;
		ULONG  ulBlockSize, ulDataOffset;
		PULONG pRefCount;
		APIRET nRet;

		/* calculate 64 bytes per entry, but a minimum of 1 FILEFINDBUF3 */
		ulDataOffset = sizeof(ULONG) + uRequested * sizeof(ImplDirectoryItem);
		ulBlockSize  = uRequested < 5 ? sizeof(FILEFINDBUF3) : uRequested * 64;
		ulBlockSize += ulDataOffset;

		/* allocate memory block */
		pMem = (PBYTE) rtl_allocateMemory(ulBlockSize);

		if(pMem == NULL)
			return osl_File_E_NOMEM;

		/* initialize the blocks refecount variable */
		pRefCount = (PULONG) pMem;
		*pRefCount = 0;

		nRet = DosFindNext(pDir->data.dir.hDirectory, (pMem + ulDataOffset),
						   ulBlockSize - ulDataOffset, &ulRetrieved);

		if(nRet != NO_ERROR)
		{
			rtl_freeMemory(pMem);
			return 666;
		}

		/* reserve 4 byes for refcount */
		pffBuf = pMem + ulDataOffset;
		pMem += sizeof(ULONG);

		*puRetrieved = 0;
		while(*puRetrieved < ulRetrieved)
		{
			/* set data pointers */
			pItems[*puRetrieved] = pMem;
			pMem += sizeof(ImplDirectoryItem);

			/* increase refcount */
			PITEM->pRefCount = pRefCount;
			PITEM->pRefCount++;

			/* calculate offset to data structure */
			PITEM->ulOffset = pffBuf - (PBYTE) pItems[*puRetrieved];
			PITEM->nType = ITEMTYPE_FINDFILE;

			/* remember directory */
			PITEM->pDirectory = pDir;
			pDir->nRefCount++;

			/* reset loop variables */
			*puRetrieved++;
			if(((FILEFINDBUF3 *)pffBuf)->oNextEntryOffset)
				pffBuf += ((FILEFINDBUF3 *)pffBuf)->oNextEntryOffset;
			else
				break;
		}

		return osl_File_E_None;
	}

	/*
	 * first element cached from "find first"
	 */

	/* return only the previous found file */
	pItems[0] = pDir->pFirstFile;
	*puRetrieved = 1;

	/* ensure the data will not be used twice */
	pDir->pFirstFile = NULL;

	return osl_File_E_None;
}

#endif
/*****************************************************************************/
/* osl_closeDirectory */
/*****************************************************************************/

oslFileError SAL_CALL osl_closeDirectory(oslDirectory Directory)
{
	ImplDirectory *pDir = (ImplDirectory *) Directory;

    /* decrease refcount */
	pDir->nRefCount--;

    /* destruct if refcount is 0 */
	if(pDir->nRefCount == 0)
	{
		rtl_freeMemory(pDir);
	}

	return osl_File_E_None;
}

/*****************************************************************************/
/* osl_releaseDirectoryItem */
/*****************************************************************************/

oslFileError SAL_CALL osl_releaseDirectoryItem(oslDirectoryItem Item)
{
	ImplDirectoryItem *pDirItem = (ImplDirectoryItem *) Item;
	/*
	 * several directory items can be grouped in a single memory block, so
	 * not the items have a reference count, but the block.
	 */

	/* decrease refcount of the memory block */
	pDirItem->pBlock->nRefCount--;

    /* free memory block if refcount is 0 */
	if(pDirItem->pBlock->nRefCount == 0)
	{
		/* pointer to directory is only set when item was received by getNext() */
		if(pDirItem->pBlock->pDirectory)
			osl_closeDirectory(pDirItem->pBlock->pDirectory);

		rtl_freeMemory(pDirItem->pBlock);
	}

	return osl_File_E_None;
}

/*****************************************************************************/
/* osl_getDirectoryItem */
/*****************************************************************************/


oslFileError SAL_CALL osl_getDirectoryItem(rtl_String *strFilePath,
										   oslDirectoryItem *pItem)
{
 	return osl_File_E_None;
}

#if 0
	APIRET nRet;
	PBYTE  pMem;
	PVOID  pfStatus;
	PSZ    pszPath;

	/* convert rtl_String to PSZ */
	pszPath = (PSZ) rtl_string_getStr(strDirectoryPath);

    /* ignore leading "//./" if found */
	if(pszPath[2] == '.')
	{
		if(pszPath[3] != '\0')
			pszPath += 4;
		else
			pszPath += 3;
	}

	/* allocate buffer for a single "find next" */
	pMem = rtl_allocateMemory(sizeof(ImplDirectoryItem) + sizeof(FILESTATUS3) + sizeof(ULONG));

	if(pMem)
	{
		/* reserve 4 bytes for refcount */
		ImplDirectoryItem *pItem = (ImplDirectoryItem *) (pMem + sizeof(ULONG));

		/* initialize refcount */
		pItem->pRefCount  = (PULONG) pMem;
		*pItem->pRefCount = 1;

		/* set type and offset to data */
		pItem->ulOffset   = sizeof(ImplDirectoryItem);
		pItem->nType      = ITEMTYPE_PATHINFO;
		pItem->PDirectory = NULL;

		/* setup data for findfirst call */
		pfStatus = (PBYTE) pItem + pItem->ulOffset;
	}
	else
	{
		rtl_freeMemory(pMem);
		return osl_File_E_NOMEM;
	}

	nRet = DosQueryPathInfo(pszPath, pfStatus, sizeof(FILESTATUS3));

	if(nRet != NO_ERROR)
	{
		rtl_freeMemory(pMem);
		return 666;
	}

	*pItem = pMem + sizeof(ULONG);

	return osl_File_E_None;
}

#endif

/*****************************************************************************/
/* osl_getFileStatus */
/*****************************************************************************/

#define PITEM ((ImplDirectoryItem *) Item)

oslFileError SAL_CALL osl_getFileStatus(oslDirectoryItem Item,
										oslFileStatus *pStatus,
										sal_uInt32 uFieldMask)
{
	PITEM->pBlock->pfnGetFileStatus(Item, pStatus, uFieldMask);
}

#undef PITEM

#if 0
	
	/* item is a local volume drive */
	if(pItem->nType == ITEMTYPE_DRIVE)
	{
		pStatus->eType        = osl_File_Type_Volume;
		pStatus->uValidFields = osl_FileStatus_Mask_Type;


		return osl_File_E_None;
	}

}

#endif

/*****************************************************************************/
/* osl_getVolumeInformation */
/*****************************************************************************/

#define osl_VolumeInfo_Mask_Space \
	(osl_VolumeInfo_Mask_TotalSpace | osl_VolumeInfo_Mask_UsedSpace | osl_VolumeInfo_Mask_FreeSpace)

oslFileError SAL_CALL osl_getVolumeInformation(rtl_String *strDirectory,
											   oslVolumeInfo *pInfo,
											   sal_uInt32 uFieldMask)
{
	CHAR   szPath[CCHMAXPATH];
	BYTE   nDrive;
	APIRET nRet = NO_ERROR;

	/* convert rtl strings to local path names */
	if(-1 == psz_from_rtl_String(szPath, sizeof(szPath), strDirectory))
		return osl_File_E_NAMETOOLONG;

	/* volume info not available for UNC path */
	if(szPath[1] != ':')
		return osl_File_E_INVAL;

	/* calculate drive number: a = 1, b = 2 aso. */
	tolower(szPath[0]);
	nDrive = szPath[0] - 'a' + 1;

	/* invalidate all fields */
	pInfo->uValidFields = 0;

#ifndef LONG_FILENAMES_ON_FAT
	pInfo->uMaxNameLength = CCHMAXPATHCOMP;
	pInfo->uMaxPathLength = CCHMAXPATH;

	pInfo->uValidFields |= osl_VolumeInfo_Mask_MaxNameLength | osl_VolumeInfo_Mask_MaxPathLength;
#endif

    /* query attached filesystem information */
	if(uFieldMask & (osl_VolumeInfo_Mask_Attributes | osl_VolumeInfo_Mask_FileSystemName))
	{
		FSQBUFFER2 fsqbuffer;
		ULONG ulBufLen = sizeof(FSQBUFFER2);

		nRet = DosQueryFSAttach(NULL, nDrive, FSAIL_DRVNUMBER,
								&fsqbuffer, &ulBufLen);

		/* map error values and return */
		if(nRet)
			return mapError(nRet);

		/* if drive is remote, attributes are already clear */
		if(fsqbuffer.iType == FSAT_REMOTEDRV)
		{
			pInfo->uAttributes |= osl_Volume_Attribute_Remote;
			pInfo->uValidFields |= osl_VolumeInfo_Mask_Attributes;
		}

		/* convert filesystem name to unicode */
		rtl_String_from_psz(&pInfo->strFileSystemName, (PSZ) &fsqbuffer.szFSDName[fsqbuffer.cbName]);
		pInfo->uValidFields |= osl_VolumeInfo_Mask_FileSystemName;
	}

	/* if drive information was not already determined */
	if((uFieldMask & osl_VolumeInfo_Mask_Attributes) &&
	   !(pInfo->uValidFields & osl_VolumeInfo_Mask_Attributes))
	{
		BYTE  abParm[2] = { 0, nDrive - 1 };
		ULONG ulParmLen = 2;
		ULONG ulDataLen = 0;
		BIOSPARAMETERBLOCK bpb;

		memset(&bpb, 0, sizeof(bpb));

		/* directly access the device driver */
		nRet = DosDevIOCtl((HFILE)-1, IOCTL_DISK, DSK_GETDEVICEPARAMS,
						   (PVOID) &abParm[0], sizeof(abParm), &ulParmLen,
						   (PVOID) &bpb, sizeof(bpb), &ulDataLen);

		/* map error values and return */
		if(nRet)
			return mapError(nRet);

		/* if this flag is not set, the drive is a removable one */
		if(!(bpb.fsDeviceAttr & 0x01))
			pInfo->uAttributes |= osl_Volume_Attribute_Removeable;

		/* attributes completly determined anyway */
		pInfo->uValidFields |= osl_VolumeInfo_Mask_Attributes;
	}

	if(uFieldMask & osl_VolumeInfo_Mask_Space)
	{
		FSALLOCATE fsabuffer;

		/* query filesystem allocation data */
		nRet = DosQueryFSInfo(nDrive, FSIL_ALLOC, &fsabuffer, sizeof(FSALLOCATE));

		/* map error values and return */
		if(nRet)
			return mapError(nRet);

		pInfo->uTotalSpace = fsabuffer.cbSector * fsabuffer.cSectorUnit;
		pInfo->uFreeSpace  = pInfo->uTotalSpace * fsabuffer.cUnitAvail;
		pInfo->uTotalSpace *= fsabuffer.cUnit;
		pInfo->uUsedSpace  = pInfo->uTotalSpace - pInfo->uFreeSpace;

		pInfo->uValidFields |= osl_VolumeInfo_Mask_Space;
	}

	return osl_File_E_None;
}

/*****************************************************************************/
/* osl_openFile */
/*****************************************************************************/
oslFileError SAL_CALL osl_openFile(rtl_String *strPath,
								   oslFileHandle *pHandle,
								   sal_uInt32 uFlags )
{
	PSZ    pszPath;
    CHAR   szPath[CCHMAXPATH];
	HFILE  hFile;
	ULONG  ulAction;
	ULONG  ulOpenFlags;
	ULONG  ulOpenMode;
	APIRET nRet;

	/* convert rtl strings to local path names */
	if(-1 == psz_from_rtl_String(szPath, sizeof(szPath), strPath))
		return osl_File_E_NAMETOOLONG;

	/* set appropriate open flags ansd mode */
	ulOpenFlags = OPEN_ACTION_OPEN_IF_EXISTS;
	ulOpenMode  = OPEN_SHARE_DENYWRITE;

	if(uFlags & osl_File_OpenFlag_Create)
		ulOpenFlags |= OPEN_ACTION_CREATE_IF_NEW;

	if(uFlags & (osl_File_OpenFlag_Read | osl_File_OpenFlag_Write))
	{
		ulOpenMode |= OPEN_ACCESS_READWRITE;
	}
	else if(uFlags & osl_File_OpenFlag_Write)
	{
		ulOpenMode |= OPEN_ACCESS_WRITEONLY;
	}
	else
	{
		ulOpenMode |= OPEN_ACCESS_READONLY;
	}

    /* open file with corresponding flags and mode */
	nRet = DosOpen(pszPath, &hFile, &ulAction, 0, FILE_READONLY | FILE_HIDDEN,
				   ulOpenFlags, ulOpenMode, NULL);

#ifdef LONG_FILENAMES_ON_FAT
	/* if long filenames used on FAT, the job is not that easy */
	if(nRet == ERROR_FILENAME_EXCED_RANGE)
	{
		EAOP eaop;
	}
#endif

	/* map error values and return */
	if(nRet)
		return mapError(nRet);

	/* use OS/2 file handle as handle */
	*pHandle = (oslFileHandle) hFile;
	return osl_File_E_None;
}

/*****************************************************************************/
/* osl_setFilePos */
/*****************************************************************************/

oslFileError SAL_CALL osl_setFilePos(oslFileHandle Handle, sal_uInt32 uHow, sal_uInt64 uPos)
{
	ULONG  ulLocation;
	APIRET nRet;

	/* check value of uPos */
	if(uPos > UINT32MAX)
		return osl_File_E_OVERFLOW;

	/* set the OS/2 file pointer to offset uPos */
	nRet = DosSetFilePtr((HFILE) Handle, uPos, FILE_BEGIN, &ulLocation);

	/* offset is a signed value, so this is a overrun */
	if(nRet == ERROR_NEGATIVE_SEEK)
	{
		/* get the current position to subtract it from the new location */
		nRet = DosSetFilePtr((HFILE) Handle, 0, FILE_CURRENT, &ulLocation);

		if(nRet == NO_ERROR)
		{
			nRet = DosSetFilePtr((HFILE) Handle, uPos - ulLocation,
								 FILE_CURRENT, &ulLocation);
		}
	}

	/* map error values and return */
	if(nRet)
		return mapError(nRet);

	return osl_File_E_None;
}

/*****************************************************************************/
/* osl_getFilePos */
/*****************************************************************************/
oslFileError SAL_CALL osl_getFilePos( oslFileHandle Handle, sal_uInt64 *pPos )
{
	APIRET nRet;
	ULONG  ulLocation;

	oslFileError nError;

	/* to get the current file pointer, move it to Offset 0 from current position */
	nRet = DosSetFilePtr((HFILE) Handle, 0, FILE_CURRENT, &ulLocation);

	/* map error values and return */
	if(nRet)
		return mapError(nRet);

	/* return the new (and old) file pointer position */
	*pPos = ulLocation;
	return osl_File_E_None;
}

/*****************************************************************************/
/* osl_setFileSize */
/*****************************************************************************/
oslFileError SAL_CALL osl_setFileSize(oslFileHandle Handle, sal_uInt64 uSize)
{
	APIRET nRet;

	/* check value of uPos */
	if(uSize > UINT32MAX)
		return osl_File_E_OVERFLOW;

	/* set the new file size */
	nRet = DosSetFileSize((HFILE) Handle, uSize);

	/* map error values and return */
	if(nRet)
		return mapError(nRet);

	return osl_File_E_None;
}

/*****************************************************************************/
/* osl_readFile */
/*****************************************************************************/
oslFileError SAL_CALL osl_readFile(oslFileHandle Handle,
								   void *pBuffer,
								   sal_uInt64 uBytesRequested,
								   sal_uInt64 *pBytesRead)
{
	ULONG  cbActual;
	APIRET nRet;

	/* check value of uPos */
	if(uBytesRequested > UINT32MAX)
		return osl_File_E_OVERFLOW;

	/* try to read the requested number of bytes */
	nRet = DosRead((HFILE) Handle, pBuffer, uBytesRequested, &cbActual);

	/* map error values and return */
	if(nRet)
		return mapError(nRet);

	*pBytesRead = cbActual;
	return osl_File_E_None;
}

/*****************************************************************************/
/* osl_writeFile */
/*****************************************************************************/
oslFileError SAL_CALL osl_writeFile(oslFileHandle Handle,
									const void *pBuffer,
									sal_uInt64 uBytesToWrite,
									sal_uInt64 *pBytesWritten )
{
	ULONG  cbActual;
	APIRET nRet;

	oslFileError nError;

	/* check value of uPos */
	if(uBytesToWrite > UINT32MAX)
		return osl_File_E_OVERFLOW;

	/* try to read the requested number of bytes */
	nRet = DosWrite((HFILE) Handle, (PVOID) pBuffer, uBytesToWrite,
					&cbActual);

	/* map error values and return */
	if(nRet)
		return mapError(nRet);

	*pBytesWritten = cbActual;
	return osl_File_E_None;
}

/*****************************************************************************/
/* osl_closeFile */
/*****************************************************************************/
oslFileError SAL_CALL osl_closeFile(oslFileHandle Handle)
{
	APIRET nRet;
	oslFileError nError;

	/* free the systems filesystem handle */
	nRet = DosClose((HFILE) Handle);

	/* map error values and return */
	if(nRet)
		return mapError(nRet);

	return osl_File_E_None;
}

#if 0
/*****************************************************************************/
/* osl_createDirectoryItemFromHandle */
/*****************************************************************************/

oslFileError SAL_CALL osl_createDirectoryItemFromHandle( oslFileHandle Handle,
														 oslDirectoryItem *pItem )
{
	/* allocate buffer for a single "find next" */
	PBYTE pMem = rtl_allocateMemory( sizeof(ImplDirectoryItem) +
									 sizeof(FILEFINDBUF3) +
									 sizeof(ULONG)
								   );

	if(pMem)
	{
		/* reserve 4 bytes for refcount */
		ImplDirectoryItem *pItem = (ImplDirectoryItem *) (pMem + sizeof(ULONG));

		/* initialize refcount */
		pItem->pRefCount = (PULONG) pMem;
		*pItem->pRefCount = 1;

		/* save first file for getNextDirectoryItem */
		pDir->pFirstFile = (PBYTE) (pItem->pRefCount + 1);
		pItem->ulOffset  = (pDir->pFirstFile - (PBYTE) pItem) + sizeof(ImplDirectoryItem);
		pItem->nType = ITEMTYPE_FINDFILE;

		/* remember directory */
		pItem->pDirectory = pDir;
		pDir->nRefCount++;

		/* setup data for findfirst call */
		pffBuf = (FILEFINDBUF3 *) ((PBYTE) pItem + pItem->ulOffset);
		ulBufSize = sizeof(FILEFINDBUF3);
		ulCount = 1;
	}
	else
	{
		osl_closeDirectory((oslDirectory) pDir);
		return osl_File_E_NOMEM;
	}
}
#endif
/*****************************************************************************/
/* osl_createDirectory */
/*****************************************************************************/
oslFileError SAL_CALL osl_createDirectory(rtl_String* strPath)
{
    CHAR   szPath[CCHMAXPATH];
	APIRET nRet;

	oslFileError nError;

	/* convert rtl strings to local path names */
	if(-1 == psz_from_rtl_String(szPath, sizeof(szPath), strPath))
		return osl_File_E_NAMETOOLONG;

	/* try to create directory */
	nRet = DosCreateDir(szPath, NULL);

#ifdef LONG_FILENAMES_ON_FAT
	/* if long filenames used on FAT, the job is not that easy */
	if(nRet == ERROR_FILENAME_EXCED_RANGE)
	{
		EAOP eaop;
	}
#endif

	/* map the most important errors */
	switch(nRet)
	{
	case NO_ERROR:
		nError = osl_File_E_None;
		break;
	default:
		nError = osl_File_E_invalidError;
	}

	return nError;
}

/*****************************************************************************/
/* osl_removeDirectory */
/*****************************************************************************/
oslFileError SAL_CALL osl_removeDirectory(rtl_String* strPath)
{
    CHAR   szPath[CCHMAXPATH];
	APIRET nRet;

	oslFileError nError;

	/* convert rtl strings to local path names */
	if(-1 == psz_from_rtl_String(szPath, sizeof(szPath), strPath))
		return osl_File_E_NAMETOOLONG;

	/* try to remove directory */
	nRet = DosDeleteDir(szPath);

#ifdef LONG_FILENAMES_ON_FAT
	/* if long filenames used on FAT, the job is not that easy */
	if(nRet == ERROR_FILENAME_EXCED_RANGE)
	{
		EAOP eaop;
	}
#endif

	/* map error values and return */
	if(nRet)
		return mapError(nRet);

	return osl_File_E_None;
}

/*****************************************************************************/
/* osl_removeFile */
/*****************************************************************************/
oslFileError SAL_CALL osl_removeFile(rtl_String* strPath)
{
    CHAR   szPath[CCHMAXPATH];
	APIRET nRet;

	oslFileError nError;

	/* convert rtl strings to local path names */
	if(-1 == psz_from_rtl_String(szPath, sizeof(szPath), strPath))
		return osl_File_E_NAMETOOLONG;

	/* try to remove directory */
	nRet = DosDelete(szPath);

#ifdef LONG_FILENAMES_ON_FAT
	/* if long filenames used on FAT, the job is not that easy */
	if(nRet == ERROR_FILENAME_EXCED_RANGE)
	{
		EAOP eaop;
	}
#endif

	/* map error values and return */
	if(nRet)
		return mapError(nRet);

	return osl_File_E_None;
}

/*****************************************************************************/
/* osl_copyFile */
/*****************************************************************************/
oslFileError SAL_CALL osl_copyFile(rtl_String* strPath, rtl_String *strDestPath)
{
	CHAR   szPath[CCHMAXPATH];
	CHAR   szDestPath[CCHMAXPATH];
	APIRET nRet;

	oslFileError nError;

	/* convert rtl strings to local path names */
	if(-1 == psz_from_rtl_String(szPath, sizeof(szPath), strPath))
		return osl_File_E_NAMETOOLONG;

	/* convert rtl strings to local path names */
	if(-1 == psz_from_rtl_String(szDestPath, sizeof(szDestPath), strDestPath))
		return osl_File_E_NAMETOOLONG;

	nRet = DosCopy(szPath, szDestPath, 0);

#ifdef LONG_FILENAMES_ON_FAT
	/* if long filenames used on FAT, the job is not that easy */
	if(nRet == ERROR_FILENAME_EXCED_RANGE)
	{
		EAOP eaop;
	}
#endif

	/* map error values and return */
	if(nRet)
		return mapError(nRet);

	return osl_File_E_None;
}

/*****************************************************************************/
/* osl_moveFile */
/*****************************************************************************/
oslFileError SAL_CALL osl_moveFile(rtl_String* strPath, rtl_String *strDestPath)
{
	CHAR   szPath[CCHMAXPATH];
	CHAR   szDestPath[CCHMAXPATH];
	APIRET nRet;

	oslFileError nError;

	/* convert rtl strings to local path names */
	if(-1 == psz_from_rtl_String(szPath, sizeof(szPath), strPath))
		return osl_File_E_NAMETOOLONG;

	/* convert rtl strings to local path names */
	if(-1 == psz_from_rtl_String(szDestPath, sizeof(szDestPath), strDestPath))
		return osl_File_E_NAMETOOLONG;

	nRet = DosMove(szPath, szDestPath);

#ifdef LONG_FILENAMES_ON_FAT
	/* if long filenames used on FAT, the job is not that easy */
	if(nRet == ERROR_FILENAME_EXCED_RANGE)
	{
		EAOP eaop;
	}
#endif

	/* map error values and return */
	if(nRet)
		return mapError(nRet);

	return osl_File_E_None;
}

/*****************************************************************************/
/* osl_getCanonicalName */
/*****************************************************************************/
oslFileError SAL_CALL osl_getCanonicalName(rtl_String *strRequested,
										   rtl_String **strValid)
{
}

/*****************************************************************************/
/* osl_getAbsolutePath */
/*****************************************************************************/
sal_Bool SAL_CALL osl_getAbsolutePath(rtl_String *strDirBase,
									  rtl_String *strRelative,
									  rtl_String **strAbsolute)
{
}
