/*************************************************************************
 *
 *  $RCSfile: app2.cxx,v $
 *
 *  $Revision: 1.10 $
 *
 *  last change: $Author: fs $ $Date: 2001/08/13 11:04:14 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifdef PRECOMPILED
#include "ofapch.hxx"
#endif

#include <svtools/stritem.hxx>

#pragma hdrstop

#define _SIDLL_HXX
#define  _VCATTR_HXX
#define _VCONT_HXX
#define _VCSBX_HXX
#define _VCTRLS_HXX
#define _VCDRWOBJ_HXX
#define _SI_VCFORM_HXX

//sfxsh.hxx
//#define _SFXSH_HXX
//#define _SFX_SHELL_HXX
//#define _SFXAPP_HXX
#define _SFXBINDIGS_HXX
//#define _SFXDISPATCH_HXX
//#define _SFXMSG_HXX
//#define _SFXREQUEST_HXX
#define _SFXMACRO_HXX

//sfx.hxx
//#define _SFX_HXX ***
//#define _SFXAPPWIN_HXX
//#define _SFX_SAVEOPT_HXX
//#define _SFX_CHILDWIN_HXX
//#define _SFXCTRLITEM_HXX
#define _SFX_PRNMON_HXX
#define _INTRO_HXX
#define _SFXMSGDESCR_HXX
#define _SFXMSGPOOL_HXX
#define _SFXFILEDLG_HXX
#define _PASSW_HXX
//#define _SFXTBXCTRL_HXX
#define _SFXSTBITEM_HXX
#define _SFXMNUITEM_HXX
#define _SFXIMGMGR_HXX
#define _SFXTBXMGR_HXX
#define _SFXSTBMGR_HXX
#define _SFX_MINFITEM_HXX
#define _SFXEVENT_HXX

//sfxdlg.hxx
//#define _SFXDLG_HXX
//#define _SFXTABDLG_HXX
//#define _BASEDLGS_HXX
#define _DINFDLG_HXX
#define _SFXDINFEDT_HXX
#define _SFX_MGETEMPL_HXX
//#define _SFX_TPLPITEM_HXX
#define _SFX_STYLEDLG_HXX
#define _NEWSTYLE_HXX
#define _SFXDOCTEMPL_HXX
#define _SFXDOCTDLG_HXX
//#define _SFXDOCKWIN_HXX ***
#define _SFX_TEMPLDLG_HXX
#define _SFXNEW_HXX
#define _SFXDOCMAN_HXX

//sfxdoc.hxx
//#define _SFXDOC_HXX
//#define _SFX_OBJSH_HXX
//#define _SFX_CLIENTSH_HXX
//#define _SFX_DOCFILT_HACK_HXX
//#define _SFX_FCONTNR_HXX
#define _SFXDOCFILE_HXX
//#define _SFXFRAME_HXX
//#define _SFXVIEWFRM_HXX
//#define _SFXVIEWSH_HXX
//#define _MDIFRM_HXX
#define _SFX_IPFRM_HXX
#define _SFX_INTERNO_HXX
//#define _FSETOBJSH_HXX

#define _DOCMGR_HXX

#define _SVCTRL3_HXX
#define _STD_VAR_ARRAYS

// include ---------------------------------------------------------------

//#include "sbaobj.hxx"
#ifndef _SBASLTID_HRC
#include "sbasltid.hrc"
#endif

#ifndef _SFXENUMITEM_HXX
#include <svtools/eitem.hxx>
#endif

#ifndef _SFXREQUEST_HXX
#include <sfx2/request.hxx>
#endif

#include "app.hxx"

#include "ofaitem.hxx"

#include "ofaids.hrc"
#include "autocdlg.hxx"
#include "osplcfg.hxx"
#include "hyprlink.hxx"

#ifndef _SFXDISPATCH_HXX
#include <sfx2/dispatch.hxx>
#endif

#ifndef _SFXVIEWFRM_HXX
#include <sfx2/viewfrm.hxx>
#endif

#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif
#ifndef _COM_SUN_STAR_UI_DIALOGS_XEXECUTABLEDIALOG_HPP_
#include <com/sun/star/ui/dialogs/XExecutableDialog.hpp>
#endif
#ifndef _VCL_STDTEXT_HXX
#include <vcl/stdtext.hxx>
#endif

// ------------------------------------------------------------------------

void OfficeApplication::BaseExec_Impl( SfxRequest &rReq )
{
	using namespace ::com::sun::star::uno;
	using namespace ::com::sun::star::ui::dialogs;
	using namespace ::com::sun::star::lang;

	USHORT nSlot = rReq.GetSlot();

	::rtl::OUString sDialogServiceName;
	switch ( nSlot )
	{
		case SID_ADDRESS_DATA_SOURCE:
			sDialogServiceName = ::rtl::OUString::createFromAscii("com.sun.star.ui.dialogs.AddressBookSourcePilot");
			break;

		case SID_DATASOURCE_ADMINISTRATION:
			sDialogServiceName = ::rtl::OUString::createFromAscii("com.sun.star.sdb.DatasourceAdministrationDialog");
			break;

		case SID_SDB52_IMPORT_WIZARD:
			sDialogServiceName = ::rtl::OUString::createFromAscii("com.sun.star.sdb.DatabaseImportWizard");
			break;
	}

	if (sDialogServiceName.getLength())
	{
		try
		{
			Reference< XMultiServiceFactory > xORB = ::comphelper::getProcessServiceFactory();
			Reference< XExecutableDialog > xDialog;
			if (xORB.is())
				xDialog = Reference< XExecutableDialog >(xORB->createInstance(sDialogServiceName), UNO_QUERY);
			if (xDialog.is())
				xDialog->execute();
			else
				ShowServiceNotAvailableError(NULL, sDialogServiceName, TRUE);
		}
		catch(::com::sun::star::uno::Exception&)
		{
		}
	}
}


//-------------------------------------------------------------------------

void OfficeApplication::Execute_Impl( SfxRequest &rReq )
{
	USHORT nSlot = rReq.GetSlot();

	switch ( nSlot )
	{
        case SID_AUTO_CORRECT_DLG:
		{
			BOOL bSWOptions = FALSE;
			const SfxPoolItem* pItem;
			const SfxItemSet* pSet = rReq.GetArgs();
			SfxItemPool* pPool = pSet ? pSet->GetPool() : NULL;

			if ( pSet &&
				 pSet->GetItemState( pPool->GetWhich( nSlot ), FALSE, &pItem )
				 == SFX_ITEM_SET )
				bSWOptions = ((SfxBoolItem*)pItem)->GetValue();

			SfxItemSet aSet(GetPool(), SID_AUTO_CORRECT_DLG, SID_AUTO_CORRECT_DLG);
			OfaAutoCorrDlg aDlg(NULL, &aSet, bSWOptions);
			aDlg.Execute();
		}
		break;

		case SID_GET_COLORTABLE:
			rReq.SetReturnValue(OfaPtrItem(nSlot, GetStdColorTable()));
			break;

		case SID_COMP_BIBLIOGRAPHY:
		{
			SfxStringItem aURL(SID_FILE_NAME, String::CreateFromAscii(".component:Bibliography/View1"));
			SfxStringItem aRef(SID_REFERER, String::CreateFromAscii("private:user"));
			SfxStringItem aTarget(SID_TARGETNAME, String::CreateFromAscii("_blank"));
			SfxViewFrame::Current()->GetDispatcher()->Execute(
				SID_OPENDOC, SFX_CALLMODE_ASYNCHRON, &aURL, &aRef, &aTarget, 0L);
		}
		break;
	}
	rReq.Done();
}


