/*************************************************************************
 *
 *  $RCSfile: netscape.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: pl $ $Date: 2001/05/14 09:40:39 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include "inetset.hxx"

#if defined(SAL_UNX) || defined(SAL_W32)

#ifdef SAL_W32
#include <regtools.hxx>
#endif

#include <tools/string.hxx>

using namespace ::rtl;


char *getData(const char *def, char *src)
{
    char buf[128], *tmp, *pos, term;
    int i;
    strcpy(buf, "user_pref(\"");
    strcat(buf, def);
    strcat(buf, "\", ");
    i = strlen(buf);
    for (tmp = src; (*tmp != 0); tmp++)
    {
        if (strncmp(buf, tmp, i) == 0) break;
    }
    if (*tmp == 0) return 0;
    pos = tmp + i;
    term = (*pos == '"') ? *pos++ : ')';
    tmp = new char[256];
    i = 0;
    while(*pos != term)
    {
        if (*pos == '\\') pos++;
        tmp[i++] = *pos++;
    }
    tmp[i] = 0;
    i = strlen(tmp);
    pos = new char[i + 1];
    strcpy(pos, tmp);
    pos[i] = 0;
    delete tmp;
    return pos;
}

Entry *getNSEntry(char *name, char *buf, char *alias)
{
    char *res = getData(name, buf);
    if (!res) return 0;
    return createData(alias, res);
}

Entry *getNSEntryNoProxy(char *name, char *buf, char *alias)
{
    char *res = getData(name, buf);
    if (!res) return 0;
    ByteString s(res);
    s.SearchAndReplaceAll(',', ';');
    return createData(alias, s.GetBuffer());
}

Entry *getNumNSEntry(char *name, char *buf, char *alias)
{
    char *res = getData(name, buf);
    if (!res) return 0;
    return createNumData(alias, res);
}

Directory *readNSHostInfo(const OString &path)
{
    char *buf = readFile(path.getStr(), "rt");
    if (!buf) return 0;
    Directory *allGroups = new Directory(FALSE);
    char *thisLine = seekBehind(buf, "begingroups\n");
    if (thisLine) {
        char *nextLine = seekBehind(thisLine, "\n");
// if "notMoreThan256Entries" is definied, max. 256 groups will be read
//#define notMoreThan256Groups
#ifdef notMoreThan256Groups
        int count = 256;
        while ((nextLine != 0) && (count > 0))
#else
            while (nextLine != 0)
#endif
            {
                if (*thisLine != '*')
                { // if not root-entry
                    char *c = thisLine;
                    while (*c && (*c != ',')) c++;
                    *c = 0;
                    OString groupName(thisLine);
                    allGroups->insert(createData(groupName, ""));
                }
                thisLine = nextLine;
                nextLine = seekBehind(thisLine, "\n");
#ifdef notMoreThan256Groups
                count--;
#endif
            }
    } // if (thisLine)
    delete buf;
    return allGroups;
}

Directory *readNSRcFile(const OString &path)
{
    char *buf = readFile(path.getStr(), "rt");
    if (!buf) return 0;
    Directory *subscribedGroups = new Directory(FALSE);
    char *thisLine = buf;
    char *nextLine = seekBehind(thisLine, "\n");
    while (nextLine != 0)
    {
        char *c = thisLine;
        while (*c && (*c != ':')) c++;
        *c = 0;
        OString groupName(thisLine);
        subscribedGroups->insert(createData(groupName.getStr(), ""));
        thisLine = nextLine;
        nextLine = seekBehind(thisLine, "\n");
    }
    delete buf;
    return subscribedGroups;
}

#ifdef SAL_W32
void readNSNewsServers(OString dirRoot, OString defaultServer, Directory *user)
{ // get news-hosts via fat-file
    OString fatPath = dirRoot;
    fatPath += "\\news\\fat";
    char *fat = readFile(fatPath.getStr(), "rt");
    if (!fat) return;
    char *serverName = seekBehind(fat, "newsrc-"); // skip first "newsrc-"
    if (serverName)
    {
        serverName = seekBehind(serverName, "newsrc-");
        while (serverName)
        {
            char *tab = seekBehind(serverName, "\t");
            if (*tab)
            {
                tab[-1] = 0;
                OString serverWithPort(serverName);
                OString server = serverWithPort;
                int i = find(serverName, ":");
                if (i)
                {
                    server = server.copy(0, i);
                }
                if (server == defaultServer)
                {
                    OString s = "*";
                    s += server;
                    server = s;
                }

                Directory *serverDir = new Directory(FALSE);
                Directory *groups = new Directory(FALSE);

                char *fileLoc = seekBehind(tab, "\t");
                if (fileLoc && (strncmp(fileLoc, "FALSE", 5) == 0))
                { // read subscribed groups from *.rc files
                    fileLoc[-1] = 0;
                    OString rcFileLoc(tab);
                    tab = fileLoc;
                    Directory *subscribed = readNSRcFile(rcFileLoc);
                    if (subscribed && subscribed->hasElements())
                        groups->insert(createSub("abboniert", subscribed));
                }

                char *t = new char[serverWithPort.getLength() + 1];
                strncpy(t, serverWithPort.getStr(), serverWithPort.getLength());
                t[serverWithPort.getLength()] = 0;
                i = find(t, ":");
                if (i) t[i] = '.';
                OString hostInfoPath = dirRoot;

                hostInfoPath += "\\news\\host-";
                hostInfoPath += t;
                hostInfoPath += "\\hostinfo.dat";

                if (testFile(hostInfoPath)) serverDir->insert(
                  createData("NNTPServer", serverWithPort));
                Directory *allGroups = readNSHostInfo(hostInfoPath);
                if (allGroups && allGroups->hasElements()) groups->insert(
                 createSub("alle", allGroups));
                if (!groups->hasElements()) delete groups;
                else serverDir->insert(createSub("gruppen", groups));
                if (!serverDir->hasElements()) delete serverDir;
                else user->insert(createSub(server, serverDir));
            }
            serverName = seekBehind(tab, "newsrc-"); // get next entry
        }
    }
    delete fat;
}
#endif

#ifdef SAL_UNX
void readNSNewsServers(OString dirRoot, OString defaultServer,
                       Directory *user, Directory *hosts)
{
    if (!hosts) return;
    OString xovercache = dirRoot;
    xovercache += "/xover-cache";
    for (int i = hosts->mnUsed - 1; i >= 0; i--)
    {
        OString hostPort = OUStringToOString(hosts->maEntries[i]->name, osl_getThreadTextEncoding() );
        OString hostName = hostPort;
        xub_StrLen nColon = hostName.indexOf(':');
        if (nColon > 0)
			hostName = hostName.copy(0, nColon);
        OString hostDir = xovercache;
        hostDir += "/host-";
        hostDir += hostPort;
        OString hostInfoPath = hostDir;
        hostInfoPath += "/hostinfo.dat";
        Directory *groups = new Directory(FALSE);
        Directory *serverDir = new Directory(FALSE);
        Directory *allGroups = readNSHostInfo(hostInfoPath);
        Directory *subscribed = hosts->maEntries[i]->dir;
        if (allGroups) if (allGroups->hasElements()) groups->insert(
          createSub("alle", allGroups)); else delete allGroups;
        if (subscribed) if (subscribed->hasElements()) groups->insert(
          createSub("abboniert", subscribed)); else delete subscribed;
        if (groups->hasElements()) serverDir->insert(
          createSub("gruppen", groups)); else delete groups;
        serverDir->insert(createData("NNTPServer", hostPort));
        user->insert(createSub(hostName, serverDir));
    }
}
#endif


void readNSUser(OString dirRoot, BOOL isDefaultAccount, Directory *root,
                const OString &version)
{
    OString prefsPath = dirRoot;
#ifdef SAL_W32
    prefsPath += "\\prefs.js";
#else
    prefsPath += "/preferences.js";
#endif
    char *buf = readFile(prefsPath.getStr(), "rt");
    if (buf)
    {
        // --- browser-einstellungen vom default-user uebernehmen ---------
        if (isDefaultAccount)
        {
            OString _browser = "browser/Netscape "; _browser += version;
            OUString browser = OUString::createFromAscii(_browser);
            Entry *e;
            if (e = getNSEntry("network.proxy.http", buf,
                               "HTTPProxyName"))
                root->insert(e, browser);
            e = getNumNSEntry("network.proxy.http_port", buf,
                              "HTTPProxyPort");
            if (e) root->insert(e, browser);
            e = getNSEntry("network.proxy.ftp", buf,
                           "FTPProxyName");
            if (e) root->insert(e, browser);
            e = getNumNSEntry("network.proxy.ftp_port", buf,
                              "FTPProxyPort");
            if (e) root->insert(e, browser);
            e = getNSEntry("network.proxy.ssl", buf,
                           "SecurityProxyName");
            if (e) root->insert(e, browser);
            e = getNumNSEntry("network.proxy.ssl_port", buf,
                              "SecurityProxyPort");
            if (e) root->insert(e, browser);
            e = getNSEntry("network.hosts.socks_server", buf,
                           "SocksProxyName");
            if (e) root->insert(e, browser);
            e = getNumNSEntry("network.hosts.socks_serverport", buf,
                              "SocksProxyPort");
            if (e) root->insert(e, browser);
            e = getNSEntryNoProxy("network.proxy.no_proxies_on", buf,
                                  "NoProxy");
            if (e) root->insert(e, browser);
            e = getNSEntry("browser.startup.homepage", buf,
                           "HomePage");
            if (e) root->insert(e, browser);

            char *proxyTypeString = getData("network.proxy.type", buf);
            if (proxyTypeString == 0) root->insert(
              createNum16Data("ProxyType", "0"), browser);
            else
            {
                if (*proxyTypeString == '1') root->insert(
                  createNum16Data("ProxyType", "2"), browser);
                else if (*proxyTypeString == '2') root->insert(
                  createNum16Data("ProxyType", "1"), browser);
                delete proxyTypeString;
            }
        }

        // --- mail -------------------------------------------------------
        OString _mail = "mail/Netscape "; _mail += version;
        OUString mail = OUString::createFromAscii(_mail);
        OString userDirName(isDefaultAccount ? "*" : "");

#ifdef SAL_W32
        userDirName += getData("mail.identity.username", buf);
#else
        oslSecurity currentSec = osl_getCurrentSecurity();
#define _userName_maxLen 256
		OUString	aUserName;

        osl_getUserName(currentSec, &aUserName.pData );
        userDirName += OUStringToOString( aUserName, osl_getThreadTextEncoding() );
#endif

        Directory *userDir = new Directory(FALSE);
        char *c;
        char *smtpServer = getData("network.hosts.smtp_server", buf);
        if (smtpServer) userDir->insert(createData(
          "SMTPServer", OString(smtpServer)));
        char *popServer = getData("network.hosts.pop_server", buf);
        if (popServer) userDir->insert(createData("POPServer",
                                                  OString(popServer)));
        char *popName = getData("mail.pop_name", buf);
        if (popName) userDir->insert(createData("MailUserName",
                                                OString(popName)));
        OString summary2 = dirRoot;

#ifdef SAL_W32
        summary2 += "\\summary2.dat";
#else
        summary2 += "/summary2.dat";
        Directory *tmpNews = new Directory(FALSE);
#endif

        char *sum = readFile(summary2.getStr(), "rt");
        if (sum)
        {
            Directory *box = new Directory(FALSE);
            char *sumPos = sum;
            while (*sumPos)
            {
                if (*sumPos == '/')
                { // mailboxentry
                    // filename
                    char *d;
                    for (c = sumPos + 1; *c && (*c != '\t'); c++)
                    {
#ifdef SAL_W32
                        if (*c == '/') *c = '\\'; // translate file://name
                                                  // to DOS-Path
                        else if (*c == '|') *c = ':';
#endif
                    }
                    if (!*c) break;
                    *c++ = 0; // tab becomes null
#ifdef SAL_W32
                    OString fileName(sumPos + 1); //skip first slash
#else
                    OString fileName(sumPos); // unix needs first slash
#endif
                    // 1. number
                    while (*c == '\t') c++;
                    char *n1 = c;
                    while (*c && (*c != '\t')) c++;
                    if (!*c) break;
                    *c++ = 0;
                    // displayed name
                    while (*c == '\t') c++;
                    d = c;
                    while (*c && (*c != '\t')) c++;
                    if (!*c) break;
                    *c++ = 0;
                    OString displayName(d);
                    // 2. number
                    while (*c == '\t') c++;
                    char *n2  = c;
                    while (*c && (*c != '\t')) c++;
                    if (!*c) break;
                    *c++ = 0;
                    // 3. number
                    while (*c == '\t') c++;
                    char *n3 = c;
                    while (*c && (*c != '\t')) c++;
                    if (!*c) break;
                    *c++ = 0;
                    // 4. number
                    while (*c == '\t') c++;
                    char *n4 = c;
                    while (*c && (*c != '\t')) c++;
                    if (!*c) break;
                    *c++ = 0;
                    // 5. number
                    while (*c == '\t') c++;
                    char *n5 = c;
                    while (*c && (*c != '\t')) c++;
                    if (!*c) break;
                    *c++ = 0;
                    // 6. number
                    while (*c == '\t') c++;
                    char *n6 = c;
                    while (*c && (*c != '\t')) c++;
                    if (!*c) break;
                    *c++ = 0;
                    // 7. number
                    while (*c == '\t') c++;
                    char *n7 = c;
                    while (*c && (*c != '\t')) c++;
                    if (!*c) break;
                    *c++ = 0;
                    // 8. number
                    while (*c == '\t') c++;
                    char *n8 = c;
                    while (*c && (*c != '\t')) c++;
                    if (!*c) break;
                    *c++ = 0;
                    // 9. number
                    while (*c == '\t') c++;
                    char *n9 = c;
                    while (*c && (*c != '\t')) c++;
                    if (!*c) break;
                    *c++ = 0;
                    // 10. number
                    while (*c == '\t') c++;
                    char *n10 = c;
                    while (*c && (*c != '\n')) c++;
                    if (!*c) break;
                    *c++ = 0;
                    sumPos = c;
                    // evaluate
                    if (n4[4] == '1')
                    { // inbox
                        Directory *inbox = new Directory(FALSE);
                        inbox->insert(createData("pfad", fileName));
                        inbox->insert(createNum("typ", mtNetscape));
                        inbox->insert(createNum("ServerTyp", stPOP));
                        inbox->insert(createData("ServerName",
                                                 OString(popServer)));
                        inbox->insert(createData("MailUserName",
                                                 OString(popName)));
                        if (!inbox->hasElements()) delete inbox;
                        box->insert(createSub(displayName, inbox));
                    }
                    else if ((n4[5] == '8') || (n4[5] == '2'))
                    { // outbox
                        Directory *outbox = new Directory(FALSE);
                        outbox->insert(createData("pfad", fileName));
                        outbox->insert(createNum("typ", mtNetscape));
                        if (n4[5] == '8') outbox->insert(
                          createNum("ServerTyp", stUNSENT)); // unsent
                        else outbox->insert(createNum("ServerTyp",
                                                      stSMTP)); // smtp
                        outbox->insert(createData("ServerName",
                                                  OString(smtpServer)));
                        if (!outbox->hasElements()) delete outbox;
                        box->insert(createSub(displayName, outbox));
                    }
                    else
                    { // others
                    }
                }
                else
                { // no '/' at beginning of line

#ifdef SAL_UNX
                    if (!strncmp(sumPos, "host-", 5))
                    { // solaris: host-HOSTNAME/*.snm
                        c = sumPos + 5;
                        while (*c && (*c != '/')) c++;  // find slash
                        if (!*c) break; else *(c++) = 0;
                        OString hostName(sumPos + 5);    // getServer
                        sumPos = c;
                        while (*c && (*c != '\t')) c++; // find TAB
                        if (!strncmp(c - 4, ".snm", 4))
                            c[-4] = 0; // cut .snm of
                        else if (*c) *(c++) = 0;
                        while (*c && (*c != '\n')) c++;  // find EoL
                        if (*c) c++;
                        Directory *hostDir = tmpNews->_createSub( OStringToOUString( OString(hostName), osl_getThreadTextEncoding() ) );
                        hostDir->insert(createData(OStringToOUString( OString(sumPos), osl_getThreadTextEncoding()), Any()));
                    }
                    else
#endif

                    {
                        while (*c && (*c != '\n')) c++;
                        if (*c) c++; else break;
                        sumPos = c;
                    }
                }
            }

            delete sum;
            if (!box->hasElements()) delete box;
            else userDir->insert(createSub("box", box));
        }

        if (!userDir->hasElements()) delete userDir;
        else root->insert(createSub(userDirName, userDir), mail);

        // --- news -------------------------------------------------------
#ifdef SAL_UNX
#define __readNSNewsServers(a, b, c) readNSNewsServers(a, b, c, tmpNews)
#else
#define __readNSNewsServers(a, b, c) readNSNewsServers(a, b, c)
#endif
        OString _news = "news/Netscape "; _news += version;
        OUString news = OUString::createFromAscii(_news);
        userDir = new Directory(FALSE);
        c = getData("network.hosts.nntp_server", buf); // default news-group
        if (c)
        {
            OString nntpServer(c);
            OString nntpServerWithPort(c);
            c = getData("news.server_port", buf);
            if (c)
            {
                nntpServerWithPort += ":";
                nntpServerWithPort += c;
                __readNSNewsServers(dirRoot, nntpServerWithPort, userDir);
            }
            else __readNSNewsServers(dirRoot, nntpServer, userDir);
        } else __readNSNewsServers(dirRoot, "", userDir);
#undef __readNSNewsServers
        if (!userDir->hasElements()) delete userDir;
        else root->insert(createSub(userDirName, userDir), news);

        delete buf;
    }
}

#ifdef SAL_W32
void readNetscape405(Directory *root, const OString &version)
{
    HKEY users;
    if (getRegKey(HKEY_LOCAL_MACHINE,
      "SOFTWARE\\Netscape\\Netscape Navigator\\Users", users))
    {
        OString currentUser;
        if (getRegSTRING(users, "CurrentUser", currentUser))
        {
            DWORD len = 1024;
            char *userName = new char[len];
            DWORD i = 0;
            DWORD l = len;
            while (RegEnumKeyEx(users, i, userName, &l, 0, 0, 0, 0)
                   == ERROR_SUCCESS)
            {
                HKEY userKey;
                if (getRegKey(users, userName, userKey))
                {
                    OString dirRoot;
                    if (getRegSTRING(userKey, "DirRoot", dirRoot))
                    {
                        readNSUser(dirRoot, (strcmp(currentUser.getStr(),
                          userName) == 0), root, version);
                    }
                    RegCloseKey(userKey);
                }
                l = len;
                i++;
            }
        }
        RegCloseKey(users);
    }
}

void readNetscape451(Directory *root, const OString &version)
{
    HKEY biff;
    if (getRegKey(HKEY_CURRENT_USER,
      "Software\\Netscape\\Netscape Navigator\\biff", biff))
    {
        OString currentUser;
        if (getRegSTRING(biff, "CurrentUser", currentUser))
        {
            HKEY users;
            if (getRegKey(biff, "users", users))
            {
                DWORD len = 1024;
                char *userName = new char[len];
                DWORD i = 0;
                DWORD l = len;
                while (RegEnumKeyEx(users, i, userName, &l, 0, 0, 0, 0)
                       == ERROR_SUCCESS)
                {
                    OString userKeyPath =
                      "Software\\Netscape\\Netscape Navigator\\biff\\users\\";
                    userKeyPath += userName;
                    HKEY userKey;
                    if (getRegKey(HKEY_CURRENT_USER,
                                  userKeyPath.getStr(), userKey))
                    {
                        OString defaultServerName;
                        if (getRegSTRING(userKey, "defaultServer",
                                         defaultServerName))
                        {
                            OString serverName = "servers\\";
                            serverName += defaultServerName;
                            HKEY serversKey;
                            if (getRegKey(userKey, serverName, serversKey))
                            {
                                OString popstatePath;
                                if (getRegSTRING(serversKey, "popstatePath",
                                                 popstatePath))
                                {
                                    OString dirRoot = popstatePath.copy(0,
/*"\mail\popstate.dat".getLength()==17*/  popstatePath.getLength() - 18);
                                    readNSUser(dirRoot, (strcmp(
                                      currentUser.getStr(), userName) == 0),
                                      root, version);
                                }
                                RegCloseKey(serversKey);
                            }
                        }
                        RegCloseKey(userKey);
                    }
                    l = len;
                    i++;
                }
                delete userName;
                RegCloseKey(users);
            }
        }
        RegCloseKey(biff);
    }
}

void readNetscape(Directory *root)
{
    HKEY netscapeKey;
    if (getRegKey(HKEY_LOCAL_MACHINE,
      "SOFTWARE\\Netscape\\Netscape Navigator", netscapeKey))
    {
        OString currentVersion;
        if (getRegSTRING(netscapeKey, "CurrentVersion", currentVersion))
        {
            if (strncmp(currentVersion.getStr(), "4.0", 3) == 0)
                readNetscape405(root, currentVersion);
            else if (strncmp(currentVersion.getStr(), "4.", 2) == 0)
            {
                char c = currentVersion.getStr()[2];
                if ((c >= '5') && (c <= '9'))
                    readNetscape451(root, currentVersion);
            }
        }
        RegCloseKey(netscapeKey);
    }
}

#endif // SAL_W32

#ifdef SAL_UNX
void readNetscape(Directory *root)
{
    char *home = getenv("HOME");
    if (home)
    {
        OString dirRoot(home);
        dirRoot += "/.netscape";
        readNSUser(dirRoot, TRUE, root, "4.x");
    }
}

#endif // SAL_UNX

#endif // SAL_UNX || SAL_W32

