/*************************************************************************
 *
 *  $RCSfile: controlloader.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:16:45 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <vos/mutex.hxx>
#include <tools/urlobj.hxx>
#include <usr/weak.hxx>
#include <usr/reflserv.hxx>
#include <usr/services.hxx>
#include <usr/factoryhlp.hxx>
#include <usr/smart2uno.hxx>
#include <toolkit/unoiface.hxx>
#ifndef _SMART_COM_SUN_STAR_FRAME_XCONTROLLER_HXX_
#include <smart/com/sun/star/frame/XController.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XFRAME_HXX_
#include <smart/com/sun/star/frame/XFrame.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XFRAMELOADER_HXX_
#include <smart/com/sun/star/frame/XFrameLoader.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XLOADEVENTLISTENER_HXX_
#include <smart/com/sun/star/frame/XLoadEventListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_LANG_XSERVICEINFO_HXX_
#include <smart/com/sun/star/lang/XServiceInfo.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HXX_
#include <smart/com/sun/star/lang/XMultiServiceFactory.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XPROPERTYSET_HXX_
#include <smart/com/sun/star/beans/XPropertySet.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_PROPERTYVALUE_HXX_
#include <smart/com/sun/star/beans/PropertyValue.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XPROPERTYSETINFO_HXX_
#include <smart/com/sun/star/beans/XPropertySetInfo.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XMULTIPROPERTYSET_HXX_
#include <smart/com/sun/star/beans/XMultiPropertySet.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XFASTPROPERTYSET_HXX_
#include <smart/com/sun/star/beans/XFastPropertySet.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XVETOABLECHANGELISTENER_HXX_
#include <smart/com/sun/star/beans/XVetoableChangeListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_PROPERTYATTRIBUTE_HXX_
#include <smart/com/sun/star/beans/PropertyAttribute.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XPROPERTIESCHANGELISTENER_HXX_
#include <smart/com/sun/star/beans/XPropertiesChangeListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XPROPERTYCHANGELISTENER_HXX_
#include <smart/com/sun/star/beans/XPropertyChangeListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XPROPERTYACCESS_HXX_
#include <smart/com/sun/star/beans/XPropertyAccess.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XPROPERTYCONTAINER_HXX_
#include <smart/com/sun/star/beans/XPropertyContainer.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_REGISTRY_XREGISTRYKEY_HXX_
#include <smart/com/sun/star/registry/XRegistryKey.hxx>
#endif

#ifdef _USE_NAMESPACE
using namespace usr;
using namespace vos;
#endif

// --- Testkomponente mit UnoControl -------------------------------------------
class UnoControlFrameLoader : public XFrameLoader, public OWeakObject
{
	XMultiServiceFactoryRef	xSMgr;
public:
							UnoControlFrameLoader( const XMultiServiceFactoryRef & rSMgr );
	friend	XInterfaceRef 	UnoControlFrameLoader_CreateInstance( const XMultiServiceFactoryRef& rSMgr ) THROWS((Exception));

	// XInterface
	virtual void			acquire()
							{ OWeakObject::acquire(); }
	virtual void			release()
							{ OWeakObject::release(); }
	virtual void *			getImplementation(Reflection *p)
							{ return OWeakObject::getImplementation(p); }

	virtual BOOL 			queryInterface( UsrUik aUIK, XInterfaceRef& );

	// XIdlClassProvider
    Sequence< XIdlClassRef > getIdlClasses(void);

	// XServiceInfo
	UString 				getImplementationName() THROWS( () );
    BOOL 					supportsService(const UString& ServiceName) THROWS( () );
    Sequence< UString > 	getSupportedServiceNames(void) THROWS( () );
	static UString 			getImplementationName_Static() THROWS( () )
							{
								return L"com.sun.star.comp.extensions.UnoControlFrameLoader";
							}

	static XIdlClassRef		getStaticIdlClass();
    static Sequence<UString>	getSupportedServiceNames_Static(void) THROWS( () );

	// XLoader
    virtual void 		load(const XFrameRef& aFrame, const UString& aURL,
							const Sequence< PropertyValue >& aArgs,
							const XLoadEventListenerRef& aListener);
    virtual void 		cancel(void);
};

UnoControlFrameLoader::UnoControlFrameLoader( const XMultiServiceFactoryRef & rSMgr )
	: xSMgr( rSMgr )
{
}

void UnoControlFrameLoader::load( const XFrameRef& aFrame, const UString& aURL,
							const Sequence< PropertyValue >& aArgs,
							const XLoadEventListenerRef& aListener)
{
	// ContainerWindow des Frames
	XWindowRef aRef = aFrame->getContainerWindow();

	// Name des UnoControls
	// Die URL mu\s lauten: [staroffice].component:UnoControl/Name
	String aURLStr( OUStringToString( aURL, CHARSET_SYSTEM ) );
	String aModelName = aURLStr.GetToken( 1, '/' );

	// Edit als UnoControl und Model erzeugen
	XMultiServiceFactoryRef xMgr = getProcessServiceManager();
	XInterfaceRef xObject( xMgr->createInstance( StringToOUString( aModelName, CHARSET_SYSTEM ) ), USR_QUERY );
	XControlRef xControl( xObject, USR_QUERY );
	if ( !xControl.is() )
	{
		XControlModelRef xModel( xObject, USR_QUERY );
		XPropertySetRef xPropSet( xObject, USR_QUERY );
		if ( xPropSet.is() && xModel.is() )
		{
			UsrAny aAny = xPropSet->getPropertyValue( L"DefaultControl" );
			UString aControlName = aAny.getString();

			xControl = XControlRef( xMgr->createInstance( aControlName ), USR_QUERY );
			if ( xControl.is() )
				xControl->setModel( xModel );
		}
	}

	if ( xControl.is() )
	{
		// Peer als Child zu dem FrameWindow
		XWindowPeerRef aPeer( aRef, USR_QUERY );
		xControl->createPeer( aPeer->getToolkit(), aPeer );

		XWindowRef xWindow( xControl, USR_QUERY );
		xWindow->setVisible( TRUE );
		aFrame->setComponent( xWindow, XControllerRef() );
		aListener->loadFinished( this );
		return;
	}

	aListener->loadCancelled( this );
}

BOOL UnoControlFrameLoader::queryInterface( UsrUik aUIK, XInterfaceRef& xRet )
{
	if( aUIK == XFrameLoader::getSmartUik() )
		xRet = (XFrameLoader*) this;
	else
		return OWeakObject::queryInterface( aUIK, xRet );
	return xRet.is();
}

void UnoControlFrameLoader::cancel()
{
}

XInterfaceRef UnoControlFrameLoader_CreateInstance( const XMultiServiceFactoryRef & rSMgr ) THROWS((Exception))
{
	return *(new UnoControlFrameLoader( rSMgr ) );
}

//-------------------------------------------------------------------------
XIdlClassRef UnoControlFrameLoader::getStaticIdlClass()
{
	// Global Method, must be guarded (multithreading)
	OGuard aGuard( OMutex::getGlobalMutex() );
	{
		// use the standard class implementation of the usr library
		static XIdlClassRef xClass =
		createStandardClass(
			getImplementationName_Static(),
			OWeakObject::getStaticIdlClass(),
			2 /*Anzahl Interfaces*/,
			XFrameLoader_getReflection(),
			XServiceInfo_getReflection() );

		return xClass;
	}
}

//-------------------------------------------------------------------------
// XIdlClassProvider
Sequence< XIdlClassRef > UnoControlFrameLoader::getIdlClasses()
{
	XIdlClassRef x = getStaticIdlClass();
	return Sequence< XIdlClassRef >( &x, 1 );
}

// XServiceInfo
UString UnoControlFrameLoader::getImplementationName() THROWS( () )
{
	return getImplementationName_Static();
}

// XServiceInfo
BOOL UnoControlFrameLoader::supportsService(const UString& ServiceName) THROWS( () )
{
	Sequence< UString > aSNL = getSupportedServiceNames();
	const UString * pArray = aSNL.getConstArray();
	for( INT32 i = 0; i < aSNL.getLen(); i++ )
		if( pArray[i] == ServiceName )
			return TRUE;
	return FALSE;
}

// XServiceInfo
Sequence< UString > UnoControlFrameLoader::getSupportedServiceNames(void) THROWS( () )
{
	return getSupportedServiceNames_Static();
}

// ORegistryServiceManager_Static
Sequence< UString > UnoControlFrameLoader::getSupportedServiceNames_Static(void) THROWS( () )
{
	Sequence< UString > aSNS( 1 );
	aSNS.getArray()[0] = L"com.sun.star.frame.UnoControlFrameLoader";
	return aSNS;
}

extern "C" {

BOOL EXTERN_SERVICE_CALLTYPE exService_writeRegEntry( const UNO_INTERFACE(XRegistryKey)* xUnoKey)
{
	XRegistryKeyRef xKey;
	uno2smart(xKey, *xUnoKey);

	UString aImpl = L"/";
	aImpl += UnoControlFrameLoader::getImplementationName_Static();
    XRegistryKeyRef xNewKey = xKey->createKey(
        aImpl + UString( L"/UNO/SERVICES" ) );
    Sequence< UString > aServices = UnoControlFrameLoader::getSupportedServiceNames_Static();
    for( INT32 i = 0; i < aServices.getLen(); i++ )
        xNewKey->createKey( aServices.getConstArray()[i]);

	// Einen FrameLoader "uber URL-Pattern registrieren
	xNewKey = xKey->createKey( aImpl + UString( L"/UNO/Loader" ));
	XRegistryKeyRef xLoaderKey = xKey->createKey( aImpl + UString( L"/Loader" ));
	xNewKey = xLoaderKey->createKey( L"Pattern" );
	xNewKey->setAsciiValue( L".component:UnoControl/*" ); /**/

	return True;
}

UNO_INTERFACE(XInterface) EXTERN_SERVICE_CALLTYPE exService_getFactory
(
	const sal_Unicode* implementationName,
	const UNO_INTERFACE(XMultiServiceFactory)* xUnoFact,
	const UNO_INTERFACE(XRegistryKey)*
)
{
	UNO_INTERFACE(XInterface) xUnoRet = {0, 0};

	XInterfaceRef 			xRet;
	XMultiServiceFactoryRef xSMgr;
	UString					aImplementationName(implementationName);

	uno2smart(xSMgr, *xUnoFact);

	if ( UString(implementationName) == UnoControlFrameLoader::getImplementationName_Static() )
	{
		xRet = createSingleFactory( xSMgr, implementationName,
										UnoControlFrameLoader_CreateInstance,
										UnoControlFrameLoader::getSupportedServiceNames_Static() );
	}

	if (xRet.is())
		smart2uno(xRet, xUnoRet);
	return xUnoRet;
}

}
