/*************************************************************************
 *
 *  $RCSfile: framectr.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/25 16:02:07 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_WAITOBJ_HXX //autogen wg. WaitObject
#include <vcl/waitobj.hxx>
#endif

#include <vos/mutex.hxx>
#include <usr/iterhlp.hxx>
#include <vcl/msgbox.hxx>
#include <toolkit/unoiface.hxx>
#include <tools/debug.hxx>

#include "framectr.hxx"
#include "datman.hxx"
#include "adrmod.hxx"
#include "fieldwin.hxx"

#ifndef _SMART_COM_SUN_STAR_DATA_XDATABASEDIALOGS_HXX_
#include <smart/com/sun/star/data/XDatabaseDialogs.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_XDATABASEQUERYCOMPOSER_HXX_
#include <smart/com/sun/star/data/XDatabaseQueryComposer.hxx>
#endif


#ifndef _VOS_NO_NAMESPACE
	using namespace usr;
	using namespace vos;
#endif

extern UString gGridModelCommand;

SV_IMPL_PTRARR( AdrStatusDispatchArr, AdrStatusDispatchPtr );

class AdrFrameCtrl_Impl : public XFrameActionListener, public UsrObject
{
public:
	OMutex 								aMutex;
	OMultiTypeInterfaceContainerHelper	aLC;
	AdrFrameController*			pController;

										SMART_UNO_DECLARATION( AdrFrameCtrl_Impl, UsrObject );

	BOOL 								queryInterface( UsrUik aUIK, XInterfaceRef& xRet );

										AdrFrameCtrl_Impl()
											: aLC( aMutex )
											, pController(0)
										{}

										~AdrFrameCtrl_Impl();

    virtual void 						frameAction(const FrameActionEvent& aEvent) THROWS( (UsrSystemException) );
	virtual void 						disposing( const EventObject& Source );
};

SMART_UNO_IMPLEMENTATION( AdrFrameCtrl_Impl, UsrObject );

AdrFrameCtrl_Impl::~AdrFrameCtrl_Impl()
{
}

BOOL AdrFrameCtrl_Impl::queryInterface( UsrUik aUIK, XInterfaceRef& xRet )
{
	if( aUIK == XFrameActionListener::getSmartUik() )
		xRet = (XFrameActionListener*) this;
	else if( aUIK == XEventListener::getSmartUik() )
		xRet = (XEventListener*) this;
	else return UsrObject::queryInterface( aUIK, xRet );
	return xRet.is();
}

void AdrFrameCtrl_Impl::frameAction(const FrameActionEvent& aEvent) THROWS( (UsrSystemException) )
{
	if ( pController && aEvent.Frame == pController->getFrame())
	{
		if(aEvent.Action == FrameAction_FRAME_ACTIVATED)
		{
			if(pController->xWindow.is() )
				pController->xWindow->setFocus();
			pController->activate();
		}
		else if(aEvent.Action == FrameAction_FRAME_DEACTIVATING)
		{
			pController->deactivate();
		}
	}
}

void AdrFrameCtrl_Impl::disposing( const EventObject& Source )
{
	if ( pController )
		pController->getFrame()->removeFrameActionListener( this );
}

AdrFrameController::AdrFrameController():
	pDatMan(NULL),
	pFieldWin(NULL)
{
	pDatMan=GetAdrModul()->createDataManager();
	pDatMan->SetFrameController(this);
	xDatMan=(XPropertyChangeListener*)pDatMan;
}

AdrFrameController::AdrFrameController(AdrDataManager* pDataManager):
	pDatMan(pDataManager),
	pFieldWin(NULL)
{
	pDatMan->SetFrameController(this);
	xDatMan=(XPropertyChangeListener*)pDatMan;
}

void AdrFrameController::InitController(const XWindowRef& xComponent)
{
	xWindow=xComponent;
	bDisposing=FALSE;
	bHierarchical=TRUE;
	pImp = new AdrFrameCtrl_Impl;
	pImp->pController = this;
	pImp->acquire();
}

AdrFrameController::~AdrFrameController()
{
	pImp->pController = NULL;
	pImp->release();
}

AdrDataManagerHdl	AdrFrameController::GetDataManager()
{
	return &pDatMan;
}
	

SMART_UNO_IMPLEMENTATION( AdrFrameController, UsrObject );

BOOL AdrFrameController::queryInterface( UsrUik aUIK, XInterfaceRef& xRet )
{
	if( aUIK == XDispatch::getSmartUik() )
		xRet = (XDispatch*) this;
	else if( aUIK == XDispatchProvider::getSmartUik() )
		xRet = (XDispatchProvider*) this;
	else if( aUIK == XController::getSmartUik() )
		xRet = (XController*) this;
	else if( aUIK == XComponent::getSmartUik() )
		xRet = (XComponent*) this;
	else return UsrObject::queryInterface( aUIK, xRet );
	return xRet.is();
}

void AdrFrameController::attachFrame( const XFrameRef& xArg )
{
	xFrame = xArg;
	xFrame->addFrameActionListener( pImp );
}

BOOL AdrFrameController::attachModel( const XModelRef& xModel )
{
	return FALSE;
}

BOOL AdrFrameController::suspend( BOOL bSuspend )
{
	if ( bSuspend )
		getFrame()->removeFrameActionListener( pImp );
	else
		getFrame()->addFrameActionListener( pImp );
	return TRUE;
}

UsrAny AdrFrameController::getViewData()
{
	return UsrAny();
}

void AdrFrameController::restoreViewData( const UsrAny& Value )
{
}

XFrameRef AdrFrameController::getFrame()
{
	return xFrame;
}

XModelRef AdrFrameController::getModel()
{
	return XModelRef();
}

void AdrFrameController::dispose()
{
	delete pFieldWin;
	
	pDatMan->setActivDataSource(UString());
	
	
	bDisposing = TRUE;
	EventObject aObject;
	aObject.Source = (XController*)this;
	pImp->aLC.disposeAndClear(aObject);
	pDatMan->disposing(EventObject());
	
	xDatMan=XPropertyChangeListenerRef();
	pDatMan=NULL;

}

void AdrFrameController::addEventListener( const XEventListenerRef& aListener )
{
	pImp->aLC.addInterface( XEventListener::getSmartUik(), aListener );
}

void AdrFrameController::removeEventListener( const XEventListenerRef& aListener )
{
	pImp->aLC.removeInterface( XEventListener::getSmartUik(), aListener );
}

XDispatchRef AdrFrameController::queryDispatch( const URL& aURL, const UString& aTarget, INT32 nSearchFlags )
{
	if ( !bDisposing )
	{	
		String aCommand( UStringToString( aURL.Path,CHARSET_SYSTEM ) );
		if (	aCommand == "Undo" || aCommand == "Cut" ||
				aCommand == "Copy" || aCommand == "Paste" ||
				aCommand == "SelectAll" || aCommand.Copy(0,4)  == "Adr/")

			return (XDispatch*) this;
	}

	return XDispatchRef();
}

Sequence<XDispatchRef> AdrFrameController::queryDispatches( const Sequence<DispatchDescriptor>& aDescripts )
{
	return Sequence<XDispatchRef>();
}

//class XDispatch
void AdrFrameController::dispatch(const URL& aURL, const Sequence< PropertyValue >& aArgs)
{
	if ( !bDisposing )
	{	
		WaitObject aWaitObject;
			
		VCLXWindow* pComp = (VCLXWindow*) xWindow->getImplementation( VCLXWindow_getReflection() );
		Window* pParent = pComp->GetWindow();
		pParent->EnableInput(FALSE);
			
		String aCommand( UStringToString( aURL.Path,CHARSET_SYSTEM ) );
		if (	aCommand == "Undo" || aCommand == "Cut" ||
				aCommand == "Copy" || aCommand == "Paste" ||
				aCommand == "SelectAll" ||  aCommand == "Adr/changeEntry" ||
				aCommand == "Adr/search" )
		{
			InfoBox aInfoB(pParent,aCommand );
			aInfoB.Execute();
		}
		else if(aCommand == "Adr/newEntry" )
		{
			pDatMan->insertRecord();
		}
		else if(aCommand == "Adr/removeEntry")
		{
			pDatMan->removeRecord();
		}
		else if(aCommand == "Adr/InsertFieldDlg")
		{
			if(!pFieldWin)
			{
				pFieldWin	= new AdrFieldWin(pParent);
				pFieldWin->Update(pDatMan->getDatabaseForm());
			}
			if(pFieldWin->IsVisible())
			{
				pFieldWin->Hide();
			}
			else
			{
				pFieldWin->Show();
			}
			
			USHORT nCount = aStatusListeners.Count();
			
			for ( USHORT n=0; n<nCount; n++ )
			{
				AdrStatusDispatch *pObj = aStatusListeners[n];
				if ( pObj->aURL.Path == "Adr/InsertFieldDlg" )
				{
					FeatureStateEvent  aEvent;
					aEvent.FeatureURL = pObj->aURL;
					aEvent.IsEnabled  = TRUE;
					aEvent.Requery    = FALSE;
					aEvent.Source     = (XDispatch *) this;
					aEvent.State.setBOOL(pFieldWin->IsVisible());
					pObj->xListener->statusChanged( aEvent );
					break;
				}
			}
		}

		else if(aCommand == "Adr/source")
		{
			ChangeDataSource(aArgs);
		}
		else if(aCommand == "Adr/hierarchical")
		{
			bHierarchical=!bHierarchical;
			USHORT nCount = aStatusListeners.Count();
			for ( USHORT n=0; n<nCount; n++ )
			{
				AdrStatusDispatch *pObj = aStatusListeners[n];
				if ( pObj->aURL.Path == "Adr/hierarchical" )
				{
					FeatureStateEvent  aEvent;
					aEvent.FeatureURL = pObj->aURL;
					aEvent.IsEnabled  = TRUE;
					aEvent.Requery    = FALSE;
					aEvent.Source     = (XDispatch *) this;
					aEvent.State.setBOOL(bHierarchical);
					pObj->xListener->statusChanged( aEvent );
					//break; because there are more than one
				}
			}
		}
		else if(aCommand == "Adr/autoFilter")
		{
			USHORT nCount = aStatusListeners.Count();
			for ( USHORT n=0; n<nCount; n++ )
			{
				AdrStatusDispatch *pObj = aStatusListeners[n];
				if ( pObj->aURL.Path == "Adr/removeFilter" )
				{
					FeatureStateEvent  aEvent;
					aEvent.FeatureURL = pObj->aURL;
					aEvent.IsEnabled  = TRUE;
					aEvent.Requery    = FALSE;
					aEvent.Source     = (XDispatch *) this;
					pObj->xListener->statusChanged( aEvent );
					//break; because there are more than one
				}
			}

			const PropertyValue* pPropertyValue = aArgs.getConstArray();
			UsrAny aValue=pPropertyValue[0].Value;
			UString aQuery=aValue.getString();

			aValue=pPropertyValue[1].Value;
			UString aQueryField=aValue.getString();
			pDatMan->setQueryField(aQueryField);
			pDatMan->startQueryWith(aQuery);
		}
		else if(aCommand == "Adr/standardFilter")
		{
			USHORT nCount = aStatusListeners.Count();
			for ( USHORT n=0; n<nCount; n++ )
			{
				AdrStatusDispatch *pObj = aStatusListeners[n];
				if ( pObj->aURL.Path == "Adr/removeFilter" )
				{
					FeatureStateEvent  aEvent;
					aEvent.FeatureURL = pObj->aURL;
					aEvent.IsEnabled  = TRUE;
					aEvent.Requery    = FALSE;
					aEvent.Source     = (XDispatch *) this;
					pObj->xListener->statusChanged( aEvent );
					//break; because there are more than one
				}
			}

			XDatabaseQueryComposerRef xParser=pDatMan->getParser();
			if(xParser.is())
			{
				XDatabaseDialogsRef xDlgs(xParser, USR_QUERY);
				XNamedRef xField;
				xDlgs->executeFilter(xField);
				pDatMan->setFilter(xParser->getFilter());
			}
		}
		else if(aCommand == "Adr/removeFilter")
		{
			RemoveFilter();
			/*
			USHORT nCount = aStatusListeners.Count();
			for ( USHORT n=0; n<nCount; n++ )
			{
				AdrStatusDispatch *pObj = aStatusListeners[n];
				if ( pObj->aURL.Path == "Adr/removeFilter" )
				{
					FeatureStateEvent  aEvent;
					aEvent.FeatureURL = pObj->aURL;
					aEvent.IsEnabled  = FALSE;
					aEvent.Requery    = FALSE;
					aEvent.Source     = (XDispatch *) this;
					pObj->xListener->statusChanged( aEvent );
					//break; because there are more than one
				}
			}
			*/
		}
		pParent->EnableInput(TRUE);
	}

}
void AdrFrameController::addStatusListener(const XStatusListenerRef& aListener, const URL& aURL)
{
	// create a new Reference and insert into listener array
	aStatusListeners.Insert( new AdrStatusDispatch( aURL, aListener ), aStatusListeners.Count() );
	
	// den ersten Status synchron zusenden
	if ( aURL.Path == "Adr/hierarchical" )
	{
		FeatureStateEvent aEvent;
		aEvent.FeatureURL = aURL;
		aEvent.IsEnabled  = TRUE;
		aEvent.Requery    = FALSE;
		aEvent.Source     = (XDispatch *) this;
		aEvent.State.setString( bHierarchical? L"" : L"*" );
		aListener->statusChanged( aEvent );
	}
	else if(aURL.Path == "Adr/MenuFilter")
	{
		FeatureStateEvent aEvent;
		aEvent.FeatureURL = aURL;
		aEvent.IsEnabled  = TRUE;
		aEvent.Requery    = FALSE;
		aEvent.Source     = (XDispatch *) this;
		aEvent.FeatureDescriptor=pDatMan->getQueryField();

		Sequence<UString> aStringSeq=pDatMan->getQueryFields();
		aEvent.State.set(&aStringSeq,Sequence<UString>::getReflection());
		aListener->statusChanged( aEvent );
	}
	else if ( aURL.Path == "Adr/source")
	{
		FeatureStateEvent aEvent;
		aEvent.FeatureURL = aURL;
		aEvent.IsEnabled  = TRUE;
		aEvent.Requery    = FALSE;
		aEvent.Source     = (XDispatch *) this;
		aEvent.FeatureDescriptor=pDatMan->getActivDataSource();

		Sequence<UString> aStringSeq=pDatMan->getDataSources();
		aEvent.State.set(&aStringSeq,Sequence<UString>::getReflection());
		aListener->statusChanged( aEvent );
	}
	else if(aURL.Path == "Adr/query")
	{
		FeatureStateEvent aEvent;
		aEvent.FeatureURL = aURL;
		aEvent.IsEnabled  = TRUE;
		aEvent.Requery    = FALSE;
		aEvent.Source     = (XDispatch *) this;
		aEvent.State.setString(pDatMan->getQueryString());
		aListener->statusChanged( aEvent );
	}
	else if (aURL.Path == "Adr/removeFilter" )
	{
		UString aFilterStr=pDatMan->getFilter();
		FeatureStateEvent  aEvent;
		aEvent.FeatureURL = aURL;
		aEvent.IsEnabled  = (aFilterStr.len() > 0);
		aEvent.Requery    = FALSE;
		aEvent.Source     = (XDispatch *) this;
		aListener->statusChanged( aEvent );
		//break; because there are more than one
	}
	else 
	{
		FeatureStateEvent aEvent;
		aEvent.FeatureURL = aURL;
		aEvent.IsEnabled  = TRUE;
		aEvent.Requery    = FALSE;
		aEvent.Source     = (XDispatch *) this;
		aListener->statusChanged( aEvent );
	}
}

void AdrFrameController::removeStatusListener(const XStatusListenerRef& aObject, const URL& aURL)
{
	// search listener array for given listener
	// for checking equality always "cast" to XInterface
	if ( !bDisposing )
	{	
		USHORT nCount = aStatusListeners.Count();
		for ( USHORT n=0; n<nCount; n++ )
		{
			AdrStatusDispatch *pObj = aStatusListeners[n];
			BOOL bFlag=pObj->xListener.is();
			if (!bFlag || (pObj->xListener == aObject && 
				( !aURL.Complete.len() || pObj->aURL.Path == aURL.Path  )))
			{
				aStatusListeners.DeleteAndDestroy( n );
				break;
			}
		}
	}
}

void AdrFrameController::RemoveFilter()
{
	UString aQuery;
	pDatMan->startQueryWith(aQuery);

	USHORT nCount = aStatusListeners.Count();
	FeatureStateEvent  aEvent;

	BOOL bRemoveFilter=FALSE;
	BOOL bQueryText=FALSE;

	for ( USHORT n=0; n<nCount; n++ )
	{
		AdrStatusDispatch *pObj = aStatusListeners[n];
		if ( pObj->aURL.Path == "Adr/removeFilter" )
		{
			FeatureStateEvent  aEvent;
			aEvent.FeatureURL = pObj->aURL;
			aEvent.IsEnabled  = FALSE;
			aEvent.Requery    = FALSE;
			aEvent.Source     = (XDispatch *) this;
			pObj->xListener->statusChanged( aEvent );
			bRemoveFilter=TRUE;
		}
		else if(pObj->aURL.Path == "Adr/query")
		{
			FeatureStateEvent aEvent;
			aEvent.FeatureURL = pObj->aURL;
			aEvent.IsEnabled  = TRUE;
			aEvent.Requery    = FALSE;
			aEvent.Source     = (XDispatch *) this;
			aEvent.State.setString(aQuery);
			pObj->xListener->statusChanged( aEvent );
			bQueryText=TRUE;
		}
		
		if(bRemoveFilter && bQueryText) break;

	}
}	


void AdrFrameController::ChangeDataSource(const Sequence< PropertyValue >& aArgs)
{
	const PropertyValue* pPropertyValue = aArgs.getConstArray();
	UsrAny aValue=pPropertyValue[0].Value;
	UString aDBTableName=aValue.getString();
	
	pDatMan->unloadDatabase();
	pDatMan->setActivDataSource(aDBTableName);
	XControlModelRef xNewModel=pDatMan->createGridModel();
			
	USHORT nCount = aStatusListeners.Count();
	FeatureStateEvent  aEvent;

	BOOL bGridMod=FALSE;
	BOOL bMenuFilter=FALSE;
	BOOL bQueryText=FALSE;
	for ( USHORT n=0; n<nCount; n++ )
	{
		AdrStatusDispatch *pObj = aStatusListeners[n];
		if ( pObj->aURL.Path == L"Adr/newGridModel" )
		{
			aEvent.FeatureURL = pObj->aURL;
			aEvent.IsEnabled  = TRUE;
			aEvent.Requery    = FALSE;
			aEvent.Source     = (XDispatch *) this;

			aEvent.State.set(&xNewModel, XControlModel_getReflection());
			pObj->xListener->statusChanged( aEvent );
			bGridMod=TRUE;
		}
		else if(pObj->aURL.Path == "Adr/MenuFilter")
		{
			aEvent.FeatureURL = pObj->aURL;
			aEvent.IsEnabled  = TRUE;
			aEvent.Requery    = FALSE;
			aEvent.Source     = (XDispatch *) this;
			aEvent.FeatureDescriptor=pDatMan->getQueryField();

			Sequence<UString> aStringSeq=pDatMan->getQueryFields();
			aEvent.State.set(&aStringSeq,Sequence<UString>::getReflection());
			pObj->xListener->statusChanged( aEvent );
			bMenuFilter=TRUE;
		}
		else if(pObj->aURL.Path == "Adr/query")
		{
			FeatureStateEvent aEvent;
			aEvent.FeatureURL = pObj->aURL;
			aEvent.IsEnabled  = TRUE;
			aEvent.Requery    = FALSE;
			aEvent.Source     = (XDispatch *) this;
			aEvent.State.setString(pDatMan->getQueryString());
			pObj->xListener->statusChanged( aEvent );
			bQueryText=TRUE;
		}
		else if (pObj->aURL.Path == "Adr/removeFilter" )
		{
			UString aFilterStr=pDatMan->getFilter();
			FeatureStateEvent  aEvent;
			aEvent.FeatureURL = pObj->aURL;
			aEvent.IsEnabled  = (aFilterStr.len() > 0);
			aEvent.Requery    = FALSE;
			aEvent.Source     = (XDispatch *) this;
			pObj->xListener->statusChanged( aEvent );
			//break; because there are more than one
		}
	}
	pDatMan->loadDatabase();
	if(pFieldWin)
	{
		pFieldWin->Update(pDatMan->getDatabaseForm());
	}
}	

void AdrFrameController::RecordChanged()
{
	USHORT nCount = aStatusListeners.Count();
	FeatureStateEvent  aEvent;

	for ( USHORT n=0; n<nCount; n++ )
	{
		AdrStatusDispatch *pObj = aStatusListeners[n];
		if ( pObj->aURL.Path == L"Adr/newEntry" )
		{
			aEvent.FeatureURL = pObj->aURL;
			aEvent.IsEnabled  = pDatMan->IsRecordInsertable();
			aEvent.Requery    = FALSE;					
			aEvent.Source     = (XDispatch *) this;
			pObj->xListener->statusChanged( aEvent );
		}
		else if ( pObj->aURL.Path == L"Adr/removeEntry")
		{
			aEvent.FeatureURL = pObj->aURL;
			aEvent.IsEnabled  = pDatMan->IsRecordRemovable();
			aEvent.Requery    = FALSE;
			aEvent.Source     = (XDispatch *) this;
			pObj->xListener->statusChanged( aEvent );
		}
	}
}	

void AdrFrameController::activate()
{
	if(pFieldWin) pFieldWin->Show();
}
void AdrFrameController::deactivate()
{
	if(pFieldWin) pFieldWin->Hide();
}


