
#include "ssoinit.hxx"

#ifndef _SOLAR_HRC
#include <svtools/solar.hrc>
#endif
#include "ssodlg.hxx"

#ifndef _COM_SUN_STAR_AUTH_XSSOPASSWORDCACHE_HPP_
#include <com/sun/star/auth/XSSOPasswordCache.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XNAMEACCESS_HPP_
#include <com/sun/star/container/XNameAccess.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTYVALUE_HPP_
#include <com/sun/star/beans/PropertyValue.hpp>
#endif
#ifndef _UTL_BOOTSTRAP_HXX
#include <unotools/bootstrap.hxx>
#endif

#ifndef _VOS_SECURITY_HXX_
#include <vos/security.hxx>
#endif
#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif
#ifndef _OSL_PROCESS_H_
#include <osl/process.h>
#endif
#ifndef _OSL_FILE_HXX_
#include <osl/file.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_PATHOPTIONS_HXX
#include <svtools/pathoptions.hxx>
#endif
#ifndef _RTL_USTRBUF_HXX_
#include <rtl/ustrbuf.hxx>
#endif
#ifndef _RTL_BOOTSTRAP_HXX_
#include <rtl/bootstrap.hxx>
#endif
#ifndef _SV_MSGBOX_HXX
#include <vcl/msgbox.hxx>
#endif
#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif
#ifndef _TOOLS_STREAM_HXX_
#include <tools/stream.hxx>
#endif
#ifndef _ISOLANG_HXX
#include <tools/isolang.hxx>
#endif

using namespace vos;
using namespace rtl;
using namespace osl;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::container;
using namespace ::com::sun::star::beans ;


static const OUString sBootstrap= OUString::createFromAscii( "[Bootstrap]" );

// SSO Keys
static const OUString sKeyMech	= OUString::createFromAscii( "SSO_Mechanism" );
static const OUString sKeyUser	= OUString::createFromAscii( "SSO_User" );

// SSO Values
static const OUString sValueMech= OUString::createFromAscii( "SIMPLE" );

// CFG Keys, with and without the CFG prefix
static const OUString sCfgPrefix = OUString::createFromAscii("CFG_") ;

static const OUString sSimpleKeyOffline = 
    OUString::createFromAscii("Offline") ;
static const OUString sSimpleKeyBackendService = 
    OUString::createFromAscii("BackendService") ;
static const OUString sSimpleKeyWrapperService = 
    OUString::createFromAscii("BackendWrapper") ;
static const OUString sSimpleKeyStrataService = 
    OUString::createFromAscii("Strata") ;

static const OUString sKeyOffline			=
    sCfgPrefix + sSimpleKeyOffline ;
static const OUString sKeyServerType		=
	OUString::createFromAscii( "CFG_ServerType" );
static const OUString sKeyBackendService	=
    sCfgPrefix + sSimpleKeyBackendService ;
static const OUString sKeyStrataService	=
	sCfgPrefix + sSimpleKeyStrataService ;	

// CFG Values
static const OUString sValueOffline			=
	OUString::createFromAscii( "false" );
static const OUString sValueServerType		=
	OUString::createFromAscii( "uno" );
static const OUString sValueBackendService	=
    OUString::createFromAscii(
            "com.sun.star.configuration.backend.LdapSingleBackend") ;
static const OUString sValueBackendImplementation = 
	OUString::createFromAscii(
		    "com.sun.star.comp.configuration.backend.LdapSingleBackend" );
static const OUString sValueLocalBackendService =
    OUString::createFromAscii(
            "com.sun.star.configuration.backend.LocalSingleBackend") ;
static const OUString sValueOnlineWrapperService = 
    OUString::createFromAscii(
            "com.sun.star.configuration.backend.OnlineBackend") ;


static const OUString sEquals	= OUString::createFromAscii( "=" );

static const OUString sConfigSrvc	= OUString::createFromAscii(
	"com.sun.star.configuration.ConfigurationProvider" );
static const OUString sConfigURL	= OUString::createFromAscii(
	"/org.openoffice.Setup/L10N" );
static const OUString sAccessSrvc	= OUString::createFromAscii(
	"com.sun.star.configuration.ConfigurationUpdateAccess" );
static const OUString sLocale		= OUString::createFromAscii( "ooLocale" );

static const OString  sResMgrName	= OUStringToOString(
										String::CreateFromAscii( "dkt" ) +
										String::CreateFromInt32( SOLARUPD ),
										RTL_TEXTENCODING_UTF8 );


static const OUString sValueLdap = OUString ::createFromAscii("Ldap");

#define CONFIGINI	SAL_CONFIGFILE( "configmgr" )
#define SSOINI		SAL_CONFIGFILE( "sso" )

OUString GetBootstrap( const char *	inFileName, sal_Bool isUser )
{
	OUString theIniDir;
	if ( isUser )
	{
		::utl::Bootstrap::locateUserData( theIniDir );
		theIniDir += OUString::createFromAscii( "/config/" );
	}	
	else
	{
		OUString theExec;
		osl_getExecutableFile( &theExec.pData );
		theIniDir = theExec.copy( 0, theExec.lastIndexOf( '/' ) + 1 );
	}
	return theIniDir + OUString::createFromAscii( inFileName );
}

sal_Bool IsRemoteConfigMgr( void )
{
	sal_Bool			isRemote	 = sal_False;
	::rtl::Bootstrap	theBootstrap(GetBootstrap( CONFIGINI, sal_False ));
	OUString			theOfflineValue;
	theBootstrap.getFrom( sKeyOffline,
						  theOfflineValue,
						  sValueOffline );
	if ( theOfflineValue == sValueOffline )
	{
		OUString theServerTypeValue;
		theBootstrap.getFrom( sKeyServerType,
							  theServerTypeValue );
		if ( theServerTypeValue.getLength() == 0 ||
			 theServerTypeValue == sValueServerType )
		{
			OUString theBackendServiceValue;
			theBootstrap.getFrom( sKeyBackendService,
								  theBackendServiceValue );
			isRemote = ( theBackendServiceValue == sValueBackendService ||
                    theBackendServiceValue == sValueBackendImplementation);
		
			if (!isRemote)
			{
				OUString theStrataServiceValue;
				theBootstrap.getFrom( sKeyStrataService,
									  theStrataServiceValue );
					
				if (theStrataServiceValue.indexOf(sValueLdap)!=-1)
				{
					isRemote = sal_True;
				}
			}
		}
	}
	return isRemote;
}

sal_Bool IsSimpleSSO( void )
{
	OUString			theValue;
	::rtl::Bootstrap	theUserBootstrap(GetBootstrap( SSOINI, sal_True ));
	theUserBootstrap.getFrom( sKeyMech, theValue );
	if ( theValue.getLength() == 0 )
	{
		::rtl::Bootstrap theSharedBootstrap(GetBootstrap( SSOINI, sal_False ));
		theSharedBootstrap.getFrom( sKeyMech, theValue, sValueMech );
	}
	return ( theValue == sValueMech ? sal_True : sal_False );
}

OUString GetSSOUser( void )
{
	OUString			theValue;
	OUString			theDefaultValue;
	::rtl::Bootstrap	theBootstrap(GetBootstrap( SSOINI, sal_True ));
	OSecurity().getUserName( theDefaultValue );
	theBootstrap.getFrom( sKeyUser, theValue, theDefaultValue );
	return OUString( theValue );
}

void WriteUserNameToINI( const OUString & inUserName )
{
	// ::rtl::Bootstrap doesn't support writing bootstrap entries
	// so we need to write them ourselves
	::rtl::Bootstrap	theBootstrap(GetBootstrap( SSOINI, sal_True )); 
	OUString			theIniFileName;
	theBootstrap.getIniName( theIniFileName );
	OUString theSystemPath;
	FileBase::getSystemPathFromFileURL( theIniFileName, theSystemPath );
	SvFileStream theStream;
	theStream.Open( theSystemPath, STREAM_WRITE | STREAM_TRUNC );
	if ( theStream.IsOpen() )
	{
		theStream.WriteLine( ByteString( sBootstrap.getStr(),
										 sBootstrap.getLength(),
										 RTL_TEXTENCODING_UTF8 ) );

		OUString theString = sKeyUser + sEquals + inUserName;
		theStream.WriteLine( ByteString( theString.getStr(),
										 theString.getLength(),
										 RTL_TEXTENCODING_UTF8 ) );

		theStream.Close();
	}
}

LanguageType GetLanguageType( void )
{
	LanguageType						theLanguageType		= LANGUAGE_DONTKNOW;
	try
	{
		Reference< XMultiServiceFactory >	theMSF				=
			::comphelper::getProcessServiceFactory();
        // Force the use of a local backend to get the 
        // configuration data, since the remote one cannot
        // get initialised without SSO.
        Sequence<Any> arguments(3) ;
        PropertyValue propertyValue ;

        propertyValue.Handle = -1 ;
        propertyValue.State = PropertyState_DIRECT_VALUE ;
        // Local backend service
        propertyValue.Name = sSimpleKeyBackendService ;
        propertyValue.Value <<= sValueLocalBackendService ;
        arguments [0] <<= propertyValue ;
        // Online backend wrapper, no offline cache
        propertyValue.Name = sSimpleKeyWrapperService ;
        propertyValue.Value <<= sValueOnlineWrapperService ;
        arguments [1] <<= propertyValue ;
        // No offline mode
        propertyValue.Name = sSimpleKeyOffline ;
        propertyValue.Value <<= sal_False ;
        arguments [2] <<= propertyValue ;
        // Finally get the configuration provider
		Reference< XMultiServiceFactory >	theConfigProvider	=
			Reference< XMultiServiceFactory > (
				theMSF->createInstanceWithArguments( sConfigSrvc, arguments),
				UNO_QUERY );
		if ( theConfigProvider.is() )
		{
			Sequence< Any >	theArgs( 1 );
			theArgs[ 0 ] <<= sConfigURL;	
			Reference< XNameAccess > theNameAccess =
				Reference< XNameAccess > (
					theConfigProvider->createInstanceWithArguments(
						sAccessSrvc,
						theArgs ),
					UNO_QUERY );
			if ( theNameAccess.is() )
			{
				OUString theLocale;
				theNameAccess->getByName( sLocale ) >>= theLocale;
				theLanguageType = ConvertIsoStringToLanguage( theLocale );
			}
		}
	}
	// Can use theLanguageType = LANGUAGE_DONTKNOW if unable to retrieve
	// the correct value
	catch ( Exception&  )
	{
	}

    return theLanguageType;
}

void SetUILanguage( LanguageType inLanguageType )
{
	AllSettings theSettings = GetpApp()->GetSettings();
	theSettings.SetUILanguage( inLanguageType );
	GetpApp()->SetSettings( theSettings );
}

typedef Reference< ::com::sun::star::auth::XSSOPasswordCache > PasswordCache;

static 
PasswordCache getCacheForLogin(  )
{
	try
	{
		// Currently we only have one SSO consumer i.e. config. manager
		// using remote backend. No need to initialise SSO if a local
		// manager is to be used. In addition, we only require SSO
		// initialisation  if the user's security mechanism is "SIMPLE".
        if ( IsRemoteConfigMgr() && IsSimpleSSO() )
		{
	        Reference< XMultiServiceFactory > theFactory =
		        ::comphelper::getProcessServiceFactory();

	        PasswordCache theCache(
			        theFactory->createInstance(
				        ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM(
					        "com.sun.star.auth.SSOPasswordCache" ) ) ),
			        UNO_QUERY );

            return theCache;
        }

	}
    catch ( Exception & )
	{
		// There isn't really anything to do here.
	}
    return PasswordCache();
}

sal_Bool NeedsLogin(  )
{
    return getCacheForLogin().is();
}

sal_Bool InitSSO( sal_Bool bDiscardOldCredentials )
{
    // assume that we have credentials, unless new ones are reuired
    sal_Bool bGotCredentials = ! bDiscardOldCredentials;
	try
	{
        // determines if we need to consider showing a login dialog at all
        PasswordCache theCache = getCacheForLogin();

		if ( theCache.is() )
		{
			OUString theUserName = GetSSOUser();	
			sal_Bool bIsPersistent = false;
			OUString thePassword = theCache->getPassword( theUserName,
														  bIsPersistent );

			if ( bDiscardOldCredentials ||
                 ! bIsPersistent ||
                 ! thePassword.getLength() )
			{
                bGotCredentials = false;

				LanguageType theLanguageType = GetLanguageType();
				// Geoff: do we need this
				//SetUILanguage( theLanguageType );
				ResMgr * theResMgr =
					ResMgr::CreateResMgr( sResMgrName, theLanguageType );
				SSOLoginDialog theDialog( 0, theResMgr );
				theDialog.SetName( theUserName );
				if ( theDialog.Execute() == RET_OK )
				{
					OUString theNewUserName = theDialog.GetName();
					if ( theNewUserName != theUserName )
					{
						WriteUserNameToINI( theNewUserName );

                        // JB: should this be theUserName or outside the braces ?
						theCache->removePassword( theNewUserName, sal_True);
					}
					thePassword = theDialog.GetPassword();
					theCache->addPassword(
										theNewUserName,
										thePassword,
										theDialog.IsSavePassword() );
                    bGotCredentials = true;
				}
			}
		}
	}
	catch ( ... )
	{
		// There isn't really anything to do here.
	}
    return bGotCredentials;
}
