/*************************************************************************
 *
 *  $RCSfile: containerelement.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: fs $ $Date: 2001/06/18 11:49:05 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _DBA_CORE_CONTAINERELEMENT_HXX_
#define _DBA_CORE_CONTAINERELEMENT_HXX_

#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif

#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include <com/sun/star/uno/Sequence.hxx>
#endif

namespace utl
{
	class OConfigurationTreeRoot;
}

//........................................................................
namespace dbaccess
{
//........................................................................

//==========================================================================
//= OContainerElement - an abstract base class for objects which are
//=						a) hold by a parent container under a unique name
//=						b) stored within the configuration
//==========================================================================
class SAL_NO_VTABLE OContainerElement
{
public:
	/** called when the element was inserted into a new parent container.
		@param		_rxContext			the container
		@param		_rElementName		the name of the element within the container
		@param		_rxConfigRoot		the new configuration node under which the object should be stored (on request)
	*/
	virtual void		inserted(
		const ::com::sun::star::uno::Reference< ::com::sun::star::uno::XInterface >& _rxContainer,
		const ::rtl::OUString& _rElementName,
		const ::utl::OConfigurationTreeRoot& _rConfigRoot) = 0;

	/** called when the element was removed from it's parent container.
	*/
	virtual void		removed() = 0;

	/** returns whether or not the object is currently element of a container
	*/
	virtual sal_Bool	isContainerElement() const = 0;

	/** returns a unique id which may be used for getting access to the objects implementation via an UNO tunnel
	*/
	static ::com::sun::star::uno::Sequence< sal_Int8 > getUnoTunnelImplementationId();
};

//........................................................................
}	// namespace dbaccess
//........................................................................

#endif // _DBA_CORE_CONTAINERELEMENT_HXX_

