/*************************************************************************
 *
 *  $RCSfile: strg_ifc.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: np $ $Date: 2002/03/08 14:45:20 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#include <precomp.h>
#include <store/strg_ifc.hxx>


// NOT FULLY DEFINED SERVICES
#include <store/storage.hxx>
#include <store/c_stgifc.hxx>
#include <store/g_stgifc.hxx>
#include <store/l_stgifc.hxx>


namespace ary
{
namespace store
{


//***************************       CheshireCat       ************************//

struct Interface::CheshireCat
{
    Dyn<Interface_Cpp>  pCpp;
    Dyn<Locations_Ifc>  pLocations;
    Dyn<Groups_Ifc>     pGroups;

    Storage *           pStorage;

                        CheshireCat(
                            Storage &           io_rStorage );
};

Interface::
CheshireCat::CheshireCat( Storage & io_rStorage )
    :   pCpp( new Interface_Cpp(io_rStorage) ),
        pLocations( new Locations_Ifc(io_rStorage.TheLocations()) ),
        pGroups( new Groups_Ifc(io_rStorage.TheIndependentGroups()) ),
        pStorage( &io_rStorage )
{
}


//***************************       Interface       ************************//

Interface::Interface( Storage & io_rStorage )
    :   pi( new CheshireCat(io_rStorage) )
{
}

Interface::~Interface()
{
}

Interface_Cpp &
Interface::Ifc_Cpp()
{
    return *pi->pCpp;
}

Locations_Ifc &
Interface::Ifc_Locations()
{
    return *pi->pLocations;
}

// Groups_Ifc &
// Interface::Ifc_GlobalGroups()
// {
//     return *pi->pGroups;
// }


} // namespace store
} // namespace ary


