/*************************************************************************
 *
 *  $RCSfile: ip_2s.hxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: np $ $Date: 2002/11/01 17:12:09 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef ARY_IDL_IP_2S_HXX
#define ARY_IDL_IP_2S_HXX


// USED SERVICES
    // BASE CLASSES
    // COMPONENTS
    // PARAMETERS
#include <ary/stdconstiter.hxx>
#include <ary/idl/i_language.hxx>

namespace csv
{
    class bistream;
}


namespace ary
{
namespace idl
{
namespace alphabetical_index
{
    enum E_Letter
    {
        a = int('a'),
        b,
        c,
        d,
        e,
        f,
        g,
        h,
        i,
        j,
        k,
        l,
        m,
        n,
        o,
        p,
        q,
        r,
        s,
        t,
        u,
        v,
        w,
        x,
        y,
        z,
        non_alpha = int('_'),
        MAX
    };
}

class SecondariesPilot
{
  public:
    // LIFECYCLE
    virtual             SecondariesPilot::~SecondariesPilot() {}

    // OPERATIONS
    void                Connect_Types2Ces();
    void                Gather_CrossReferences();
    void                Read_Links2DevManual(
                            csv::bstream &      i_file );

    // INQUIRY
    void                Get_AlphabeticalIndex(
                            std::vector<Ce_id> &
                                                o_rResult,
                            alphabetical_index::E_Letter
                                                i_cLetter ) const;
  private:
    virtual void        do_Connect_Types2Ces() = 0;
    virtual void        do_Gather_CrossReferences() = 0;
    virtual void        do_Read_Links2DevManual(
                            csv::bstream &      i_file ) = 0;
    virtual void        inq_Get_AlphabeticalIndex(
                            std::vector<Ce_id> &
                                                o_rResult,
                            alphabetical_index::E_Letter
                                                i_cLetter) const = 0;
};




// IMPLEMENTATION

inline void
SecondariesPilot::Connect_Types2Ces()
    { do_Connect_Types2Ces(); }

inline void                
SecondariesPilot::Gather_CrossReferences()
    { do_Gather_CrossReferences(); }

inline void
SecondariesPilot::Read_Links2DevManual( csv::bstream & i_file )
    { do_Read_Links2DevManual(i_file);  }

inline void
SecondariesPilot::Get_AlphabeticalIndex( std::vector<Ce_id> &         o_rResult,
                                         alphabetical_index::E_Letter i_cLetter ) const
    { inq_Get_AlphabeticalIndex(o_rResult, i_cLetter);  }

}   // namespace idl
}   // namespace ary



#endif

