/*************************************************************************
 *
 *  $RCSfile: VectorBtreeCompactor.java,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: abi $ $Date: 2000/11/30 18:02:54 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
package com.sun.xmlsearch.db;

import java.io.File;

public class VectorBtreeCompactor extends FullVectorBtree {
  private CompactorVectorBlock _currentLeaf;
  private byte[]          _lastKey = new byte[_vecLen];
  private int             _lastKeyLength = 0;
  private int             _limit;
  private int             _nEntries = 0;
  private int             _entry = 0;
  
  private int             _counter = 0;
  private InternalBlockState _parent = null;
  
  private final class CompactorVectorBlock extends FullVectorBlock {
    public CompactorVectorBlock(int size) {
      super(size);
    }

    protected void doMap1(VectorBtreeCompactor owner,
			  VectorBtreeCompactor target)
      throws Exception {
	//      System.err.println("# is " + number + ", leaf? " + _isLeaf);
	byte[] buffer = new byte[owner.getVectorLength()];
	if (_isLeaf)
	  for (int ix = 0; ix < _free; ix += _vecLen + 1 - _data[ix]) {
	    //	    System.err.println("compression = " + _data[ix]);
	    System.arraycopy(_data, ix+1, buffer, _data[ix], _vecLen - _data[ix]);
	    target.store(buffer);
	    //	    if (owner.find(buffer) == false) System.err.println("NOT found");
	  }
	else {
	  owner.lock(this);
	  for (int ix = 0; ix < _free; ix++) {
	    owner.accessBlock1(integerAt(ix*4)).doMap1(owner,target);
	    System.arraycopy(_data, vector(ix), buffer, 0, _vecLen);
	    target.store(buffer);
	    //	    if (owner.find(buffer) == false) System.err.println("NOT found");
	  }
	  owner.accessBlock1(integerAt(_free*4)).doMap1(owner, target);
	  owner.unlock(this);
	}
    }
  } // end of inner class
  
  private final class InternalBlockState {
    private CompactorVectorBlock _block;
    private byte[]             _lastKey = new byte[_vecLen];
    private int               _lastKeyLength;
    private int             _entry;
    private int             _nEntries;
    private int             _limit;
    private InternalBlockState _parent;
  
    public InternalBlockState(int leftChild) {
      /*
	System.out.println("NEW ROOT " + _counter);
	_block = new CompactorVectorBlock();
	_block._isLeaf = false;
	_block.setBlockNumber(_counter++);
	init(leftChild);
	*/
    }
    
    private void init(int leftChild) {
      _entry = 0;
      _nEntries = 0;
      _lastKeyLength = 0;
      _block.setIntegerAt(0, leftChild);
    }
  
    /*
      public void store(byte[] buffer, int keyLen, int id, int newBlock)
      {
      //      System.out.println(new String(buffer, 0, keyLen) + " " + id);
      int cpr = 0;
      while (cpr < _lastKeyLength && _lastKey[cpr] == buffer[cpr])
      ++cpr;
      int needed = _vecLen - cpr;
      if (_entry + needed <= _limit)
      {
      //	  _block.makeEntry(_entry, buffer, id, keyLen - cpr, cpr);
      _entry += needed;
      _nEntries++;
      _block.setIntegerAt(_nEntries*4, newBlock);
      _limit -= 4;
      _lastKeyLength = keyLen;
      System.arraycopy(buffer, cpr, _lastKey, cpr, keyLen - cpr);
      }
      else
      {
      System.out.println("NEW: SPLIT INTERNAL");
      _block.setFree(_entry);
      _block.setNumberOfEntries(_nEntries);
      if (_parent == null)
      _parent = new InternalBlockState(_block.number);
      _parent.store(buffer, keyLen, id, newBlock(_block));
      init(newBlock);
      }
      }
      */
    
    public void close() throws java.io.IOException {
      _block.setFree(_entry);
      //      _block.setNumberOfEntries(_nEntries);
      _blockManager.writeBlock(_block);
      if (_parent == null)
	System.out.println("root: " + _block._number);
      else
	_parent.close();
    }
  } // end of internal class

  public VectorBtreeCompactor(VectorBtreeParameters params, boolean update)
    throws Exception {
      _vecLen = params.getVectorLength();
      _blockSize = params.getBlockSize();
      _blockManager = new BlockManager(params, update, new BlockFactory() {
	public Block makeBlock() {
	  return new CompactorVectorBlock(_blockSize);
	}
      });
      _currentLeaf = new CompactorVectorBlock(_blockSize);
      _currentLeaf.setBlockNumber(_counter++);
      _root = accessBlock1(params.getRootPosition());
  }

  protected CompactorVectorBlock accessBlock1(int index) throws Exception {
    return (CompactorVectorBlock)_blockManager.accessBlock(index);
  }

  int testCounter = 0;
  
  private void store(byte[] vector) {
    for (int i = 0; i < _vecLen; i++)
      System.out.print("|" + (vector[i]&0xFF));
    System.out.println("|");
    ++testCounter;
  }
  
  private int newBlock(VectorBlock block) {
    int number = _counter++;
    try {
      _blockManager.writeBlock(block); // write out full
      block.setBlockNumber(number); // recycle
      _blockManager.writeBlock(block); // reserve space for new
    }
    catch (java.io.IOException e) {
      e.printStackTrace();
    }
    return number;
  }

  public void close() throws java.io.IOException {
    _currentLeaf.setFree(_entry);
    //    _currentLeaf.setNumberOfEntries(_nEntries);
    _blockManager.writeBlock(_currentLeaf);
    if (_parent == null)
      System.out.println("root: " + _currentLeaf._number);
    else
      _parent.close();
    _blockManager.close();
  }

  public void compact(File file) throws Exception {
    VectorBtreeParameters params = new VectorBtreeParameters(file,1024,0,9);
    final VectorBtreeCompactor target = new VectorBtreeCompactor(params, true);
    ((CompactorVectorBlock)_root).doMap1(this,target);
    target.close();
    System.err.println("testCounter = " + target.testCounter);
  }
  
  /*
  public static void main(String[] args) {
    try {
      Schema schema = new Schema(args[0], false);
      VectorBtreeParameters params = new VectorBtreeParameters(schema, "EDGE");
      VectorBtreeCompactor source = new VectorBtreeCompactor(params, false);
      URL url = new URL("file", "", args[1]);
      source.compact(url);
    }
    catch (Exception e) {
      System.err.println(e);
      e.printStackTrace();
    }
  }
  */
}
