/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.util;

import java.awt.Color;

public class ColourConverter {
    private static final short BLACK = 0;
    private static final short SILVER = 1;
    private static final short GREY = 2;
    private static final short WHITE = 3;
    private static final short RED = 4;
    private static final short LIME = 5;
    private static final short BLUE = 6;
    private static final short AQUA = 7;
    private static final short FUCHSIA = 8;
    private static final short YELLOW = 9;
    private static final short MAROON = 10;
    private static final short GREEN = 11;
    private static final short NAVY = 12;
    private static final short TEAL = 13;
    private static final short PURPLE = 14;
    public static final short OLIVE = 15;
    private short[] tableLookup = null;

    public ColourConverter() {
    }

    public ColourConverter(short[] sArray) {
        this.tableLookup = sArray;
    }

    private short colourLookup(short s) {
        if (this.tableLookup != null) {
            return this.tableLookup[s];
        }
        return s;
    }

    public short convertFromRGB(Color color) {
        int n = 0;
        int n2 = 0;
        int[] nArray = new int[3];
        nArray[2] = 128;
        int[] nArray2 = nArray;
        int n3 = color.getRed();
        int n4 = color.getGreen();
        int n5 = color.getBlue();
        if (n3 > 192 && n4 > 192 && n5 > 192) {
            if (n3 != 255) {
                n3 = this.getClosest(n3, nArray2);
            }
            if (n4 != 255) {
                n4 = this.getClosest(n4, nArray2);
            }
            if (n5 != 255) {
                n5 = this.getClosest(n5, nArray2);
            }
        }
        n += this.getClosest(n3) << 16;
        n += this.getClosest(n4) << 8;
        if (((n += this.getClosest(n5)) & 0xFF0000) == 0xFF0000 || (n & 0xFF00) == 65280 || (n & 0xFF) == 255) {
            if ((n & 0xFF0000) == 0x800000) {
                n ^= 0x800000;
            }
            if ((n & 0xFF00) == 32768) {
                n ^= 0x8000;
            }
            if ((n & 0xFF) == 128) {
                n ^= 0x80;
            }
        }
        switch (n) {
            case 0: {
                n2 = 0;
                break;
            }
            case 0x808080: {
                if (!this.isGrey(color)) {
                    n2 = 1;
                    break;
                }
                n2 = 2;
                break;
            }
            case 0xFFFFFF: {
                if (!this.isGrey(color)) {
                    n2 = 3;
                    break;
                }
                n2 = 2;
                break;
            }
            case 0xFF0000: {
                n2 = 4;
                break;
            }
            case 65280: {
                n2 = 5;
                break;
            }
            case 255: {
                n2 = 6;
                break;
            }
            case 65535: {
                n2 = 7;
                break;
            }
            case 0xFF00FF: {
                n2 = 8;
                break;
            }
            case 0xFFFF00: {
                n2 = 9;
                break;
            }
            case 0x800000: {
                n2 = 10;
                break;
            }
            case 32768: {
                n2 = 11;
                break;
            }
            case 128: {
                n2 = 12;
                break;
            }
            case 32896: {
                n2 = 13;
                break;
            }
            case 0x800080: {
                n2 = 14;
                break;
            }
            case 0x808000: {
                n2 = 15;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return this.colourLookup((short)n2);
    }

    public Color convertToRGB(short s) {
        short s2 = this.indexLookup(s);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        switch (s2) {
            case 1: {
                n3 = 128;
                n2 = 128;
                n = 128;
                break;
            }
            case 2: {
                n3 = 192;
                n2 = 192;
                n = 192;
                break;
            }
            case 3: {
                n3 = 255;
                n2 = 255;
                n = 255;
                break;
            }
            case 4: {
                n = 255;
                break;
            }
            case 5: {
                n2 = 255;
                break;
            }
            case 6: {
                n3 = 255;
                break;
            }
            case 7: {
                n3 = 255;
                n2 = 255;
                break;
            }
            case 8: {
                n3 = 255;
                n = 255;
                break;
            }
            case 9: {
                n2 = 255;
                n = 255;
                break;
            }
            case 10: {
                n = 128;
                break;
            }
            case 11: {
                n2 = 128;
                break;
            }
            case 12: {
                n3 = 128;
                break;
            }
            case 13: {
                n2 = 128;
                n3 = 128;
                break;
            }
            case 14: {
                n3 = 128;
                n = 128;
                break;
            }
            case 15: {
                n2 = 128;
                n = 128;
                break;
            }
            default: {
                n3 = 0;
                n2 = 0;
                n = 0;
            }
        }
        return new Color(n, n2, n3);
    }

    private int getClosest(int n) {
        int[] nArray = new int[3];
        nArray[1] = 128;
        nArray[2] = 255;
        int[] nArray2 = nArray;
        return this.getClosest(n, nArray2);
    }

    private int getClosest(int n, int[] nArray) {
        if (n == nArray[0] || n == nArray[1] || n == nArray[2]) {
            return n;
        }
        if (n < nArray[1]) {
            int n2 = n - nArray[0];
            return Math.round((float)n2 / (float)(nArray[1] - nArray[0])) == 1 ? nArray[1] : nArray[0];
        }
        int n3 = n - nArray[1];
        return Math.round((float)n3 / (float)(nArray[2] - nArray[1])) >= 1 ? nArray[2] : nArray[1];
    }

    private short indexLookup(short n) {
        int n2 = 0;
        if (this.tableLookup != null) {
            int n3 = 0;
            while (n3 < this.tableLookup.length) {
                if (this.tableLookup[n3] == n) {
                    n2 = n3;
                }
                n3 = (short)(n3 + 1);
            }
        } else {
            n2 = n;
        }
        return (short)n2;
    }

    private boolean isGrey(Color color) {
        int n = 0;
        int[] nArray = new int[]{128, 192, 255};
        n += this.getClosest(color.getRed(), nArray) << 16;
        n += this.getClosest(color.getGreen(), nArray) << 8;
        return (n += this.getClosest(color.getBlue(), nArray)) == 0xC0C0C0;
    }
}

