/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InvalidObjectException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.openide.ErrorManager;
import org.openide.modules.Dependency;
import org.openide.modules.SpecificationVersion;
import org.openide.util.IconManager;
import org.openide.util.Lookup;
import org.openide.util.RE13;
import org.openide.util.SwingEditors;

public final class Utilities {
    public static final int OS_WINNT = 1;
    public static final int OS_WIN95 = 2;
    public static final int OS_WIN98 = 4;
    public static final int OS_SOLARIS = 8;
    public static final int OS_LINUX = 16;
    public static final int OS_HP = 32;
    public static final int OS_AIX = 64;
    public static final int OS_IRIX = 128;
    public static final int OS_SUNOS = 256;
    public static final int OS_TRU64 = 512;
    public static final int OS_DEC = 512;
    public static final int OS_OS2 = 1024;
    public static final int OS_MAC = 2048;
    public static final int OS_WIN2000 = 4096;
    public static final int OS_VMS = 8192;
    public static final int OS_WIN_OTHER = 16384;
    public static final int OS_OTHER = 65536;
    public static final int OS_WINDOWS_MASK = 20487;
    public static final int OS_UNIX_MASK = 3064;
    public static final int TYPICAL_WINDOWS_TASKBAR_HEIGHT = 27;
    private static final int TYPICAL_MACOSX_MENU_HEIGHT = 24;
    private static Reference namesAndValues;
    private static Lookup.Result systemLoaderLookupResult;
    private static final String CLASS_LOADER_LOCK = "Utilities.CLASS_LOADER_LOCK";
    private static Lookup.Result activeModulesLookupResult;
    private static final String MODULES_LOCK = "Utilities.MODULES_LOCK";
    private static final Set listeningAtModules;
    private static int operatingSystem;
    private static Reference keywords;
    private static Timer clearIntrospector;
    private static ActionListener doClear;
    private static final String TRANS_LOCK = "TRANS_LOCK";
    private static Object transLoader;
    private static RE transExp;
    static /* synthetic */ Class class$java$awt$Component;
    static /* synthetic */ Class class$java$awt$Cursor;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$awt$event$KeyEvent;
    static /* synthetic */ Class class$java$awt$GraphicsConfiguration;
    static /* synthetic */ Class class$java$awt$Toolkit;
    static /* synthetic */ Class class$java$awt$Frame;
    static /* synthetic */ Class class$java$lang$ClassLoader;

    private Utilities() {
    }

    public static final int getOperatingSystem() {
        if (operatingSystem == -1) {
            String string = System.getProperty("os.name");
            operatingSystem = "Windows NT".equals(string) ? 1 : ("Windows 95".equals(string) ? 2 : ("Windows 98".equals(string) ? 4 : ("Windows 2000".equals(string) ? 4096 : (string.startsWith("Windows ") ? 16384 : ("Solaris".equals(string) ? 8 : (string.startsWith("SunOS") ? 8 : (string.endsWith("Linux") ? 16 : ("HP-UX".equals(string) ? 32 : ("AIX".equals(string) ? 64 : ("Irix".equals(string) ? 128 : ("SunOS".equals(string) ? 256 : ("Digital UNIX".equals(string) ? 512 : ("OS/2".equals(string) ? 1024 : ("OpenVMS".equals(string) ? 8192 : (string.equals("Mac OS X") ? 2048 : (string.startsWith("Darwin") ? 2048 : 65536))))))))))))))));
        }
        return operatingSystem;
    }

    public static final boolean isWindows() {
        return (Utilities.getOperatingSystem() & 0x5007) != 0;
    }

    public static final boolean isUnix() {
        return (Utilities.getOperatingSystem() & 0xBF8) != 0;
    }

    private static synchronized HashMap keywords() {
        HashMap<String, String> hashMap;
        if (keywords != null && (hashMap = (HashMap<String, String>)keywords.get()) != null) {
            return hashMap;
        }
        hashMap = new HashMap<String, String>(71);
        hashMap.put("abstract", "abstract");
        hashMap.put("default", "default");
        hashMap.put("if", "if");
        hashMap.put("private", "private");
        hashMap.put("throw", "throw");
        hashMap.put("boolean", "boolean");
        hashMap.put("do", "do");
        hashMap.put("implements", "implements");
        hashMap.put("protected", "protected");
        hashMap.put("throws", "throws");
        hashMap.put("break", "break");
        hashMap.put("double", "double");
        hashMap.put("import", "import");
        hashMap.put("public", "public");
        hashMap.put("transient", "transient");
        hashMap.put("byte", "byte");
        hashMap.put("else", "else");
        hashMap.put("instanceof", "instanceof");
        hashMap.put("return", "return");
        hashMap.put("try", "try");
        hashMap.put("case", "case");
        hashMap.put("extends", "extends");
        hashMap.put("int", "int");
        hashMap.put("short", "short");
        hashMap.put("void", "void");
        hashMap.put("catch", "catch");
        hashMap.put("final", "final");
        hashMap.put("interface", "interface");
        hashMap.put("static", "static");
        hashMap.put("volatile", "volatile");
        hashMap.put("char", "char");
        hashMap.put("finally", "finally");
        hashMap.put("long", "long");
        hashMap.put("class", "class");
        hashMap.put("while", "while");
        hashMap.put("super", "super");
        hashMap.put("float", "float");
        hashMap.put("native", "native");
        hashMap.put("switch", "switch");
        hashMap.put("const", "const");
        hashMap.put("for", "for");
        hashMap.put("new", "new");
        hashMap.put("synchronized", "synchronized");
        hashMap.put("continue", "continue");
        hashMap.put("continue", "continue");
        hashMap.put("goto", "goto");
        hashMap.put("package", "package");
        hashMap.put("this", "this");
        hashMap.put("null", "null");
        hashMap.put("true", "true");
        hashMap.put("false", "false");
        hashMap.put("assert", "assert");
        keywords = new SoftReference(hashMap);
        return hashMap;
    }

    public static final boolean isJavaIdentifier(String string) {
        if (string == null) {
            return false;
        }
        if (string.equals("")) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        int n = 1;
        while (n < string.length()) {
            if (!Character.isJavaIdentifierPart(string.charAt(n))) {
                return false;
            }
            ++n;
        }
        return !Utilities.keywords().containsKey(string);
    }

    public static BeanInfo getBeanInfo(Class clazz) throws IntrospectionException {
        BeanInfo beanInfo = clazz.getName().startsWith("javax.swing") ? SwingEditors.scanAndSetBeanInfo(Introspector.getBeanInfo(clazz)) : Introspector.getBeanInfo(clazz);
        if ((class$java$awt$Component == null ? (class$java$awt$Component = Utilities.class$("java.awt.Component")) : class$java$awt$Component).isAssignableFrom(clazz)) {
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            int n = 0;
            while (n < propertyDescriptorArray.length) {
                if (propertyDescriptorArray[n].getName().equals("cursor")) {
                    try {
                        Method method = (class$java$awt$Component == null ? (class$java$awt$Component = Utilities.class$("java.awt.Component")) : class$java$awt$Component).getDeclaredMethod("getCursor", new Class[0]);
                        Method method2 = (class$java$awt$Component == null ? (class$java$awt$Component = Utilities.class$("java.awt.Component")) : class$java$awt$Component).getDeclaredMethod("setCursor", class$java$awt$Cursor == null ? (class$java$awt$Cursor = Utilities.class$("java.awt.Cursor")) : class$java$awt$Cursor);
                        propertyDescriptorArray[n] = new PropertyDescriptor("cursor", method, method2);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        noSuchMethodException.printStackTrace();
                    }
                    break;
                }
                ++n;
            }
        }
        if (beanInfo != null) {
            if (clearIntrospector == null) {
                doClear = new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Introspector.flushCaches();
                    }
                };
                clearIntrospector = new Timer(15000, doClear);
                clearIntrospector.setRepeats(false);
            }
            clearIntrospector.restart();
        }
        return beanInfo;
    }

    public static BeanInfo getBeanInfo(Class clazz, Class clazz2) throws IntrospectionException {
        if (clazz.getName().startsWith("javax.swing")) {
            return SwingEditors.scanAndSetBeanInfo(Introspector.getBeanInfo(clazz, clazz2));
        }
        return Introspector.getBeanInfo(clazz, clazz2);
    }

    public static String[] wrapStringToArray(String string, int n, boolean bl, boolean bl2) {
        BreakIterator breakIterator = bl ? BreakIterator.getWordInstance() : BreakIterator.getCharacterInstance();
        return Utilities.wrapStringToArray(string, n, breakIterator, bl2);
    }

    public static String[] wrapStringToArray(String string, int n, BreakIterator breakIterator, boolean bl) {
        int n2;
        int n3;
        String[] stringArray;
        block15: {
            if (string.length() == 0) {
                return new String[]{string};
            }
            if (bl) {
                string = Utilities.trimString(string);
                string = string.replace('\n', ' ');
                stringArray = new String[]{string};
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
                n3 = stringTokenizer.countTokens();
                stringArray = new String[n3];
                n2 = 0;
                while (n2 < n3) {
                    stringArray[n2] = stringTokenizer.nextToken();
                    ++n2;
                }
            }
            if (n < 1) {
                n = 1;
            }
            if (string.length() <= n) {
                return stringArray;
            }
            boolean bl2 = true;
            n3 = 0;
            while (n3 < stringArray.length) {
                boolean bl3 = bl2 = bl2 && stringArray[n3].length() < n;
                if (bl2) {
                    ++n3;
                    continue;
                }
                break block15;
            }
            return stringArray;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        n3 = 0;
        n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].length() < n) {
                arrayList.add(stringArray[n2]);
            } else {
                breakIterator.setText(stringArray[n2]);
                int n4 = breakIterator.next();
                int n5 = 0;
                while (true) {
                    if (n4 - n3 < n && n4 != -1) {
                        n5 = n4;
                        n4 = breakIterator.next();
                        continue;
                    }
                    if (n4 == -1) {
                        n4 = n5 = stringArray[n2].length();
                    }
                    if (n5 == 0) {
                        n5 = n4;
                    }
                    arrayList.add(stringArray[n2].substring(n3, n5));
                    n3 = n5;
                    n5 = 0;
                    if (n3 >= stringArray[n2].length()) break;
                }
                n3 = 0;
            }
            ++n2;
        }
        String[] stringArray2 = new String[arrayList.size()];
        return arrayList.toArray(stringArray2);
    }

    private static String trimString(String string) {
        char c;
        int n = 0;
        int n2 = string.length();
        if (n2 == 0) {
            return string;
        }
        while (((c = string.charAt(n++)) == '\n' || c == '\r') && n < n2) {
        }
        --n;
        if ((n = (string = string.substring(n)).length() - 1) < 0) {
            return string;
        }
        while (((c = string.charAt(n--)) == '\n' || c == '\r') && n >= 0) {
        }
        return string.substring(0, n + 2);
    }

    public static String wrapString(String string, int n, BreakIterator breakIterator, boolean bl) {
        String[] stringArray = Utilities.wrapStringToArray(string, n, breakIterator, bl);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < stringArray.length) {
            stringBuffer.append(stringArray[n2]);
            stringBuffer.append('\n');
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String wrapString(String string, int n, boolean bl, boolean bl2) {
        if (bl2) {
            while (string.startsWith("\n")) {
                string = string.substring(1);
            }
            while (string.endsWith("\n")) {
                string = string.substring(0, string.length() - 1);
            }
            string = string.replace('\n', ' ');
        }
        if (n < 1) {
            n = 1;
        }
        if (string.length() <= n) {
            return string;
        }
        Vector<String> vector = new Vector<String>();
        int n2 = 0;
        int n3 = -1;
        int n4 = 0;
        while (n4 < string.length()) {
            if (n2 >= string.length() - 1) break;
            if (string.charAt(n4) == '\n') {
                vector.addElement(string.substring(n2, n4));
                n2 = n4 + 1;
                n3 = -1;
            } else {
                if (Character.isSpaceChar(string.charAt(n4))) {
                    n3 = n4;
                }
                if (n4 == string.length() - 1) {
                    vector.addElement(string.substring(n2));
                    break;
                }
                if (n4 - n2 == n) {
                    if (bl && n3 != -1) {
                        vector.addElement(string.substring(n2, n3));
                        n2 = n3 + 1;
                        n3 = -1;
                    } else {
                        vector.addElement(string.substring(n2, n4));
                        n2 = n4;
                        n3 = -1;
                    }
                }
            }
            ++n4;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append((String)enumeration.nextElement());
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public static String replaceString(String string, String string2, String string3) {
        int n;
        int n2 = 0;
        if ("".equals(string2)) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        do {
            if ((n = string.indexOf(string2, n2)) == -1) {
                stringBuffer.append(string.substring(n2));
                return stringBuffer.toString();
            }
            stringBuffer.append(string.substring(n2, n));
            stringBuffer.append(string3);
        } while ((n2 = n + string2.length()) != string.length());
        return stringBuffer.toString();
    }

    public static final String pureClassName(String string) {
        int n = string.indexOf(36);
        if (n >= 0 && n < string.length()) {
            return string.substring(n + 1, string.length());
        }
        return string;
    }

    public static final boolean isLargeFrameIcons() {
        return Utilities.getOperatingSystem() == 8 || Utilities.getOperatingSystem() == 32;
    }

    public static int arrayHashCode(Object[] objectArray) {
        int n = 0;
        int n2 = objectArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Object object = objectArray[n3];
            int n4 = object == null ? 1 : object.hashCode();
            n += n4 ^ n3;
            ++n3;
        }
        return n;
    }

    public static boolean compareObjects(Object object, Object object2) {
        return Utilities.compareObjectsImpl(object, object2, 1);
    }

    public static boolean compareObjectsImpl(Object object, Object object2, int n) {
        if (object == null) {
            return object2 == null;
        }
        if (object2 == null) {
            return false;
        }
        if (n > 0) {
            if (object instanceof Object[] && object2 instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                int n2 = objectArray.length;
                Object[] objectArray2 = (Object[])object2;
                int n3 = objectArray2.length;
                if (n2 != n3) {
                    return false;
                }
                int n4 = 0;
                while (n4 < n2) {
                    if (!Utilities.compareObjectsImpl(objectArray[n4], objectArray2[n4], n - 1)) {
                        return false;
                    }
                    ++n4;
                }
                return true;
            }
            if (object instanceof byte[] && object2 instanceof byte[]) {
                byte[] byArray = (byte[])object;
                int n5 = byArray.length;
                byte[] byArray2 = (byte[])object2;
                int n6 = byArray2.length;
                if (n5 != n6) {
                    return false;
                }
                int n7 = 0;
                while (n7 < n5) {
                    if (byArray[n7] != byArray2[n7]) {
                        return false;
                    }
                    ++n7;
                }
                return true;
            }
            if (object instanceof short[] && object2 instanceof short[]) {
                short[] sArray = (short[])object;
                int n8 = sArray.length;
                short[] sArray2 = (short[])object2;
                int n9 = sArray2.length;
                if (n8 != n9) {
                    return false;
                }
                int n10 = 0;
                while (n10 < n8) {
                    if (sArray[n10] != sArray2[n10]) {
                        return false;
                    }
                    ++n10;
                }
                return true;
            }
            if (object instanceof int[] && object2 instanceof int[]) {
                int[] nArray = (int[])object;
                int n11 = nArray.length;
                int[] nArray2 = (int[])object2;
                int n12 = nArray2.length;
                if (n11 != n12) {
                    return false;
                }
                int n13 = 0;
                while (n13 < n11) {
                    if (nArray[n13] != nArray2[n13]) {
                        return false;
                    }
                    ++n13;
                }
                return true;
            }
            if (object instanceof long[] && object2 instanceof long[]) {
                long[] lArray = (long[])object;
                int n14 = lArray.length;
                long[] lArray2 = (long[])object2;
                int n15 = lArray2.length;
                if (n14 != n15) {
                    return false;
                }
                int n16 = 0;
                while (n16 < n14) {
                    if (lArray[n16] != lArray2[n16]) {
                        return false;
                    }
                    ++n16;
                }
                return true;
            }
            if (object instanceof float[] && object2 instanceof float[]) {
                float[] fArray = (float[])object;
                int n17 = fArray.length;
                float[] fArray2 = (float[])object2;
                int n18 = fArray2.length;
                if (n17 != n18) {
                    return false;
                }
                int n19 = 0;
                while (n19 < n17) {
                    if (fArray[n19] != fArray2[n19]) {
                        return false;
                    }
                    ++n19;
                }
                return true;
            }
            if (object instanceof double[] && object2 instanceof double[]) {
                double[] dArray = (double[])object;
                int n20 = dArray.length;
                double[] dArray2 = (double[])object2;
                int n21 = dArray2.length;
                if (n20 != n21) {
                    return false;
                }
                int n22 = 0;
                while (n22 < n20) {
                    if (dArray[n22] != dArray2[n22]) {
                        return false;
                    }
                    ++n22;
                }
                return true;
            }
            if (object instanceof char[] && object2 instanceof char[]) {
                char[] cArray = (char[])object;
                int n23 = cArray.length;
                char[] cArray2 = (char[])object2;
                int n24 = cArray2.length;
                if (n23 != n24) {
                    return false;
                }
                int n25 = 0;
                while (n25 < n23) {
                    if (cArray[n25] != cArray2[n25]) {
                        return false;
                    }
                    ++n25;
                }
                return true;
            }
            if (object instanceof boolean[] && object2 instanceof boolean[]) {
                boolean[] blArray = (boolean[])object;
                int n26 = blArray.length;
                boolean[] blArray2 = (boolean[])object2;
                int n27 = blArray2.length;
                if (n26 != n27) {
                    return false;
                }
                int n28 = 0;
                while (n28 < n26) {
                    if (blArray[n28] != blArray2[n28]) {
                        return false;
                    }
                    ++n28;
                }
                return true;
            }
        }
        return object.equals(object2);
    }

    public static String getClassName(Class clazz) {
        if (clazz.isArray()) {
            return Utilities.getClassName(clazz.getComponentType()) + "[]";
        }
        return clazz.getName();
    }

    public static String getShortClassName(Class clazz) {
        if (clazz.isArray()) {
            return Utilities.getShortClassName(clazz.getComponentType()) + "[]";
        }
        String string = clazz.getName().replace('$', '.');
        return string.substring(string.lastIndexOf(".") + 1, string.length());
    }

    public static Object toPrimitiveArray(Object[] objectArray) {
        if (objectArray instanceof Integer[]) {
            int[] nArray = new int[objectArray.length];
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                nArray[n2] = (Integer)objectArray[n2] == null ? 0 : (Integer)objectArray[n2];
                ++n2;
            }
            return nArray;
        }
        if (objectArray instanceof Boolean[]) {
            boolean[] blArray = new boolean[objectArray.length];
            int n = objectArray.length;
            int n3 = 0;
            while (n3 < n) {
                blArray[n3] = (Boolean)objectArray[n3] == null ? false : (Boolean)objectArray[n3];
                ++n3;
            }
            return blArray;
        }
        if (objectArray instanceof Byte[]) {
            byte[] byArray = new byte[objectArray.length];
            int n = objectArray.length;
            int n4 = 0;
            while (n4 < n) {
                byArray[n4] = (Byte)objectArray[n4] == null ? (byte)0 : (Byte)objectArray[n4];
                ++n4;
            }
            return byArray;
        }
        if (objectArray instanceof Character[]) {
            char[] cArray = new char[objectArray.length];
            int n = objectArray.length;
            int n5 = 0;
            while (n5 < n) {
                cArray[n5] = (Character)objectArray[n5] == null ? (char)'\u0000' : ((Character)objectArray[n5]).charValue();
                ++n5;
            }
            return cArray;
        }
        if (objectArray instanceof Double[]) {
            double[] dArray = new double[objectArray.length];
            int n = objectArray.length;
            int n6 = 0;
            while (n6 < n) {
                dArray[n6] = (Double)objectArray[n6] == null ? 0.0 : (Double)objectArray[n6];
                ++n6;
            }
            return dArray;
        }
        if (objectArray instanceof Float[]) {
            float[] fArray = new float[objectArray.length];
            int n = objectArray.length;
            int n7 = 0;
            while (n7 < n) {
                fArray[n7] = (Float)objectArray[n7] == null ? 0.0f : ((Float)objectArray[n7]).floatValue();
                ++n7;
            }
            return fArray;
        }
        if (objectArray instanceof Long[]) {
            long[] lArray = new long[objectArray.length];
            int n = objectArray.length;
            int n8 = 0;
            while (n8 < n) {
                lArray[n8] = (Long)objectArray[n8] == null ? 0L : (Long)objectArray[n8];
                ++n8;
            }
            return lArray;
        }
        if (objectArray instanceof Short[]) {
            short[] sArray = new short[objectArray.length];
            int n = objectArray.length;
            int n9 = 0;
            while (n9 < n) {
                sArray[n9] = (Short)objectArray[n9] == null ? (short)0 : (Short)objectArray[n9];
                ++n9;
            }
            return sArray;
        }
        throw new IllegalArgumentException();
    }

    public static Object[] toObjectArray(Object object) {
        if (object instanceof Object[]) {
            return (Object[])object;
        }
        if (object instanceof int[]) {
            int n = ((int[])object).length;
            Object[] objectArray = new Integer[n];
            int n2 = 0;
            while (n2 < n) {
                objectArray[n2] = new Integer(((int[])object)[n2]);
                ++n2;
            }
            return objectArray;
        }
        if (object instanceof boolean[]) {
            int n = ((boolean[])object).length;
            Object[] objectArray = new Boolean[n];
            int n3 = 0;
            while (n3 < n) {
                objectArray[n3] = new Boolean(((boolean[])object)[n3]);
                ++n3;
            }
            return objectArray;
        }
        if (object instanceof byte[]) {
            int n = ((byte[])object).length;
            Object[] objectArray = new Byte[n];
            int n4 = 0;
            while (n4 < n) {
                objectArray[n4] = new Byte(((byte[])object)[n4]);
                ++n4;
            }
            return objectArray;
        }
        if (object instanceof char[]) {
            int n = ((char[])object).length;
            Object[] objectArray = new Character[n];
            int n5 = 0;
            while (n5 < n) {
                objectArray[n5] = new Character(((char[])object)[n5]);
                ++n5;
            }
            return objectArray;
        }
        if (object instanceof double[]) {
            int n = ((double[])object).length;
            Object[] objectArray = new Double[n];
            int n6 = 0;
            while (n6 < n) {
                objectArray[n6] = new Double(((double[])object)[n6]);
                ++n6;
            }
            return objectArray;
        }
        if (object instanceof float[]) {
            int n = ((float[])object).length;
            Object[] objectArray = new Float[n];
            int n7 = 0;
            while (n7 < n) {
                objectArray[n7] = new Float(((float[])object)[n7]);
                ++n7;
            }
            return objectArray;
        }
        if (object instanceof long[]) {
            int n = ((long[])object).length;
            Object[] objectArray = new Long[n];
            int n8 = 0;
            while (n8 < n) {
                objectArray[n8] = new Long(((long[])object)[n8]);
                ++n8;
            }
            return objectArray;
        }
        if (object instanceof short[]) {
            int n = ((short[])object).length;
            Object[] objectArray = new Short[n];
            int n9 = 0;
            while (n9 < n) {
                objectArray[n9] = new Short(((short[])object)[n9]);
                ++n9;
            }
            return objectArray;
        }
        throw new IllegalArgumentException();
    }

    public static Class getObjectType(Class clazz) {
        if (!clazz.isPrimitive()) {
            return clazz;
        }
        if (clazz == Integer.TYPE) {
            return class$java$lang$Integer == null ? (class$java$lang$Integer = Utilities.class$("java.lang.Integer")) : class$java$lang$Integer;
        }
        if (clazz == Boolean.TYPE) {
            return class$java$lang$Boolean == null ? (class$java$lang$Boolean = Utilities.class$("java.lang.Boolean")) : class$java$lang$Boolean;
        }
        if (clazz == Byte.TYPE) {
            return class$java$lang$Byte == null ? (class$java$lang$Byte = Utilities.class$("java.lang.Byte")) : class$java$lang$Byte;
        }
        if (clazz == Character.TYPE) {
            return class$java$lang$Character == null ? (class$java$lang$Character = Utilities.class$("java.lang.Character")) : class$java$lang$Character;
        }
        if (clazz == Double.TYPE) {
            return class$java$lang$Double == null ? (class$java$lang$Double = Utilities.class$("java.lang.Double")) : class$java$lang$Double;
        }
        if (clazz == Float.TYPE) {
            return class$java$lang$Float == null ? (class$java$lang$Float = Utilities.class$("java.lang.Float")) : class$java$lang$Float;
        }
        if (clazz == Long.TYPE) {
            return class$java$lang$Long == null ? (class$java$lang$Long = Utilities.class$("java.lang.Long")) : class$java$lang$Long;
        }
        if (clazz == Short.TYPE) {
            return class$java$lang$Short == null ? (class$java$lang$Short = Utilities.class$("java.lang.Short")) : class$java$lang$Short;
        }
        throw new IllegalArgumentException();
    }

    public static Class getPrimitiveType(Class clazz) {
        if (!clazz.isPrimitive()) {
            return clazz;
        }
        if (clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = Utilities.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return Integer.TYPE;
        }
        if (clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = Utilities.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return Boolean.TYPE;
        }
        if (clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = Utilities.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return Byte.TYPE;
        }
        if (clazz == (class$java$lang$Character == null ? (class$java$lang$Character = Utilities.class$("java.lang.Character")) : class$java$lang$Character)) {
            return Character.TYPE;
        }
        if (clazz == (class$java$lang$Double == null ? (class$java$lang$Double = Utilities.class$("java.lang.Double")) : class$java$lang$Double)) {
            return Double.TYPE;
        }
        if (clazz == (class$java$lang$Float == null ? (class$java$lang$Float = Utilities.class$("java.lang.Float")) : class$java$lang$Float)) {
            return Float.TYPE;
        }
        if (clazz == (class$java$lang$Long == null ? (class$java$lang$Long = Utilities.class$("java.lang.Long")) : class$java$lang$Long)) {
            return Long.TYPE;
        }
        if (clazz == (class$java$lang$Short == null ? (class$java$lang$Short = Utilities.class$("java.lang.Short")) : class$java$lang$Short)) {
            return Short.TYPE;
        }
        throw new IllegalArgumentException();
    }

    public static Component getFocusTraversableComponent(Component component) {
        if (component.isFocusTraversable()) {
            return component;
        }
        if (!(component instanceof Container)) {
            return null;
        }
        int n = ((Container)component).getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            Component component2 = ((Container)component).getComponent(n2);
            if (component2 != null) {
                return component2;
            }
            ++n2;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String[] parseParameters(String string) {
        int n = 0;
        int n2 = 1;
        int n3 = 2;
        int n4 = 4;
        int n5 = 8;
        Vector<String> vector = new Vector<String>(5, 5);
        int n6 = n;
        StringBuffer stringBuffer = new StringBuffer(20);
        int n7 = string.length();
        int n8 = 0;
        while (n8 < n7) {
            block25: {
                char c;
                block34: {
                    block36: {
                        block35: {
                            block29: {
                                block33: {
                                    block32: {
                                        block30: {
                                            block31: {
                                                block26: {
                                                    block28: {
                                                        block27: {
                                                            c = string.charAt(n8);
                                                            if (!Character.isWhitespace(c)) break block26;
                                                            if (n6 != n) break block27;
                                                            if (stringBuffer.length() > 0) {
                                                                vector.addElement(stringBuffer.toString());
                                                                stringBuffer.setLength(0);
                                                            }
                                                            break block25;
                                                        }
                                                        if (n6 != n4) break block28;
                                                        vector.addElement(stringBuffer.toString());
                                                        stringBuffer.setLength(0);
                                                        n6 = n;
                                                        break block25;
                                                    }
                                                    if (n6 == n5) {
                                                        stringBuffer.append('\\');
                                                        vector.addElement(stringBuffer.toString());
                                                        stringBuffer.setLength(0);
                                                        n6 = n;
                                                        break block25;
                                                    } else if (n6 == n3) {
                                                        n6 = n2;
                                                        stringBuffer.append('\\');
                                                        stringBuffer.append(c);
                                                        break block25;
                                                    } else {
                                                        stringBuffer.append(c);
                                                    }
                                                    break block25;
                                                }
                                                if (c != '\\') break block29;
                                                if (n6 != n) break block30;
                                                if (++n8 >= n7) break block31;
                                                char c2 = string.charAt(n8);
                                                if (c2 == '\"' || c2 == '\\') {
                                                    stringBuffer.append(c2);
                                                    break block25;
                                                } else if (Character.isWhitespace(c2)) {
                                                    stringBuffer.append(c);
                                                    --n8;
                                                    break block25;
                                                } else {
                                                    stringBuffer.append(c);
                                                    stringBuffer.append(c2);
                                                }
                                                break block25;
                                            }
                                            stringBuffer.append('\\');
                                            break;
                                        }
                                        if (n6 != n2) break block32;
                                        n6 = n3;
                                        break block25;
                                    }
                                    if (n6 != n3) break block33;
                                    stringBuffer.append('\\');
                                    n6 = n2;
                                    break block25;
                                }
                                if (n6 == n4) {
                                    n6 = n5;
                                    break block25;
                                } else if (n6 == n5) {
                                    stringBuffer.append('\\');
                                    n6 = n4;
                                }
                                break block25;
                            }
                            if (c != '\"') break block34;
                            if (n6 != n) break block35;
                            n6 = n2;
                            break block25;
                        }
                        if (n6 != n2) break block36;
                        n6 = n4;
                        break block25;
                    }
                    if (n6 == n4) {
                        n6 = n2;
                        break block25;
                    } else if (n6 == n5) {
                        stringBuffer.append('\"');
                        n6 = n4;
                        break block25;
                    } else {
                        stringBuffer.append('\"');
                        n6 = n2;
                    }
                    break block25;
                }
                if (n6 == n3) {
                    stringBuffer.append('\\');
                    n6 = n2;
                } else if (n6 == n5) {
                    stringBuffer.append('\\');
                    n6 = n4;
                }
                stringBuffer.append(c);
            }
            ++n8;
        }
        if (n6 == n2) {
            vector.addElement(stringBuffer.toString());
        } else if ((n6 & (n3 | n5)) != 0) {
            stringBuffer.append('\\');
            vector.addElement(stringBuffer.toString());
        } else if (stringBuffer.length() != 0) {
            vector.addElement(stringBuffer.toString());
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static String escapeParameters(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            Utilities.escapeString(stringArray[n], stringBuffer);
            stringBuffer.append(' ');
            ++n;
        }
        int n2 = stringBuffer.length();
        if (n2 > 0) {
            stringBuffer.setLength(n2 - 1);
        }
        return stringBuffer.toString().trim();
    }

    private static void escapeString(String string, StringBuffer stringBuffer) {
        if (string.length() == 0) {
            stringBuffer.append("\"\"");
            return;
        }
        boolean bl = false;
        int n = stringBuffer.length();
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            char c = string.charAt(n3);
            if (Character.isWhitespace(c)) {
                bl = true;
                stringBuffer.append(c);
            } else if (c == '\\') {
                stringBuffer.append('\\').append('\\');
            } else if (c == '\"') {
                stringBuffer.append('\\').append('\"');
            } else {
                stringBuffer.append(c);
            }
            ++n3;
        }
        if (bl) {
            stringBuffer.insert(n, '\"');
            stringBuffer.append('\"');
        }
    }

    private static synchronized HashMap[] initNameAndValues() {
        Object object;
        Object[] objectArray;
        if (namesAndValues != null && (objectArray = (HashMap[])namesAndValues.get()) != null) {
            return objectArray;
        }
        objectArray = (class$java$awt$event$KeyEvent == null ? (class$java$awt$event$KeyEvent = Utilities.class$("java.awt.event.KeyEvent")) : class$java$awt$event$KeyEvent).getDeclaredFields();
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>(objectArray.length * 4 / 3 + 1, 0.75f);
        HashMap<Integer, Object> hashMap2 = new HashMap<Integer, Object>(objectArray.length * 4 / 3 + 1, 0.75f);
        int n = 0;
        while (n < objectArray.length) {
            if (Modifier.isStatic(((Field)objectArray[n]).getModifiers()) && ((String)(object = ((Field)objectArray[n]).getName())).startsWith("VK_")) {
                object = ((String)object).substring(3);
                try {
                    int n2 = ((Field)objectArray[n]).getInt(null);
                    Integer n3 = new Integer(n2);
                    hashMap.put(object, n3);
                    hashMap2.put(n3, object);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            ++n;
        }
        object = new HashMap[]{hashMap, hashMap2};
        namesAndValues = new SoftReference<Object>(object);
        return object;
    }

    public static String keyToString(KeyStroke keyStroke) {
        HashMap[] hashMapArray;
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        if (Utilities.addModifiers(stringBuffer, keyStroke.getModifiers())) {
            stringBuffer.append('-');
        }
        if ((string = (String)(hashMapArray = Utilities.initNameAndValues())[1].get(new Integer(keyStroke.getKeyCode()))) == null) {
            stringBuffer.append(keyStroke.getKeyChar());
        } else {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static KeyStroke stringToKey(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string.toUpperCase(), "-", true);
        int n = 0;
        HashMap hashMap = Utilities.initNameAndValues()[0];
        int n2 = -1;
        try {
            String string2;
            while (true) {
                if ((string2 = stringTokenizer.nextToken()).equals("-")) {
                    if (n2 == -1) continue;
                    n |= n2;
                    n2 = -1;
                    continue;
                }
                if (!stringTokenizer.hasMoreElements()) break;
                n2 = Utilities.readModifiers(string2);
            }
            Integer n3 = (Integer)hashMap.get(string2);
            if (n3 != null) {
                return KeyStroke.getKeyStroke(n3, n);
            }
            return null;
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    public static KeyStroke[] stringToKeys(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string.toUpperCase(), " ");
        ArrayList<KeyStroke> arrayList = new ArrayList<KeyStroke>();
        while (stringTokenizer.hasMoreElements()) {
            string = stringTokenizer.nextToken();
            KeyStroke keyStroke = Utilities.stringToKey(string);
            if (keyStroke == null) {
                return null;
            }
            arrayList.add(keyStroke);
        }
        return arrayList.toArray(new KeyStroke[arrayList.size()]);
    }

    private static boolean addModifiers(StringBuffer stringBuffer, int n) {
        boolean bl = false;
        if ((n & 2) != 0) {
            stringBuffer.append("C");
            bl = true;
        }
        if ((n & 8) != 0) {
            stringBuffer.append("A");
            bl = true;
        }
        if ((n & 1) != 0) {
            stringBuffer.append("S");
            bl = true;
        }
        if ((n & 4) != 0) {
            stringBuffer.append("M");
            bl = true;
        }
        return bl;
    }

    private static int readModifiers(String string) throws NoSuchElementException {
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            switch (string.charAt(n2)) {
                case 'C': {
                    n |= 2;
                    break;
                }
                case 'A': {
                    n |= 8;
                    break;
                }
                case 'M': {
                    n |= 4;
                    break;
                }
                case 'S': {
                    n |= 1;
                    break;
                }
                default: {
                    throw new NoSuchElementException();
                }
            }
            ++n2;
        }
        return n;
    }

    private static GraphicsConfiguration getCurrentGraphicsConfiguration() {
        Frame[] frameArray = Frame.getFrames();
        int n = 0;
        while (n < frameArray.length) {
            if (SwingUtilities.findFocusOwner(frameArray[n]) != null) {
                return frameArray[n].getGraphicsConfiguration();
            }
            ++n;
        }
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    public static Rectangle getUsableScreenBounds() {
        return Utilities.getUsableScreenBounds(Utilities.getCurrentGraphicsConfiguration());
    }

    public static Rectangle getUsableScreenBounds(GraphicsConfiguration graphicsConfiguration) {
        if (graphicsConfiguration == null) {
            graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        }
        Rectangle rectangle = new Rectangle(graphicsConfiguration.getBounds());
        String string = System.getProperty("netbeans.screen.insets");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
            if (stringTokenizer.countTokens() == 4) {
                try {
                    rectangle.y = Integer.parseInt(stringTokenizer.nextToken());
                    rectangle.x = Integer.parseInt(stringTokenizer.nextToken());
                    rectangle.height -= rectangle.y + Integer.parseInt(stringTokenizer.nextToken());
                    rectangle.width -= rectangle.x + Integer.parseInt(stringTokenizer.nextToken());
                }
                catch (NumberFormatException numberFormatException) {
                    ErrorManager.getDefault().notify(16, numberFormatException);
                }
            }
            return rectangle;
        }
        string = System.getProperty("netbeans.taskbar.height");
        if (string != null) {
            rectangle.height -= Integer.getInteger(string, 0).intValue();
            return rectangle;
        }
        if (Dependency.JAVA_SPEC.compareTo(new SpecificationVersion("1.4")) >= 0) {
            try {
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                Method method = (class$java$awt$Toolkit == null ? (class$java$awt$Toolkit = Utilities.class$("java.awt.Toolkit")) : class$java$awt$Toolkit).getMethod("getScreenInsets", class$java$awt$GraphicsConfiguration == null ? (class$java$awt$GraphicsConfiguration = Utilities.class$("java.awt.GraphicsConfiguration")) : class$java$awt$GraphicsConfiguration);
                if (method == null) {
                    return rectangle;
                }
                Insets insets = (Insets)method.invoke((Object)toolkit, graphicsConfiguration);
                rectangle.y += insets.top;
                rectangle.x += insets.left;
                rectangle.height -= insets.top + insets.bottom;
                rectangle.width -= insets.left + insets.right;
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(16, exception);
            }
            return rectangle;
        }
        if (Utilities.isWindows()) {
            rectangle.height -= 27;
            return rectangle;
        }
        if ((Utilities.getOperatingSystem() & 0x800) != 0) {
            rectangle.height -= 24;
            rectangle.y += 24;
            return rectangle;
        }
        return rectangle;
    }

    public static Rectangle findCenterBounds(Dimension dimension) {
        return Utilities.findCenterBounds(Utilities.getCurrentGraphicsConfiguration(), dimension);
    }

    private static Rectangle findCenterBounds(GraphicsConfiguration graphicsConfiguration, Dimension dimension) {
        if (graphicsConfiguration == null) {
            graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        }
        Rectangle rectangle = graphicsConfiguration.getBounds();
        return new Rectangle(rectangle.x + (rectangle.width - dimension.width) / 2, rectangle.y + (rectangle.height - dimension.height) / 2, dimension.width, dimension.height);
    }

    public static final Dimension getScreenSize() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        if (Utilities.isWindows() && !Boolean.getBoolean("netbeans.no.taskbar")) {
            dimension.height -= 27;
        } else if ((Utilities.getOperatingSystem() & 0x800) != 0) {
            dimension.height -= 24;
        }
        return dimension;
    }

    public static final int showJFileChooser(JFileChooser jFileChooser, Component component, String string) {
        if (string != null) {
            jFileChooser.setApproveButtonText(string);
            jFileChooser.setDialogType(2);
        }
        Frame frame = null;
        Dialog dialog = null;
        if (component instanceof Dialog) {
            dialog = (Dialog)component;
        } else {
            frame = component instanceof Frame ? (Frame)component : (Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame == null ? (class$java$awt$Frame = Utilities.class$("java.awt.Frame")) : class$java$awt$Frame, component);
        }
        String string2 = jFileChooser.getDialogTitle();
        if (string2 == null) {
            string2 = jFileChooser.getUI().getDialogTitle(jFileChooser);
        }
        final JDialog jDialog = dialog != null ? new JDialog(dialog, string2, true) : new JDialog(frame, string2, true);
        jDialog.setDefaultCloseOperation(2);
        Container container = jDialog.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)jFileChooser, "Center");
        jDialog.pack();
        jDialog.setBounds(Utilities.findCenterBounds(component.getGraphicsConfiguration(), jDialog.getSize()));
        jFileChooser.rescanCurrentDirectory();
        final int[] nArray = new int[]{1};
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand() == "ApproveSelection") {
                    nArray[0] = 0;
                }
                jDialog.setVisible(false);
                jDialog.dispose();
            }
        };
        jFileChooser.addActionListener(actionListener);
        jDialog.show();
        return nArray[0];
    }

    public static List partialSort(List list, Comparator comparator, boolean bl) throws UnorderableException {
        Object object;
        Iterator iterator;
        HashMap hashMap = new HashMap();
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2 + 1;
            while (n3 < n) {
                int n4 = comparator.compare(list.get(n2), list.get(n3));
                if (n4 != 0) {
                    Object e = list.get(n4 < 0 ? n2 : n3);
                    iterator = list.get(n4 > 0 ? n2 : n3);
                    object = (Set)hashMap.get(iterator);
                    if (object == null) {
                        object = new HashSet();
                        hashMap.put(iterator, object);
                    }
                    object.add(e);
                }
                ++n3;
            }
            ++n2;
        }
        LinkedList linkedList = new LinkedList(list);
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        while (linkedList.size() > 0) {
            boolean bl2 = false;
            iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                Set set = (Set)hashMap.get(object);
                if (set != null && set.size() != 0) continue;
                iterator.remove();
                bl2 = true;
                arrayList.add(object);
                Iterator iterator2 = linkedList.iterator();
                while (iterator2.hasNext()) {
                    Object e = iterator2.next();
                    Set set2 = (Set)hashMap.get(e);
                    if (set2 == null) continue;
                    set2.remove(object);
                }
                if (bl) break;
            }
            if (bl2) continue;
            throw new UnorderableException(linkedList, hashMap);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String translate(String string) {
        RE rE;
        Utilities.checkMapping();
        String string2 = TRANS_LOCK;
        synchronized (string2) {
            rE = transExp;
        }
        if (rE == null) {
            return string;
        }
        RE rE2 = rE;
        synchronized (rE2) {
            String string3 = rE.convert(string);
            return string3;
        }
    }

    private static void checkMapping() {
        if (transLoader == TRANS_LOCK) {
            return;
        }
        ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = Utilities.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader);
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        if (transLoader == classLoader) {
            return;
        }
        Utilities.initForLoader(classLoader, classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void initForLoader(ClassLoader classLoader, Object object) {
        String[] stringArray;
        Object object2;
        Object object3;
        Enumeration<URL> enumeration;
        if (object == null) {
            object = TRANS_LOCK;
        }
        try {
            enumeration = classLoader.getResources("META-INF/netbeans/translate.names");
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, iOException);
            enumeration = null;
        }
        if (enumeration == null || !enumeration.hasMoreElements()) {
            String string = TRANS_LOCK;
            synchronized (string) {
                transLoader = object;
                transExp = null;
            }
            return;
        }
        RE rE = null;
        if (Dependency.JAVA_SPEC.compareTo(new SpecificationVersion("1.4")) >= 0) {
            try {
                rE = (RE)Class.forName("org.openide.util.RE14").newInstance();
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (rE == null) {
            rE = new RE13();
        }
        TreeSet treeSet = new TreeSet(new Comparator(){

            public int compare(Object object, Object object2) {
                int n;
                String string = ((String[])object)[0];
                String string2 = ((String[])object2)[0];
                int n2 = string.length();
                if (n2 != (n = string2.length())) {
                    return n - n2;
                }
                return string2.compareTo(string);
            }
        });
        while (enumeration.hasMoreElements()) {
            object3 = enumeration.nextElement();
            try {
                object2 = new BufferedReader(new InputStreamReader(((URL)object3).openStream(), "UTF8"));
                Utilities.loadTranslationFile(rE, (BufferedReader)object2, treeSet);
                ((BufferedReader)object2).close();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, iOException);
            }
        }
        object3 = new String[treeSet.size()];
        object2 = new String[((String[])object3).length];
        int n = 0;
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            stringArray = (String[])iterator.next();
            object3[n] = stringArray[1].intern();
            object2[n] = stringArray[0];
            ++n;
        }
        stringArray = "TRANS_LOCK";
        synchronized (stringArray) {
            if (((Object)object3).length == 0) {
                transExp = null;
            } else {
                transExp = rE;
                transExp.init((String[])object2, (String[])object3);
            }
            transLoader = object;
        }
    }

    private static void loadTranslationFile(RE rE, BufferedReader bufferedReader, Set set) throws IOException {
        String string;
        while ((string = bufferedReader.readLine()) != null) {
            if (string.length() == 0 || string.startsWith("#")) continue;
            String[] stringArray = rE.readPair(string);
            if (stringArray == null) {
                throw new InvalidObjectException("Line is invalid: " + string);
            }
            set.add(stringArray);
        }
    }

    public static final Image mergeImages(Image image, Image image2, int n, int n2) {
        return IconManager.mergeImages(image, image2, n, n2);
    }

    public static final Image loadImage(String string) {
        return IconManager.getIcon(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        listeningAtModules = new HashSet();
        operatingSystem = -1;
    }

    static interface RE {
        public void init(String[] var1, String[] var2);

        public String convert(String var1);

        public String[] readPair(String var1);
    }

    static final class StringArrayComparator
    implements Comparator {
        StringArrayComparator() {
        }

        public boolean equals(Object object) {
            return super.equals(object);
        }

        public int compare(Object object, Object object2) {
            String[] stringArray = (String[])object;
            String[] stringArray2 = (String[])object2;
            return stringArray2[0].length() - stringArray[0].length();
        }
    }

    public static class UnorderableException
    extends RuntimeException {
        private Collection unorderable;
        private Map deps;
        static final long serialVersionUID = 6749951134051806661L;

        public UnorderableException(Collection collection, Map map) {
            this.unorderable = collection;
            this.deps = map;
        }

        public UnorderableException(String string, Collection collection, Map map) {
            super(string);
            this.unorderable = collection;
            this.deps = map;
        }

        public Collection getUnorderable() {
            return this.unorderable;
        }

        public Map getDeps() {
            return this.deps;
        }
    }
}

