/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src.nodes;

import java.beans.PropertyEditor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.editors.ModifierEditor;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.src.Identifier;
import org.openide.src.MemberElement;
import org.openide.src.SourceException;
import org.openide.src.nodes.ElementNode;
import org.openide.src.nodes.SourceEditSupport;
import org.openide.util.Utilities;

public abstract class MemberElementNode
extends ElementNode {
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$String;

    public MemberElementNode(MemberElement memberElement, Children children, boolean bl) {
        super(memberElement, children, bl);
        this.superSetName(memberElement.getName().getName());
    }

    public void setName(final String string) {
        try {
            if (this.testJavaId(string)) {
                SourceEditSupport.invokeAtomicAsUser(this.element, new SourceEditSupport.ExceptionalRunnable(){

                    public void run() throws SourceException {
                        ((MemberElement)MemberElementNode.this.element).setName(Identifier.create(string));
                        MemberElementNode.this.superSetName(string);
                    }
                });
            }
        }
        catch (IOException iOException) {
            MessageFormat messageFormat = new MessageFormat(ElementNode.bundle.getString("MSG_ElementCantRename"));
            String[] stringArray = new String[]{((MemberElement)this.element).getName().toString(), iOException.getMessage()};
            if (stringArray[1] == null) {
                stringArray[1] = "";
            }
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Invalid name");
            ErrorManager.getDefault().annotate(illegalArgumentException, 256, null, messageFormat.format(stringArray), iOException, null);
            throw illegalArgumentException;
        }
    }

    boolean testJavaId(String string) throws IllegalArgumentException {
        boolean bl = Utilities.isJavaIdentifier(string);
        if (!bl) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Invalid identifier");
            ErrorManager.getDefault().annotate(illegalArgumentException, 256, null, ElementNode.bundle.getString("MSG_Not_Valid_Identifier"), null, null);
            throw illegalArgumentException;
        }
        return bl;
    }

    protected Node.Property createModifiersProperty(boolean bl) {
        ElementNode.ElementProp elementProp = new ElementNode.ElementProp("modifiers", class$java$lang$Integer == null ? (class$java$lang$Integer = MemberElementNode.class$("java.lang.Integer")) : class$java$lang$Integer, bl){

            public Object getValue() {
                return new Integer(((MemberElement)MemberElementNode.this.element).getModifiers());
            }

            public void setValue(Object object) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                super.setValue(object);
                if (!(object instanceof Integer)) {
                    throw new IllegalArgumentException();
                }
                this.runAtomic(MemberElementNode.this.element, new SourceEditSupport.ExceptionalRunnable(this, object){
                    private final /* synthetic */ Object val$val;
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$val = object;
                    }

                    public void run() throws SourceException {
                        ((MemberElement)2.access$000(this.this$1).element).setModifiers((Integer)this.val$val);
                    }
                });
            }

            public PropertyEditor getPropertyEditor() {
                return new ModifierEditor(((MemberElement)MemberElementNode.this.element).getModifiersMask());
            }

            static /* synthetic */ MemberElementNode access$000(2 var0) {
                return var0.MemberElementNode.this;
            }
        };
        elementProp.setValue("changeImmediate", Boolean.FALSE);
        return elementProp;
    }

    protected Node.Property createNameProperty(boolean bl) {
        return new ElementNode.ElementProp("name", class$java$lang$String == null ? (class$java$lang$String = MemberElementNode.class$("java.lang.String")) : class$java$lang$String, bl){

            public Object getValue() {
                return ((MemberElement)MemberElementNode.this.element).getName().getName();
            }

            public void setValue(Object object) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                super.setValue(object);
                if (!(object instanceof String)) {
                    throw new IllegalArgumentException();
                }
                this.runAtomic(MemberElementNode.this.element, new SourceEditSupport.ExceptionalRunnable(this, object){
                    private final /* synthetic */ Object val$val;
                    private final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$val = object;
                    }

                    public void run() throws SourceException {
                        String string;
                        String string2 = string = ((String)this.val$val).trim();
                        String string3 = ((MemberElement)4.access$100(this.this$1).element).getName().getFullName();
                        int n = string3.lastIndexOf(".");
                        if (n != -1) {
                            string2 = string3.substring(0, n + 1) + string;
                        }
                        if (4.access$100(this.this$1).testJavaId(string)) {
                            ((MemberElement)4.access$100(this.this$1).element).setName(Identifier.create(string2, string));
                        }
                    }
                });
            }

            static /* synthetic */ MemberElementNode access$100(4 var0) {
                return var0.MemberElementNode.this;
            }
        };
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

