/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import org.openide.ErrorManager;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

class TreeViewCellEditor
extends DefaultTreeCellEditor
implements CellEditorListener,
FocusListener {
    static final long serialVersionUID = -2171725285964032312L;
    boolean dndActive = false;
    private boolean cancelled = false;
    private boolean stopped = false;
    static /* synthetic */ Class class$org$openide$explorer$view$TreeViewCellEditor;

    public TreeViewCellEditor(JTree jTree, DefaultTreeCellRenderer defaultTreeCellRenderer) {
        super(jTree, defaultTreeCellRenderer);
        this.addCellEditorListener(this);
    }

    /*
     * Unable to fully structure code
     */
    public void editingStopped(ChangeEvent var1_1) {
        block8: {
            if (this.stopped) {
                return;
            }
            this.stopped = true;
            var2_2 = this.lastPath;
            if (var2_2 != null && (var3_3 = Visualizer.findNode(var2_2.getLastPathComponent())) != null && var3_3.canRename()) {
                block9: {
                    var4_4 = (String)this.getCellEditorValue();
                    try {
                        if (!var3_3.getName().equals(var4_4)) {
                            var3_3.setName(var4_4);
                        }
                        break block8;
                    }
                    catch (IllegalArgumentException var5_5) {
                        var6_6 = true;
                        var7_7 = ErrorManager.getDefault();
                        var8_8 = var7_7.findAnnotations(var5_5);
                        if (var8_8 == null || var8_8.length <= 0) break block9;
                        var9_9 = 0;
                        ** while (var9_9 < var8_8.length)
                    }
lbl-1000:
                    // 1 sources

                    {
                        var10_11 = var8_8[var9_9].getLocalizedMessage();
                        if (var10_11 != null && !var10_11.equals("")) {
                            var6_6 = false;
                        }
                        ++var9_9;
                        continue;
                    }
                }
                if (var6_6) {
                    var9_10 = NbBundle.getMessage(TreeViewCellEditor.class$org$openide$explorer$view$TreeViewCellEditor == null ? (TreeViewCellEditor.class$org$openide$explorer$view$TreeViewCellEditor = TreeViewCellEditor.class$("org.openide.explorer.view.TreeViewCellEditor")) : TreeViewCellEditor.class$org$openide$explorer$view$TreeViewCellEditor, "RenameFailed", var3_3.getName(), var4_4);
                    var7_7.annotate((Throwable)var5_5, var9_10);
                }
                var7_7.notify(256, var5_5);
            }
        }
    }

    public void editingCanceled(ChangeEvent changeEvent) {
        this.cancelled = true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JTextField) {
            this.cancelled = true;
            this.cancelCellEditing();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this.stopped || this.cancelled) {
            return;
        }
        if (!this.stopCellEditing()) {
            this.cancelCellEditing();
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    protected TreeCellEditor createTreeCellEditor() {
        JTextField jTextField = new JTextField(){

            public void addNotify() {
                TreeViewCellEditor.this.stopped = (TreeViewCellEditor.this.cancelled = false);
                super.addNotify();
                this.requestFocus();
            }
        };
        jTextField.registerKeyboardAction(this, KeyStroke.getKeyStroke(27, 0, true), 0);
        jTextField.addFocusListener(this);
        Ed ed = new Ed(jTextField);
        ed.setClickCountToStart(1);
        return ed;
    }

    public boolean isCellEditable(EventObject eventObject) {
        if (eventObject != null && eventObject instanceof MouseEvent && !SwingUtilities.isLeftMouseButton((MouseEvent)eventObject)) {
            return false;
        }
        if (this.lastPath != null) {
            Node node = Visualizer.findNode(this.lastPath.getLastPathComponent());
            if (node == null || !node.canRename()) {
                return false;
            }
        } else {
            return false;
        }
        if (this.dndActive) {
            return false;
        }
        return super.isCellEditable(eventObject);
    }

    protected void determineOffset(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
        if (this.renderer != null) {
            this.renderer.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, true);
            this.editingIcon = this.renderer.getIcon();
            this.offset = this.renderer.getIconTextGap() + this.editingIcon.getIconWidth();
        } else {
            this.editingIcon = null;
            this.offset = 0;
        }
    }

    void setDnDActive(boolean bl) {
        this.dndActive = bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class Ed
    extends DefaultCellEditor {
        static final long serialVersionUID = -6373058702842751408L;

        public Ed(JTextField jTextField) {
            super(jTextField);
        }

        public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
            Node node = Visualizer.findNode(object);
            if (node != null && node.canRename()) {
                this.delegate.setValue(node.getName());
            } else {
                this.delegate.setValue("");
            }
            ((JTextField)this.editorComponent).selectAll();
            return this.editorComponent;
        }
    }
}

