/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.DrawableLegendItem;
import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.Legend;
import com.jrefinery.chart.LegendItem;
import com.jrefinery.chart.LegendItemCollection;
import com.jrefinery.chart.Spacer;
import com.jrefinery.chart.event.LegendChangeEvent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.LineMetrics;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class StandardLegend
extends Legend {
    public static final Font DEFAULT_FONT = new Font("SansSerif", 0, 10);
    private Stroke outlineStroke;
    private Paint outlinePaint;
    private Paint backgroundPaint;
    private Spacer innerGap;
    private Font itemFont;
    private Paint itemPaint;
    private Stroke keyBoxOutlineStroke = new BasicStroke(0.5f);
    private Paint keyBoxOutlinePaint = Color.lightGray;

    public StandardLegend(JFreeChart jFreeChart) {
        this(jFreeChart, 3, new Spacer(1, 2.0, 2.0, 2.0, 2.0), Color.white, new BasicStroke(), Color.gray, DEFAULT_FONT, Color.black);
    }

    public StandardLegend(JFreeChart jFreeChart, int n, Spacer spacer, Paint paint, Stroke stroke, Paint paint2, Font font, Paint paint3) {
        super(jFreeChart, n);
        this.innerGap = spacer;
        this.backgroundPaint = paint;
        this.outlineStroke = stroke;
        this.outlinePaint = paint2;
        this.itemFont = font;
        this.itemPaint = paint3;
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void setBackgroundPaint(Paint paint) {
        this.backgroundPaint = paint;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public Stroke getOutlineStroke() {
        return this.outlineStroke;
    }

    public void setOutlineStroke(Stroke stroke) {
        this.outlineStroke = stroke;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public Paint getOutlinePaint() {
        return this.outlinePaint;
    }

    public void setOutlinePaint(Paint paint) {
        this.outlinePaint = paint;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public Font getItemFont() {
        return this.itemFont;
    }

    public void setItemFont(Font font) {
        this.itemFont = font;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public Paint getItemPaint() {
        return this.itemPaint;
    }

    public void setItemPaint(Paint paint) {
        this.itemPaint = paint;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public Stroke getKeyBoxOutlineStroke() {
        return this.keyBoxOutlineStroke;
    }

    public void setKeyBoxOutlineStroke(Stroke stroke) {
        this.keyBoxOutlineStroke = stroke;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public Paint getKeyBoxOutlinePaint() {
        return this.keyBoxOutlinePaint;
    }

    public void setKeyBoxOutlinePaint(Paint paint) {
        this.keyBoxOutlinePaint = paint;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public Rectangle2D draw(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        return this.draw(graphics2D, rectangle2D, (this.getAnchor() & 1) != 0, (this.getAnchor() & 2) != 0);
    }

    protected Rectangle2D draw(Graphics2D graphics2D, Rectangle2D rectangle2D, boolean bl, boolean bl2) {
        LegendItemCollection legendItemCollection = this.getChart().getPlot().getLegendItems();
        if (legendItemCollection != null && legendItemCollection.getItemCount() > 0) {
            double d;
            double d2;
            Rectangle2D rectangle2D2 = new Rectangle2D.Double();
            Point2D.Double double_ = new Point2D.Double();
            DrawableLegendItem[] drawableLegendItemArray = new DrawableLegendItem[legendItemCollection.getItemCount()];
            graphics2D.setFont(this.itemFont);
            if (bl) {
                d2 = rectangle2D.getX() + this.getOuterGap();
                d = rectangle2D.getX() + rectangle2D.getWidth() - 2.0 * this.getOuterGap() - 1.0;
                double d3 = 0.0;
                double d4 = 0.0;
                double d5 = 0.0;
                double d6 = 0.0;
                boolean bl3 = true;
                int n = 0;
                while (n < legendItemCollection.getItemCount()) {
                    drawableLegendItemArray[n] = this.createDrawableLegendItem(graphics2D, legendItemCollection.get(n), d4, d6);
                    if (!bl3 && drawableLegendItemArray[n].getX() + drawableLegendItemArray[n].getWidth() + d2 > d) {
                        d3 = Math.max(d3, d4);
                        d4 = 0.0;
                        d6 += d5;
                        --n;
                        bl3 = true;
                    } else {
                        d5 = Math.max(d5, drawableLegendItemArray[n].getHeight());
                        d4 += drawableLegendItemArray[n].getWidth();
                        bl3 = false;
                    }
                    ++n;
                }
                d3 = Math.max(d3, d4);
                rectangle2D2 = new Rectangle2D.Double(0.0, 0.0, d3, d6 += d5);
                double d7 = bl2 ? rectangle2D.getY() + rectangle2D.getHeight() - d6 - this.getOuterGap() : rectangle2D.getY() + this.getOuterGap();
                double d8 = rectangle2D.getX() + rectangle2D.getWidth() / 2.0 - d3 / 2.0;
                double_ = new Point2D.Double(d8, d7);
            } else {
                d2 = 0.0;
                d = 0.0;
                graphics2D.setFont(this.itemFont);
                int n = 0;
                while (n < drawableLegendItemArray.length) {
                    drawableLegendItemArray[n] = this.createDrawableLegendItem(graphics2D, legendItemCollection.get(n), 0.0, d2);
                    d2 += drawableLegendItemArray[n].getHeight();
                    d = Math.max(d, drawableLegendItemArray[n].getWidth());
                    ++n;
                }
                rectangle2D2 = new Rectangle2D.Float(0.0f, 0.0f, (float)d, (float)d2);
                double d9 = bl2 ? rectangle2D.getMaxX() - d - this.getOuterGap() : rectangle2D.getX() + this.getOuterGap();
                double d10 = rectangle2D.getY() + rectangle2D.getHeight() / 2.0 - d2 / 2.0;
                double_ = new Point2D.Double(d9, d10);
            }
            graphics2D.translate(((Point2D)double_).getX(), ((Point2D)double_).getY());
            graphics2D.setPaint(this.backgroundPaint);
            graphics2D.fill(rectangle2D2);
            graphics2D.setPaint(this.outlinePaint);
            graphics2D.setStroke(this.outlineStroke);
            graphics2D.draw(rectangle2D2);
            int n = 0;
            while (n < drawableLegendItemArray.length) {
                graphics2D.setPaint(drawableLegendItemArray[n].getItem().getPaint());
                Shape shape = drawableLegendItemArray[n].getMarker();
                graphics2D.fill(shape);
                if (this.getOutlineKeyBoxes()) {
                    graphics2D.setPaint(this.keyBoxOutlinePaint);
                    graphics2D.setStroke(this.keyBoxOutlineStroke);
                    graphics2D.draw(shape);
                }
                graphics2D.setPaint(this.itemPaint);
                graphics2D.setFont(this.itemFont);
                graphics2D.drawString(drawableLegendItemArray[n].getItem().getLabel(), (float)drawableLegendItemArray[n].getLabelPosition().getX(), (float)drawableLegendItemArray[n].getLabelPosition().getY());
                ++n;
            }
            graphics2D.translate(-((Point2D)double_).getX(), -((Point2D)double_).getY());
            if (bl) {
                double d11 = rectangle2D.getY();
                double d12 = bl2 ? d11 : d11 + rectangle2D2.getHeight() + this.getOuterGap();
                return new Rectangle2D.Double(rectangle2D.getX(), d12, rectangle2D.getWidth(), rectangle2D.getHeight() - rectangle2D2.getHeight() - 2.0 * this.getOuterGap());
            }
            double d13 = bl2 ? rectangle2D.getX() : rectangle2D.getX() + rectangle2D2.getWidth() + 2.0 * this.getOuterGap();
            return new Rectangle2D.Double(d13, rectangle2D.getY(), rectangle2D.getWidth() - rectangle2D2.getWidth() - 2.0 * this.getOuterGap(), rectangle2D.getHeight());
        }
        return rectangle2D;
    }

    private Rectangle2D getLegendBox(int n, int n2, float f, Rectangle2D rectangle2D) {
        int n3 = 2;
        float f2 = f * 0.7f;
        float f3 = (float)rectangle2D.getX() + (float)n3 + 0.15f * f;
        float f4 = (float)rectangle2D.getY() + (float)n3 + ((float)n + 0.15f) * f;
        return new Rectangle2D.Float(f3, f4, f2, f2);
    }

    private DrawableLegendItem createDrawableLegendItem(Graphics2D graphics2D, LegendItem legendItem, double d, double d2) {
        int n = 2;
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        LineMetrics lineMetrics = fontMetrics.getLineMetrics(legendItem.getLabel(), graphics2D);
        float f = lineMetrics.getAscent();
        float f2 = f + lineMetrics.getDescent() + lineMetrics.getLeading();
        DrawableLegendItem drawableLegendItem = new DrawableLegendItem(legendItem);
        float f3 = (float)(d + (double)n + (double)(1.15f * f2));
        float f4 = (float)(d2 + (double)n + (double)(0.15f * f2) + (double)f);
        drawableLegendItem.setLabelPosition(new Point2D.Float(f3, f4));
        float f5 = f2 * 0.7f;
        f3 = (float)(d + (double)n + (double)(0.15f * f2));
        f4 = (float)(d2 + (double)n + (double)(0.15f * f2));
        drawableLegendItem.setMarker(new Rectangle2D.Float(f3, f4, f5, f5));
        float f6 = (float)(drawableLegendItem.getLabelPosition().getX() - d + fontMetrics.getStringBounds(legendItem.getLabel(), graphics2D).getWidth() + 0.5 * (double)f);
        float f7 = (float)(2 * n) + f2;
        drawableLegendItem.setBounds(d, d2, f6, f7);
        return drawableLegendItem;
    }
}

