/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxw.aportisdoc;

import java.io.IOException;
import org.openoffice.xmerge.ConvertData;
import org.openoffice.xmerge.ConvertException;
import org.openoffice.xmerge.Document;
import org.openoffice.xmerge.DocumentSerializer;
import org.openoffice.xmerge.converter.palm.PalmDocument;
import org.openoffice.xmerge.converter.palm.Record;
import org.openoffice.xmerge.converter.xml.OfficeConstants;
import org.openoffice.xmerge.converter.xml.sxw.SxwDocument;
import org.openoffice.xmerge.converter.xml.sxw.aportisdoc.DocConstants;
import org.openoffice.xmerge.converter.xml.sxw.aportisdoc.DocEncoder;
import org.openoffice.xmerge.util.Debug;
import org.openoffice.xmerge.util.XmlUtil;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DocumentSerializerImpl
implements OfficeConstants,
DocConstants,
DocumentSerializer {
    private DocEncoder encoder = null;
    private SxwDocument sxwDoc = null;

    public DocumentSerializerImpl(Document doc) {
        this.sxwDoc = (SxwDocument)doc;
    }

    public ConvertData serialize() throws ConvertException, IOException {
        String docName = this.sxwDoc.getName();
        org.w3c.dom.Document domDoc = this.sxwDoc.getContentDOM();
        this.encoder = new DocEncoder();
        NodeList list = domDoc.getElementsByTagName("office:body");
        int len = list.getLength();
        if (len > 0) {
            Node node = list.item(0);
            this.traverseBody(node);
        }
        Record[] records = this.encoder.getRecords();
        ConvertData cd = new ConvertData();
        PalmDocument palmDoc = new PalmDocument(docName, DocConstants.CREATOR_ID, DocConstants.TYPE_ID, 0, 8, records);
        cd.addDocument((Document)palmDoc);
        return cd;
    }

    private void traverseBody(Node node) throws IOException {
        this.log("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.log("<AportisDOC>");
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            int len = nodeList.getLength();
            int i = 0;
            while (i < len) {
                Node child = nodeList.item(i);
                if (child.getNodeType() == 1) {
                    String nodeName = child.getNodeName();
                    if (nodeName.equals("text:p") || nodeName.equals("text:h")) {
                        this.traverseParagraph(child);
                    } else if (nodeName.equals("text:unordered-list")) {
                        this.traverseList(child);
                    } else if (nodeName.equals("text:ordered-list")) {
                        this.traverseList(child);
                    } else {
                        this.log("<OTHERS " + XmlUtil.getNodeInfo((Node)child) + " />");
                    }
                }
                ++i;
            }
        }
        this.log("</AportisDOC>");
    }

    private void traverseParagraph(Node node) throws IOException {
        this.log("<PARA>");
        this.traverseParaContents(node);
        this.encoder.addText('\n');
        this.log("</PARA>");
    }

    private void traverseParaContents(Node node) throws IOException {
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            int len = nodeList.getLength();
            int i = 0;
            while (i < len) {
                Node child = nodeList.item(i);
                short nodeType = child.getNodeType();
                switch (nodeType) {
                    case 3: {
                        String s = child.getNodeValue();
                        if (s.length() > 0) {
                            this.encoder.addText(s);
                        }
                        this.log("<TEXT>");
                        this.log(s);
                        this.log("</TEXT>");
                        break;
                    }
                    case 1: {
                        this.traverseParaElem(child);
                        break;
                    }
                    case 5: {
                        this.log("<ENTITY_REFERENCE>");
                        this.traverseParaContents(child);
                        this.log("<ENTITY_REFERENCE/>");
                        break;
                    }
                    default: {
                        this.log("<OTHERS " + XmlUtil.getNodeInfo((Node)node) + " />");
                    }
                }
                ++i;
            }
        }
    }

    private void traverseParaElem(Node node) throws IOException {
        String nodeName = node.getNodeName();
        if (nodeName.equals("text:s")) {
            NamedNodeMap map = node.getAttributes();
            Node attr = map.getNamedItem("text:c");
            StringBuffer space = new StringBuffer(32);
            int count = 1;
            if (attr != null) {
                try {
                    String countStr = attr.getNodeValue();
                    count = Integer.parseInt(countStr.trim());
                }
                catch (NumberFormatException e) {
                    throw new IOException(e.getMessage());
                }
            }
            int j = 0;
            while (j < count) {
                space.append(' ');
                ++j;
            }
            this.encoder.addText(space.toString());
            this.log("<SPACE count=\"" + count + "\" />");
        } else if (nodeName.equals("text:tab-stop")) {
            this.encoder.addText('\t');
            this.log("<TAB/>");
        } else if (nodeName.equals("text:line-break")) {
            this.log("skipped <LINE-BREAK/>");
        } else if (nodeName.equals("text:span")) {
            this.log("<SPAN>");
            this.traverseParaContents(node);
            this.log("</SPAN>");
        } else if (nodeName.equals("text:a")) {
            this.log("<HYPERLINK>");
            this.traverseParaContents(node);
            this.log("<HYPERLINK/>");
        } else if (nodeName.equals("text:bookmark") || nodeName.equals("text:bookmark-start")) {
            this.log("<BOOKMARK/>");
        } else if (nodeName.equals("text:variable-set") || nodeName.equals("text:variable-get") || nodeName.equals("text:expression") || nodeName.equals("text:user-field-get") || nodeName.equals("text:page-variable-get") || nodeName.equals("text:sequence") || nodeName.equals("text:variable-input") || nodeName.equals("text:time") || nodeName.equals("text:page-count") || nodeName.equals("text:page-number") || nodeName.equals("text:subject") || nodeName.equals("text:title") || nodeName.equals("text:creation-time") || nodeName.equals("text:date") || nodeName.equals("text:text-input") || nodeName.equals("text:author-initials")) {
            this.log("<FIELD>");
            this.traverseParaContents(node);
            this.log("</FIELD>");
        } else if (nodeName.startsWith("text:")) {
            this.log("<Unknown text Field>");
            this.traverseParaContents(node);
            this.log("</Unknown text Field>");
        } else {
            this.log("<OTHERS " + XmlUtil.getNodeInfo((Node)node) + " />");
        }
    }

    private void traverseList(Node node) throws IOException {
        this.log("<LIST>");
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            int len = nodeList.getLength();
            int i = 0;
            while (i < len) {
                Node child = nodeList.item(i);
                if (child.getNodeType() == 1) {
                    String nodeName = child.getNodeName();
                    if (nodeName.equals("text:list-item")) {
                        this.traverseListItem(child);
                    } else if (nodeName.equals("text:list-header")) {
                        this.traverseListHeader(child);
                    } else {
                        this.log("<INVALID-XML-BUG " + XmlUtil.getNodeInfo((Node)child) + " />");
                    }
                }
                ++i;
            }
        }
        this.log("</LIST>");
    }

    private void traverseListHeader(Node node) throws IOException {
        this.log("<LIST-HEADER>");
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            int len = nodeList.getLength();
            int i = 0;
            while (i < len) {
                Node child = nodeList.item(i);
                if (child.getNodeType() == 1) {
                    String nodeName = child.getNodeName();
                    if (nodeName.equals("text:p")) {
                        this.traverseParagraph(child);
                    } else {
                        this.log("<INVALID-XML-BUG " + XmlUtil.getNodeInfo((Node)child) + " />");
                    }
                }
                ++i;
            }
        }
        this.log("</LIST-HEADER>");
    }

    private void traverseListItem(Node node) throws IOException {
        this.log("<LIST-ITEM>");
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            int len = nodeList.getLength();
            int i = 0;
            while (i < len) {
                Node child = nodeList.item(i);
                if (child.getNodeType() == 1) {
                    String nodeName = child.getNodeName();
                    if (nodeName.equals("text:p")) {
                        this.traverseParagraph(child);
                    } else if (nodeName.equals("text:unordered-list")) {
                        this.traverseList(child);
                    } else if (nodeName.equals("text:ordered-list")) {
                        this.traverseList(child);
                    } else {
                        this.log("<INVALID-XML-BUG " + XmlUtil.getNodeInfo((Node)child) + " />");
                    }
                }
                ++i;
            }
        }
        this.log("</LIST-ITEM>");
    }

    private void log(String str) {
        Debug.log((int)4, (String)str);
    }
}

