/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.tr;

import com.jclark.xsl.conv.NumberListFormat;
import com.jclark.xsl.expr.Pattern;
import com.jclark.xsl.om.Name;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.SafeNodeIterator;
import com.jclark.xsl.om.XSLException;
import com.jclark.xsl.tr.Action;
import com.jclark.xsl.tr.NumberListFormatTemplate;
import com.jclark.xsl.tr.ProcessContext;
import com.jclark.xsl.tr.Result;

class MultiLevelNumberAction
implements Action {
    private Pattern count;
    private Pattern from;
    private NumberListFormatTemplate formatTemplate;

    MultiLevelNumberAction(Pattern pattern, Pattern pattern2, NumberListFormatTemplate numberListFormatTemplate) {
        this.count = pattern;
        this.from = pattern2;
        this.formatTemplate = numberListFormatTemplate;
    }

    public void invoke(ProcessContext processContext, Node node, Result result) throws XSLException {
        int n;
        NumberListFormat numberListFormat = this.formatTemplate.instantiate(processContext, node);
        if (this.count == null) {
            n = node.getType() == 0 ? this.numberUp(node.getName(), numberListFormat, processContext, node, result) : 0;
        } else {
            Cache cache = (Cache)processContext.get(this);
            if (cache == null) {
                cache = new Cache();
                processContext.put(this, cache);
            }
            n = this.numberUp(numberListFormat, processContext, cache, node, result);
        }
        if (n == 0) {
            result.characters(numberListFormat.getPrefix(0));
        }
        result.characters(numberListFormat.getSuffix());
    }

    private int numberUp(NumberListFormat numberListFormat, ProcessContext processContext, Cache cache, Node node, Result result) throws XSLException {
        Node node2;
        do {
            int n;
            node2 = node.getParent();
            if (this.from != null && this.from.matches(node, processContext)) break;
            if (!this.count.matches(node, processContext)) continue;
            int n2 = this.numberUp(numberListFormat, processContext, cache, node2, result);
            CacheEntry cacheEntry = cache.get(n2);
            if (node2 == null) {
                n = 1;
            } else if (node.equals(cacheEntry.child)) {
                n = cacheEntry.n;
            } else if (node2.equals(cacheEntry.parent) && cacheEntry.child.compareTo(node) < 0) {
                n = cacheEntry.n;
                SafeNodeIterator safeNodeIterator = cacheEntry.child.getFollowingSiblings();
                while (true) {
                    Node node3;
                    if (!this.count.matches(node3 = safeNodeIterator.next(), processContext)) {
                        continue;
                    }
                    ++n;
                    if (node3.equals(node)) break;
                }
                cacheEntry.n = n;
                cacheEntry.child = node;
            } else {
                n = 0;
                SafeNodeIterator safeNodeIterator = node2.getChildren();
                while (true) {
                    Node node4;
                    if (!this.count.matches(node4 = safeNodeIterator.next(), processContext)) {
                        continue;
                    }
                    ++n;
                    if (node4.equals(node)) break;
                }
                cacheEntry.parent = node2;
                cacheEntry.child = node;
                cacheEntry.n = n;
            }
            result.characters(numberListFormat.getPrefix(n2));
            result.characters(numberListFormat.formatNumber(n2, n));
            return n2 + 1;
        } while ((node = node2) != null);
        return 0;
    }

    private int numberUp(Name name, NumberListFormat numberListFormat, ProcessContext processContext, Node node, Result result) throws XSLException {
        int n = 0;
        Node node2 = node.getParent();
        while (node2 != null) {
            if (name.equals(node2.getName())) {
                n = this.numberUp(name, numberListFormat, processContext, node2, result);
                break;
            }
            node2 = node2.getParent();
        }
        int n2 = 0;
        SafeNodeIterator safeNodeIterator = node.getParent().getChildren();
        while (true) {
            Node node3;
            if (!name.equals((node3 = safeNodeIterator.next()).getName()) || node3.getType() != 0) {
                continue;
            }
            ++n2;
            if (node3.equals(node)) break;
        }
        result.characters(numberListFormat.getPrefix(n));
        result.characters(numberListFormat.formatNumber(n, n2));
        return n + 1;
    }

    static final class CacheEntry {
        Node parent;
        Node child;
        int n;

        CacheEntry() {
        }
    }

    static final class Cache {
        static final int SPARE = 4;
        CacheEntry[] entries;

        Cache() {
        }

        CacheEntry get(int n) {
            if (this.entries == null) {
                this.entries = new CacheEntry[n + 1 + 4];
            } else if (n >= this.entries.length) {
                CacheEntry[] cacheEntryArray = this.entries;
                this.entries = new CacheEntry[n + 1 + 4];
                System.arraycopy(cacheEntryArray, 0, this.entries, 0, cacheEntryArray.length);
            }
            if (this.entries[n] == null) {
                this.entries[n] = new CacheEntry();
            }
            return this.entries[n];
        }
    }
}

