#!/bin/sh

INSTALLDIR=${INSTALLDIR:-/usr/local/lib/Ngraph}
BINDIR=${BINDIR:-/usr/local/bin}

TEXTFILES="Ngraph.ini .Ngraph .Ngraph.ngp .fit.ngp INSTALL.jis gpl.txt gpl.ja.txt"
ADDINFILES="append.nsc math.nsc text-in.nsc \
           calc.nsc calc.tcl legend.nsc legend.tcl fitrslt.nsc fitrslt.tcl \
           fft.nsc fft.tcl"
DEMOFILES="demo.ngp demo1.ngp demo2.ngp demo3.ngp demo4.ngp \
           demo5a.ngp demo5b.ngp demo5c.ngp demo5d.ngp demo5e.ngp \
           demo1.dat demo2.dat demo3.dat demo4.dat encoding.ngp"

BINARIES="ngraph ngraph.sh terminal"

echo "Updating ngraph.sh and Ngraph.ini"
if [ ! -d ./org ]
then
  mkdir ./org
fi
if [ ! -f ./org/ngraph.sh ]
then
  cp ngraph.sh ./org
fi
if [ ! -f ./org/Ngraph.ini ]
then
  cp Ngraph.ini ./org
fi
sed -e "s?INSTALLDIR?${INSTALLDIR}?" ./org/ngraph.sh > ngraph.sh
sed -e "s?INSTALLDIR?${INSTALLDIR}?" ./org/Ngraph.ini > Ngraph.ini

echo "Making directories in ${INSTALLDIR}"
if [ ! -d ${INSTALLDIR} ]
then
  mkdir ${INSTALLDIR}
  chmod 0755 ${INSTALLDIR}
fi
if [ ! -d ${INSTALLDIR}/ja ]
then
  mkdir ${INSTALLDIR}/ja
  chmod 0755 ${INSTALLDIR}/ja
fi
if [ ! -d ${INSTALLDIR}/demo ]
then
  mkdir ${INSTALLDIR}/demo
  chmod 0755 ${INSTALLDIR}/demo
fi
if [ ! -d ${INSTALLDIR}/doc ]
then
  mkdir ${INSTALLDIR}/doc
  chmod 0755 ${INSTALLDIR}/doc
fi

echo "Copying files to ${INSTALLDIR}"
cp ${TEXTFILES} ${BINARIES} Ngraph ${INSTALLDIR}
cp ja/Ngraph ${INSTALLDIR}/ja
cp icon/Ngraph.xpm ${INSTALLDIR}
(cd ${INSTALLDIR}
 chmod 0644 ${TEXTFILES} Ngraph ja/Ngraph Ngraph.xpm
 chmod 0755 ${BINARIES} 
)

echo "Copying driver files to ${INSTALLDIR}"
cp  x11drive/Ngraph.ps x11drive/gra2ps.ini x11drive/gra2ps ${INSTALLDIR}
cp  x11drive/gra2wmf.ini x11drive/gra2wmf ${INSTALLDIR}
(cd ${INSTALLDIR}
 chmod 0644 Ngraph.ps
 chmod 0644 gra2ps.ini
 chmod 0755 gra2ps
 chmod 0644 gra2wmf.ini
 chmod 0755 gra2wmf
)

echo "Copying add-in files to ${INSTALLDIR}"
(cd x11addin
 cp ${ADDINFILES} fft ${INSTALLDIR}
)
(cd ${INSTALLDIR}
 chmod 0644 ${ADDINFILES}
 chmod 0755 fft
)

echo "Copying demo files to ${INSTALLDIR}/demo"
(cd x11demo
 cp ${DEMOFILES} ${INSTALLDIR}/demo
 cd ${INSTALLDIR}/demo
 chmod 0644 ${DEMOFILES}
)

if [ ! -h ${BINDIR}/ngraph ]
then
  echo "Making a symbolic link ${BINDIR}/ngraph"
  ln -s ${INSTALLDIR}/ngraph.sh ${BINDIR}/ngraph
fi

if [ -f ./org/ngraph.sh ]
then
  cp ./org/ngraph.sh .
fi
if [ -f ./org/Ngraph.ini ]
then
  cp ./org/Ngraph.ini .
fi

echo '*'
echo '*' Installation is completed.
echo '*' HTML documents are distributed separately!
echo '*'

