/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures.constants;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.gjt.jclasslib.structures.CPInfo;
import org.gjt.jclasslib.structures.InvalidByteCodeException;

public class ConstantClassInfo
extends CPInfo {
    public static final int SIZE = 2;
    private int nameIndex;

    public byte getTag() {
        return 7;
    }

    public String getTagVerbose() {
        return "CONSTANT_Class_info";
    }

    public String getVerbose() throws InvalidByteCodeException {
        return this.getName();
    }

    public int getNameIndex() {
        return this.nameIndex;
    }

    public void setNameIndex(int n) {
        this.nameIndex = n;
    }

    public String getName() throws InvalidByteCodeException {
        return this.classFile.getConstantPoolUtf8Entry(this.nameIndex).getString();
    }

    public void read(DataInput dataInput) throws InvalidByteCodeException, IOException {
        this.nameIndex = dataInput.readUnsignedShort();
        if (this.debug) {
            this.debug("read ");
        }
    }

    public void write(DataOutput dataOutput) throws InvalidByteCodeException, IOException {
        dataOutput.writeByte(7);
        dataOutput.writeShort(this.nameIndex);
        if (this.debug) {
            this.debug("wrote ");
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof ConstantClassInfo)) {
            return false;
        }
        ConstantClassInfo constantClassInfo = (ConstantClassInfo)object;
        return super.equals(object) && constantClassInfo.nameIndex == this.nameIndex;
    }

    public int hashCode() {
        return super.hashCode() ^ this.nameIndex;
    }

    protected void debug(String string) {
        super.debug(string + this.getTagVerbose() + " with name_index " + this.nameIndex);
    }
}

