/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.browser.detail.constants;

import javax.swing.tree.TreePath;
import org.gjt.jclasslib.browser.BrowserServices;
import org.gjt.jclasslib.browser.detail.constants.AbstractConstantInfoDetailPane;
import org.gjt.jclasslib.structures.InvalidByteCodeException;
import org.gjt.jclasslib.structures.constants.ConstantUtf8Info;
import org.gjt.jclasslib.util.ExtendedJLabel;

public class ConstantUtf8InfoDetailPane
extends AbstractConstantInfoDetailPane {
    private ExtendedJLabel lblByteLength;
    private ExtendedJLabel lblByteLengthComment;
    private ExtendedJLabel lblStringLength;
    private ExtendedJLabel lblString;

    public ConstantUtf8InfoDetailPane(BrowserServices browserServices) {
        super(browserServices);
    }

    protected void setupLabels() {
        this.lblByteLength = this.highlightLabel();
        this.lblByteLengthComment = this.highlightLabel();
        this.addDetailPaneEntry(this.normalLabel("Length of byte array:"), this.lblByteLength, this.lblByteLengthComment);
        this.lblStringLength = this.highlightLabel();
        this.addDetailPaneEntry(this.normalLabel("Length of string:"), this.lblStringLength);
        this.lblString = this.highlightLabel();
        this.addDetailPaneEntry(this.normalLabel("String:"), null, this.lblString);
    }

    public void show(TreePath treePath) {
        int n = this.constantPoolIndex(treePath);
        try {
            ConstantUtf8Info constantUtf8Info = this.services.getClassFile().getConstantPoolUtf8Entry(n);
            this.lblByteLength.setText(constantUtf8Info.getBytes().length);
            this.lblStringLength.setText(constantUtf8Info.getString().length());
            this.lblString.setText(this.getConstantPoolEntryName(n));
        }
        catch (InvalidByteCodeException invalidByteCodeException) {
            this.lblByteLength.setText(-1);
            this.lblStringLength.setText(-1);
            this.lblByteLengthComment.setText("invalid constant pool entry");
        }
        super.show(treePath);
    }
}

